/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.engine;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.core.content.res.ResourcesCompat;
import com.bumptech.glide.Glide;
import com.moengage.core.internal.global.GlobalResources;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.model.ViewDimension;
import com.moengage.core.internal.utils.CoreUtils;
import com.moengage.core.internal.utils.MoEUtils;
import com.moengage.inapp.R;
import com.moengage.inapp.internal.ActionHandler;
import com.moengage.inapp.internal.UtilsKt;
import com.moengage.inapp.internal.engine.BaseViewEngine;
import com.moengage.inapp.internal.engine.NudgesViewEngineHelper;
import com.moengage.inapp.internal.engine.ViewEngineUtilsKt;
import com.moengage.inapp.internal.engine.WidgetFactory;
import com.moengage.inapp.internal.exceptions.CouldNotCreateViewException;
import com.moengage.inapp.internal.exceptions.ImageNotFoundException;
import com.moengage.inapp.internal.exceptions.VideoNotFoundException;
import com.moengage.inapp.internal.model.InAppComponent;
import com.moengage.inapp.internal.model.InAppContainer;
import com.moengage.inapp.internal.model.InAppWidget;
import com.moengage.inapp.internal.model.Margin;
import com.moengage.inapp.internal.model.NativeCampaignPayload;
import com.moengage.inapp.internal.model.Padding;
import com.moengage.inapp.internal.model.Spacing;
import com.moengage.inapp.internal.model.ViewCreationMeta;
import com.moengage.inapp.internal.model.Widget;
import com.moengage.inapp.internal.model.actions.RatingChangeAction;
import com.moengage.inapp.internal.model.customrating.CustomRatingComponent;
import com.moengage.inapp.internal.model.customrating.RatingIcon;
import com.moengage.inapp.internal.model.enums.DisplaySize;
import com.moengage.inapp.internal.model.enums.Orientation;
import com.moengage.inapp.internal.model.enums.TemplateAlignment;
import com.moengage.inapp.internal.model.enums.ViewType;
import com.moengage.inapp.internal.model.enums.WidgetType;
import com.moengage.inapp.internal.model.style.ButtonStyle;
import com.moengage.inapp.internal.model.style.CloseStyle;
import com.moengage.inapp.internal.model.style.ContainerStyle;
import com.moengage.inapp.internal.model.style.ImageStyle;
import com.moengage.inapp.internal.model.style.InAppStyle;
import com.moengage.inapp.internal.model.style.RatingStyle;
import com.moengage.inapp.internal.model.style.TextStyle;
import com.moengage.inapp.internal.repository.InAppFileManager;
import com.moengage.inapp.internal.widgets.ratingbar.MoECustomRatingBar;
import com.moengage.inapp.internal.widgets.ratingbar.MoERatingBar;
import com.moengage.inapp.model.actions.Action;
import java.io.File;
import java.util.List;

public class ViewEngine
extends BaseViewEngine {
    private static final String TAG = "InApp_7.1.2_ViewEngine";
    private static final int CLOSE_BUTTON_SIZE = 42;
    private static final int CLOSE_BUTTON_PADDING = 6;
    private static final int CLOSE_BUTTON_MARGIN = 21;
    private static final int CLOSE_BUTTON_IMAGE_SIZE = 24;
    private final NativeCampaignPayload payload;
    private final Context context;
    private final InAppFileManager imageManager;
    private final ViewDimension parentViewDimensions;
    private View popUpView;
    private final int statusBarHeight;
    private final float densityScale;
    private int popUpId;
    private final Activity activity;
    private View inAppView;
    private final SdkInstance sdkInstance;
    private final NudgesViewEngineHelper nudgesViewEngineHelper;
    private final WidgetFactory widgetFactory;
    private ViewDimension primaryContainerExcludeDimen;

    public ViewEngine(Activity activity2, SdkInstance sdkInstance, NativeCampaignPayload payload2, ViewCreationMeta viewCreationMeta) {
        super(activity2, payload2, viewCreationMeta);
        this.activity = activity2;
        this.sdkInstance = sdkInstance;
        this.context = activity2.getApplicationContext();
        this.payload = payload2;
        this.imageManager = new InAppFileManager(activity2.getApplicationContext(), sdkInstance);
        this.parentViewDimensions = viewCreationMeta.deviceDimensions;
        this.statusBarHeight = viewCreationMeta.statusBarHeight;
        this.densityScale = activity2.getResources().getDisplayMetrics().density;
        this.nudgesViewEngineHelper = new NudgesViewEngineHelper(this.context, sdkInstance, viewCreationMeta, payload2, this.imageManager, this.densityScale);
        this.widgetFactory = new WidgetFactory(activity2, sdkInstance, viewCreationMeta, payload2, this.densityScale);
    }

    @Override
    @SuppressLint(value={"WrongThread"})
    @WorkerThread
    @Nullable
    public View createInApp() {
        try {
            this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createInApp() : Will try to create in-app view for campaign-id: " + this.payload.getCampaignId());
            this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createInApp() : Device Dimensions: " + this.parentViewDimensions + " Status Bar height: " + this.statusBarHeight);
            this.inAppView = this.createPrimaryContainer(this.payload.getPrimaryContainer());
            if (this.inAppView == null) {
                return null;
            }
            this.handleBackPress(this.inAppView);
            this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createInApp() : InApp creation complete, returning created view.");
            ContainerStyle style = (ContainerStyle)this.payload.getPrimaryContainer().style;
            if (style.animation != null && style.animation.entry != -1) {
                Animation animation = AnimationUtils.loadAnimation((Context)this.context, (int)style.animation.entry);
                animation.setFillAfter(true);
                this.inAppView.setAnimation(animation);
            }
            this.inAppView.setClickable(true);
            return this.inAppView;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, () -> "InApp_7.1.2_ViewEngine createInApp() : ");
            if (t instanceof UnsupportedOperationException) {
                this.updateStatForCampaign(this.payload, "IMP_GIF_LIB_MIS", this.sdkInstance);
            } else if (t instanceof ImageNotFoundException) {
                this.updateStatForCampaign(this.payload, "IMP_IMG_FTH_FLR", this.sdkInstance);
            } else if (t instanceof VideoNotFoundException) {
                this.updateStatForCampaign(this.payload, "IMP_VDO_FTH_FLR", this.sdkInstance);
            }
            return null;
        }
    }

    private View createPrimaryContainer(InAppContainer container) throws CouldNotCreateViewException, ImageNotFoundException, IllegalStateException, VideoNotFoundException {
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createPrimaryContainer() : will create primary container");
        RelativeLayout containerLayout = new RelativeLayout(this.context);
        ContainerStyle containerStyle = (ContainerStyle)container.style;
        this.primaryContainerExcludeDimen = this.getStyleDimensionsToExclude(container, true);
        containerLayout.setId(20000 + container.id);
        View widgetView = null;
        Widget widget = this.getWidgetFromList(container.widgets, WidgetType.CONTAINER);
        if (widget == null) {
            throw new IllegalStateException("Unexpected Widget type");
        }
        widgetView = this.createPopUp((InAppContainer)widget.inAppWidget, containerLayout);
        if (widgetView == null) {
            throw new CouldNotCreateViewException("One of the container/widget creation wasn't successful cannot create view further");
        }
        this.popUpView = widgetView;
        containerLayout.addView(widgetView);
        widget = this.getWidgetFromList(container.widgets, WidgetType.WIDGET);
        if (widget == null) {
            throw new IllegalStateException("Unexpected Widget type");
        }
        InAppWidget closeWidget = (InAppWidget)widget.inAppWidget;
        if (closeWidget.viewType != ViewType.CLOSE_BUTTON) {
            throw new IllegalStateException("Unexpected Widget type. Expected widget type is close button.");
        }
        ViewDimension campaignDimensions = ViewEngineUtilsKt.getViewDimensionsFromPercentage(this.parentViewDimensions, containerStyle);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createPrimaryContainer() : Campaign Dimension: " + campaignDimensions);
        ViewDimension unspecifiedDimension = this.getUnspecifiedViewDimension((View)containerLayout);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createPrimaryContainer() : Computed Dimension: " + unspecifiedDimension);
        campaignDimensions.height = Math.max(campaignDimensions.height, unspecifiedDimension.height);
        if (closeWidget.component.style.display) {
            widgetView = this.createCloseButton(closeWidget, campaignDimensions);
            this.alignCloseButton(widgetView, (CloseStyle)closeWidget.component.style);
            containerLayout.addView(widgetView);
        }
        this.setPrimaryContainerDimensions(container, campaignDimensions, containerLayout);
        this.styleContainer(containerLayout, (ContainerStyle)container.style, campaignDimensions, true, this.primaryContainerExcludeDimen);
        containerLayout.setClipToOutline(true);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createPrimaryContainer() : creation completed.");
        return containerLayout;
    }

    private Widget getWidgetFromList(List<Widget> widgetList, WidgetType widgetType) {
        for (Widget widget : widgetList) {
            if (widget.type != widgetType) continue;
            return widget;
        }
        return null;
    }

    private void alignCloseButton(View widgetView, CloseStyle style) throws CouldNotCreateViewException {
        if (style.position == null) {
            throw new CouldNotCreateViewException("Cannot create in-app position of close button is missing Campaign-id:" + this.payload.getCampaignId());
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)widgetView.getLayoutParams();
        switch (style.position) {
            case LEFT: {
                if (this.payload.getTemplateType().equals("POP_UP")) {
                    layoutParams.addRule(6, this.popUpView.getId());
                    layoutParams.addRule(5, this.popUpView.getId());
                    layoutParams.leftMargin = (int)((float)layoutParams.leftMargin + ((float)ViewEngineUtilsKt.transformViewDimension(style.margin.left, this.parentViewDimensions.width) - 21.0f * this.densityScale));
                    break;
                }
                layoutParams.addRule(9);
                break;
            }
            case RIGHT: {
                if (this.payload.getTemplateType().equals("POP_UP")) {
                    layoutParams.rightMargin = (int)((float)layoutParams.rightMargin + ((float)ViewEngineUtilsKt.transformViewDimension(style.margin.right, this.parentViewDimensions.width) - 21.0f * this.densityScale));
                    layoutParams.addRule(6, this.popUpView.getId());
                    layoutParams.addRule(7, this.popUpView.getId());
                    break;
                }
                layoutParams.addRule(11);
            }
        }
        if (this.payload.getTemplateType().equals("POP_UP")) {
            layoutParams.topMargin -= (int)(21.0f * this.densityScale);
        }
        widgetView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private View createCloseButton(InAppWidget widget, ViewDimension primaryContainerDimension) {
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createCloseButton() : Will create close button. " + widget);
        Bitmap imageBitmap = this.imageManager.getImageFromUrl(this.context, widget.component.content, this.payload.getCampaignId());
        if (imageBitmap == null) {
            int res = R.drawable.moengage_inapp_close;
            imageBitmap = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)res);
        }
        ImageView imageView = new ImageView(this.context);
        int dimension = (int)(42.0f * this.densityScale);
        ViewDimension imageDimension = new ViewDimension(dimension, Math.min(dimension, primaryContainerDimension.height));
        int imageSize = (int)(24.0f * this.densityScale);
        imageView.setImageBitmap(ViewEngineUtilsKt.getScaledBitmap(imageBitmap, new ViewDimension(imageSize, imageSize)));
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(imageDimension.width, imageDimension.height);
        int fixedPadding = (int)(6.0f * this.densityScale);
        Spacing padding = new Spacing(fixedPadding, fixedPadding, fixedPadding, fixedPadding);
        imageView.setPadding(padding.left, padding.top, padding.right, padding.bottom);
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageView.setClickable(true);
        this.addAction((View)imageView, widget.actions);
        return imageView;
    }

    @SuppressLint(value={"ResourceType"})
    private View createPopUp(InAppContainer container, RelativeLayout primaryContainer) throws CouldNotCreateViewException, ImageNotFoundException, VideoNotFoundException {
        RelativeLayout popUpLayout = new RelativeLayout(this.context);
        this.popUpId = container.id;
        View popUpView = this.createContainer(container, primaryContainer);
        if (popUpView == null) {
            throw new CouldNotCreateViewException("One of the container/widget creation wasn't successful cannot create view further");
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        this.addMarginToLayout(layoutParams, container.style);
        popUpLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        ViewDimension popUpDimensions = new ViewDimension(ViewEngineUtilsKt.getViewDimensionsFromPercentage((ViewDimension)this.parentViewDimensions, (InAppStyle)container.style).width, this.getUnspecifiedViewDimension((View)popUpView).height);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createPopUp() : Pop up view Dimensions: " + popUpDimensions);
        this.styleContainer(popUpLayout, (ContainerStyle)container.style, popUpDimensions, false, this.primaryContainerExcludeDimen);
        popUpLayout.addView(popUpView);
        this.alignContainer((View)popUpLayout, this.payload.getAlignment());
        popUpLayout.setId(12345);
        return popUpLayout;
    }

    private void alignContainer(View view, TemplateAlignment alignment) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
        layoutParams.addRule(15);
        layoutParams.addRule(14);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private View createContainer(InAppContainer container, RelativeLayout primaryContainer) throws CouldNotCreateViewException, ImageNotFoundException, VideoNotFoundException {
        LinearLayout containerLayout = new LinearLayout(this.context);
        switch (container.orientation) {
            case VERTICAL: {
                containerLayout.setOrientation(1);
                break;
            }
            case HORIZONTAL: {
                containerLayout.setOrientation(0);
                containerLayout.setGravity(1);
            }
        }
        View widgetView = null;
        block8: for (Widget widget : container.widgets) {
            switch (widget.type) {
                case WIDGET: {
                    InAppWidget inAppWidget = (InAppWidget)widget.inAppWidget;
                    if (!inAppWidget.component.style.display) {
                        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createContainer() : Display type of widget is false. Will not create widget. " + inAppWidget);
                        continue block8;
                    }
                    widgetView = this.createWidget(inAppWidget, container.orientation, primaryContainer, this.getStyleDimensionsToExclude(container, false));
                    break;
                }
                case CONTAINER: {
                    InAppContainer inAppContainer = (InAppContainer)widget.inAppWidget;
                    if (!inAppContainer.style.display) {
                        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createContainer() : Display type of container is false. Will not create container. " + inAppContainer);
                        continue block8;
                    }
                    widgetView = this.createContainer(inAppContainer, primaryContainer);
                }
            }
            if (widgetView == null) {
                throw new CouldNotCreateViewException("One of the container/widget creation wasn't successful cannot create view further");
            }
            containerLayout.addView(widgetView);
        }
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createContainer() : " + container.style);
        this.setViewDimensionsPopUp((View)containerLayout, container.style);
        if (this.popUpId != container.id) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)containerLayout.getLayoutParams();
            this.addMarginToLayout(layoutParams, container.style);
            containerLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            Spacing spacing = this.transformPadding(container.style.padding);
            containerLayout.setPadding(spacing.left, spacing.top, spacing.right, spacing.bottom);
            this.styleContainer(containerLayout, (ContainerStyle)container.style);
        }
        containerLayout.setId(20000 + container.id);
        return containerLayout;
    }

    private void setViewDimensionsPopUp(View view, InAppStyle style) {
        ViewDimension campaignDimension = ViewEngineUtilsKt.getViewDimensionsFromPercentage(this.parentViewDimensions, style);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine setViewDimensionsPopUp() : Campaign Dimension " + campaignDimension);
        ViewDimension computedDimension = this.getUnspecifiedViewDimension(view);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine setViewDimensionsPopUp() : Computed dimension: " + computedDimension);
        campaignDimension.height = Math.max(campaignDimension.height, computedDimension.height);
        if (this.getPrimaryContainerStyle().displaySize == DisplaySize.FULLSCREEN) {
            campaignDimension.height = -1;
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private View createWidget(InAppWidget widget, Orientation parentOrientation, RelativeLayout primaryContainer, ViewDimension toExclude) throws ImageNotFoundException, CouldNotCreateViewException, VideoNotFoundException {
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createWidget() : Creating widget: " + widget);
        Object view = null;
        switch (widget.viewType) {
            case TEXT: 
            case FEEDBACK_TEXT: {
                view = this.createTextView(widget, parentOrientation, toExclude);
                break;
            }
            case IMAGE: {
                view = this.createImageView(widget, parentOrientation, primaryContainer, toExclude);
                break;
            }
            case BUTTON: {
                view = this.createButton(widget, parentOrientation, toExclude);
                break;
            }
            case RATING: {
                view = this.createRatingBar(widget, parentOrientation, toExclude);
                break;
            }
            case VIDEO: {
                view = this.nudgesViewEngineHelper.createVideoView(widget, parentOrientation, primaryContainer, toExclude);
                break;
            }
            case CUSTOM_RATING: {
                view = this.createCustomRatingBar(widget, parentOrientation, toExclude);
            }
        }
        if (view == null) {
            throw new CouldNotCreateViewException("View type not recognised. Type " + (Object)((Object)widget.viewType));
        }
        view.setId(30000 + widget.id);
        view.setClickable(true);
        this.addAction((View)view, widget.actions);
        return view;
    }

    private TextView createTextView(InAppWidget widget, Orientation parentOrientation, ViewDimension toExclude) {
        int resourceId;
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createTextView() : Will create text widget: " + widget);
        TextView textView = new TextView(this.context);
        this.setTextContent(textView, widget.component);
        TextStyle textStyle = (TextStyle)widget.component.style;
        textView.setTextSize(textStyle.font.size);
        if (textStyle.font.color != null) {
            textView.setTextColor(ViewEngineUtilsKt.getColor(textStyle.font.color));
        }
        if ((resourceId = this.context.getResources().getIdentifier(textStyle.font.name, "font", this.context.getPackageName())) > 0) {
            Typeface typeface = ResourcesCompat.getFont((Context)this.context, (int)resourceId);
            textView.setTypeface(typeface);
        }
        ViewDimension campaignDimension = ViewEngineUtilsKt.getViewDimensionsFromPercentage(this.parentViewDimensions, widget.component.style);
        if (this.payload.getTemplateType().equals("NON_INTRUSIVE")) {
            campaignDimension.width -= toExclude.width;
        }
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createTextView() : Campaign Dimension: " + campaignDimension);
        campaignDimension.height = -2;
        Spacing paddingSpacing = this.transformPadding(textStyle.padding);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createTextView() : Padding: " + paddingSpacing);
        textView.setPadding(paddingSpacing.left, paddingSpacing.top, paddingSpacing.right, paddingSpacing.bottom);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createTextView() : Final Dimensions: " + campaignDimension);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
        ViewEngineUtilsKt.setLayoutGravity(layoutParams, parentOrientation);
        Spacing marginSpacing = ViewEngineUtilsKt.transformMargin(this.sdkInstance, this.parentViewDimensions, textStyle.margin);
        layoutParams.setMargins(marginSpacing.left, marginSpacing.top, marginSpacing.right, marginSpacing.bottom);
        textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        GradientDrawable drawable2 = new GradientDrawable();
        if (textStyle.background != null && textStyle.background.color != null) {
            drawable2.setColor(ViewEngineUtilsKt.getColor(textStyle.background.color));
        }
        if (textStyle.border != null) {
            ViewEngineUtilsKt.getBorder(textStyle.border, drawable2, this.densityScale);
        }
        ViewEngineUtilsKt.applyBackgroundToView((View)textView, (Drawable)drawable2, this.payload.getTemplateType());
        if (!this.payload.getTemplateType().equals("NON_INTRUSIVE") || widget.viewType == ViewType.FEEDBACK_TEXT) {
            textView.setGravity(17);
        }
        textView.setVisibility(textStyle.visibility.toViewVisibility());
        if (textStyle.maxLines != -1) {
            textView.setMaxLines(textStyle.maxLines);
            textView.setEllipsize(TextUtils.TruncateAt.END);
        }
        return textView;
    }

    @SuppressLint(value={"CheckResult"})
    private View createImageView(InAppWidget widget, Orientation parentOrientation, RelativeLayout primaryContainer, ViewDimension toExclude) throws ImageNotFoundException {
        LinearLayout.LayoutParams linearLayoutParams;
        LinearLayout imageviewContainer;
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createImageView() : Will create this widget: " + widget);
        boolean isGif = CoreUtils.isGif((String)widget.component.content);
        if (!MoEUtils.hasGlideSupport()) {
            this.sdkInstance.logger.log(2, () -> "InApp_7.1.2_ViewEngine createImageView() : Image is of gif type, gif dependency not present");
            throw new UnsupportedOperationException("Library support not found: Image and gif require Glide library.");
        }
        ImageView imageView = new ImageView(this.context);
        ImageStyle imageStyle = (ImageStyle)widget.component.style;
        ContainerStyle containerStyle = this.getPrimaryContainerStyle();
        boolean isResizeableGif = isGif && containerStyle.displaySize != null;
        ViewDimension campaignDimension = isResizeableGif ? ViewEngineUtilsKt.getViewDimensionsFromPercentage(this.parentViewDimensions, containerStyle) : ViewEngineUtilsKt.getViewDimensionsFromPercentage(this.parentViewDimensions, imageStyle);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createImageView() : Campaign Dimension: " + campaignDimension);
        if (containerStyle.displaySize == DisplaySize.FULLSCREEN) {
            ViewDimension fullscreenDimension = this.nudgesViewEngineHelper.getFullScreenViewDimension(containerStyle);
            this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createImageView(): fullscreen Dimensions: " + fullscreenDimension);
            campaignDimension.width = fullscreenDimension.width;
            campaignDimension.height = fullscreenDimension.height;
        }
        if (isGif) {
            this.loadGif(imageView, isResizeableGif, widget, imageStyle, campaignDimension);
        } else {
            this.loadBitmap(imageView, widget, campaignDimension);
        }
        if (isResizeableGif) {
            imageviewContainer = this.nudgesViewEngineHelper.createContainerForResizeableImageView(primaryContainer, imageView, imageStyle, containerStyle.displaySize);
            linearLayoutParams = new LinearLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
            linearLayoutParams.weight = 0.9f;
        } else {
            imageviewContainer = new LinearLayout(this.context);
            linearLayoutParams = new LinearLayout.LayoutParams(imageView.getLayoutParams().width, imageView.getLayoutParams().height);
            imageviewContainer.addView((View)imageView);
            this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createImageView() : widget: " + widget + " creation completed.");
        }
        Spacing marginSpacing = ViewEngineUtilsKt.transformMargin(this.sdkInstance, this.parentViewDimensions, imageStyle.margin);
        linearLayoutParams.setMargins(marginSpacing.left, marginSpacing.top, marginSpacing.right, marginSpacing.bottom);
        linearLayoutParams.leftMargin = marginSpacing.left;
        linearLayoutParams.rightMargin = marginSpacing.right;
        linearLayoutParams.topMargin = marginSpacing.top;
        linearLayoutParams.bottomMargin = marginSpacing.bottom;
        ViewEngineUtilsKt.setLayoutGravity(linearLayoutParams, parentOrientation);
        imageviewContainer.setLayoutParams((ViewGroup.LayoutParams)linearLayoutParams);
        int borderWidth = 0;
        if (imageStyle.border != null) {
            borderWidth = this.transformToPx(imageStyle.border.width);
        }
        if (imageStyle.border != null) {
            ViewEngineUtilsKt.applyBackgroundToView((View)imageviewContainer, (Drawable)ViewEngineUtilsKt.getBorder(imageStyle.border, this.densityScale), this.payload.getTemplateType());
        }
        imageviewContainer.setPadding(borderWidth, borderWidth, borderWidth, borderWidth);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createImageView() : widget: " + widget + " creation completed");
        return imageviewContainer;
    }

    private Button createButton(InAppWidget widget, Orientation parentOrientation, ViewDimension toExclude) {
        int resourceId;
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createButton() : Will create button widget " + widget);
        Button button = new Button(this.context);
        this.setTextContent((TextView)button, widget.component);
        ButtonStyle style = (ButtonStyle)widget.component.style;
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createButton() : Style: " + style);
        button.setTextSize(style.font.size);
        if (style.font.color != null) {
            button.setTextColor(ViewEngineUtilsKt.getColor(style.font.color));
        }
        if ((resourceId = this.context.getResources().getIdentifier(style.font.name, "font", this.context.getPackageName())) > 0) {
            Typeface typeface = ResourcesCompat.getFont((Context)this.context, (int)resourceId);
            button.setTypeface(typeface);
        }
        ViewDimension campaignDimension = ViewEngineUtilsKt.getViewDimensionsFromPercentage(this.parentViewDimensions, widget.component.style);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createButton() : Campaign Dimension: " + campaignDimension);
        Spacing spacing = this.transformPadding(style.padding);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createButton() : Padding: " + spacing);
        button.setPadding(spacing.left, spacing.top, spacing.right, spacing.bottom);
        ViewDimension unSpecifiedDimension = this.getUnspecifiedViewDimension((View)button);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createButton() : Calculated Dimensions: " + unSpecifiedDimension);
        int minimumHeight = this.transformToPx(style.minHeight);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createButton() : Minimum height for widget: " + minimumHeight);
        if (minimumHeight > unSpecifiedDimension.height) {
            campaignDimension.height = minimumHeight;
        }
        if (this.payload.getTemplateType().equals("NON_INTRUSIVE")) {
            campaignDimension.width -= toExclude.width;
        }
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createButton() : Final Dimensions: " + campaignDimension);
        LinearLayout.LayoutParams layoutParams = this.getPrimaryContainerStyle().displaySize != null ? new LinearLayout.LayoutParams(-1, campaignDimension.height) : new LinearLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
        ViewEngineUtilsKt.setLayoutGravity(layoutParams, parentOrientation);
        Spacing marginSpacing = ViewEngineUtilsKt.transformMargin(this.sdkInstance, this.parentViewDimensions, style.margin);
        layoutParams.setMargins(marginSpacing.left, marginSpacing.top, marginSpacing.right, marginSpacing.bottom);
        button.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        GradientDrawable drawable2 = new GradientDrawable();
        if (style.background != null && style.background.color != null) {
            drawable2.setColor(ViewEngineUtilsKt.getColor(style.background.color));
        }
        if (style.border != null) {
            ViewEngineUtilsKt.getBorder(style.border, drawable2, this.densityScale);
        }
        ViewEngineUtilsKt.applyBackgroundToView((View)button, (Drawable)drawable2, this.payload.getTemplateType());
        button.setGravity(17);
        return button;
    }

    private MoERatingBar createRatingBar(InAppWidget widget, Orientation parentOrientation, ViewDimension toExclude) {
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createRatingBar() : Will create rating widget: " + widget);
        MoERatingBar ratingBar = new MoERatingBar(this.context);
        ratingBar.setIsIndicator(false);
        RatingStyle style = (RatingStyle)widget.component.style;
        ratingBar.setNumStars(style.numberOfStars);
        if (style.isHalfStepAllowed) {
            ratingBar.setStepSize(0.5f);
        } else {
            ratingBar.setStepSize(1.0f);
        }
        ratingBar.setColor(ViewEngineUtilsKt.getColor(style.color));
        ViewDimension campaignDimension = new ViewDimension(ViewEngineUtilsKt.getViewDimensionsFromPercentage((ViewDimension)this.parentViewDimensions, (InAppStyle)style).width, (int)(style.realHeight * (double)this.densityScale));
        if (this.payload.getTemplateType().equals("NON_INTRUSIVE")) {
            campaignDimension.width -= toExclude.width;
        }
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createRatingBar() : Campaign dimensions: " + campaignDimension);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
        ViewEngineUtilsKt.setLayoutGravity(layoutParams, parentOrientation);
        Spacing marginSpacing = ViewEngineUtilsKt.transformMargin(this.sdkInstance, this.parentViewDimensions, style.margin);
        layoutParams.setMargins(marginSpacing.left, marginSpacing.top, marginSpacing.right, marginSpacing.bottom);
        ratingBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        GradientDrawable drawable2 = new GradientDrawable();
        if (style.border != null) {
            ViewEngineUtilsKt.getBorder(style.border, drawable2, this.densityScale);
        }
        ViewEngineUtilsKt.applyBackgroundToView((View)ratingBar, (Drawable)drawable2, this.payload.getTemplateType());
        return ratingBar;
    }

    private void addAction(View view, List<Action> actions) {
        if (actions == null) {
            this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine addAction() : View does not have any actionType.");
            return;
        }
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine addAction() : Will try to execute actionType: " + actions);
        view.setOnClickListener(v -> {
            ActionHandler handler = new ActionHandler(this.activity, this.sdkInstance);
            for (Action action : actions) {
                this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine onClick() : Will execute actionType: " + action);
                handler.onActionPerformed(this.inAppView, action, this.payload);
            }
        });
    }

    private void setTextContent(TextView view, InAppComponent component) {
        view.setText((CharSequence)component.content);
        view.setAllCaps(false);
    }

    private void addMarginToLayout(RelativeLayout.LayoutParams layoutParams, InAppStyle style) {
        Margin margin = style.margin;
        layoutParams.leftMargin = margin.left == 0.0 ? 0 : ViewEngineUtilsKt.transformViewDimension(margin.left, this.parentViewDimensions.width);
        layoutParams.rightMargin = margin.right == 0.0 ? 0 : ViewEngineUtilsKt.transformViewDimension(margin.right, this.parentViewDimensions.width);
        layoutParams.topMargin = margin.top == 0.0 ? 0 : ViewEngineUtilsKt.transformViewDimension(margin.top, this.parentViewDimensions.height);
        layoutParams.bottomMargin = margin.bottom == 0.0 ? 0 : ViewEngineUtilsKt.transformViewDimension(margin.bottom, this.parentViewDimensions.height);
    }

    private ViewDimension getUnspecifiedViewDimension(View view) {
        view.measure(0, 0);
        return new ViewDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    private void styleContainer(LinearLayout containerLayout, ContainerStyle style) {
        if (style.background != null && style.background.color != null) {
            containerLayout.setBackgroundColor(ViewEngineUtilsKt.getColor(style.background.color));
        }
        if (style.border != null) {
            GradientDrawable backgroundDrawable = ViewEngineUtilsKt.getBorder(style.border, this.densityScale);
            if (style.background != null && style.background.color != null) {
                backgroundDrawable.setColor(ViewEngineUtilsKt.getColor(style.background.color));
            }
            ViewEngineUtilsKt.applyBackgroundToView((View)containerLayout, (Drawable)backgroundDrawable, this.payload.getTemplateType());
        }
    }

    private void styleContainer(RelativeLayout containerLayout, ContainerStyle style, ViewDimension containerDimensions, Boolean isPrimaryContainer, ViewDimension toExclude) throws ImageNotFoundException {
        int borderRadius;
        int borderWidth;
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine styleContainer() : will style container");
        if (style.background == null) {
            return;
        }
        if (style.border != null) {
            borderWidth = (int)(style.border.width * (double)this.densityScale);
            borderRadius = (int)style.border.radius;
        } else {
            borderRadius = 0;
            borderWidth = 0;
        }
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine styleContainer() : borderWidth: " + borderWidth + ", borderRadius: " + borderRadius);
        ViewEngineUtilsKt.updateContainerPaddingIfRequired(borderWidth, containerLayout);
        if (style.background.content != null) {
            RelativeLayout.LayoutParams layoutParams;
            this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine styleContainer() : background has content.");
            if (!MoEUtils.hasGlideSupport()) {
                this.sdkInstance.logger.log(2, () -> "InApp_7.1.2_ViewEngine styleContainer() : Image is of gif type, gif dependency not present");
                throw new UnsupportedOperationException("Library support not found: Image and gif require Glide library.");
            }
            ImageView imageView = new ImageView(this.context);
            if (this.getPrimaryContainerStyle().displaySize != null) {
                layoutParams = new RelativeLayout.LayoutParams(-1, -1);
                this.nudgesViewEngineHelper.handleBackgroundImageForResizeableNudge(style, imageView);
            } else {
                int height = isPrimaryContainer == false ? containerDimensions.height - toExclude.height : containerDimensions.height;
                layoutParams = new RelativeLayout.LayoutParams(containerDimensions.width - toExclude.width, height);
            }
            imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            imageView.setScaleType(ImageView.ScaleType.FIT_XY);
            if (CoreUtils.isGif((String)style.background.content)) {
                File gifFile = this.imageManager.getGifFromUrl(style.background.content, this.payload.getCampaignId());
                if (gifFile == null || !gifFile.exists()) {
                    throw new ImageNotFoundException("Gif Download failure");
                }
                UtilsKt.loadContainerImageBackground(this.context, this.sdkInstance, borderRadius, gifFile, imageView, true);
            } else {
                Bitmap imageBitmap = this.imageManager.getImageFromUrl(this.context, style.background.content, this.payload.getCampaignId());
                if (imageBitmap == null) {
                    throw new ImageNotFoundException("Image Download failure");
                }
                UtilsKt.loadContainerImageBackground(this.context, this.sdkInstance, borderRadius, imageBitmap, imageView, false);
            }
            containerLayout.addView((View)imageView, 0);
        }
        GradientDrawable drawable2 = new GradientDrawable();
        if (style.background.color != null) {
            drawable2.setColor(ViewEngineUtilsKt.getColor(style.background.color));
        }
        if (style.border != null) {
            ViewEngineUtilsKt.getBorder(style.border, drawable2, this.densityScale);
        }
        ViewEngineUtilsKt.applyBackgroundToView((View)containerLayout, (Drawable)drawable2, this.payload.getTemplateType());
    }

    private void handleBackPress(View inAppView) {
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine handleBackPress() : will set back press handling.");
        if (this.payload.getTemplateType().equals("NON_INTRUSIVE")) {
            return;
        }
        inAppView.setFocusable(true);
        inAppView.setFocusableInTouchMode(true);
        inAppView.requestFocus();
        inAppView.setOnKeyListener((v, keyCode, event) -> {
            try {
                if (event.getAction() == 0 && keyCode == 4) {
                    this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine handleBackPress() : on back button pressed");
                    ContainerStyle containerStyle = (ContainerStyle)this.payload.getPrimaryContainer().style;
                    com.moengage.inapp.internal.model.Animation animation = containerStyle.animation;
                    if (animation != null && animation.exit != -1) {
                        Animation viewAnimation = AnimationUtils.loadAnimation((Context)this.context, (int)animation.exit);
                        viewAnimation.setFillAfter(true);
                        v.setAnimation(viewAnimation);
                    }
                    ((ViewGroup)v.getParent()).removeView(v);
                    ViewEngineUtilsKt.handleDismiss(this.sdkInstance, this.payload);
                    return true;
                }
            }
            catch (Throwable t) {
                this.sdkInstance.logger.log(1, t, () -> "InApp_7.1.2_ViewEngine onKey() : ");
            }
            return false;
        });
    }

    private Spacing transformPadding(Padding padding) {
        Spacing spacing = new Spacing(padding.left == 0.0 ? 0 : ViewEngineUtilsKt.transformViewDimension(padding.left, this.parentViewDimensions.width), padding.right == 0.0 ? 0 : ViewEngineUtilsKt.transformViewDimension(padding.right, this.parentViewDimensions.width), padding.top == 0.0 ? 0 : ViewEngineUtilsKt.transformViewDimension(padding.top, this.parentViewDimensions.height), padding.bottom == 0.0 ? 0 : ViewEngineUtilsKt.transformViewDimension(padding.bottom, this.parentViewDimensions.height));
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine transformPadding() : Padding: " + spacing);
        return spacing;
    }

    private int transformToPx(double dp) {
        return (int)TypedValue.applyDimension((int)1, (float)((float)dp), (DisplayMetrics)this.activity.getResources().getDisplayMetrics());
    }

    private void setPrimaryContainerDimensions(InAppContainer container, ViewDimension campaignDimensions, RelativeLayout containerLayout) throws CouldNotCreateViewException {
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine setPrimaryContainerDimensions() : will set dimensions");
        ContainerStyle containerStyle = (ContainerStyle)container.style;
        Spacing spacingMargin = ViewEngineUtilsKt.transformMargin(this.sdkInstance, this.parentViewDimensions, container.style.margin);
        if (this.payload.getTemplateType().equals("POP_UP") || this.payload.getTemplateType().equals("FULL_SCREEN")) {
            spacingMargin = new Spacing(spacingMargin.left, spacingMargin.right, spacingMargin.top + this.statusBarHeight, spacingMargin.bottom);
        }
        if (this.payload.getTemplateType().equals("NON_INTRUSIVE")) {
            this.nudgesViewEngineHelper.setPrimaryContainerDimensions(containerLayout, containerStyle, campaignDimensions);
        } else {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(campaignDimensions.width, -1);
            layoutParams.setMargins(spacingMargin.left, spacingMargin.top, spacingMargin.right, spacingMargin.bottom);
            containerLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        Spacing spacingPadding = this.transformPadding(container.style.padding);
        containerLayout.setPadding(spacingPadding.left, spacingPadding.top, spacingPadding.right, spacingPadding.bottom);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine setPrimaryContainerDimensions() : completed");
    }

    private void loadBitmap(ImageView imageView, InAppWidget widget, ViewDimension campaignDimension) throws ImageNotFoundException {
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine loadBitmap() : will load bitmap in ImageView.");
        Bitmap imageBitmap = this.imageManager.getImageFromUrl(this.context, widget.component.content, this.payload.getCampaignId());
        if (imageBitmap == null) {
            throw new ImageNotFoundException("Image Download failure");
        }
        ViewDimension imageDimension = new ViewDimension(imageBitmap.getWidth(), imageBitmap.getHeight());
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine loadBitmap() : Image dimensions: " + imageDimension);
        campaignDimension.height = imageDimension.height * campaignDimension.width / imageDimension.width;
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine loadBitmap() : Final dimensions: " + campaignDimension);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageView.setImageBitmap(ViewEngineUtilsKt.getScaledBitmap(imageBitmap, campaignDimension));
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine loadBitmap() : completed");
    }

    private void loadGif(ImageView imageView, boolean isResizeableGif, InAppWidget widget, ImageStyle imageStyle, ViewDimension campaignDimension) throws ImageNotFoundException {
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine loadGif() : will load gif in ImageView.");
        File gifFile = this.imageManager.getGifFromUrl(widget.component.content, this.payload.getCampaignId());
        if (gifFile == null || !gifFile.exists()) {
            throw new ImageNotFoundException("Gif Download failure");
        }
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine loadGif() : Real dimensions: " + new ViewDimension((int)imageStyle.realWidth, (int)imageStyle.realHeight));
        campaignDimension.height = (int)(imageStyle.realHeight * (double)campaignDimension.width / imageStyle.realWidth);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine loadGif() : Final Dimensions: " + campaignDimension);
        if (isResizeableGif) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
            layoutParams.gravity = 17;
            imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            imageView.setScaleType(ImageView.ScaleType.FIT_XY);
        } else {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
            imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
        GlobalResources.INSTANCE.getMainThread().post(() -> {
            try {
                Glide.with((Context)this.context).asGif().load(gifFile).into(imageView);
            }
            catch (Throwable t) {
                this.sdkInstance.logger.log(1, t, () -> "InApp_7.1.2_ViewEngine styleContainer() : ");
            }
        });
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine loadGif() : completed");
    }

    private ContainerStyle getPrimaryContainerStyle() throws IllegalStateException {
        if (this.payload.getPrimaryContainer() == null) {
            throw new IllegalStateException("no primary container found");
        }
        return (ContainerStyle)this.payload.getPrimaryContainer().style;
    }

    private MoECustomRatingBar createCustomRatingBar(InAppWidget widget, Orientation parentOrientation, ViewDimension toExclude) {
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createCustomRatingBar() : Will create rating widget: " + widget);
        MoECustomRatingBar ratingBar = this.widgetFactory.createCustomRatingBar(widget, parentOrientation, toExclude);
        CustomRatingComponent customRatingComponent = (CustomRatingComponent)widget.component;
        ratingBar.setOnRatingBarChangeListener((ratingBar1, rating, fromUser) -> {
            try {
                this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createCustomRatingBar() : onRatingChanged() : rating: " + rating);
                RatingChangeAction ratingChangeAction2 = ViewEngineUtilsKt.filterRatingChangeActionFromList(widget.actions);
                if (ratingChangeAction2 == null) {
                    this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createCustomRatingBar() onRatingChanged() : ratingChangeAction is null.");
                    return;
                }
                RatingIcon ratingIcon = customRatingComponent.getRatingIcons().get((int)rating);
                if (ratingIcon == null) {
                    this.sdkInstance.logger.log(1, () -> "InApp_7.1.2_ViewEngine createCustomRatingBar() : Couldn't find rating icon for rating " + rating);
                    return;
                }
                ViewEngineUtilsKt.addContentToSetTextAction(ratingChangeAction2.getActions(), ratingIcon.getDescription());
                new ActionHandler(this.activity, this.sdkInstance).onActionPerformed(this.inAppView, ratingChangeAction2, this.payload);
            }
            catch (Throwable t) {
                this.sdkInstance.logger.log(1, t, () -> "InApp_7.1.2_ViewEngine createCustomRatingBar() : ");
            }
        });
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine createCustomRatingBar() : MoECustomRatingBar created successfully.");
        return ratingBar;
    }

    private ViewDimension getStyleDimensionsToExclude(InAppContainer container, Boolean isPrimaryContainer) {
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine getStyleDimensionsToExclude() : will set dimensions");
        ContainerStyle containerStyle = (ContainerStyle)container.style;
        int borderWidth = containerStyle.background != null && containerStyle.border != null ? (int)(containerStyle.border.width * (double)this.densityScale) : 0;
        Spacing paddingSpacing = this.transformPadding(container.style.padding);
        Spacing spacingMargin = ViewEngineUtilsKt.transformMargin(this.sdkInstance, this.parentViewDimensions, container.style.margin);
        ViewDimension toExclude = new ViewDimension(borderWidth * 2, borderWidth * 2);
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine getStyleDimensionsToExclude() : toExclude: " + toExclude);
        if (isPrimaryContainer.booleanValue()) {
            this.primaryContainerExcludeDimen = toExclude;
        } else {
            toExclude.width += this.primaryContainerExcludeDimen.width;
            toExclude.height += this.primaryContainerExcludeDimen.height;
        }
        this.sdkInstance.logger.log(() -> "InApp_7.1.2_ViewEngine getStyleDimensionsToExclude() : completed");
        return toExclude;
    }
}

