/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.engine;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.GravityInt;
import androidx.core.content.ContextCompat;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.model.ViewDimension;
import com.moengage.inapp.internal.InAppInstanceProvider;
import com.moengage.inapp.internal.InAppModuleManager;
import com.moengage.inapp.internal.engine.ViewEngineUtilsKt;
import com.moengage.inapp.internal.exceptions.CouldNotCreateViewException;
import com.moengage.inapp.internal.model.Border;
import com.moengage.inapp.internal.model.CampaignPayload;
import com.moengage.inapp.internal.model.Color;
import com.moengage.inapp.internal.model.Margin;
import com.moengage.inapp.internal.model.NativeCampaignPayload;
import com.moengage.inapp.internal.model.Spacing;
import com.moengage.inapp.internal.model.actions.RatingChangeAction;
import com.moengage.inapp.internal.model.actions.SetTextAction;
import com.moengage.inapp.internal.model.configmeta.InAppConfigMeta;
import com.moengage.inapp.internal.model.configmeta.NudgeConfigMeta;
import com.moengage.inapp.internal.model.enums.Orientation;
import com.moengage.inapp.internal.model.style.InAppStyle;
import com.moengage.inapp.model.actions.Action;
import com.moengage.inapp.model.enums.InAppPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u00be\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u0000\u001a\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0000\u001a\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#H\u0003\u001a\u001a\u0010$\u001a\u0004\u0018\u00010\u00112\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'H\u0000\u001a\u0018\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0000\u001a\u0018\u0010,\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.H\u0000\u001a\"\u0010/\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00100\u001a\u00020.2\b\b\u0002\u00101\u001a\u000202H\u0000\u001a\u0018\u0010/\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00103\u001a\u000204H\u0000\u001a\u0018\u00105\u001a\u00020\b2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0000\u001a \u00105\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00106\u001a\u00020:2\u0006\u0010;\u001a\u00020#H\u0000\u001a \u0010<\u001a\u00020=2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010)\u001a\u00020'2\u0006\u0010>\u001a\u00020?H\u0000\u001a\u0018\u0010@\u001a\u00020\u00172\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u0017H\u0000\u001a\u0018\u0010D\u001a\u00020\b2\u0006\u0010E\u001a\u00020\u00172\u0006\u0010F\u001a\u00020GH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"TAG", "", "addContentToSetTextAction", "", "Lcom/moengage/inapp/model/actions/Action;", "actions", "content", "applyBackgroundToView", "", "view", "Landroid/view/View;", "drawable", "Landroid/graphics/drawable/Drawable;", "templateType", "filterRatingChangeActionFromList", "Lcom/moengage/inapp/internal/model/actions/RatingChangeAction;", "generateBitmapFromRes", "Landroid/graphics/Bitmap;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "context", "Landroid/content/Context;", "resId", "", "getBorder", "Landroid/graphics/drawable/GradientDrawable;", "border", "Lcom/moengage/inapp/internal/model/Border;", "densityScale", "", "getColor", "color", "Lcom/moengage/inapp/internal/model/Color;", "getLayoutGravityFromPosition", "position", "Lcom/moengage/inapp/model/enums/InAppPosition;", "getScaledBitmap", "imageBitmap", "bitmapDimension", "Lcom/moengage/core/internal/model/ViewDimension;", "getViewDimensionsFromPercentage", "viewDimension", "style", "Lcom/moengage/inapp/internal/model/style/InAppStyle;", "handleDismiss", "payload", "Lcom/moengage/inapp/internal/model/CampaignPayload;", "removeNonIntrusiveNudgeFromCache", "campaignPayload", "isVisible", "", "inAppConfigMeta", "Lcom/moengage/inapp/internal/model/configmeta/InAppConfigMeta;", "setLayoutGravity", "layoutParams", "Landroid/widget/LinearLayout$LayoutParams;", "parentOrientation", "Lcom/moengage/inapp/internal/model/enums/Orientation;", "Landroid/widget/FrameLayout$LayoutParams;", "inAppPosition", "transformMargin", "Lcom/moengage/inapp/internal/model/Spacing;", "margin", "Lcom/moengage/inapp/internal/model/Margin;", "transformViewDimension", "dimension", "", "containerReference", "updateContainerPaddingIfRequired", "borderWidth", "containerLayout", "Landroid/widget/RelativeLayout;", "inapp_release"})
public final class ViewEngineUtilsKt {
    @NotNull
    private static final String TAG = "InApp_7.1.2_ViewEngineUtils";

    public static final void handleDismiss(@NotNull SdkInstance sdkInstance, @NotNull CampaignPayload payload2) {
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)payload2, (String)"payload");
        InAppInstanceProvider.INSTANCE.getControllerForInstance$inapp_release(sdkInstance).getViewHandler().handleDismiss(payload2);
    }

    public static final void removeNonIntrusiveNudgeFromCache(@NotNull SdkInstance sdkInstance, @NotNull CampaignPayload campaignPayload, boolean isVisible) {
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)campaignPayload, (String)"campaignPayload");
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)removeNonIntrusiveNudgeFromCache.1.INSTANCE, (int)3, null);
        if (!Intrinsics.areEqual((Object)campaignPayload.getTemplateType(), (Object)"NON_INTRUSIVE")) {
            return;
        }
        InAppPosition position = ((NativeCampaignPayload)campaignPayload).getPosition();
        if (isVisible) {
            InAppModuleManager.INSTANCE.removeVisibleNudgePosition(position);
        }
        InAppModuleManager.INSTANCE.removeProcessingNudgePosition(position);
        InAppInstanceProvider.INSTANCE.getCacheForInstance$inapp_release(sdkInstance).removeFromVisibleOrProcessingNonIntrusiveNudge(campaignPayload.getCampaignId());
    }

    public static /* synthetic */ void removeNonIntrusiveNudgeFromCache$default(SdkInstance sdkInstance, CampaignPayload campaignPayload, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        ViewEngineUtilsKt.removeNonIntrusiveNudgeFromCache(sdkInstance, campaignPayload, bl);
    }

    @Nullable
    public static final Bitmap generateBitmapFromRes(@NotNull SdkInstance sdkInstance, @NotNull Context context, int resId) {
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(resId){
                final /* synthetic */ int $resId;
                {
                    this.$resId = $resId;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ViewEngineUtilsKt.access$getTAG$p() + " generateBitmapFromRes(): will generate bitmap for resId: " + this.$resId;
                }
            }), (int)3, null);
            Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)resId);
            if (drawable2 == null) {
                return null;
            }
            Drawable drawable3 = drawable2;
            drawable3.setBounds(0, 0, drawable3.getIntrinsicWidth(), drawable3.getIntrinsicHeight());
            Bitmap bitmap = Bitmap.createBitmap((int)drawable3.getIntrinsicWidth(), (int)drawable3.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(\n          \u2026onfig.ARGB_8888\n        )");
            Bitmap bitmap2 = bitmap;
            Canvas canvas = new Canvas(bitmap2);
            drawable3.draw(canvas);
            Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(resId){
                final /* synthetic */ int $resId;
                {
                    this.$resId = $resId;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ViewEngineUtilsKt.access$getTAG$p() + " generateBitmapFromRes(): generated bitmap for resId: " + this.$resId;
                }
            }), (int)3, null);
            return bitmap2;
        }
        catch (Throwable t) {
            sdkInstance.logger.log(1, t, (Function0)generateBitmapFromRes.3.INSTANCE);
            return null;
        }
    }

    @NotNull
    public static final Spacing transformMargin(@NotNull SdkInstance sdkInstance, @NotNull ViewDimension viewDimension, @NotNull Margin margin) {
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)viewDimension, (String)"viewDimension");
        Intrinsics.checkNotNullParameter((Object)margin, (String)"margin");
        Spacing spacing = new Spacing(margin.left == 0.0 ? 0 : ViewEngineUtilsKt.transformViewDimension(margin.left, viewDimension.width), margin.right == 0.0 ? 0 : ViewEngineUtilsKt.transformViewDimension(margin.right, viewDimension.width), margin.top == 0.0 ? 0 : ViewEngineUtilsKt.transformViewDimension(margin.top, viewDimension.height), margin.bottom == 0.0 ? 0 : ViewEngineUtilsKt.transformViewDimension(margin.bottom, viewDimension.height));
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(spacing){
            final /* synthetic */ Spacing $spacing;
            {
                this.$spacing = $spacing;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ViewEngineUtilsKt.access$getTAG$p() + " transformMargin() : Margin: " + this.$spacing;
            }
        }), (int)3, null);
        return spacing;
    }

    public static final int transformViewDimension(double dimension, int containerReference) {
        return (int)(dimension * (double)containerReference / (double)100);
    }

    @NotNull
    public static final ViewDimension getViewDimensionsFromPercentage(@NotNull ViewDimension viewDimension, @NotNull InAppStyle style) {
        Intrinsics.checkNotNullParameter((Object)viewDimension, (String)"viewDimension");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return new ViewDimension(ViewEngineUtilsKt.transformViewDimension(style.width, viewDimension.width), style.height == -2.0 ? -2 : ViewEngineUtilsKt.transformViewDimension(style.height, viewDimension.height));
    }

    @Nullable
    public static final Bitmap getScaledBitmap(@NotNull Bitmap imageBitmap, @NotNull ViewDimension bitmapDimension) {
        Intrinsics.checkNotNullParameter((Object)imageBitmap, (String)"imageBitmap");
        Intrinsics.checkNotNullParameter((Object)bitmapDimension, (String)"bitmapDimension");
        return Bitmap.createScaledBitmap((Bitmap)imageBitmap, (int)bitmapDimension.width, (int)bitmapDimension.height, (boolean)true);
    }

    public static final void setLayoutGravity(@NotNull LinearLayout.LayoutParams layoutParams, @NotNull Orientation parentOrientation) {
        Intrinsics.checkNotNullParameter((Object)layoutParams, (String)"layoutParams");
        Intrinsics.checkNotNullParameter((Object)((Object)parentOrientation), (String)"parentOrientation");
        if (Orientation.VERTICAL == parentOrientation) {
            layoutParams.gravity = 1;
        }
    }

    public static final void setLayoutGravity(@NotNull SdkInstance sdkInstance, @NotNull FrameLayout.LayoutParams layoutParams, @NotNull InAppPosition inAppPosition) {
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)layoutParams, (String)"layoutParams");
        Intrinsics.checkNotNullParameter((Object)((Object)inAppPosition), (String)"inAppPosition");
        layoutParams.gravity = ViewEngineUtilsKt.getLayoutGravityFromPosition(sdkInstance, inAppPosition);
    }

    @GravityInt
    private static final int getLayoutGravityFromPosition(SdkInstance sdkInstance, InAppPosition position) throws CouldNotCreateViewException {
        int n;
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(position){
            final /* synthetic */ InAppPosition $position;
            {
                this.$position = $position;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ViewEngineUtilsKt.access$getTAG$p() + " getLayoutGravityFromPosition(): will try to provide gravity for position: " + (Object)((Object)this.$position);
            }
        }), (int)3, null);
        switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
            case 1: {
                n = 49;
                break;
            }
            case 2: {
                n = 81;
                break;
            }
            case 3: {
                n = 8388691;
                break;
            }
            case 4: {
                n = 0x800055;
                break;
            }
            default: {
                throw new CouldNotCreateViewException("Unsupported InApp position: " + (Object)((Object)position));
            }
        }
        int gravity = n;
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(gravity){
            final /* synthetic */ int $gravity;
            {
                this.$gravity = $gravity;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ViewEngineUtilsKt.access$getTAG$p() + " getLayoutGravityFromPosition(): layout gravity: " + this.$gravity;
            }
        }), (int)3, null);
        return gravity;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RatingChangeAction filterRatingChangeActionFromList(@Nullable List<? extends Action> actions) {
        void $this$filterIsInstanceTo$iv$iv;
        if (actions == null) {
            return null;
        }
        Iterable $this$filterIsInstance$iv = actions;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RatingChangeAction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredActions = (List)destination$iv$iv;
        return filteredActions.isEmpty() ? (RatingChangeAction)null : (RatingChangeAction)filteredActions.get(0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Action> addContentToSetTextAction(@NotNull List<? extends Action> actions, @NotNull String content) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Iterable $this$filterIsInstance$iv = actions;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SetTextAction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$onEach$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2d16$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
            SetTextAction action = (SetTextAction)element$iv;
            boolean bl2 = false;
            action.setContent(content);
        }
        return actions;
    }

    public static final void applyBackgroundToView(@NotNull View view, @NotNull Drawable drawable2, @NotNull String templateType) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)templateType, (String)"templateType");
        view.setBackground(drawable2);
        view.setOutlineProvider(ViewOutlineProvider.BACKGROUND);
        view.setClipToOutline(true);
    }

    @NotNull
    public static final GradientDrawable getBorder(@NotNull Border border, float densityScale) {
        Intrinsics.checkNotNullParameter((Object)border, (String)"border");
        GradientDrawable drawable2 = new GradientDrawable();
        return ViewEngineUtilsKt.getBorder(border, drawable2, densityScale);
    }

    @NotNull
    public static final GradientDrawable getBorder(@NotNull Border border, @NotNull GradientDrawable drawable2, float densityScale) {
        Intrinsics.checkNotNullParameter((Object)border, (String)"border");
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        if (!(border.radius == 0.0)) {
            drawable2.setCornerRadius((float)border.radius * densityScale);
        }
        if (border.color != null && !(border.width == 0.0)) {
            int n = (int)(border.width * (double)densityScale);
            Color color = border.color;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"border.color");
            drawable2.setStroke(n, ViewEngineUtilsKt.getColor(color));
        }
        return drawable2;
    }

    public static final int getColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return android.graphics.Color.argb((int)((int)(color.alpha * 255.0f + 0.5f)), (int)color.red, (int)color.green, (int)color.blue);
    }

    public static final void updateContainerPaddingIfRequired(int borderWidth, @NotNull RelativeLayout containerLayout) {
        Intrinsics.checkNotNullParameter((Object)containerLayout, (String)"containerLayout");
        if (borderWidth != 0) {
            Spacing paddingSpacing = new Spacing(containerLayout.getPaddingLeft(), containerLayout.getPaddingRight(), containerLayout.getPaddingTop(), containerLayout.getPaddingBottom());
            containerLayout.setPadding(paddingSpacing.left + borderWidth, paddingSpacing.top + borderWidth, paddingSpacing.right + borderWidth, paddingSpacing.bottom + borderWidth);
        }
    }

    public static final void removeNonIntrusiveNudgeFromCache(@NotNull SdkInstance sdkInstance, @NotNull InAppConfigMeta inAppConfigMeta) {
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)inAppConfigMeta, (String)"inAppConfigMeta");
        if (!(inAppConfigMeta instanceof NudgeConfigMeta)) {
            return;
        }
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(inAppConfigMeta){
            final /* synthetic */ InAppConfigMeta $inAppConfigMeta;
            {
                this.$inAppConfigMeta = $inAppConfigMeta;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ViewEngineUtilsKt.access$getTAG$p() + " removeNonIntrusiveNudgeFromCache() : " + this.$inAppConfigMeta;
            }
        }), (int)3, null);
        InAppModuleManager.INSTANCE.removeVisibleNudgePosition(((NudgeConfigMeta)inAppConfigMeta).getPosition());
        InAppModuleManager.INSTANCE.removeProcessingNudgePosition(((NudgeConfigMeta)inAppConfigMeta).getPosition());
        InAppInstanceProvider.INSTANCE.getCacheForInstance$inapp_release(sdkInstance).removeFromVisibleOrProcessingNonIntrusiveNudge(inAppConfigMeta.getCampaignId());
    }

    public static final /* synthetic */ String access$getTAG$p() {
        return TAG;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InAppPosition.values().length];
            nArray[InAppPosition.TOP.ordinal()] = 1;
            nArray[InAppPosition.BOTTOM.ordinal()] = 2;
            nArray[InAppPosition.BOTTOM_LEFT.ordinal()] = 3;
            nArray[InAppPosition.BOTTOM_RIGHT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

