/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.html;

import com.moengage.core.Properties;
import com.moengage.core.model.GeoLocation;
import com.moengage.inapp.internal.UtilsKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J3\u0010\r\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/moengage/inapp/internal/html/WebPayloadParser;", "", "()V", "addDateAttributes", "", "dateAttrJson", "", "properties", "Lcom/moengage/core/Properties;", "addGeneralAttributes", "generalAttrJson", "addLocationAttributes", "locationAttrJson", "toProperties", "nonInteractive", "", "toProperties$inapp_release", "inapp_release"})
public final class WebPayloadParser {
    @NotNull
    public final Properties toProperties$inapp_release(@Nullable String generalAttrJson, @Nullable String locationAttrJson, @Nullable String dateAttrJson, boolean nonInteractive) {
        Properties properties = new Properties();
        this.addGeneralAttributes(generalAttrJson, properties);
        this.addLocationAttributes(locationAttrJson, properties);
        this.addDateAttributes(dateAttrJson, properties);
        if (nonInteractive) {
            properties.setNonInteractive();
        }
        return properties;
    }

    private final void addGeneralAttributes(String generalAttrJson, Properties properties) {
        CharSequence charSequence = generalAttrJson;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !UtilsKt.isValidJavaScriptString(generalAttrJson)) {
            return;
        }
        JSONObject attributesJson = new JSONObject(generalAttrJson);
        Iterator keys = attributesJson.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            CharSequence charSequence2 = key;
            if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            properties.addAttribute(key, attributesJson.get(key));
        }
    }

    private final void addLocationAttributes(String locationAttrJson, Properties properties) {
        CharSequence charSequence = locationAttrJson;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !UtilsKt.isValidJavaScriptString(locationAttrJson)) {
            return;
        }
        JSONObject locationJson = new JSONObject(locationAttrJson);
        Iterator keys = locationJson.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object object = locationJson.get(key);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.JSONObject");
            JSONObject value = (JSONObject)object;
            CharSequence charSequence2 = key;
            if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            properties.addAttribute(key, (Object)new GeoLocation(value.getDouble("latitude"), value.getDouble("longitude")));
        }
    }

    private final void addDateAttributes(String dateAttrJson, Properties properties) {
        CharSequence charSequence = dateAttrJson;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !UtilsKt.isValidJavaScriptString(dateAttrJson)) {
            return;
        }
        JSONObject dateAttributeJson = new JSONObject(dateAttrJson);
        Iterator keys = dateAttributeJson.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            CharSequence charSequence2 = key;
            if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            String string = dateAttributeJson.getString(key);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateAttributeJson.getString(key)");
            properties.addDateIso(key, string);
        }
    }
}

