/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.model.meta;

import androidx.annotation.Nullable;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.utils.ApiUtilsKt;
import com.moengage.core.internal.utils.TimeUtilsKt;
import com.moengage.inapp.internal.model.enums.CampaignSubType;
import com.moengage.inapp.internal.model.enums.InAppType;
import com.moengage.inapp.internal.model.enums.ScreenOrientation;
import com.moengage.inapp.internal.model.meta.DeliveryControl;
import com.moengage.inapp.internal.model.meta.DisplayControl;
import com.moengage.inapp.internal.model.meta.Trigger;
import com.moengage.inapp.internal.repository.ModelToJsonMapperKt;
import com.moengage.inapp.model.CampaignContext;
import com.moengage.inapp.model.enums.InAppPosition;
import java.util.Set;
import org.json.JSONObject;

public class CampaignMeta {
    private static final String TAG = "CampaignMeta";
    public final String campaignId;
    public final String campaignName;
    public final long expiryTime;
    public final long lastUpdatedTime;
    public final DisplayControl displayControl;
    public final String templateType;
    public final DeliveryControl deliveryControl;
    @Nullable
    public final Trigger trigger;
    @Nullable
    public final CampaignContext campaignContext;
    @Nullable
    public InAppType inAppType;
    public Set<ScreenOrientation> supportedOrientations;
    public final CampaignSubType campaignSubType;
    public final InAppPosition position;
    private static final String CAMPAIGN_ID = "campaign_id";
    private static final String CAMPAIGN_NAME = "campaign_name";
    private static final String EXPIRY_TIME = "expiry_time";
    private static final String LAST_UPDATED_TIME = "updated_time";
    private static final String DISPLAY_CONTROL = "display";
    private static final String TEMPLATE_TYPE = "template_type";
    private static final String DELIVERY_CONTROL = "delivery";
    private static final String TRIGGER = "trigger";
    private static final String CAMPAIGN_CONTEXT = "campaign_context";
    private static final String INAPP_TYPE = "inapp_type";
    private static final String ORIENTATIONS = "orientations";
    private static final String CAMPAIGN_SUB_TYPE = "campaign_sub_type";
    private static final String POSITION = "position";

    public CampaignMeta(String campaignId, String campaignName, long expiryTime, long lastUpdatedTime, DisplayControl displayControl, String templateType, DeliveryControl deliveryControl, @Nullable Trigger trigger, @Nullable CampaignContext campaignContext, @Nullable InAppType inAppType, Set<ScreenOrientation> supportedOrientations, CampaignSubType campaignSubType, InAppPosition position) {
        this.campaignId = campaignId;
        this.campaignName = campaignName;
        this.expiryTime = expiryTime;
        this.lastUpdatedTime = lastUpdatedTime;
        this.displayControl = displayControl;
        this.templateType = templateType;
        this.deliveryControl = deliveryControl;
        this.trigger = trigger;
        this.campaignContext = campaignContext;
        this.inAppType = inAppType;
        this.supportedOrientations = supportedOrientations;
        this.campaignSubType = campaignSubType;
        this.position = position;
    }

    public String toString() {
        try {
            JSONObject jsonObject = CampaignMeta.toJson(this);
            if (jsonObject != null) {
                return jsonObject.toString(4);
            }
        }
        catch (Throwable t) {
            Logger.print((int)1, (Throwable)t, () -> "CampaignMeta toString() ");
        }
        return super.toString();
    }

    public static JSONObject toJson(CampaignMeta meta) {
        try {
            JSONObject metaJson = new JSONObject();
            metaJson.put(CAMPAIGN_ID, (Object)meta.campaignId).put(CAMPAIGN_NAME, (Object)meta.campaignName).put(EXPIRY_TIME, (Object)TimeUtilsKt.isoStringFromSeconds((long)meta.expiryTime)).put(LAST_UPDATED_TIME, (Object)TimeUtilsKt.isoStringFromSeconds((long)meta.lastUpdatedTime)).put(DISPLAY_CONTROL, (Object)DisplayControl.toJson(meta.displayControl)).put(TEMPLATE_TYPE, (Object)meta.templateType).put(DELIVERY_CONTROL, (Object)DeliveryControl.toJson(meta.deliveryControl)).put(TRIGGER, (Object)ModelToJsonMapperKt.triggerToJson(meta.trigger)).put(CAMPAIGN_CONTEXT, (Object)meta.campaignContext).put(CAMPAIGN_SUB_TYPE, (Object)meta.campaignSubType.toString().toLowerCase());
            if (meta.campaignContext != null) {
                metaJson.put(CAMPAIGN_CONTEXT, (Object)meta.campaignContext.getPayload());
            }
            if (meta.inAppType != null) {
                metaJson.put(INAPP_TYPE, (Object)meta.inAppType.toString());
            }
            if (meta.supportedOrientations != null) {
                metaJson.put(ORIENTATIONS, (Object)ApiUtilsKt.setToJsonArray(meta.supportedOrientations));
            }
            if (meta.position != null) {
                metaJson.put(POSITION, (Object)meta.position.toString().toLowerCase());
            }
            return metaJson;
        }
        catch (Throwable t) {
            Logger.print((int)1, (Throwable)t, () -> "CampaignMetatoJson()");
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignMeta meta = (CampaignMeta)o;
        if (this.expiryTime != meta.expiryTime) {
            return false;
        }
        if (this.lastUpdatedTime != meta.lastUpdatedTime) {
            return false;
        }
        if (!this.campaignId.equals(meta.campaignId)) {
            return false;
        }
        if (!this.campaignName.equals(meta.campaignName)) {
            return false;
        }
        if (!this.displayControl.equals(meta.displayControl)) {
            return false;
        }
        if (!this.templateType.equals(meta.templateType)) {
            return false;
        }
        if (!this.deliveryControl.equals(meta.deliveryControl)) {
            return false;
        }
        if (this.campaignContext != null ? !this.campaignContext.equals(meta.campaignContext) : meta.campaignContext == null) {
            return false;
        }
        if (!(this.trigger == null ? meta.trigger == null : this.trigger.equals(meta.trigger))) {
            return false;
        }
        if (this.inAppType != meta.inAppType) {
            return false;
        }
        if (this.position != meta.position) {
            return false;
        }
        return this.supportedOrientations.equals(meta.supportedOrientations);
    }

    @Nullable
    private static CampaignContext campaignContextFromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return CampaignContext.fromJson(jsonObject);
    }
}

