/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.model.meta;

import androidx.annotation.Nullable;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.utils.CoreUtils;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Rules {
    private static final String TAG = "Rules";
    @Nullable
    public final String screenName;
    @Nullable
    public final Set<String> context;
    private static final String SCREEN_NAME = "screen_name";
    private static final String CONTEXTS = "contexts";

    public Rules(@Nullable String screenName, @Nullable Set<String> context) {
        this.screenName = screenName;
        this.context = context;
    }

    public static JSONObject toJson(Rules rules) {
        try {
            JSONObject rulesJson = new JSONObject();
            if (!CoreUtils.isNullOrEmpty((CharSequence)rules.screenName)) {
                rulesJson.put(SCREEN_NAME, (Object)rules.screenName);
            }
            if (rules.context != null && !rules.context.isEmpty()) {
                JSONArray contextArray = new JSONArray();
                Iterator<String> iterator = rules.context.iterator();
                while (iterator.hasNext()) {
                    contextArray.put((Object)iterator.next());
                }
                rulesJson.put(CONTEXTS, (Object)contextArray);
            }
            return rulesJson;
        }
        catch (Exception e) {
            Logger.print((int)1, (Throwable)e, () -> "Rules toJson() ");
            return null;
        }
    }

    public String toString() {
        try {
            JSONObject jsonObject = Rules.toJson(this);
            if (jsonObject != null) {
                return jsonObject.toString(4);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rules rules = (Rules)o;
        if (this.screenName != null ? !this.screenName.equals(rules.screenName) : rules.screenName != null) {
            return false;
        }
        return this.context != null ? this.context.equals(rules.context) : rules.context == null;
    }
}

