/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.repository;

import com.moengage.core.internal.model.Event;
import com.moengage.inapp.internal.DelayedInAppData;
import com.moengage.inapp.internal.InAppModuleManager;
import com.moengage.inapp.internal.ScreenData;
import com.moengage.inapp.internal.model.meta.InAppCampaign;
import com.moengage.inapp.internal.repository.InAppRepository;
import com.moengage.inapp.internal.repository.PayloadMapper;
import com.moengage.inapp.listeners.InAppLifeCycleListener;
import com.moengage.inapp.listeners.OnClickActionListener;
import com.moengage.inapp.listeners.SelfHandledAvailableListener;
import com.moengage.inapp.model.enums.InAppPosition;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020*J\u000e\u0010L\u001a\u00020J2\u0006\u0010M\u001a\u00020\u0005J\u0006\u0010N\u001a\u00020JJ\f\u0010O\u001a\b\u0012\u0004\u0012\u00020*0&J\u000e\u0010P\u001a\u00020\u00162\u0006\u0010M\u001a\u00020\u0005J\u000e\u0010Q\u001a\u00020J2\u0006\u0010M\u001a\u00020\u0005J\u000e\u0010R\u001a\u00020J2\u0006\u0010S\u001a\u00020TJ\u000e\u0010U\u001a\u00020J2\u0006\u0010V\u001a\u00020!J(\u0010W\u001a\u0014\u0012\u0004\u0012\u00020*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR*\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\"\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\u000f\u001a\u0004\u0018\u00010!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0014RB\u0010+\u001a\u0014\u0012\u0004\u0012\u00020*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100)2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\bR2\u0010-\u001a&\u0012\f\u0012\n .*\u0004\u0018\u00010*0* .*\u0012\u0012\f\u0012\n .*\u0004\u0018\u00010*0*\u0018\u00010\u00100&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0017\u00106\u001a\b\u0012\u0004\u0012\u0002070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u001eR*\u00109\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u001eR&\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020<0\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\b\"\u0004\b>\u0010?R*\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u0014R\u001c\u0010B\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u0017\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00050\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\u001e\u00a8\u0006X"}, d2={"Lcom/moengage/inapp/internal/repository/InAppCache;", "", "()V", "activityBasedVisibleOrProcessingCampaigns", "", "", "", "getActivityBasedVisibleOrProcessingCampaigns", "()Ljava/util/Map;", "clickActionListener", "Lcom/moengage/inapp/listeners/OnClickActionListener;", "getClickActionListener", "()Lcom/moengage/inapp/listeners/OnClickActionListener;", "setClickActionListener", "(Lcom/moengage/inapp/listeners/OnClickActionListener;)V", "<set-?>", "", "Lcom/moengage/inapp/internal/model/meta/InAppCampaign;", "generalCampaign", "getGeneralCampaign", "()Ljava/util/List;", "hasHtmlCampaignSetupFailed", "", "getHasHtmlCampaignSetupFailed", "()Z", "setHasHtmlCampaignSetupFailed", "(Z)V", "inAppContext", "", "getInAppContext", "()Ljava/util/Set;", "setInAppContext", "(Ljava/util/Set;)V", "Lcom/moengage/inapp/internal/ScreenData;", "lastScreenData", "getLastScreenData", "()Lcom/moengage/inapp/internal/ScreenData;", "lifeCycleListeners", "", "Lcom/moengage/inapp/listeners/InAppLifeCycleListener;", "getLifeCycleListeners", "", "Lcom/moengage/inapp/model/enums/InAppPosition;", "nonIntrusiveNudgeCampaigns", "getNonIntrusiveNudgeCampaigns", "pendingNudgeCalls", "kotlin.jvm.PlatformType", "pendingSelfHandledListener", "Ljava/lang/ref/WeakReference;", "Lcom/moengage/inapp/listeners/SelfHandledAvailableListener;", "getPendingSelfHandledListener", "()Ljava/lang/ref/WeakReference;", "setPendingSelfHandledListener", "(Ljava/lang/ref/WeakReference;)V", "pendingTriggerEvents", "Lcom/moengage/core/internal/model/Event;", "getPendingTriggerEvents", "primaryTriggerEvents", "getPrimaryTriggerEvents", "scheduledCampaigns", "Lcom/moengage/inapp/internal/DelayedInAppData;", "getScheduledCampaigns", "setScheduledCampaigns", "(Ljava/util/Map;)V", "selfHandledCampaign", "getSelfHandledCampaign", "selfHandledListener", "getSelfHandledListener", "()Lcom/moengage/inapp/listeners/SelfHandledAvailableListener;", "setSelfHandledListener", "(Lcom/moengage/inapp/listeners/SelfHandledAvailableListener;)V", "visibleOrProcessingCampaigns", "getVisibleOrProcessingCampaigns", "addToPendingNudgeCall", "", "position", "addVisibleOrProcessingNonIntrusiveNudge", "campaignId", "clearPendingNudgesCalls", "getPendingNudgeCalls", "isCampaignVisibleOrProcessing", "removeFromVisibleOrProcessingNonIntrusiveNudge", "updateCache", "repository", "Lcom/moengage/inapp/internal/repository/InAppRepository;", "updateLastScreenData", "screenData", "updateNonIntrusiveNudgeCampaigns", "inapp_release"})
public final class InAppCache {
    @NotNull
    private List<InAppCampaign> generalCampaign = CollectionsKt.emptyList();
    @NotNull
    private Set<String> primaryTriggerEvents = SetsKt.emptySet();
    @NotNull
    private List<InAppCampaign> selfHandledCampaign = CollectionsKt.emptyList();
    @Nullable
    private SelfHandledAvailableListener selfHandledListener;
    @Nullable
    private OnClickActionListener clickActionListener;
    @NotNull
    private final List<InAppLifeCycleListener> lifeCycleListeners = new ArrayList();
    @NotNull
    private final Set<Event> pendingTriggerEvents = new LinkedHashSet();
    @NotNull
    private Set<String> inAppContext = SetsKt.emptySet();
    @Nullable
    private ScreenData lastScreenData;
    private boolean hasHtmlCampaignSetupFailed;
    @NotNull
    private WeakReference<SelfHandledAvailableListener> pendingSelfHandledListener = new WeakReference<Object>(null);
    @NotNull
    private Map<String, DelayedInAppData> scheduledCampaigns;
    @NotNull
    private Map<InAppPosition, ? extends List<InAppCampaign>> nonIntrusiveNudgeCampaigns;
    @NotNull
    private final Map<String, Set<String>> activityBasedVisibleOrProcessingCampaigns;
    @NotNull
    private final Set<String> visibleOrProcessingCampaigns;
    private final List<InAppPosition> pendingNudgeCalls;

    public InAppCache() {
        Map map = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(mutableMapOf())");
        this.scheduledCampaigns = map;
        Map map2 = Collections.synchronizedMap(MapsKt.emptyMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"synchronizedMap(mapOf<In\u2026, List<InAppCampaign>>())");
        this.nonIntrusiveNudgeCampaigns = map2;
        Map map3 = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkNotNullExpressionValue(map3, (String)"synchronizedMap(\n       \u2026tableSet<String>>()\n    )");
        this.activityBasedVisibleOrProcessingCampaigns = map3;
        Set set = Collections.synchronizedSet(new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(mutableSetOf<String>())");
        this.visibleOrProcessingCampaigns = set;
        this.pendingNudgeCalls = Collections.synchronizedList(new ArrayList());
    }

    @NotNull
    public final List<InAppCampaign> getGeneralCampaign() {
        return this.generalCampaign;
    }

    @NotNull
    public final Set<String> getPrimaryTriggerEvents() {
        return this.primaryTriggerEvents;
    }

    @NotNull
    public final List<InAppCampaign> getSelfHandledCampaign() {
        return this.selfHandledCampaign;
    }

    public final void updateCache(@NotNull InAppRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        PayloadMapper mapper = new PayloadMapper();
        this.generalCampaign = mapper.entityToCampaign(repository.getGeneralCampaigns());
        this.primaryTriggerEvents = repository.getPrimaryTriggerEvents();
        this.selfHandledCampaign = mapper.entityToCampaign(repository.getSelfHandledCampaign());
        this.nonIntrusiveNudgeCampaigns = this.updateNonIntrusiveNudgeCampaigns(mapper.entityToCampaign(repository.getNonIntrusiveNudgeCampaigns()));
    }

    @Nullable
    public final SelfHandledAvailableListener getSelfHandledListener() {
        return this.selfHandledListener;
    }

    public final void setSelfHandledListener(@Nullable SelfHandledAvailableListener selfHandledAvailableListener) {
        this.selfHandledListener = selfHandledAvailableListener;
    }

    @Nullable
    public final OnClickActionListener getClickActionListener() {
        return this.clickActionListener;
    }

    public final void setClickActionListener(@Nullable OnClickActionListener onClickActionListener) {
        this.clickActionListener = onClickActionListener;
    }

    @NotNull
    public final List<InAppLifeCycleListener> getLifeCycleListeners() {
        return this.lifeCycleListeners;
    }

    @NotNull
    public final Set<Event> getPendingTriggerEvents() {
        return this.pendingTriggerEvents;
    }

    @NotNull
    public final Set<String> getInAppContext() {
        return this.inAppContext;
    }

    public final void setInAppContext(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.inAppContext = set;
    }

    @Nullable
    public final ScreenData getLastScreenData() {
        return this.lastScreenData;
    }

    public final void updateLastScreenData(@NotNull ScreenData screenData) {
        Intrinsics.checkNotNullParameter((Object)screenData, (String)"screenData");
        this.lastScreenData = screenData;
    }

    public final boolean getHasHtmlCampaignSetupFailed() {
        return this.hasHtmlCampaignSetupFailed;
    }

    public final void setHasHtmlCampaignSetupFailed(boolean bl) {
        this.hasHtmlCampaignSetupFailed = bl;
    }

    @NotNull
    public final WeakReference<SelfHandledAvailableListener> getPendingSelfHandledListener() {
        return this.pendingSelfHandledListener;
    }

    public final void setPendingSelfHandledListener(@NotNull WeakReference<SelfHandledAvailableListener> weakReference) {
        Intrinsics.checkNotNullParameter(weakReference, (String)"<set-?>");
        this.pendingSelfHandledListener = weakReference;
    }

    @NotNull
    public final Map<String, DelayedInAppData> getScheduledCampaigns() {
        return this.scheduledCampaigns;
    }

    public final void setScheduledCampaigns(@NotNull Map<String, DelayedInAppData> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.scheduledCampaigns = map;
    }

    @NotNull
    public final Map<InAppPosition, List<InAppCampaign>> getNonIntrusiveNudgeCampaigns() {
        return this.nonIntrusiveNudgeCampaigns;
    }

    @NotNull
    public final Map<String, Set<String>> getActivityBasedVisibleOrProcessingCampaigns() {
        return this.activityBasedVisibleOrProcessingCampaigns;
    }

    @NotNull
    public final Set<String> getVisibleOrProcessingCampaigns() {
        return this.visibleOrProcessingCampaigns;
    }

    private final Map<InAppPosition, List<InAppCampaign>> updateNonIntrusiveNudgeCampaigns(List<InAppCampaign> nonIntrusiveNudgeCampaigns) {
        Map map = new LinkedHashMap();
        for (InAppCampaign nudge : nonIntrusiveNudgeCampaigns) {
            InAppPosition inAppPosition;
            if (map.containsKey((Object)nudge.getCampaignMeta().position)) {
                List list = (List)map.get((Object)nudge.getCampaignMeta().position);
                if (list != null) {
                    list.add(nudge);
                }
                continue;
            }
            Map map2 = map;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)nudge.getCampaignMeta().position), (String)"nudge.campaignMeta.position");
            Object object = new InAppCampaign[]{nudge};
            object = CollectionsKt.mutableListOf((Object[])object);
            map2.put(inAppPosition, object);
        }
        return map;
    }

    public final void addVisibleOrProcessingNonIntrusiveNudge(@NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        String currentActivityName = InAppModuleManager.INSTANCE.getNotNullCurrentActivityName();
        if (this.activityBasedVisibleOrProcessingCampaigns.containsKey(currentActivityName)) {
            Set<String> set = this.activityBasedVisibleOrProcessingCampaigns.get(currentActivityName);
            if (set != null) {
                set.add(campaignId);
            }
        } else {
            Map<String, Set<String>> map = this.activityBasedVisibleOrProcessingCampaigns;
            Object object = new String[]{campaignId};
            object = SetsKt.mutableSetOf((Object[])object);
            map.put(currentActivityName, (Set<String>)object);
        }
        this.visibleOrProcessingCampaigns.add(campaignId);
    }

    public final void removeFromVisibleOrProcessingNonIntrusiveNudge(@NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        Set<String> set = this.activityBasedVisibleOrProcessingCampaigns.get(InAppModuleManager.INSTANCE.getNotNullCurrentActivityName());
        if (set != null) {
            set.remove(campaignId);
        }
        this.visibleOrProcessingCampaigns.remove(campaignId);
    }

    public final void clearPendingNudgesCalls() {
        this.pendingNudgeCalls.clear();
    }

    @NotNull
    public final List<InAppPosition> getPendingNudgeCalls() {
        List<InAppPosition> list = this.pendingNudgeCalls;
        Intrinsics.checkNotNullExpressionValue(list, (String)"pendingNudgeCalls");
        return list;
    }

    public final void addToPendingNudgeCall(@NotNull InAppPosition position) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        this.pendingNudgeCalls.add(position);
    }

    public final boolean isCampaignVisibleOrProcessing(@NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        return this.visibleOrProcessingCampaigns.contains(campaignId);
    }
}

