/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.repository;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import com.moengage.core.internal.lifecycle.LifecycleManager;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.storage.FileManager;
import com.moengage.core.internal.utils.CoreUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000eJ\u0016\u0010\u000f\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000eJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\n2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0018J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nJ \u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nJ\u001a\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0018\u0010%\u001a\u0004\u0018\u00010$2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/moengage/inapp/internal/repository/InAppFileManager;", "", "context", "Landroid/content/Context;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Landroid/content/Context;Lcom/moengage/core/internal/model/SdkInstance;)V", "fileManager", "Lcom/moengage/core/internal/storage/FileManager;", "tag", "", "deleteHtmlAssetsForCampaignIds", "", "campaignIdList", "", "deleteImagesForCampaignIds", "downloadAndSaveFile", "", "campaignId", "relativePath", "absoluteUrl", "downloadAndSaveHtmlAssets", "", "assets", "", "getBundledImageIfPresent", "Landroid/graphics/Bitmap;", "imageName", "getGifFromUrl", "Ljava/io/File;", "url", "getHtmlAssetsPath", "getImageFromUrl", "getRemoteImage", "imageURI", "getVideo", "Landroid/net/Uri;", "getVideoFromUrl", "isRemoteResource", "imageUrl", "inapp_release"})
public final class InAppFileManager {
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final String tag;
    @NotNull
    private FileManager fileManager;

    public InAppFileManager(@NotNull Context context, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.sdkInstance = sdkInstance;
        this.tag = "InApp_7.1.2_InAppFileManager";
        this.fileManager = new FileManager(context, this.sdkInstance);
    }

    @Nullable
    public final Bitmap getImageFromUrl(@NotNull Context context, @NotNull String url, @NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        try {
            return this.isRemoteResource(url) ? this.getRemoteImage(url, campaignId) : this.getBundledImageIfPresent(context, url);
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ InAppFileManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppFileManager.access$getTag$p(this.this$0) + "  getImageFromUrl() : ";
                }
            });
            return null;
        }
    }

    public final void deleteImagesForCampaignIds(@Nullable Set<String> campaignIdList) {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ InAppFileManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppFileManager.access$getTag$p(this.this$0) + " deleteImagesForCampaignIds() : Deleting images for campaigns";
            }
        }), (int)3, null);
        if (campaignIdList == null) {
            return;
        }
        Iterator<String> iterator = campaignIdList.iterator();
        while (iterator.hasNext()) {
            String campaignId;
            String it = campaignId = iterator.next();
            boolean bl = false;
            this.fileManager.deleteFolder(it);
        }
    }

    private final Bitmap getRemoteImage(String imageURI, String campaignId) throws NoSuchAlgorithmException {
        Bitmap bitmap;
        String fileName = CoreUtils.getSha256ForString((String)imageURI);
        if (this.fileManager.fileExistsInDirectory(campaignId, fileName)) {
            bitmap = BitmapFactory.decodeFile((String)this.fileManager.getPathForFile(campaignId, fileName));
        } else {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, imageURI){
                final /* synthetic */ InAppFileManager this$0;
                final /* synthetic */ String $imageURI;
                {
                    this.this$0 = $receiver;
                    this.$imageURI = $imageURI;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppFileManager.access$getTag$p(this.this$0) + " getRemoteImage() : Downloading image, url - " + this.$imageURI;
                }
            }), (int)3, null);
            Bitmap bitmap2 = CoreUtils.downloadImageBitmap((String)imageURI);
            if (bitmap2 == null) {
                return null;
            }
            Bitmap bitmap3 = bitmap2;
            this.fileManager.saveImageFile(campaignId, fileName, bitmap3);
            bitmap = bitmap3;
        }
        return bitmap;
    }

    private final Bitmap getBundledImageIfPresent(Context context, String imageName) {
        int res = context.getResources().getIdentifier(imageName, "drawable", context.getPackageName());
        return res == 0 ? (Bitmap)null : BitmapFactory.decodeResource((Resources)context.getResources(), (int)res);
    }

    private final boolean isRemoteResource(String imageUrl) {
        return StringsKt.startsWith$default((String)imageUrl, (String)"https://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)imageUrl, (String)"http://", (boolean)false, (int)2, null);
    }

    @Nullable
    public final File getGifFromUrl(@NotNull String url, @NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        try {
            String fileName = CoreUtils.getSha256ForString((String)url) + ".gif";
            if (this.fileManager.fileExistsInDirectory(campaignId, fileName)) {
                return this.fileManager.getFileByName(campaignId, fileName);
            }
            InputStream inputStream = new URL(url).openStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            return this.fileManager.saveFile(campaignId, fileName, inputStream);
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ InAppFileManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppFileManager.access$getTag$p(this.this$0) + "  getGifFromUrl() : ";
                }
            });
            return null;
        }
    }

    public final int downloadAndSaveHtmlAssets(@NotNull String campaignId, @NotNull Map<String, String> assets) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        Intrinsics.checkNotNullParameter(assets, (String)"assets");
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, campaignId){
            final /* synthetic */ InAppFileManager this$0;
            final /* synthetic */ String $campaignId;
            {
                this.this$0 = $receiver;
                this.$campaignId = $campaignId;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppFileManager.access$getTag$p(this.this$0) + "  downloadAndSaveFiles() : downloading files for campaignId: " + this.$campaignId;
            }
        }), (int)3, null);
        int[] nArray = new int[]{0};
        int[] successCount = nArray;
        try {
            CountDownLatch countDownLatch = new CountDownLatch(assets.size());
            ExecutorService executorService = Executors.newFixedThreadPool(Math.max(assets.size(), 5));
            for (Map.Entry<String, String> entry : assets.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                executorService.submit(() -> InAppFileManager.downloadAndSaveHtmlAssets$lambda-1(this, campaignId, key, value, successCount, countDownLatch));
            }
            countDownLatch.await();
            executorService.shutdown();
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ InAppFileManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppFileManager.access$getTag$p(this.this$0) + "  downloadAndSaveHtmlAssets() : ";
                }
            });
        }
        return successCount[0];
    }

    @NotNull
    public final String getHtmlAssetsPath(@NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        return this.fileManager.getPathForFile(campaignId + "/html", "");
    }

    private final boolean downloadAndSaveFile(String campaignId, String relativePath, String absoluteUrl) {
        try {
            String string = relativePath.substring(StringsKt.lastIndexOf$default((CharSequence)relativePath, (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String fileName = string;
            String subDir = StringsKt.replace$default((String)relativePath, (String)fileName, (String)"", (boolean)false, (int)4, null);
            if (((CharSequence)subDir).length() > 0) {
                subDir = campaignId + "/html/" + subDir;
            }
            if (this.fileManager.fileExistsInDirectory(subDir, fileName)) {
                Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, relativePath){
                    final /* synthetic */ InAppFileManager this$0;
                    final /* synthetic */ String $relativePath;
                    {
                        this.this$0 = $receiver;
                        this.$relativePath = $relativePath;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return InAppFileManager.access$getTag$p(this.this$0) + "  downloadAndSaveFiles() : file already exists. file:" + this.$relativePath;
                    }
                }), (int)3, null);
                return true;
            }
            InputStream inputStream = new URL(absoluteUrl).openStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            boolean isSuccess = this.fileManager.saveFile(subDir, fileName, inputStream) != null;
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, isSuccess, relativePath, absoluteUrl){
                final /* synthetic */ InAppFileManager this$0;
                final /* synthetic */ boolean $isSuccess;
                final /* synthetic */ String $relativePath;
                final /* synthetic */ String $absoluteUrl;
                {
                    this.this$0 = $receiver;
                    this.$isSuccess = $isSuccess;
                    this.$relativePath = $relativePath;
                    this.$absoluteUrl = $absoluteUrl;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppFileManager.access$getTag$p(this.this$0) + " downloadAndSaveFiles() : isDownloadSuccess: ," + this.$isSuccess + "  file: " + this.$relativePath + ", fileUrl: " + this.$absoluteUrl;
                }
            }), (int)3, null);
            inputStream.close();
            return isSuccess;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ InAppFileManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppFileManager.access$getTag$p(this.this$0) + " downloadAndSaveFiles() : ";
                }
            });
            return false;
        }
    }

    public final void deleteHtmlAssetsForCampaignIds(@Nullable Set<String> campaignIdList) {
        if (campaignIdList == null) {
            return;
        }
        for (String campaignId : campaignIdList) {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)3, null, (Function0)((Function0)new Function0<String>(this, campaignId){
                final /* synthetic */ InAppFileManager this$0;
                final /* synthetic */ String $campaignId;
                {
                    this.this$0 = $receiver;
                    this.$campaignId = $campaignId;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppFileManager.access$getTag$p(this.this$0) + " deleteHtmlAssetsForCampaignIds() : campaignId:" + this.$campaignId;
                }
            }), (int)2, null);
            this.fileManager.deleteFolder(campaignId + "/html");
        }
    }

    @Nullable
    public final Uri getVideoFromUrl(@NotNull String url, @NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, campaignId){
            final /* synthetic */ InAppFileManager this$0;
            final /* synthetic */ String $campaignId;
            {
                this.this$0 = $receiver;
                this.$campaignId = $campaignId;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppFileManager.access$getTag$p(this.this$0) + " getVideoFromUrl(): will try fetch video from url for campaignId: " + this.$campaignId;
            }
        }), (int)3, null);
        try {
            return this.isRemoteResource(url) ? this.getVideo(url, campaignId) : (Uri)null;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ InAppFileManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppFileManager.access$getTag$p(this.this$0) + "  getVideoFromUrl() : ";
                }
            });
            return null;
        }
    }

    private final Uri getVideo(String url, String campaignId) throws NoSuchAlgorithmException {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, campaignId, url){
            final /* synthetic */ InAppFileManager this$0;
            final /* synthetic */ String $campaignId;
            final /* synthetic */ String $url;
            {
                this.this$0 = $receiver;
                this.$campaignId = $campaignId;
                this.$url = $url;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppFileManager.access$getTag$p(this.this$0) + " getVideo(): will try to fetch video from the url for campaignId: " + this.$campaignId + ", url: " + this.$url;
            }
        }), (int)3, null);
        try {
            String fileName = CoreUtils.getSha256ForString((String)url);
            if (this.fileManager.fileExistsInDirectory(campaignId, fileName)) {
                return Uri.fromFile((File)this.fileManager.getFileByName(campaignId, fileName));
            }
            InputStream inputStream = new URL(url).openStream();
            LifecycleManager.INSTANCE.addBackgroundListener(arg_0 -> InAppFileManager.getVideo$lambda-2(inputStream, this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            File file = this.fileManager.saveFile(campaignId, fileName, inputStream);
            if (file == null) {
                return null;
            }
            File file2 = file;
            inputStream.close();
            return Uri.fromFile((File)file2);
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ InAppFileManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppFileManager.access$getTag$p(this.this$0) + " getVideo(): ";
                }
            });
            return null;
        }
    }

    private static final void downloadAndSaveHtmlAssets$lambda-1(InAppFileManager this$0, String $campaignId, String $key, String $value, int[] $successCount, CountDownLatch $countDownLatch) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$campaignId, (String)"$campaignId");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)$successCount, (String)"$successCount");
        Intrinsics.checkNotNullParameter((Object)$countDownLatch, (String)"$countDownLatch");
        if (this$0.downloadAndSaveFile($campaignId, $key, $value)) {
            int n = $successCount[0];
            $successCount[0] = n + 1;
        }
        $countDownLatch.countDown();
    }

    private static final void getVideo$lambda-2(InputStream $inputStream, InAppFileManager this$0, Context it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            $inputStream.close();
        }
        catch (Throwable t) {
            this$0.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this$0){
                final /* synthetic */ InAppFileManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppFileManager.access$getTag$p(this.this$0) + " getVideo(): onAppBackground() : ";
                }
            });
        }
    }

    public static final /* synthetic */ String access$getTag$p(InAppFileManager $this) {
        return $this.tag;
    }
}

