/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.repository;

import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.moengage.core.internal.exception.NetworkRequestDisabledException;
import com.moengage.core.internal.exception.NetworkRequestFailedException;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.DeviceType;
import com.moengage.core.internal.model.NetworkResult;
import com.moengage.core.internal.model.ResultFailure;
import com.moengage.core.internal.model.ResultSuccess;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.model.SdkStatus;
import com.moengage.core.internal.model.network.BaseRequest;
import com.moengage.core.internal.utils.TimeUtilsKt;
import com.moengage.inapp.internal.DeliveryLogger;
import com.moengage.inapp.internal.InAppInstanceProvider;
import com.moengage.inapp.internal.model.CampaignEntity;
import com.moengage.inapp.internal.model.CampaignPayload;
import com.moengage.inapp.internal.model.InAppGlobalState;
import com.moengage.inapp.internal.model.StatModel;
import com.moengage.inapp.internal.model.TriggerRequestMeta;
import com.moengage.inapp.internal.model.meta.CampaignState;
import com.moengage.inapp.internal.model.meta.InAppCampaign;
import com.moengage.inapp.internal.model.meta.Trigger;
import com.moengage.inapp.internal.model.meta.TriggerCondition;
import com.moengage.inapp.internal.model.network.CampaignError;
import com.moengage.inapp.internal.model.network.CampaignRequest;
import com.moengage.inapp.internal.model.network.InAppMetaRequest;
import com.moengage.inapp.internal.model.network.MetaResponse;
import com.moengage.inapp.internal.model.network.StatsUploadRequest;
import com.moengage.inapp.internal.repository.PayloadMapper;
import com.moengage.inapp.internal.repository.local.LocalRepository;
import com.moengage.inapp.internal.repository.remote.RemoteRepository;
import com.moengage.inapp.model.CampaignContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0096\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0001J\t\u0010\u0013\u001a\u00020\rH\u0096\u0001J\u0006\u0010\u0014\u001a\u00020\rJ\t\u0010\u0015\u001a\u00020\rH\u0096\u0001J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0001J\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0096\u0001J:\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0007J\u0011\u0010\u001e\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*H\u0096\u0001J\u0018\u0010+\u001a\u00020,2\u0006\u0010%\u001a\u00020&2\u0006\u0010-\u001a\u00020,H\u0007J\u0011\u0010.\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*H\u0096\u0001J\u001a\u0010/\u001a\u0004\u0018\u00010\u001b2\u0006\u00100\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0007J\u000f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0096\u0001J\u000f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0096\u0001J\t\u00103\u001a\u000204H\u0096\u0001J\u0013\u00105\u001a\u0004\u0018\u00010\u00102\u0006\u00100\u001a\u00020\u000bH\u0096\u0001J\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020!0\u000f2\u0006\u00107\u001a\u00020\u000bJ\u000f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0096\u0001J\t\u00109\u001a\u00020:H\u0096\u0001J\t\u0010;\u001a\u000204H\u0096\u0001J\t\u0010<\u001a\u000204H\u0096\u0001J\u000f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0096\u0001J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000b0$J\t\u0010?\u001a\u00020\u0017H\u0096\u0001J\t\u0010@\u001a\u00020AH\u0096\u0001J\u000f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0096\u0001J\u0017\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00190\u000f2\u0006\u0010D\u001a\u00020\u0017H\u0096\u0001J\u000f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0096\u0001J\u0006\u0010F\u001a\u00020,J\t\u0010G\u001a\u00020,H\u0096\u0001J\b\u0010H\u001a\u00020\rH\u0007J\u0018\u0010I\u001a\u00020\r2\u0006\u0010J\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000bH\u0002J\u0018\u0010K\u001a\u00020\r2\u0006\u0010L\u001a\u00020M2\u0006\u0010)\u001a\u00020*H\u0002J\u0011\u0010N\u001a\u00020\r2\u0006\u0010O\u001a\u000204H\u0096\u0001J\u0011\u0010P\u001a\u00020\r2\u0006\u0010Q\u001a\u000204H\u0096\u0001J\u0011\u0010R\u001a\u00020\r2\u0006\u0010S\u001a\u000204H\u0096\u0001J\u0011\u0010T\u001a\u00020\r2\u0006\u0010U\u001a\u000204H\u0096\u0001J\r\u0010V\u001a\u00020\rH\u0000\u00a2\u0006\u0002\bWJ\u0006\u0010X\u001a\u00020\rJ\u0019\u0010Y\u001a\u00020\u00172\u0006\u0010Z\u001a\u00020[2\u0006\u00100\u001a\u00020\u000bH\u0096\u0001J\u0010\u0010\\\u001a\u00020\r2\u0006\u00100\u001a\u00020\u000bH\u0002J\u0011\u0010]\u001a\u00020\r2\u0006\u0010^\u001a\u000204H\u0096\u0001J\u0006\u0010_\u001a\u00020\rJ\u0011\u0010_\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020`H\u0096\u0001J\u0011\u0010a\u001a\u0002042\u0006\u0010b\u001a\u00020\u0019H\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/moengage/inapp/internal/repository/InAppRepository;", "Lcom/moengage/inapp/internal/repository/local/LocalRepository;", "Lcom/moengage/inapp/internal/repository/remote/RemoteRepository;", "localRepository", "remoteRepository", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Lcom/moengage/inapp/internal/repository/local/LocalRepository;Lcom/moengage/inapp/internal/repository/remote/RemoteRepository;Lcom/moengage/core/internal/model/SdkInstance;)V", "syncObj", "", "tag", "", "addOrUpdateInApp", "", "newCampaigns", "", "Lcom/moengage/inapp/internal/model/CampaignEntity;", "baseRequest", "Lcom/moengage/core/internal/model/network/BaseRequest;", "clearData", "clearDataAndUpdateCache", "deleteExpiredCampaigns", "deleteStatById", "", "stat", "Lcom/moengage/inapp/internal/model/StatModel;", "fetchCampaignMeta", "Lcom/moengage/core/internal/model/NetworkResult;", "inAppMetaRequest", "Lcom/moengage/inapp/internal/model/network/InAppMetaRequest;", "fetchCampaignPayload", "Lcom/moengage/inapp/internal/model/CampaignPayload;", "campaign", "Lcom/moengage/inapp/internal/model/meta/InAppCampaign;", "screenName", "appContext", "", "deviceType", "Lcom/moengage/core/internal/model/DeviceType;", "triggerMeta", "Lcom/moengage/inapp/internal/model/TriggerRequestMeta;", "request", "Lcom/moengage/inapp/internal/model/network/CampaignRequest;", "fetchInAppCampaignMeta", "", "hasPushPermission", "fetchTestCampaign", "fetchTestCampaignPayload", "campaignId", "getAllActiveCampaigns", "getAllCampaigns", "getApiSyncInterval", "", "getCampaignById", "getCampaignsForEvent", "eventName", "getGeneralCampaigns", "getGlobalState", "Lcom/moengage/inapp/internal/model/InAppGlobalState;", "getLastHtmlAssetsDeleteTime", "getLastSyncTime", "getNonIntrusiveNudgeCampaigns", "getPrimaryTriggerEvents", "getPushPermissionRequestCount", "getSdkStatus", "Lcom/moengage/core/internal/model/SdkStatus;", "getSelfHandledCampaign", "getStats", "batchSize", "getTriggerCampaigns", "isModuleEnabled", "isStorageAndAPICallEnabled", "onLogout", "processError", "errorResponse", "processFailure", "error", "Lcom/moengage/inapp/internal/model/network/CampaignError;", "storeApiSyncInterval", "syncInterval", "storeGlobalDelay", "globalDelay", "storeHtmlAssetsDeleteTime", "deleteTime", "storeLastApiSyncTime", "nextSyncTime", "syncAndResetData", "syncAndResetData$inapp_release", "updateCache", "updateCampaignState", "state", "Lcom/moengage/inapp/internal/model/meta/CampaignState;", "updateCampaignStateForControlGroup", "updateLastShowTime", "time", "uploadStats", "Lcom/moengage/inapp/internal/model/network/StatsUploadRequest;", "writeStats", "statModel", "inapp_release"})
public final class InAppRepository
implements LocalRepository,
RemoteRepository {
    @NotNull
    private final LocalRepository localRepository;
    @NotNull
    private final RemoteRepository remoteRepository;
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final String tag;
    @NotNull
    private final Object syncObj;

    public InAppRepository(@NotNull LocalRepository localRepository, @NotNull RemoteRepository remoteRepository, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        Intrinsics.checkNotNullParameter((Object)remoteRepository, (String)"remoteRepository");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.localRepository = localRepository;
        this.remoteRepository = remoteRepository;
        this.sdkInstance = sdkInstance;
        this.tag = "InApp_7.1.1_InAppRepository";
        this.syncObj = new Object();
    }

    @Override
    public void addOrUpdateInApp(@NotNull List<CampaignEntity> newCampaigns) {
        Intrinsics.checkNotNullParameter(newCampaigns, (String)"newCampaigns");
        this.localRepository.addOrUpdateInApp(newCampaigns);
    }

    @Override
    @NotNull
    public BaseRequest baseRequest() {
        return this.localRepository.baseRequest();
    }

    @Override
    public void clearData() {
        this.localRepository.clearData();
    }

    @Override
    public void deleteExpiredCampaigns() {
        this.localRepository.deleteExpiredCampaigns();
    }

    @Override
    public int deleteStatById(@NotNull StatModel stat) {
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        return this.localRepository.deleteStatById(stat);
    }

    @Override
    @NotNull
    public List<CampaignEntity> getAllActiveCampaigns() {
        return this.localRepository.getAllActiveCampaigns();
    }

    @Override
    @NotNull
    public List<CampaignEntity> getAllCampaigns() {
        return this.localRepository.getAllCampaigns();
    }

    @Override
    public long getApiSyncInterval() {
        return this.localRepository.getApiSyncInterval();
    }

    @Override
    @Nullable
    public CampaignEntity getCampaignById(@NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        return this.localRepository.getCampaignById(campaignId);
    }

    @Override
    @NotNull
    public List<CampaignEntity> getGeneralCampaigns() {
        return this.localRepository.getGeneralCampaigns();
    }

    @Override
    @NotNull
    public InAppGlobalState getGlobalState() {
        return this.localRepository.getGlobalState();
    }

    @Override
    public long getLastHtmlAssetsDeleteTime() {
        return this.localRepository.getLastHtmlAssetsDeleteTime();
    }

    @Override
    public long getLastSyncTime() {
        return this.localRepository.getLastSyncTime();
    }

    @Override
    @NotNull
    public List<CampaignEntity> getNonIntrusiveNudgeCampaigns() {
        return this.localRepository.getNonIntrusiveNudgeCampaigns();
    }

    @Override
    public int getPushPermissionRequestCount() {
        return this.localRepository.getPushPermissionRequestCount();
    }

    @Override
    @NotNull
    public SdkStatus getSdkStatus() {
        return this.localRepository.getSdkStatus();
    }

    @Override
    @NotNull
    public List<CampaignEntity> getSelfHandledCampaign() {
        return this.localRepository.getSelfHandledCampaign();
    }

    @Override
    @NotNull
    public List<StatModel> getStats(int batchSize) {
        return this.localRepository.getStats(batchSize);
    }

    @Override
    @NotNull
    public List<CampaignEntity> getTriggerCampaigns() {
        return this.localRepository.getTriggerCampaigns();
    }

    @Override
    public boolean isStorageAndAPICallEnabled() {
        return this.localRepository.isStorageAndAPICallEnabled();
    }

    @Override
    public void storeApiSyncInterval(long syncInterval) {
        this.localRepository.storeApiSyncInterval(syncInterval);
    }

    @Override
    public void storeGlobalDelay(long globalDelay) {
        this.localRepository.storeGlobalDelay(globalDelay);
    }

    @Override
    public void storeHtmlAssetsDeleteTime(long deleteTime) {
        this.localRepository.storeHtmlAssetsDeleteTime(deleteTime);
    }

    @Override
    public void storeLastApiSyncTime(long nextSyncTime) {
        this.localRepository.storeLastApiSyncTime(nextSyncTime);
    }

    @Override
    public int updateCampaignState(@NotNull CampaignState state, @NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        return this.localRepository.updateCampaignState(state, campaignId);
    }

    @Override
    public void updateLastShowTime(long time) {
        this.localRepository.updateLastShowTime(time);
    }

    @Override
    public long writeStats(@NotNull StatModel statModel) {
        Intrinsics.checkNotNullParameter((Object)statModel, (String)"statModel");
        return this.localRepository.writeStats(statModel);
    }

    @Override
    @NotNull
    public NetworkResult fetchCampaignMeta(@NotNull InAppMetaRequest inAppMetaRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)inAppMetaRequest), (String)"inAppMetaRequest");
        return this.remoteRepository.fetchCampaignMeta(inAppMetaRequest);
    }

    @Override
    @NotNull
    public NetworkResult fetchCampaignPayload(@NotNull CampaignRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return this.remoteRepository.fetchCampaignPayload(request);
    }

    @Override
    @NotNull
    public NetworkResult fetchTestCampaign(@NotNull CampaignRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return this.remoteRepository.fetchTestCampaign(request);
    }

    @Override
    @NotNull
    public NetworkResult uploadStats(@NotNull StatsUploadRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return this.remoteRepository.uploadStats(request);
    }

    @WorkerThread
    public final boolean fetchInAppCampaignMeta(@NotNull DeviceType deviceType, boolean hasPushPermission) {
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ InAppRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppRepository.access$getTag$p(this.this$0) + " fetchInAppCampaignMeta() : Fetching in-app campaign meta";
            }
        }), (int)3, null);
        if (!this.isModuleEnabled()) {
            throw new NetworkRequestDisabledException("Account/SDK disabled.");
        }
        InAppMetaRequest request = new InAppMetaRequest(this.baseRequest(), deviceType, hasPushPermission);
        NetworkResult response = this.fetchCampaignMeta(request);
        if (response instanceof ResultFailure) {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ InAppRepository this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppRepository.access$getTag$p(this.this$0) + " fetchInAppCampaignMeta() : Meta API Failed.";
                }
            }), (int)3, null);
            throw new NetworkRequestFailedException("Meta API failed.");
        }
        if (response instanceof ResultSuccess) {
            Object object = ((ResultSuccess)response).getData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.moengage.inapp.internal.model.network.MetaResponse");
            MetaResponse meta = (MetaResponse)object;
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, meta){
                final /* synthetic */ InAppRepository this$0;
                final /* synthetic */ MetaResponse $meta;
                {
                    this.this$0 = $receiver;
                    this.$meta = $meta;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppRepository.access$getTag$p(this.this$0) + " fetchInAppCampaignMeta() : Sync Interval " + this.$meta.getSyncInterval();
                }
            }), (int)3, null);
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, meta){
                final /* synthetic */ InAppRepository this$0;
                final /* synthetic */ MetaResponse $meta;
                {
                    this.this$0 = $receiver;
                    this.$meta = $meta;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppRepository.access$getTag$p(this.this$0) + " fetchInAppCampaignMeta() : Global Delay " + this.$meta.getGlobalDelay();
                }
            }), (int)3, null);
            long currentTime = TimeUtilsKt.currentSeconds();
            this.storeLastApiSyncTime(currentTime);
            this.addOrUpdateInApp(meta.getCampaigns());
            if (meta.getSyncInterval() > 0L) {
                this.storeApiSyncInterval(meta.getSyncInterval());
            }
            if (meta.getGlobalDelay() >= 0L) {
                this.storeGlobalDelay(meta.getGlobalDelay());
            }
        }
        return true;
    }

    @WorkerThread
    @Nullable
    public final CampaignPayload fetchCampaignPayload(@NotNull InAppCampaign campaign, @NotNull String screenName, @NotNull Set<String> appContext, @NotNull DeviceType deviceType, @Nullable TriggerRequestMeta triggerMeta) {
        Intrinsics.checkNotNullParameter((Object)campaign, (String)"campaign");
        Intrinsics.checkNotNullParameter((Object)screenName, (String)"screenName");
        Intrinsics.checkNotNullParameter(appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ InAppRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppRepository.access$getTag$p(this.this$0) + " fetchCampaignPayload() : Fetching in-app campaign payload.";
            }
        }), (int)3, null);
        try {
            CampaignPayload campaignPayload;
            if (!this.isModuleEnabled()) {
                return null;
            }
            CampaignRequest request = new CampaignRequest(this.baseRequest(), campaign.getCampaignMeta().campaignId, screenName, appContext, triggerMeta, campaign.getCampaignMeta().campaignContext, deviceType, campaign.getCampaignMeta().inAppType);
            NetworkResult response = this.fetchCampaignPayload(request);
            if (response instanceof ResultFailure) {
                Object object = ((ResultFailure)response).getData();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.moengage.inapp.internal.model.network.CampaignError");
                CampaignError result = (CampaignError)object;
                this.processFailure(result, request);
                campaignPayload = null;
            } else if (response instanceof ResultSuccess) {
                CampaignPayload result;
                Object object = ((ResultSuccess)response).getData();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.moengage.inapp.internal.model.CampaignPayload");
                campaignPayload = result = (CampaignPayload)object;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return campaignPayload;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ InAppRepository this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppRepository.access$getTag$p(this.this$0) + " fetchCampaignPayload() : ";
                }
            });
            return null;
        }
    }

    private final void processFailure(CampaignError error, CampaignRequest request) {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, error){
            final /* synthetic */ InAppRepository this$0;
            final /* synthetic */ CampaignError $error;
            {
                this.this$0 = $receiver;
                this.$error = $error;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppRepository.access$getTag$p(this.this$0) + " processFailure() : Error: " + this.$error;
            }
        }), (int)3, null);
        if (error.getHasParsingException() && request.campaignContext != null) {
            DeliveryLogger deliveryLogger = InAppInstanceProvider.INSTANCE.getDeliveryLoggerForInstance$inapp_release(this.sdkInstance);
            CampaignContext campaignContext = request.campaignContext;
            Intrinsics.checkNotNullExpressionValue((Object)campaignContext, (String)"request.campaignContext");
            deliveryLogger.updateStatForCampaign$inapp_release(campaignContext, TimeUtilsKt.currentISOTime(), "DLV_MAND_PARM_MIS");
        } else if (error.getCode() == 410) {
            String string = error.getMessage();
            String string2 = request.campaignId;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.campaignId");
            this.processError(string, string2);
        } else if (error.getCode() != 409 && error.getCode() != 200 && request.campaignContext != null) {
            DeliveryLogger deliveryLogger = InAppInstanceProvider.INSTANCE.getDeliveryLoggerForInstance$inapp_release(this.sdkInstance);
            CampaignContext campaignContext = request.campaignContext;
            Intrinsics.checkNotNullExpressionValue((Object)campaignContext, (String)"request.campaignContext");
            deliveryLogger.updateStatForCampaign$inapp_release(campaignContext, TimeUtilsKt.currentISOTime(), "DLV_API_FLR");
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onLogout() {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ InAppRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppRepository.access$getTag$p(this.this$0) + " onLogout() : ";
            }
        }), (int)3, null);
        this.uploadStats();
        this.clearDataAndUpdateCache();
    }

    public final void updateCache() {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ InAppRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppRepository.access$getTag$p(this.this$0) + " updateCache() : Updating cache";
            }
        }), (int)3, null);
        InAppInstanceProvider.INSTANCE.getCacheForInstance$inapp_release(this.sdkInstance).updateCache(this);
    }

    @WorkerThread
    @Nullable
    public final NetworkResult fetchTestCampaignPayload(@NotNull String campaignId, @NotNull DeviceType deviceType) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ InAppRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppRepository.access$getTag$p(this.this$0) + " fetchTestCampaignPayload() : Fetching in-app test campaign payload.";
            }
        }), (int)3, null);
        try {
            if (!this.isModuleEnabled()) {
                return null;
            }
            return this.fetchTestCampaign(new CampaignRequest(this.baseRequest(), campaignId, deviceType));
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ InAppRepository this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppRepository.access$getTag$p(this.this$0) + " fetchTestCampaignPayload() : ";
                }
            });
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void uploadStats() {
        try {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ InAppRepository this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppRepository.access$getTag$p(this.this$0) + " uploadStats() : ";
                }
            }), (int)3, null);
            if (!this.isModuleEnabled() || !this.sdkInstance.getRemoteConfig().getInAppConfig().isStatsEnabled()) {
                return;
            }
            Object object = this.syncObj;
            synchronized (object) {
                boolean isSuccess;
                boolean bl = false;
                block5: do {
                    isSuccess = true;
                    List<StatModel> statList = this.getStats(30);
                    Collection collection = statList;
                    if (collection == null || collection.isEmpty()) {
                        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                            final /* synthetic */ InAppRepository this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return InAppRepository.access$getTag$p(this.this$0) + " uploadStats() : Not pending batches";
                            }
                        }), (int)3, null);
                        return;
                    }
                    for (StatModel model : statList) {
                        NetworkResult response = this.uploadStats(new StatsUploadRequest(this.baseRequest(), model));
                        if (response instanceof ResultFailure) {
                            isSuccess = false;
                            continue block5;
                        }
                        this.deleteStatById(model);
                    }
                } while (isSuccess);
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ InAppRepository this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppRepository.access$getTag$p(this.this$0) + " uploadStats() : ";
                }
            });
        }
    }

    public final boolean isModuleEnabled() {
        boolean isModuleEnabled2 = this.getSdkStatus().isEnabled() && this.sdkInstance.getRemoteConfig().isAppEnabled() && this.sdkInstance.getRemoteConfig().getModuleStatus().isInAppEnabled() && this.isStorageAndAPICallEnabled();
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, isModuleEnabled2){
            final /* synthetic */ InAppRepository this$0;
            final /* synthetic */ boolean $isModuleEnabled;
            {
                this.this$0 = $receiver;
                this.$isModuleEnabled = $isModuleEnabled;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppRepository.access$getTag$p(this.this$0) + " isModuleEnabled() : " + this.$isModuleEnabled;
            }
        }), (int)3, null);
        return isModuleEnabled2;
    }

    private final void processError(String errorResponse, String campaignId) {
        try {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, campaignId, errorResponse){
                final /* synthetic */ InAppRepository this$0;
                final /* synthetic */ String $campaignId;
                final /* synthetic */ String $errorResponse;
                {
                    this.this$0 = $receiver;
                    this.$campaignId = $campaignId;
                    this.$errorResponse = $errorResponse;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppRepository.access$getTag$p(this.this$0) + " processError() : Campaign id: " + this.$campaignId + ", error response: " + this.$errorResponse;
                }
            }), (int)3, null);
            if (StringsKt.isBlank((CharSequence)errorResponse)) {
                return;
            }
            JSONObject errorJson = new JSONObject(errorResponse);
            if (Intrinsics.areEqual((Object)"E001", (Object)errorJson.optString("code", ""))) {
                this.updateCampaignStateForControlGroup(campaignId);
            }
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ InAppRepository this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppRepository.access$getTag$p(this.this$0) + " processError() : ";
                }
            });
        }
    }

    private final void updateCampaignStateForControlGroup(String campaignId) {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, campaignId){
            final /* synthetic */ InAppRepository this$0;
            final /* synthetic */ String $campaignId;
            {
                this.this$0 = $receiver;
                this.$campaignId = $campaignId;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppRepository.access$getTag$p(this.this$0) + " updateCampaignStateForControlGroup() : Updating campaign state for id: " + this.$campaignId;
            }
        }), (int)3, null);
        CampaignEntity campaignEntity = this.getCampaignById(campaignId);
        if (campaignEntity == null) {
            return;
        }
        CampaignEntity campaign = campaignEntity;
        CampaignState updatedState = new CampaignState(campaign.getState().getShowCount() + 1L, TimeUtilsKt.currentSeconds(), campaign.getState().isClicked());
        this.updateCampaignState(updatedState, campaignId);
        this.updateCache();
    }

    @NotNull
    public final List<InAppCampaign> getCampaignsForEvent(@NotNull String eventName) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        try {
            PayloadMapper mapper = new PayloadMapper();
            List<InAppCampaign> triggerCampaigns = mapper.entityToCampaign(this.localRepository.getTriggerCampaigns());
            if (triggerCampaigns.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            List filteredTriggerCampaigns = new ArrayList();
            block2: for (InAppCampaign triggerCampaign : triggerCampaigns) {
                Trigger trigger;
                if (triggerCampaign.getCampaignMeta().trigger == null) continue;
                boolean bl = false;
                for (TriggerCondition triggerCondition : trigger.getPrimaryConditions()) {
                    if (!Intrinsics.areEqual((Object)triggerCondition.getEventName(), (Object)eventName)) continue;
                    filteredTriggerCampaigns.add(triggerCampaign);
                    continue block2;
                }
            }
            return filteredTriggerCampaigns;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ InAppRepository this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppRepository.access$getTag$p(this.this$0) + " getCampaignsForEvent() : ";
                }
            });
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getPrimaryTriggerEvents() {
        try {
            List<InAppCampaign> triggerCampaigns = new PayloadMapper().entityToCampaign(this.getTriggerCampaigns());
            if (triggerCampaigns.isEmpty()) {
                return SetsKt.emptySet();
            }
            Set triggerEvents = new LinkedHashSet();
            for (InAppCampaign triggerCampaign : triggerCampaigns) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Trigger trigger;
                if (triggerCampaign.getCampaignMeta().trigger == null) continue;
                boolean bl = false;
                Iterable iterable = trigger.getPrimaryConditions();
                Set set = triggerEvents;
                boolean $i$f$map = false;
                void var10_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void triggerCondition;
                    TriggerCondition triggerCondition2 = (TriggerCondition)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(triggerCondition.getEventName());
                }
                set.addAll((List)destination$iv$iv);
            }
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, (Set<String>)triggerEvents){
                final /* synthetic */ InAppRepository this$0;
                final /* synthetic */ Set<String> $triggerEvents;
                {
                    this.this$0 = $receiver;
                    this.$triggerEvents = $triggerEvents;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppRepository.access$getTag$p(this.this$0) + " getPrimaryTriggerEvents() : Trigger Events: " + CollectionsKt.joinToString$default((Iterable)this.$triggerEvents, null, null, null, (int)0, null, null, (int)63, null);
                }
            }), (int)3, null);
            return triggerEvents;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ InAppRepository this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InAppRepository.access$getTag$p(this.this$0) + " getPrimaryTriggerEvents() : ";
                }
            });
            return SetsKt.emptySet();
        }
    }

    public final void clearDataAndUpdateCache() {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ InAppRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppRepository.access$getTag$p(this.this$0) + " clearDataAndUpdateCache() : ";
            }
        }), (int)3, null);
        this.clearData();
        this.updateCache();
    }

    public final void syncAndResetData$inapp_release() {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ InAppRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return InAppRepository.access$getTag$p(this.this$0) + " syncAndResetData() : ";
            }
        }), (int)3, null);
        this.uploadStats();
        this.clearDataAndUpdateCache();
    }

    public static final /* synthetic */ String access$getTag$p(InAppRepository $this) {
        return $this.tag;
    }
}

