/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.repository;

import com.moengage.core.internal.utils.ApiUtilsKt;
import com.moengage.core.internal.utils.MoEUtils;
import com.moengage.core.internal.utils.TimeUtilsKt;
import com.moengage.inapp.internal.UtilsKt;
import com.moengage.inapp.internal.exceptions.ParseException;
import com.moengage.inapp.internal.model.CampaignEntity;
import com.moengage.inapp.internal.model.enums.CampaignSubType;
import com.moengage.inapp.internal.model.enums.InAppType;
import com.moengage.inapp.internal.model.enums.ScreenOrientation;
import com.moengage.inapp.internal.model.meta.CampaignMeta;
import com.moengage.inapp.internal.model.meta.CampaignState;
import com.moengage.inapp.internal.model.meta.DeliveryControl;
import com.moengage.inapp.internal.model.meta.DisplayControl;
import com.moengage.inapp.internal.model.meta.FrequencyCapping;
import com.moengage.inapp.internal.model.meta.InAppCampaign;
import com.moengage.inapp.internal.model.meta.Rules;
import com.moengage.inapp.internal.model.meta.Trigger;
import com.moengage.inapp.internal.model.meta.TriggerCondition;
import com.moengage.inapp.model.CampaignContext;
import com.moengage.inapp.model.enums.InAppPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nJ\u0010\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\nJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\nJ\u0010\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\nJ\u0012\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010\nJ\u0010\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010+\u001a\u00020\nJ\u000e\u0010.\u001a\u00020/2\u0006\u0010\u000f\u001a\u00020\n\u00a8\u00060"}, d2={"Lcom/moengage/inapp/internal/repository/PayloadMapper;", "", "()V", "campaignEntityToCampaign", "Lcom/moengage/inapp/internal/model/meta/InAppCampaign;", "entity", "Lcom/moengage/inapp/internal/model/CampaignEntity;", "campaignStateFromJson", "Lcom/moengage/inapp/internal/model/meta/CampaignState;", "stateJson", "Lorg/json/JSONObject;", "campaignStateToJson", "state", "deletionTimeForCampaign", "", "campaignJson", "entityToCampaign", "", "entities", "getCampaignType", "", "getPriorityForCampaign", "jsonToCampaignContext", "Lcom/moengage/inapp/model/CampaignContext;", "contextJson", "jsonToCampaignEntity", "jsonToCampaignMeta", "Lcom/moengage/inapp/internal/model/meta/CampaignMeta;", "metaJson", "jsonToDeliveryControl", "Lcom/moengage/inapp/internal/model/meta/DeliveryControl;", "deliveryJson", "jsonToDisplayControl", "Lcom/moengage/inapp/internal/model/meta/DisplayControl;", "displayJson", "jsonToFrequencyCapping", "Lcom/moengage/inapp/internal/model/meta/FrequencyCapping;", "frequencyJson", "jsonToRules", "Lcom/moengage/inapp/internal/model/meta/Rules;", "rulesJson", "jsonToTrigger", "Lcom/moengage/inapp/internal/model/meta/Trigger;", "triggerJson", "jsonToTriggerCondition", "Lcom/moengage/inapp/internal/model/meta/TriggerCondition;", "validateMandatoryCampaignParams", "", "inapp_release"})
public final class PayloadMapper {
    @NotNull
    public final CampaignMeta jsonToCampaignMeta(@NotNull JSONObject metaJson) {
        InAppPosition inAppPosition;
        Set<ScreenOrientation> set;
        InAppType inAppType;
        Intrinsics.checkNotNullParameter((Object)metaJson, (String)"metaJson");
        String string = metaJson.getString("campaign_id");
        String string2 = metaJson.getString("campaign_name");
        String string3 = metaJson.getString("expiry_time");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"metaJson.getString(EXPIRY_TIME)");
        long l = TimeUtilsKt.secondsFromIsoString((String)string3);
        String string4 = metaJson.getString("updated_time");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"metaJson.getString(LAST_UPDATED_TIME)");
        long l2 = TimeUtilsKt.secondsFromIsoString((String)string4);
        DisplayControl displayControl = this.jsonToDisplayControl(metaJson.optJSONObject("display"));
        String string5 = metaJson.getString("template_type");
        JSONObject jSONObject = metaJson.getJSONObject("delivery");
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"metaJson.getJSONObject(DELIVERY_CONTROL)");
        DeliveryControl deliveryControl = this.jsonToDeliveryControl(jSONObject);
        Trigger trigger = this.jsonToTrigger(metaJson.optJSONObject("trigger"));
        CampaignContext campaignContext = this.jsonToCampaignContext(metaJson.optJSONObject("campaign_context"));
        if (metaJson.has("inapp_type")) {
            String string6 = metaJson.getString("inapp_type");
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"metaJson.getString(INAPP_TYPE)");
            String string7 = string6.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            inAppType = InAppType.valueOf(string7);
        } else {
            inAppType = null;
        }
        if (metaJson.has("orientations")) {
            JSONArray jSONArray = metaJson.getJSONArray("orientations");
            Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"metaJson.getJSONArray(ORIENTATIONS)");
            set = UtilsKt.screenOrientationFromJson(jSONArray);
        } else {
            set = null;
        }
        String string8 = metaJson.optString("campaign_sub_type", CampaignSubType.GENERAL.toString());
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"metaJson.optString(CAMPA\u2026bType.GENERAL.toString())");
        String string9 = string8.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        CampaignSubType campaignSubType = CampaignSubType.valueOf(string9);
        if (metaJson.has("position")) {
            String string10 = metaJson.getString("position");
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"metaJson.getString(POSITION)");
            String string11 = ((Object)StringsKt.trim((CharSequence)string10)).toString().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            inAppPosition = InAppPosition.valueOf(string11);
        } else {
            inAppPosition = null;
        }
        return new CampaignMeta(string, string2, l, l2, displayControl, string5, deliveryControl, trigger, campaignContext, inAppType, set, campaignSubType, inAppPosition);
    }

    @NotNull
    public final DisplayControl jsonToDisplayControl(@Nullable JSONObject displayJson) {
        if (displayJson == null) {
            return new DisplayControl(new Rules(null, SetsKt.emptySet()), -1L);
        }
        return new DisplayControl(this.jsonToRules(displayJson.optJSONObject("rules")), displayJson.optLong("delay", -1L));
    }

    @NotNull
    public final Rules jsonToRules(@Nullable JSONObject rulesJson) {
        if (rulesJson == null) {
            return new Rules(null, SetsKt.emptySet());
        }
        return new Rules(rulesJson.optString("screen_name", null), ApiUtilsKt.jsonArrayToStringSet$default((JSONArray)rulesJson.optJSONArray("contexts"), (boolean)false, (int)2, null));
    }

    @NotNull
    public final DeliveryControl jsonToDeliveryControl(@NotNull JSONObject deliveryJson) {
        Intrinsics.checkNotNullParameter((Object)deliveryJson, (String)"deliveryJson");
        long l = deliveryJson.getLong("priority");
        JSONObject jSONObject = deliveryJson.getJSONObject("fc_meta");
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"deliveryJson.getJSONObject(FC_META)");
        return new DeliveryControl(l, this.jsonToFrequencyCapping(jSONObject));
    }

    @NotNull
    public final FrequencyCapping jsonToFrequencyCapping(@NotNull JSONObject frequencyJson) {
        Intrinsics.checkNotNullParameter((Object)frequencyJson, (String)"frequencyJson");
        return new FrequencyCapping(frequencyJson.getBoolean("ignore_global_delay"), frequencyJson.getLong("count"), frequencyJson.getLong("delay"));
    }

    @Nullable
    public final Trigger jsonToTrigger(@Nullable JSONObject triggerJson) {
        Trigger trigger;
        if (triggerJson == null || !triggerJson.has("primary_condition")) {
            return null;
        }
        JSONObject primaryCondition = triggerJson.getJSONObject("primary_condition");
        if (primaryCondition.has("included_filters") && primaryCondition.getJSONObject("included_filters").has("filters")) {
            JSONArray filters = primaryCondition.getJSONObject("included_filters").getJSONArray("filters");
            List triggerConditions = new ArrayList();
            int n = filters.length();
            for (int filterIndex = 0; filterIndex < n; ++filterIndex) {
                TriggerCondition triggerCondition;
                JSONObject jSONObject = filters.getJSONObject(filterIndex);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"filters.getJSONObject(filterIndex)");
                if (this.jsonToTriggerCondition(jSONObject) == null) continue;
                boolean bl = false;
                triggerConditions.add(triggerCondition);
            }
            trigger = !((Collection)triggerConditions).isEmpty() ? new Trigger(triggerConditions) : (Trigger)null;
        } else {
            trigger = null;
        }
        return trigger;
    }

    @Nullable
    public final TriggerCondition jsonToTriggerCondition(@NotNull JSONObject triggerJson) {
        TriggerCondition triggerCondition;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)triggerJson, (String)"triggerJson");
        if (triggerJson.has("action_name") && !((charSequence = (CharSequence)triggerJson.getString("action_name")) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String string = triggerJson.getString("action_name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"triggerJson.getString(ACTION_NAME)");
            triggerCondition = new TriggerCondition(string, triggerJson.optJSONObject("attributes"));
        } else {
            triggerCondition = null;
        }
        return triggerCondition;
    }

    @Nullable
    public final CampaignContext jsonToCampaignContext(@Nullable JSONObject contextJson) {
        CampaignContext campaignContext;
        if (contextJson == null) {
            campaignContext = null;
        } else {
            String string = contextJson.getString("cid");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contextJson.getString(CID)");
            Map map = MoEUtils.jsonToMap((JSONObject)contextJson);
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"jsonToMap(contextJson)");
            campaignContext = new CampaignContext(string, contextJson, map);
        }
        return campaignContext;
    }

    @NotNull
    public final CampaignState campaignStateFromJson(@NotNull JSONObject stateJson) {
        Intrinsics.checkNotNullParameter((Object)stateJson, (String)"stateJson");
        return new CampaignState(stateJson.optLong("show_count", 0L), stateJson.optLong("last_show_time", 0L), stateJson.optBoolean("is_clicked", false));
    }

    @NotNull
    public final JSONObject campaignStateToJson(@NotNull CampaignState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        JSONObject json = new JSONObject();
        json.put("show_count", state.getShowCount()).put("last_show_time", state.getLastShowTime()).put("is_clicked", state.isClicked());
        return json;
    }

    @NotNull
    public final CampaignEntity jsonToCampaignEntity(@NotNull JSONObject campaignJson) {
        Intrinsics.checkNotNullParameter((Object)campaignJson, (String)"campaignJson");
        this.validateMandatoryCampaignParams(campaignJson);
        String string = campaignJson.getString("campaign_id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"campaignJson.getString(CAMPAIGN_ID)");
        String string2 = this.getCampaignType(campaignJson);
        String string3 = campaignJson.getString("status");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"campaignJson.getString(STATUS)");
        String string4 = campaignJson.getString("template_type");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"campaignJson.getString(TEMPLATE_TYPE)");
        CampaignState campaignState = new CampaignState(0L, 0L, false);
        long l = this.getPriorityForCampaign(campaignJson);
        String string5 = campaignJson.getString("updated_time");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"campaignJson.getString(LAST_UPDATED_TIME)");
        long l2 = TimeUtilsKt.secondsFromIsoString((String)string5);
        long l3 = this.deletionTimeForCampaign(campaignJson);
        long l4 = TimeUtilsKt.currentSeconds();
        String string6 = campaignJson.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"campaignJson.toString()");
        return new CampaignEntity(-1L, string, string2, string3, string4, campaignState, l, l2, l3, l4, string6);
    }

    public final long deletionTimeForCampaign(@NotNull JSONObject campaignJson) {
        Intrinsics.checkNotNullParameter((Object)campaignJson, (String)"campaignJson");
        long l = TimeUtilsKt.currentSeconds() + 5184000L;
        String string = campaignJson.getString("expiry_time");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"campaignJson.getString(EXPIRY_TIME)");
        return RangesKt.coerceAtLeast((long)l, (long)TimeUtilsKt.secondsFromIsoString((String)string));
    }

    public final long getPriorityForCampaign(@NotNull JSONObject campaignJson) {
        Intrinsics.checkNotNullParameter((Object)campaignJson, (String)"campaignJson");
        return campaignJson.getJSONObject("delivery").getLong("priority");
    }

    @NotNull
    public final String getCampaignType(@NotNull JSONObject campaignJson) {
        Intrinsics.checkNotNullParameter((Object)campaignJson, (String)"campaignJson");
        return campaignJson.optJSONObject("trigger") != null ? "smart" : "general";
    }

    @NotNull
    public final List<InAppCampaign> entityToCampaign(@NotNull List<CampaignEntity> entities) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        List campaigns = new ArrayList();
        for (CampaignEntity entity : entities) {
            campaigns.add(this.campaignEntityToCampaign(entity));
        }
        return campaigns;
    }

    @NotNull
    public final InAppCampaign campaignEntityToCampaign(@NotNull CampaignEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return new InAppCampaign(entity.getCampaignType(), entity.getStatus(), entity.getDeletionTime(), this.jsonToCampaignMeta(new JSONObject(entity.getMetaPayload())), entity.getState());
    }

    public final void validateMandatoryCampaignParams(@NotNull JSONObject campaignJson) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)campaignJson, (String)"campaignJson");
        if (campaignJson.getString("template_type").equals("NON_INTRUSIVE") && !campaignJson.has("position")) {
            throw new ParseException("position is a mandatory param for non-intrusive nudges");
        }
    }
}

