/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.repository.local;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import com.moengage.core.internal.CoreInternalHelper;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.model.SdkStatus;
import com.moengage.core.internal.model.database.DataAccessor;
import com.moengage.core.internal.model.database.QueryParams;
import com.moengage.core.internal.model.database.WhereClause;
import com.moengage.core.internal.model.network.BaseRequest;
import com.moengage.core.internal.storage.database.contract.InAppStatsContractKt;
import com.moengage.core.internal.storage.database.contract.InAppV3ContractKt;
import com.moengage.core.internal.utils.RestUtilKt;
import com.moengage.core.internal.utils.TimeUtilsKt;
import com.moengage.inapp.internal.model.CampaignEntity;
import com.moengage.inapp.internal.model.InAppGlobalState;
import com.moengage.inapp.internal.model.StatModel;
import com.moengage.inapp.internal.model.meta.CampaignState;
import com.moengage.inapp.internal.repository.InAppFileManager;
import com.moengage.inapp.internal.repository.local.LocalRepository;
import com.moengage.inapp.internal.repository.local.Marshaller;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u0016\u001a\u00020\fJ\b\u0010\u0017\u001a\u00020\u000eH\u0016J\u0006\u0010\u0018\u001a\u00020\u000eJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\b\u0010\u001c\u001a\u00020\u000eH\u0016J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u000eH\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u0015J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010'\u001a\u00020\u001fH\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u00112\u0006\u0010)\u001a\u00020\fH\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u001fH\u0016J\b\u0010.\u001a\u00020\u001fH\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u00100\u001a\u00020\u001aH\u0016J\b\u00101\u001a\u000202H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020#0\u00102\u0006\u00105\u001a\u00020\u001aH\u0016J\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001107J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u00109\u001a\u00020:H\u0016J\u000e\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u0011J\u0010\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\u001fH\u0016J\u0010\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020\u001fH\u0016J\u0010\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\u001fH\u0016J\u0010\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020\u001fH\u0016J\u0010\u0010E\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u0011H\u0002J\u0018\u0010F\u001a\u00020\u001a2\u0006\u0010G\u001a\u00020H2\u0006\u0010)\u001a\u00020\fH\u0016J\u0018\u0010I\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\f2\u0006\u0010J\u001a\u00020\fH\u0002J\u0010\u0010K\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020\u001fH\u0016J\u0010\u0010M\u001a\u00020\u001f2\u0006\u0010N\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/moengage/inapp/internal/repository/local/LocalRepositoryImpl;", "Lcom/moengage/inapp/internal/repository/local/LocalRepository;", "context", "Landroid/content/Context;", "dataAccessor", "Lcom/moengage/core/internal/model/database/DataAccessor;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Landroid/content/Context;Lcom/moengage/core/internal/model/database/DataAccessor;Lcom/moengage/core/internal/model/SdkInstance;)V", "marshaller", "Lcom/moengage/inapp/internal/repository/local/Marshaller;", "tag", "", "addOrUpdateInApp", "", "newCampaigns", "", "Lcom/moengage/inapp/internal/model/CampaignEntity;", "baseRequest", "Lcom/moengage/core/internal/model/network/BaseRequest;", "campaignsEligibleForDeletion", "", "timeInSecs", "clearData", "clearLastSyncTime", "deleteAllCampaigns", "", "deleteAllStats", "deleteExpiredCampaigns", "deleteExpiredCampaignsFromDb", "timeInSeconds", "", "deleteImagesForCampaigns", "deleteStatById", "stat", "Lcom/moengage/inapp/internal/model/StatModel;", "getAllActiveCampaigns", "getAllCampaignIds", "getAllCampaigns", "getApiSyncInterval", "getCampaignById", "campaignId", "getGeneralCampaigns", "getGlobalState", "Lcom/moengage/inapp/internal/model/InAppGlobalState;", "getLastHtmlAssetsDeleteTime", "getLastSyncTime", "getNonIntrusiveNudgeCampaigns", "getPushPermissionRequestCount", "getSdkStatus", "Lcom/moengage/core/internal/model/SdkStatus;", "getSelfHandledCampaign", "getStats", "batchSize", "getStoredCampaigns", "", "getTriggerCampaigns", "isStorageAndAPICallEnabled", "", "saveCampaign", "entity", "storeApiSyncInterval", "syncInterval", "storeGlobalDelay", "globalDelay", "storeHtmlAssetsDeleteTime", "deleteTime", "storeLastApiSyncTime", "nextSyncTime", "updateCampaign", "updateCampaignState", "state", "Lcom/moengage/inapp/internal/model/meta/CampaignState;", "updateCampaignStatus", "status", "updateLastShowTime", "time", "writeStats", "statModel", "inapp_release"})
public final class LocalRepositoryImpl
implements LocalRepository {
    @NotNull
    private final Context context;
    @NotNull
    private final DataAccessor dataAccessor;
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final String tag;
    @NotNull
    private final Marshaller marshaller;

    public LocalRepositoryImpl(@NotNull Context context, @NotNull DataAccessor dataAccessor, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dataAccessor, (String)"dataAccessor");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.context = context;
        this.dataAccessor = dataAccessor;
        this.sdkInstance = sdkInstance;
        this.tag = "InApp_7.1.1_LocalRepositoryImpl";
        this.marshaller = new Marshaller(this.context, this.sdkInstance);
    }

    @Override
    public void storeApiSyncInterval(long syncInterval) {
        this.dataAccessor.getPreference().putLong("inapp_api_sync_delay", syncInterval);
    }

    @Override
    public long getApiSyncInterval() {
        return this.dataAccessor.getPreference().getLong("inapp_api_sync_delay", 900L);
    }

    @Override
    public void storeLastApiSyncTime(long nextSyncTime) {
        this.dataAccessor.getPreference().putLong("inapp_last_sync_time", nextSyncTime);
    }

    @Override
    public long getLastSyncTime() {
        return this.dataAccessor.getPreference().getLong("inapp_last_sync_time", 0L);
    }

    @Override
    public void storeGlobalDelay(long globalDelay) {
        this.dataAccessor.getPreference().putLong("in_app_global_delay", globalDelay);
    }

    @Override
    @NotNull
    public InAppGlobalState getGlobalState() {
        long lastShowTime = this.dataAccessor.getPreference().getLong("MOE_LAST_IN_APP_SHOWN_TIME", 0L);
        return new InAppGlobalState(this.dataAccessor.getPreference().getLong("in_app_global_delay", 900L), lastShowTime, TimeUtilsKt.currentSeconds());
    }

    @Override
    public void addOrUpdateInApp(@NotNull List<CampaignEntity> newCampaigns) {
        Intrinsics.checkNotNullParameter(newCampaigns, (String)"newCampaigns");
        try {
            Map storedCampaigns = MapsKt.toMutableMap(this.getStoredCampaigns());
            if (storedCampaigns.isEmpty()) {
                ArrayList<ContentValues> contentValues = new ArrayList<ContentValues>(newCampaigns.size());
                for (CampaignEntity campaign : newCampaigns) {
                    contentValues.add(this.marshaller.campaignEntityToContentValues(campaign));
                }
                this.dataAccessor.getDbAdapter().bulkInsert("INAPP_V3", (List)contentValues);
                return;
            }
            for (CampaignEntity campaign : newCampaigns) {
                CampaignEntity inAppCampaign = (CampaignEntity)storedCampaigns.get(campaign.getCampaignId());
                if (inAppCampaign != null) {
                    campaign.setId(inAppCampaign.getId());
                    campaign.setState(inAppCampaign.getState());
                    this.updateCampaign(campaign);
                    storedCampaigns.remove(inAppCampaign.getCampaignId());
                    continue;
                }
                this.saveCampaign(campaign);
            }
            for (CampaignEntity campaign : storedCampaigns.values()) {
                this.updateCampaignStatus(campaign.getCampaignId(), "IN_ACTIVE");
            }
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " addOrUpdateInApp() : ";
                }
            });
        }
    }

    @Override
    public void deleteExpiredCampaigns() {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ LocalRepositoryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return LocalRepositoryImpl.access$getTag$p(this.this$0) + " deleteExpiredCampaigns() : ";
            }
        }), (int)3, null);
        new InAppFileManager(this.context, this.sdkInstance).deleteImagesForCampaignIds(this.campaignsEligibleForDeletion(String.valueOf(TimeUtilsKt.currentSeconds())));
        this.deleteExpiredCampaignsFromDb(TimeUtilsKt.currentSeconds());
    }

    @Override
    public void clearData() {
        this.clearLastSyncTime();
        this.deleteAllCampaigns();
        this.deleteImagesForCampaigns();
        this.deleteAllStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CampaignEntity> getGeneralCampaigns() {
        Cursor cursor = null;
        try {
            Object object = new String[]{"ACTIVE", "general", "POP_UP", "FULL_SCREEN"};
            cursor = this.dataAccessor.getDbAdapter().query("INAPP_V3", new QueryParams(InAppV3ContractKt.getPROJECTION_INAPP_V3(), new WhereClause("status = ?  AND type = ?  AND template_type IN ( ?, ? ) ", object), null, null, "priority DESC, last_updated_time DESC", 0, 44, null));
            object = this.marshaller.campaignsFromCursor(cursor);
            return object;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " getGeneralCampaigns() : ";
                }
            });
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CampaignEntity> getSelfHandledCampaign() {
        Cursor cursor = null;
        try {
            Object object = new String[]{"ACTIVE", "general", "SELF_HANDLED"};
            cursor = this.dataAccessor.getDbAdapter().query("INAPP_V3", new QueryParams(InAppV3ContractKt.getPROJECTION_INAPP_V3(), new WhereClause("status = ?  AND type = ?  AND template_type = ? ", object), null, null, "priority DESC, last_updated_time DESC", 0, 44, null));
            object = this.marshaller.campaignsFromCursor(cursor);
            return object;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " selfHandledCampaigns() : ";
                }
            });
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public BaseRequest baseRequest() {
        return RestUtilKt.getBaseRequest((Context)this.context, (SdkInstance)this.sdkInstance);
    }

    @Override
    public int updateCampaignState(@NotNull CampaignState state, @NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        int updateCount = -1;
        try {
            String[] stringArray = new String[]{campaignId};
            updateCount = this.dataAccessor.getDbAdapter().update("INAPP_V3", this.marshaller.campaignStateToContentValues(state), new WhereClause("campaign_id = ? ", stringArray));
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " updateStateForCampaign() : ";
                }
            });
        }
        return updateCount;
    }

    @Override
    public void updateLastShowTime(long time) {
        this.dataAccessor.getPreference().putLong("MOE_LAST_IN_APP_SHOWN_TIME", time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CampaignEntity> getAllActiveCampaigns() {
        Cursor cursor = null;
        try {
            Object object = new String[]{"ACTIVE"};
            cursor = this.dataAccessor.getDbAdapter().query("INAPP_V3", new QueryParams(InAppV3ContractKt.getPROJECTION_INAPP_V3(), new WhereClause("status = ? ", object), null, null, "priority DESC, last_updated_time DESC", 0, 44, null));
            object = this.marshaller.campaignsFromCursor(cursor);
            return object;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " getAllActiveCampaigns() : ";
                }
            });
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CampaignEntity getCampaignById(@NotNull String campaignId) {
        Cursor cursor;
        block7: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
            cursor = null;
            try {
                object = new String[]{campaignId};
                cursor = this.dataAccessor.getDbAdapter().query("INAPP_V3", new QueryParams(InAppV3ContractKt.getPROJECTION_INAPP_V3(), new WhereClause("campaign_id = ? ", object), null, null, null, 0, 60, null));
                if (cursor == null || !cursor.moveToFirst()) break block7;
                object = this.marshaller.entityFromCursor(cursor);
            }
            catch (Throwable t) {
                try {
                    this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                        final /* synthetic */ LocalRepositoryImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return LocalRepositoryImpl.access$getTag$p(this.this$0) + " getCampaignById() : ";
                        }
                    });
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Cursor cursor2 = cursor;
                    if (cursor2 != null) {
                        cursor2.close();
                    }
                }
            }
            cursor.close();
            return object;
        }
        Cursor cursor3 = cursor;
        if (cursor3 != null) {
            cursor3.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<StatModel> getStats(int batchSize) {
        block12: {
            List list;
            Cursor cursor;
            block11: {
                cursor = null;
                cursor = this.dataAccessor.getDbAdapter().query("INAPP_STATS", new QueryParams(InAppStatsContractKt.getPROJECTION_INAPP_STATS(), null, null, null, null, batchSize, 28, null));
                if (cursor != null && cursor.moveToFirst() && cursor.getCount() != 0) break block11;
                List list2 = CollectionsKt.emptyList();
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                return list2;
            }
            try {
                ArrayList<StatModel> statsList = new ArrayList<StatModel>(cursor.getCount());
                do {
                    try {
                        StatModel statModel = this.marshaller.statFromCursor(cursor);
                        statsList.add(statModel);
                    }
                    catch (Throwable t) {
                        this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                            final /* synthetic */ LocalRepositoryImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return LocalRepositoryImpl.access$getTag$p(this.this$0) + " getStats() : ";
                            }
                        });
                    }
                } while (cursor.moveToNext());
                list = statsList;
            }
            catch (Throwable t) {
                try {
                    this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                        final /* synthetic */ LocalRepositoryImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return LocalRepositoryImpl.access$getTag$p(this.this$0) + " getStats() : ";
                        }
                    });
                    break block12;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Cursor cursor3 = cursor;
                    if (cursor3 != null) {
                        cursor3.close();
                    }
                }
            }
            cursor.close();
            return list;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public int deleteStatById(@NotNull StatModel stat) {
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        try {
            String[] stringArray = new String[]{String.valueOf(stat._id)};
            return this.dataAccessor.getDbAdapter().delete("INAPP_STATS", new WhereClause("_id = ? ", stringArray));
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " deleteStatById() : ";
                }
            });
            return -1;
        }
    }

    @Override
    @NotNull
    public SdkStatus getSdkStatus() {
        return CoreInternalHelper.INSTANCE.getSdkStatus(this.context, this.sdkInstance);
    }

    public final long saveCampaign(@NotNull CampaignEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.dataAccessor.getDbAdapter().insert("INAPP_V3", this.marshaller.campaignEntityToContentValues(entity));
    }

    private final int updateCampaign(CampaignEntity entity) {
        String[] stringArray = new String[]{String.valueOf(entity.getId())};
        return this.dataAccessor.getDbAdapter().update("INAPP_V3", this.marshaller.campaignEntityToContentValues(entity), new WhereClause("_id = ?", stringArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, CampaignEntity> getStoredCampaigns() {
        block12: {
            Map map;
            Map campaignsMap;
            Cursor cursor;
            block11: {
                cursor = null;
                campaignsMap = new HashMap();
                cursor = this.dataAccessor.getDbAdapter().query("INAPP_V3", new QueryParams(InAppV3ContractKt.getPROJECTION_INAPP_V3(), null, null, null, null, 0, 60, null));
                if (cursor != null && cursor.moveToFirst()) break block11;
                Map map2 = MapsKt.emptyMap();
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                return map2;
            }
            try {
                do {
                    try {
                        CampaignEntity campaign = this.marshaller.entityFromCursor(cursor);
                        campaignsMap.put(campaign.getCampaignId(), campaign);
                    }
                    catch (Throwable t) {
                        this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                            final /* synthetic */ LocalRepositoryImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return LocalRepositoryImpl.access$getTag$p(this.this$0) + " getStoredCampaigns() : ";
                            }
                        });
                    }
                } while (cursor.moveToNext());
                map = campaignsMap;
            }
            catch (Throwable t) {
                try {
                    this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                        final /* synthetic */ LocalRepositoryImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return LocalRepositoryImpl.access$getTag$p(this.this$0) + " getStoredCampaigns() : ";
                        }
                    });
                    break block12;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Cursor cursor3 = cursor;
                    if (cursor3 != null) {
                        cursor3.close();
                    }
                }
            }
            cursor.close();
            return map;
        }
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<String> campaignsEligibleForDeletion(@NotNull String timeInSecs) {
        Intrinsics.checkNotNullParameter((Object)timeInSecs, (String)"timeInSecs");
        Cursor cursor = null;
        try {
            Object object = new String[]{"campaign_id"};
            String[] stringArray = object;
            object = new String[]{timeInSecs};
            cursor = this.dataAccessor.getDbAdapter().query("INAPP_V3", new QueryParams(stringArray, new WhereClause("deletion_time < ? ", object), null, null, null, 0, 60, null));
            object = this.marshaller.campaignIdsFromCursor(cursor);
            return object;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " campaignsEligibleForDeletion() : ";
                }
            });
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return SetsKt.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<String> getAllCampaignIds() {
        Cursor cursor = null;
        try {
            Object object = new String[]{"campaign_id"};
            cursor = this.dataAccessor.getDbAdapter().query("INAPP_V3", new QueryParams(object, null, null, null, null, 0, 60, null));
            object = this.marshaller.campaignIdsFromCursor(cursor);
            return object;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " getAllCampaignIds() : ";
                }
            });
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return SetsKt.emptySet();
    }

    public final void clearLastSyncTime() {
        this.dataAccessor.getPreference().removeKey("inapp_last_sync_time");
    }

    private final void deleteImagesForCampaigns() {
        new InAppFileManager(this.context, this.sdkInstance).deleteImagesForCampaignIds(this.getAllCampaignIds());
    }

    public final int deleteAllStats() {
        return this.dataAccessor.getDbAdapter().delete("INAPP_STATS", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CampaignEntity> getTriggerCampaigns() {
        Cursor cursor = null;
        try {
            Object object = new String[]{"ACTIVE", "smart"};
            cursor = this.dataAccessor.getDbAdapter().query("INAPP_V3", new QueryParams(InAppV3ContractKt.getPROJECTION_INAPP_V3(), new WhereClause("status = ?  AND type = ? ", object), null, null, "priority DESC, last_updated_time DESC", 0, 44, null));
            object = this.marshaller.campaignsFromCursor(cursor);
            return object;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " getTriggerCampaigns() : ";
                }
            });
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    public final int deleteExpiredCampaignsFromDb(long timeInSeconds) {
        try {
            String[] stringArray = new String[]{String.valueOf(timeInSeconds)};
            return this.dataAccessor.getDbAdapter().delete("INAPP_V3", new WhereClause("deletion_time < ? ", stringArray));
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " deleteExpiredCampaignsFromDb() :";
                }
            });
            return -1;
        }
    }

    public final int deleteAllCampaigns() {
        return this.dataAccessor.getDbAdapter().delete("INAPP_V3", null);
    }

    @Override
    public long writeStats(@NotNull StatModel statModel) {
        Intrinsics.checkNotNullParameter((Object)statModel, (String)"statModel");
        Ref.LongRef rowId = new Ref.LongRef();
        rowId.element = -1L;
        try {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " writeStats(): will write in-app stats to storage.";
                }
            }), (int)3, null);
            rowId.element = this.dataAccessor.getDbAdapter().insert("INAPP_STATS", this.marshaller.statToContentValues(statModel));
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, rowId, statModel){
                final /* synthetic */ LocalRepositoryImpl this$0;
                final /* synthetic */ Ref.LongRef $rowId;
                final /* synthetic */ StatModel $statModel;
                {
                    this.this$0 = $receiver;
                    this.$rowId = $rowId;
                    this.$statModel = $statModel;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " writeStats(): saved : " + this.$rowId.element + " , stats: " + this.$statModel;
                }
            }), (int)3, null);
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " writeStats() : ";
                }
            });
        }
        return rowId.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CampaignEntity> getAllCampaigns() {
        Cursor cursor = null;
        try {
            cursor = this.dataAccessor.getDbAdapter().query("INAPP_V3", new QueryParams(InAppV3ContractKt.getPROJECTION_INAPP_V3(), null, null, null, "priority DESC, last_updated_time DESC", 0, 44, null));
            List<CampaignEntity> list = this.marshaller.campaignsFromCursor(cursor);
            return list;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " getAllCampaigns() : ";
                }
            });
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public void storeHtmlAssetsDeleteTime(long deleteTime) {
        this.dataAccessor.getPreference().putLong("inapp_html_assets_delete_time", deleteTime);
    }

    @Override
    public long getLastHtmlAssetsDeleteTime() {
        return this.dataAccessor.getPreference().getLong("inapp_html_assets_delete_time", 0L);
    }

    private final int updateCampaignStatus(String campaignId, String status) {
        int updateCount = -1;
        try {
            String[] stringArray = new String[]{campaignId};
            updateCount = this.dataAccessor.getDbAdapter().update("INAPP_V3", this.marshaller.campaignStatusToContentValues(status), new WhereClause("campaign_id = ? ", stringArray));
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " updateStateForCampaign() : ";
                }
            });
        }
        return updateCount;
    }

    @Override
    public int getPushPermissionRequestCount() {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ LocalRepositoryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return LocalRepositoryImpl.access$getTag$p(this.this$0) + " getPushPermissionRequestCount() : ";
            }
        }), (int)3, null);
        return this.dataAccessor.getPreference().getInt("notification_permission_request_count", 0);
    }

    @Override
    public boolean isStorageAndAPICallEnabled() {
        return CoreInternalHelper.INSTANCE.isStorageAndAPICallEnabled(this.context, this.sdkInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CampaignEntity> getNonIntrusiveNudgeCampaigns() {
        Cursor cursor = null;
        try {
            Object object = new String[]{"ACTIVE", "general", "NON_INTRUSIVE"};
            cursor = this.dataAccessor.getDbAdapter().query("INAPP_V3", new QueryParams(InAppV3ContractKt.getPROJECTION_INAPP_V3(), new WhereClause("status = ?  AND type = ?  AND template_type = ? ", object), null, null, "priority DESC, last_updated_time DESC", 0, 44, null));
            object = this.marshaller.campaignsFromCursor(cursor);
            return object;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " selfHandledCampaigns() : ";
                }
            });
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    public static final /* synthetic */ String access$getTag$p(LocalRepositoryImpl $this) {
        return $this.tag;
    }
}

