/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.repository.local;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.storage.StorageUtilsKt;
import com.moengage.inapp.internal.model.CampaignEntity;
import com.moengage.inapp.internal.model.StatModel;
import com.moengage.inapp.internal.model.meta.CampaignState;
import com.moengage.inapp.internal.repository.PayloadMapper;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\rJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/moengage/inapp/internal/repository/local/Marshaller;", "", "context", "Landroid/content/Context;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Landroid/content/Context;Lcom/moengage/core/internal/model/SdkInstance;)V", "campaignEntityToContentValues", "Landroid/content/ContentValues;", "entity", "Lcom/moengage/inapp/internal/model/CampaignEntity;", "campaignIdsFromCursor", "", "", "cursor", "Landroid/database/Cursor;", "campaignStateToContentValues", "state", "Lcom/moengage/inapp/internal/model/meta/CampaignState;", "campaignStatusToContentValues", "status", "campaignsFromCursor", "", "entityFromCursor", "statFromCursor", "Lcom/moengage/inapp/internal/model/StatModel;", "statToContentValues", "stat", "inapp_release"})
public final class Marshaller {
    @NotNull
    private final Context context;
    @NotNull
    private final SdkInstance sdkInstance;

    public Marshaller(@NotNull Context context, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.context = context;
        this.sdkInstance = sdkInstance;
    }

    @NotNull
    public final ContentValues campaignEntityToContentValues(@NotNull CampaignEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ContentValues contentValue = new ContentValues();
        if (entity.getId() != -1L) {
            contentValue.put("_id", Long.valueOf(entity.getId()));
        }
        contentValue.put("campaign_id", entity.getCampaignId());
        contentValue.put("type", entity.getCampaignType());
        contentValue.put("status", entity.getStatus());
        contentValue.put("state", new PayloadMapper().campaignStateToJson(entity.getState()).toString());
        contentValue.put("priority", Long.valueOf(entity.getPriority()));
        contentValue.put("last_updated_time", Long.valueOf(entity.getLastUpdatedTime()));
        contentValue.put("template_type", entity.getTemplateType());
        contentValue.put("deletion_time", Long.valueOf(entity.getDeletionTime()));
        contentValue.put("last_received_time", Long.valueOf(entity.getLastReceivedTime()));
        contentValue.put("campaign_meta", StorageUtilsKt.encryptValueIfRequired((Context)this.context, (SdkInstance)this.sdkInstance, (String)entity.getMetaPayload()));
        return contentValue;
    }

    @NotNull
    public final CampaignEntity entityFromCursor(@NotNull Cursor cursor) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        long l = cursor.getLong(0);
        String string = cursor.getString(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(INAPP_V\u2026COLUMN_INDEX_CAMPAIGN_ID)");
        String string2 = cursor.getString(2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cursor.getString(INAPP_V\u2026LUMN_INDEX_CAMPAIGN_TYPE)");
        String string3 = cursor.getString(3);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"cursor.getString(INAPP_V\u2026MN_INDEX_CAMPAIGN_STATUS)");
        String string4 = cursor.getString(7);
        if (string4 == null) {
            string4 = "";
        }
        CampaignState campaignState = new PayloadMapper().campaignStateFromJson(new JSONObject(cursor.getString(4)));
        long l2 = cursor.getLong(5);
        long l3 = cursor.getLong(6);
        long l4 = cursor.getLong(8);
        long l5 = cursor.getLong(9);
        String string5 = cursor.getString(10);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"cursor.getString(\n      \u2026GN_META\n                )");
        return new CampaignEntity(l, string, string2, string3, string4, campaignState, l2, l3, l4, l5, StorageUtilsKt.decryptValueIfRequired((Context)this.context, (SdkInstance)this.sdkInstance, (String)string5));
    }

    @NotNull
    public final Set<String> campaignIdsFromCursor(@Nullable Cursor cursor) {
        Set campaignIds = new LinkedHashSet();
        if (cursor == null || !cursor.moveToFirst()) {
            return campaignIds;
        }
        do {
            String string = cursor.getString(0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(0)");
            campaignIds.add(string);
        } while (cursor.moveToNext());
        return campaignIds;
    }

    @NotNull
    public final ContentValues campaignStateToContentValues(@NotNull CampaignState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ContentValues contentValue = new ContentValues();
        contentValue.put("state", new PayloadMapper().campaignStateToJson(state).toString());
        return contentValue;
    }

    @NotNull
    public final List<CampaignEntity> campaignsFromCursor(@Nullable Cursor cursor) {
        if (cursor == null || !cursor.moveToFirst()) {
            return CollectionsKt.emptyList();
        }
        List campaigns = new ArrayList();
        do {
            campaigns.add(this.entityFromCursor(cursor));
        } while (cursor.moveToNext());
        return campaigns;
    }

    @NotNull
    public final StatModel statFromCursor(@NotNull Cursor cursor) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        long l = cursor.getLong(0);
        long l2 = cursor.getLong(1);
        String string = cursor.getString(2);
        String string2 = cursor.getString(3);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cursor.getString(INAPP_STATS_COLUMN_INDEX_PAYLOAD)");
        return new StatModel(l, l2, string, new JSONObject(StorageUtilsKt.decryptValueIfRequired((Context)this.context, (SdkInstance)this.sdkInstance, (String)string2)));
    }

    @NotNull
    public final ContentValues statToContentValues(@NotNull StatModel stat) {
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        ContentValues values = new ContentValues();
        if (stat._id != -1L) {
            values.put("_id", Long.valueOf(stat._id));
        }
        values.put("timestamp", Long.valueOf(stat.timestamp));
        values.put("request_id", stat.requestId);
        String string = stat.statsJson.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stat.statsJson.toString()");
        values.put("payload", StorageUtilsKt.encryptValueIfRequired((Context)this.context, (SdkInstance)this.sdkInstance, (String)string));
        return values;
    }

    @NotNull
    public final ContentValues campaignStatusToContentValues(@NotNull String status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        ContentValues contentValue = new ContentValues();
        contentValue.put("status", status);
        return contentValue;
    }
}

