/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.repository.remote;

import android.net.Uri;
import com.moengage.core.internal.authorization.AuthorizationHandler;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.NetworkDataEncryptionKey;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.rest.NetworkResponse;
import com.moengage.core.internal.rest.Request;
import com.moengage.core.internal.rest.RequestBuilder;
import com.moengage.core.internal.rest.RequestType;
import com.moengage.core.internal.rest.ResponseFailure;
import com.moengage.core.internal.rest.RestClient;
import com.moengage.core.internal.utils.JsonBuilder;
import com.moengage.core.internal.utils.RestUtilKt;
import com.moengage.inapp.internal.model.network.CampaignRequest;
import com.moengage.inapp.internal.model.network.InAppMetaRequest;
import com.moengage.inapp.internal.model.network.StatsUploadRequest;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/moengage/inapp/internal/repository/remote/ApiManager;", "", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "authorizationHandler", "Lcom/moengage/core/internal/authorization/AuthorizationHandler;", "(Lcom/moengage/core/internal/model/SdkInstance;Lcom/moengage/core/internal/authorization/AuthorizationHandler;)V", "tag", "", "fetchCampaignMeta", "Lcom/moengage/core/internal/rest/NetworkResponse;", "requestMeta", "Lcom/moengage/inapp/internal/model/network/InAppMetaRequest;", "fetchCampaignPayload", "campaignRequest", "Lcom/moengage/inapp/internal/model/network/CampaignRequest;", "fetchTestCampaign", "uploadStats", "request", "Lcom/moengage/inapp/internal/model/network/StatsUploadRequest;", "inapp_release"})
public final class ApiManager {
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final AuthorizationHandler authorizationHandler;
    @NotNull
    private final String tag;

    public ApiManager(@NotNull SdkInstance sdkInstance, @NotNull AuthorizationHandler authorizationHandler) {
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)authorizationHandler, (String)"authorizationHandler");
        this.sdkInstance = sdkInstance;
        this.authorizationHandler = authorizationHandler;
        this.tag = "InApp_7.1.1_ApiManager";
    }

    @NotNull
    public final NetworkResponse fetchCampaignMeta(@NotNull InAppMetaRequest requestMeta) {
        Intrinsics.checkNotNullParameter((Object)((Object)requestMeta), (String)"requestMeta");
        try {
            Uri.Builder uriBuilder = RestUtilKt.getBaseUriBuilder((SdkInstance)this.sdkInstance).appendEncodedPath("v3/campaigns/inapp/").appendEncodedPath("live").appendQueryParameter("unique_id", requestMeta.uniqueId).appendQueryParameter("sdk_ver", String.valueOf(requestMeta.sdkVersion)).appendQueryParameter("os", requestMeta.platform).appendQueryParameter("device_type", requestMeta.getDeviceType().toString()).appendQueryParameter("inapp_ver", requestMeta.getInAppVersion()).appendQueryParameter("push_opt_in_status", String.valueOf(requestMeta.getPushOptInStatus()));
            JSONObject requestBody = new JSONObject();
            requestBody.put("query_params", (Object)requestMeta.defaultParams.build());
            Uri uri = uriBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uriBuilder.build()");
            NetworkDataEncryptionKey networkDataEncryptionKey = requestMeta.networkDataEncryptionKey;
            Intrinsics.checkNotNullExpressionValue((Object)networkDataEncryptionKey, (String)"requestMeta.networkDataEncryptionKey");
            Request request = RestUtilKt.getBaseRequestBuilder$default((Uri)uri, (RequestType)RequestType.POST, (SdkInstance)this.sdkInstance, (AuthorizationHandler)this.authorizationHandler, (NetworkDataEncryptionKey)networkDataEncryptionKey, (boolean)false, (int)32, null).addBody(requestBody).build();
            RestClient restClient = new RestClient(request, this.sdkInstance);
            return restClient.executeRequest();
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ ApiManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ApiManager.access$getTag$p(this.this$0) + " fetchCampaignMeta() : ";
                }
            });
            return (NetworkResponse)new ResponseFailure(-100, "");
        }
    }

    @NotNull
    public final NetworkResponse fetchCampaignPayload(@NotNull CampaignRequest campaignRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)campaignRequest), (String)"campaignRequest");
        try {
            Object eventBuilder;
            Uri.Builder uriBuilder = RestUtilKt.getBaseUriBuilder((SdkInstance)this.sdkInstance).appendEncodedPath("v3/campaigns/inapp/").appendEncodedPath("live").appendEncodedPath(campaignRequest.campaignId).appendQueryParameter("unique_id", campaignRequest.uniqueId).appendQueryParameter("sdk_ver", String.valueOf(campaignRequest.sdkVersion)).appendQueryParameter("os", campaignRequest.platform).appendQueryParameter("device_type", campaignRequest.deviceType.toString()).appendQueryParameter("inapp_ver", campaignRequest.inAppVersion);
            JsonBuilder requestBodyBuilder = new JsonBuilder(null, 1, null);
            if (campaignRequest.triggerMeta != null) {
                eventBuilder = new JsonBuilder(null, 1, null);
                JsonBuilder jsonBuilder = eventBuilder.putString("name", campaignRequest.triggerMeta.eventName).putString("time", campaignRequest.triggerMeta.timeStamp);
                JSONObject jSONObject = campaignRequest.triggerMeta.attributes;
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"campaignRequest.triggerMeta.attributes");
                jsonBuilder.putJsonObject("attributes", jSONObject);
                requestBodyBuilder.putJsonObject("event", eventBuilder.build());
            }
            requestBodyBuilder.putJsonObject("query_params", campaignRequest.defaultParams.build());
            eventBuilder = campaignRequest.screenName;
            if (!(eventBuilder == null || StringsKt.isBlank((CharSequence)eventBuilder))) {
                requestBodyBuilder.putString("screen_name", campaignRequest.screenName);
            }
            if (!((eventBuilder = (Collection)campaignRequest.contextList) == null || eventBuilder.isEmpty())) {
                JSONArray contextArray = new JSONArray();
                for (String context : campaignRequest.contextList) {
                    contextArray.put((Object)context);
                }
                requestBodyBuilder.putJsonArray("contexts", contextArray);
            }
            requestBodyBuilder.putJsonObject("campaign_context", campaignRequest.campaignContext.getPayload());
            Uri uri = uriBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uriBuilder.build()");
            NetworkDataEncryptionKey networkDataEncryptionKey = campaignRequest.networkDataEncryptionKey;
            Intrinsics.checkNotNullExpressionValue((Object)networkDataEncryptionKey, (String)"campaignRequest.networkDataEncryptionKey");
            Request request = RestUtilKt.getBaseRequestBuilder$default((Uri)uri, (RequestType)RequestType.POST, (SdkInstance)this.sdkInstance, (AuthorizationHandler)this.authorizationHandler, (NetworkDataEncryptionKey)networkDataEncryptionKey, (boolean)false, (int)32, null).addBody(requestBodyBuilder.build()).build();
            RestClient restClient = new RestClient(request, this.sdkInstance);
            return restClient.executeRequest();
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ ApiManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ApiManager.access$getTag$p(this.this$0) + " fetchCampaignPayload() : ";
                }
            });
            return (NetworkResponse)new ResponseFailure(-100, "");
        }
    }

    @NotNull
    public final NetworkResponse fetchTestCampaign(@NotNull CampaignRequest campaignRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)campaignRequest), (String)"campaignRequest");
        try {
            Uri.Builder uriBuilder = RestUtilKt.getBaseUriBuilder((SdkInstance)this.sdkInstance).appendEncodedPath("v3/campaigns/inapp/").appendEncodedPath("test").appendEncodedPath(campaignRequest.campaignId).appendQueryParameter("sdk_ver", String.valueOf(campaignRequest.sdkVersion)).appendQueryParameter("os", campaignRequest.platform).appendQueryParameter("unique_id", campaignRequest.uniqueId).appendQueryParameter("device_type", campaignRequest.deviceType.toString()).appendQueryParameter("inapp_ver", campaignRequest.inAppVersion);
            Uri uri = uriBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uriBuilder.build()");
            NetworkDataEncryptionKey networkDataEncryptionKey = campaignRequest.networkDataEncryptionKey;
            Intrinsics.checkNotNullExpressionValue((Object)networkDataEncryptionKey, (String)"campaignRequest.networkDataEncryptionKey");
            RequestBuilder requestBuilder2 = RestUtilKt.getBaseRequestBuilder$default((Uri)uri, (RequestType)RequestType.GET, (SdkInstance)this.sdkInstance, (AuthorizationHandler)this.authorizationHandler, (NetworkDataEncryptionKey)networkDataEncryptionKey, (boolean)false, (int)32, null);
            RestClient restClient = new RestClient(requestBuilder2.build(), this.sdkInstance);
            return restClient.executeRequest();
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ ApiManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ApiManager.access$getTag$p(this.this$0) + " fetchTestCampaign() : ";
                }
            });
            return (NetworkResponse)new ResponseFailure(-100, "");
        }
    }

    @NotNull
    public final NetworkResponse uploadStats(@NotNull StatsUploadRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        try {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, request){
                final /* synthetic */ ApiManager this$0;
                final /* synthetic */ StatsUploadRequest $request;
                {
                    this.this$0 = $receiver;
                    this.$request = $request;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ApiManager.access$getTag$p(this.this$0) + " uploadStats() : " + this.$request.getStat().statsJson;
                }
            }), (int)3, null);
            Uri.Builder uriBuilder = RestUtilKt.getBaseUriBuilder((SdkInstance)this.sdkInstance).appendEncodedPath("v3/campaigns/inapp/").appendEncodedPath("live/stats").appendQueryParameter("sdk_ver", String.valueOf(request.sdkVersion)).appendQueryParameter("os", request.platform).appendQueryParameter("unique_id", request.uniqueId).appendQueryParameter("inapp_ver", request.getInAppVersion());
            JSONObject requestBody = new JSONObject();
            requestBody.put("stats", (Object)request.getStat().statsJson);
            requestBody.put("query_params", (Object)request.defaultParams.build());
            Uri uri = uriBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uriBuilder.build()");
            NetworkDataEncryptionKey networkDataEncryptionKey = request.networkDataEncryptionKey;
            Intrinsics.checkNotNullExpressionValue((Object)networkDataEncryptionKey, (String)"request.networkDataEncryptionKey");
            RequestBuilder requestBuilder2 = RestUtilKt.getBaseRequestBuilder((Uri)uri, (RequestType)RequestType.POST, (SdkInstance)this.sdkInstance, (AuthorizationHandler)this.authorizationHandler, (NetworkDataEncryptionKey)networkDataEncryptionKey, (boolean)true).addBody(requestBody);
            String string = request.getStat().requestId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.stat.requestId");
            RequestBuilder requestBuilder3 = requestBuilder2.addHeader("MOE-INAPP-BATCH-ID", string);
            RestClient restClient = new RestClient(requestBuilder3.build(), this.sdkInstance);
            return restClient.executeRequest();
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ ApiManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ApiManager.access$getTag$p(this.this$0) + " uploadStats() : ";
                }
            });
            return (NetworkResponse)new ResponseFailure(-100, "");
        }
    }

    public static final /* synthetic */ String access$getTag$p(ApiManager $this) {
        return $this.tag;
    }
}

