/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.repository.remote;

import androidx.annotation.VisibleForTesting;
import com.moengage.core.internal.model.NetworkResult;
import com.moengage.core.internal.model.ResultFailure;
import com.moengage.core.internal.model.ResultSuccess;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.rest.NetworkResponse;
import com.moengage.core.internal.rest.ResponseFailure;
import com.moengage.core.internal.rest.ResponseSuccess;
import com.moengage.core.internal.utils.CoreUtils;
import com.moengage.inapp.internal.model.CampaignEntity;
import com.moengage.inapp.internal.model.CampaignPayload;
import com.moengage.inapp.internal.model.HtmlCampaignPayload;
import com.moengage.inapp.internal.model.NativeCampaignPayload;
import com.moengage.inapp.internal.model.enums.InAppType;
import com.moengage.inapp.internal.model.network.CampaignError;
import com.moengage.inapp.internal.model.network.MetaResponse;
import com.moengage.inapp.internal.repository.PayloadMapper;
import com.moengage.inapp.internal.repository.remote.ResponseParser;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/moengage/inapp/internal/repository/remote/Parser;", "", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Lcom/moengage/core/internal/model/SdkInstance;)V", "tag", "", "campaignFromResponse", "Lcom/moengage/core/internal/model/NetworkResult;", "response", "Lcom/moengage/core/internal/rest/NetworkResponse;", "campaignsFromResponse", "", "Lcom/moengage/inapp/internal/model/CampaignEntity;", "responseJson", "Lorg/json/JSONObject;", "campaignsFromResponse$inapp_release", "htmlCampaignFromJson", "Lcom/moengage/inapp/internal/model/HtmlCampaignPayload;", "metaResponseFromJson", "Lcom/moengage/inapp/internal/model/network/MetaResponse;", "metaResponseFromJson$inapp_release", "nativeCampaignFromJson", "Lcom/moengage/inapp/internal/model/NativeCampaignPayload;", "parseCampaignMeta", "parseStatsUploadResponse", "parseTestCampaignResponse", "inapp_release"})
public final class Parser {
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final String tag;

    public Parser(@NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.sdkInstance = sdkInstance;
        this.tag = "InApp_7.1.1_Parser";
    }

    @NotNull
    public final NetworkResult campaignFromResponse(@NotNull NetworkResponse response) {
        NetworkResult networkResult;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        NetworkResponse networkResponse = response;
        if (networkResponse instanceof ResponseFailure) {
            networkResult = (NetworkResult)new ResultFailure((Object)new CampaignError(((ResponseFailure)response).getErrorCode(), ((ResponseFailure)response).getErrorMessage(), false));
        } else if (networkResponse instanceof ResponseSuccess) {
            NetworkResult networkResult2;
            try {
                CampaignPayload campaignPayload;
                String responseBody = ((ResponseSuccess)response).getData();
                JSONObject responseJson = new JSONObject(responseBody);
                String string = responseJson.getString("inapp_type");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"responseJson.getString(ResponseParser.INAPP_TYPE)");
                switch (WhenMappings.$EnumSwitchMapping$0[InAppType.valueOf(string).ordinal()]) {
                    case 1: {
                        campaignPayload = this.htmlCampaignFromJson(responseJson);
                        break;
                    }
                    case 2: {
                        campaignPayload = this.nativeCampaignFromJson(responseJson);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                CampaignPayload campaignPayload2 = campaignPayload;
                networkResult2 = (NetworkResult)new ResultSuccess((Object)campaignPayload2);
            }
            catch (Throwable t) {
                this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                    final /* synthetic */ Parser this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return Parser.access$getTag$p(this.this$0) + " campaignFromResponse() : ";
                    }
                });
                networkResult2 = (NetworkResult)new ResultFailure((Object)new CampaignError(200, ((ResponseSuccess)response).getData(), true));
            }
            networkResult = networkResult2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return networkResult;
    }

    private final HtmlCampaignPayload htmlCampaignFromJson(JSONObject responseJson) {
        HtmlCampaignPayload htmlCampaignPayload = new ResponseParser().htmlCampaignFromJson(responseJson);
        Intrinsics.checkNotNullExpressionValue((Object)htmlCampaignPayload, (String)"ResponseParser().htmlCam\u2026ignFromJson(responseJson)");
        return htmlCampaignPayload;
    }

    private final NativeCampaignPayload nativeCampaignFromJson(JSONObject responseJson) {
        NativeCampaignPayload nativeCampaignPayload;
        ResponseParser responseParser = new ResponseParser();
        if (Intrinsics.areEqual((Object)"SELF_HANDLED", (Object)responseJson.getString("template_type"))) {
            NativeCampaignPayload nativeCampaignPayload2 = responseParser.selfHandledCampaignFromJson(responseJson);
            nativeCampaignPayload = nativeCampaignPayload2;
            Intrinsics.checkNotNullExpressionValue((Object)nativeCampaignPayload2, (String)"{\n            responsePa\u2026n(responseJson)\n        }");
        } else {
            NativeCampaignPayload nativeCampaignPayload3 = responseParser.campaignPayloadFromResponse(responseJson);
            nativeCampaignPayload = nativeCampaignPayload3;
            Intrinsics.checkNotNullExpressionValue((Object)nativeCampaignPayload3, (String)"{\n            responsePa\u2026e(responseJson)\n        }");
        }
        return nativeCampaignPayload;
    }

    @NotNull
    public final NetworkResult parseStatsUploadResponse(@NotNull NetworkResponse response) {
        NetworkResult networkResult;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        NetworkResponse networkResponse = response;
        if (networkResponse instanceof ResponseSuccess) {
            networkResult = (NetworkResult)new ResultSuccess((Object)true);
        } else if (networkResponse instanceof ResponseFailure) {
            networkResult = (NetworkResult)new ResultFailure(null, 1, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return networkResult;
    }

    @NotNull
    public final NetworkResult parseCampaignMeta(@NotNull NetworkResponse response) {
        NetworkResult networkResult;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        NetworkResponse networkResponse = response;
        if (networkResponse instanceof ResponseFailure) {
            networkResult = (NetworkResult)new ResultFailure(null, 1, null);
        } else if (networkResponse instanceof ResponseSuccess) {
            networkResult = (NetworkResult)new ResultSuccess((Object)this.metaResponseFromJson$inapp_release(new JSONObject(((ResponseSuccess)response).getData())));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return networkResult;
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final MetaResponse metaResponseFromJson$inapp_release(@NotNull JSONObject responseJson) {
        Intrinsics.checkNotNullParameter((Object)responseJson, (String)"responseJson");
        return new MetaResponse(this.campaignsFromResponse$inapp_release(responseJson), responseJson.optLong("sync_interval", -1L), responseJson.getLong("min_delay_btw_inapps"));
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final List<CampaignEntity> campaignsFromResponse$inapp_release(@NotNull JSONObject responseJson) {
        Intrinsics.checkNotNullParameter((Object)responseJson, (String)"responseJson");
        try {
            if (!responseJson.has("campaigns")) {
                return CollectionsKt.emptyList();
            }
            JSONArray campaignArray = responseJson.getJSONArray("campaigns");
            if (campaignArray.length() == 0) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)campaignArray, (String)"campaignArray");
            CoreUtils.logJsonArray((String)this.tag, (JSONArray)campaignArray);
            List campaigns = new ArrayList();
            PayloadMapper mapper = new PayloadMapper();
            int n = campaignArray.length();
            for (int i = 0; i < n; ++i) {
                try {
                    JSONObject campaignJson = campaignArray.getJSONObject(i);
                    Intrinsics.checkNotNullExpressionValue((Object)campaignJson, (String)"campaignJson");
                    CampaignEntity campaign = mapper.jsonToCampaignEntity(campaignJson);
                    campaigns.add(campaign);
                    continue;
                }
                catch (Throwable t) {
                    this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                        final /* synthetic */ Parser this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return Parser.access$getTag$p(this.this$0) + " campaignsFromResponse() : ";
                        }
                    });
                }
            }
            return campaigns;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ Parser this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Parser.access$getTag$p(this.this$0) + " campaignsFromResponse() : ";
                }
            });
            return CollectionsKt.emptyList();
        }
    }

    @NotNull
    public final NetworkResult parseTestCampaignResponse(@NotNull NetworkResponse response) {
        NetworkResult networkResult;
        block9: {
            NetworkResponse networkResponse;
            block6: {
                ResultFailure resultFailure;
                block8: {
                    int n;
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        networkResponse = response;
                        if (!(networkResponse instanceof ResponseFailure)) break block6;
                        n = ((ResponseFailure)response).getErrorCode();
                        if (n != -100) break block7;
                        resultFailure = new ResultFailure((Object)"No Internet Connection.\n Please connect to internet and try again.");
                        break block8;
                    }
                    resultFailure = (500 <= n ? n < 600 : false) ? new ResultFailure((Object)"Could not reach MoEngage Server.\n Please try again or contact MoEngage Support.") : ((400 <= n ? n < 500 : false) ? new ResultFailure((Object)new JSONObject(((ResponseFailure)response).getErrorMessage()).getString("description")) : new ResultFailure((Object)"No Internet Connection.\n Please connect to internet and try again."));
                }
                networkResult = (NetworkResult)resultFailure;
                break block9;
            }
            if (networkResponse instanceof ResponseSuccess) {
                CampaignPayload campaignPayload;
                String responseBody = ((ResponseSuccess)response).getData();
                JSONObject responseJson = new JSONObject(responseBody);
                String string = responseJson.getString("inapp_type");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"responseJson.getString(ResponseParser.INAPP_TYPE)");
                switch (WhenMappings.$EnumSwitchMapping$0[InAppType.valueOf(string).ordinal()]) {
                    case 1: {
                        campaignPayload = this.htmlCampaignFromJson(responseJson);
                        break;
                    }
                    case 2: {
                        campaignPayload = this.nativeCampaignFromJson(responseJson);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                CampaignPayload campaignPayload2 = campaignPayload;
                networkResult = (NetworkResult)new ResultSuccess((Object)campaignPayload2);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return networkResult;
    }

    public static final /* synthetic */ String access$getTag$p(Parser $this) {
        return $this.tag;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InAppType.values().length];
            nArray[InAppType.HTML.ordinal()] = 1;
            nArray[InAppType.NATIVE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

