/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.repository.remote;

import com.moengage.core.internal.model.NetworkResult;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.inapp.internal.model.network.CampaignRequest;
import com.moengage.inapp.internal.model.network.InAppMetaRequest;
import com.moengage.inapp.internal.model.network.StatsUploadRequest;
import com.moengage.inapp.internal.repository.remote.ApiManager;
import com.moengage.inapp.internal.repository.remote.Parser;
import com.moengage.inapp.internal.repository.remote.RemoteRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/moengage/inapp/internal/repository/remote/RemoteRepositoryImpl;", "Lcom/moengage/inapp/internal/repository/remote/RemoteRepository;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "apiManager", "Lcom/moengage/inapp/internal/repository/remote/ApiManager;", "(Lcom/moengage/core/internal/model/SdkInstance;Lcom/moengage/inapp/internal/repository/remote/ApiManager;)V", "parser", "Lcom/moengage/inapp/internal/repository/remote/Parser;", "fetchCampaignMeta", "Lcom/moengage/core/internal/model/NetworkResult;", "inAppMetaRequest", "Lcom/moengage/inapp/internal/model/network/InAppMetaRequest;", "fetchCampaignPayload", "request", "Lcom/moengage/inapp/internal/model/network/CampaignRequest;", "fetchTestCampaign", "uploadStats", "Lcom/moengage/inapp/internal/model/network/StatsUploadRequest;", "inapp_release"})
public final class RemoteRepositoryImpl
implements RemoteRepository {
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final ApiManager apiManager;
    @NotNull
    private final Parser parser;

    public RemoteRepositoryImpl(@NotNull SdkInstance sdkInstance, @NotNull ApiManager apiManager) {
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)apiManager, (String)"apiManager");
        this.sdkInstance = sdkInstance;
        this.apiManager = apiManager;
        this.parser = new Parser(this.sdkInstance);
    }

    @Override
    @NotNull
    public NetworkResult fetchCampaignMeta(@NotNull InAppMetaRequest inAppMetaRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)inAppMetaRequest), (String)"inAppMetaRequest");
        return this.parser.parseCampaignMeta(this.apiManager.fetchCampaignMeta(inAppMetaRequest));
    }

    @Override
    @NotNull
    public NetworkResult fetchCampaignPayload(@NotNull CampaignRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return this.parser.campaignFromResponse(this.apiManager.fetchCampaignPayload(request));
    }

    @Override
    @NotNull
    public NetworkResult fetchTestCampaign(@NotNull CampaignRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return this.parser.parseTestCampaignResponse(this.apiManager.fetchTestCampaign(request));
    }

    @Override
    @NotNull
    public NetworkResult uploadStats(@NotNull StatsUploadRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return this.parser.parseStatsUploadResponse(this.apiManager.uploadStats(request));
    }
}

