/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.tasks;

import android.content.Context;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.utils.TimeUtilsKt;
import com.moengage.inapp.internal.InAppInstanceProvider;
import com.moengage.inapp.internal.model.enums.InAppType;
import com.moengage.inapp.internal.model.meta.InAppCampaign;
import com.moengage.inapp.internal.repository.InAppFileManager;
import com.moengage.inapp.internal.repository.InAppRepository;
import com.moengage.inapp.internal.repository.PayloadMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/moengage/inapp/internal/tasks/AppOpenHandler;", "", "context", "Landroid/content/Context;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Landroid/content/Context;Lcom/moengage/core/internal/model/SdkInstance;)V", "repository", "Lcom/moengage/inapp/internal/repository/InAppRepository;", "tag", "", "clearHtmlAssetsCache", "", "onAppOpen", "shouldClearHtmlAssets", "", "currentTime", "", "inapp_release"})
public final class AppOpenHandler {
    @NotNull
    private final Context context;
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final String tag;
    @NotNull
    private final InAppRepository repository;

    public AppOpenHandler(@NotNull Context context, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.context = context;
        this.sdkInstance = sdkInstance;
        this.tag = "InApp_7.1.1_AppOpenJob";
        this.repository = InAppInstanceProvider.INSTANCE.getRepositoryForInstance$inapp_release(this.context, this.sdkInstance);
    }

    public final void onAppOpen() {
        try {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ AppOpenHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return AppOpenHandler.access$getTag$p(this.this$0) + " onAppOpen() : Processing app open";
                }
            }), (int)3, null);
            long currentTime = TimeUtilsKt.currentSeconds();
            if (this.shouldClearHtmlAssets(currentTime)) {
                this.clearHtmlAssetsCache();
                this.repository.storeHtmlAssetsDeleteTime(currentTime);
            }
            InAppInstanceProvider.INSTANCE.getControllerForInstance$inapp_release(this.sdkInstance).syncMeta(this.context);
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ AppOpenHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return AppOpenHandler.access$getTag$p(this.this$0) + " onAppOpen() : ";
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void clearHtmlAssetsCache() {
        void $this$mapTo$iv$iv;
        InAppCampaign it;
        Iterable $this$filterTo$iv$iv;
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ AppOpenHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return AppOpenHandler.access$getTag$p(this.this$0) + " clearHtmlAssetsCache() : clearing html assets";
            }
        }), (int)3, null);
        Iterable $this$filter$iv = new PayloadMapper().entityToCampaign(this.repository.getAllCampaigns());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (InAppCampaign)element$iv$iv;
            boolean bl = false;
            if (!(it.getCampaignMeta().inAppType == InAppType.HTML)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (InAppCampaign)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCampaignMeta().campaignId);
        }
        Set campaignIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        new InAppFileManager(this.context, this.sdkInstance).deleteHtmlAssetsForCampaignIds(campaignIds);
    }

    private final boolean shouldClearHtmlAssets(long currentTime) {
        return this.repository.getLastHtmlAssetsDeleteTime() + 900L < currentTime;
    }

    public static final /* synthetic */ String access$getTag$p(AppOpenHandler $this) {
        return $this.tag;
    }
}

