/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.tasks;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import com.moengage.core.internal.global.GlobalResources;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.NetworkResult;
import com.moengage.core.internal.model.ResultFailure;
import com.moengage.core.internal.model.ResultSuccess;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.utils.CoreUtils;
import com.moengage.inapp.internal.InAppController;
import com.moengage.inapp.internal.InAppInstanceProvider;
import com.moengage.inapp.internal.InAppModuleManager;
import com.moengage.inapp.internal.UtilsKt;
import com.moengage.inapp.internal.model.CampaignPayload;
import com.moengage.inapp.internal.model.NativeCampaignPayload;
import com.moengage.inapp.internal.model.ViewCreationMeta;
import com.moengage.inapp.internal.repository.InAppFileManager;
import com.moengage.inapp.internal.repository.InAppRepository;
import com.moengage.inapp.listeners.SelfHandledAvailableListener;
import com.moengage.inapp.model.CampaignData;
import com.moengage.inapp.model.SelfHandledCampaign;
import com.moengage.inapp.model.SelfHandledCampaignData;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\r\u0010\u000e\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u000fJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/moengage/inapp/internal/tasks/ShowTestInApp;", "", "context", "Landroid/content/Context;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "campaignId", "", "(Landroid/content/Context;Lcom/moengage/core/internal/model/SdkInstance;Ljava/lang/String;)V", "tag", "displayTestInAppIfPossible", "", "payload", "Lcom/moengage/inapp/internal/model/CampaignPayload;", "show", "show$inapp_release", "showErrorDialog", "errorMessage", "inapp_release"})
public final class ShowTestInApp {
    @NotNull
    private final Context context;
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final String campaignId;
    @NotNull
    private final String tag;

    public ShowTestInApp(@NotNull Context context, @NotNull SdkInstance sdkInstance, @NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        this.context = context;
        this.sdkInstance = sdkInstance;
        this.campaignId = campaignId;
        this.tag = "InApp_7.1.1_ShowTestInApp";
    }

    public final void show$inapp_release() {
        try {
            InAppRepository repository = InAppInstanceProvider.INSTANCE.getRepositoryForInstance$inapp_release(this.context, this.sdkInstance);
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ ShowTestInApp this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ShowTestInApp.access$getTag$p(this.this$0) + " show() : processing test in-app";
                }
            }), (int)3, null);
            if (!UtilsKt.isModuleEnabled(this.context, this.sdkInstance)) {
                return;
            }
            if (StringsKt.isBlank((CharSequence)this.campaignId)) {
                Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ ShowTestInApp this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return ShowTestInApp.access$getTag$p(this.this$0) + " show() : Empty campaign id. Cannot show test in-app.";
                    }
                }), (int)3, null);
                return;
            }
            new InAppFileManager(this.context, this.sdkInstance).deleteHtmlAssetsForCampaignIds(SetsKt.setOf((Object)this.campaignId));
            NetworkResult campaignResponse = repository.fetchTestCampaignPayload(this.campaignId, CoreUtils.getDeviceType((Context)this.context));
            if (campaignResponse == null) {
                this.showErrorDialog("Something went wrong. Could not show in-app.\n Try again or Contact MoEngage Support. Draft-id: " + this.campaignId);
                return;
            }
            NetworkResult networkResult = campaignResponse;
            if (networkResult instanceof ResultFailure) {
                Object object = ((ResultFailure)campaignResponse).getData();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String errorMessage = (String)object;
                this.showErrorDialog(errorMessage + " Draft-Id: " + this.campaignId);
            } else if (networkResult instanceof ResultSuccess) {
                Object object = ((ResultSuccess)campaignResponse).getData();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.moengage.inapp.internal.model.CampaignPayload");
                this.displayTestInAppIfPossible((CampaignPayload)object);
            }
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ ShowTestInApp this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ShowTestInApp.access$getTag$p(this.this$0) + " show() : Completed showing test-inapp";
                }
            }), (int)3, null);
        }
        catch (Exception e) {
            this.sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(this){
                final /* synthetic */ ShowTestInApp this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ShowTestInApp.access$getTag$p(this.this$0) + " show() : ";
                }
            });
        }
    }

    private final void displayTestInAppIfPossible(CampaignPayload payload2) {
        InAppController controller = InAppInstanceProvider.INSTANCE.getControllerForInstance$inapp_release(this.sdkInstance);
        if (Intrinsics.areEqual((Object)"SELF_HANDLED", (Object)payload2.getTemplateType())) {
            Intrinsics.checkNotNull((Object)payload2, (String)"null cannot be cast to non-null type com.moengage.inapp.internal.model.NativeCampaignPayload");
            NativeCampaignPayload cfr_ignored_0 = (NativeCampaignPayload)payload2;
            SelfHandledAvailableListener selfHandledAvailableListener = InAppInstanceProvider.INSTANCE.getCacheForInstance$inapp_release(this.sdkInstance).getSelfHandledListener();
            if (selfHandledAvailableListener == null) {
                return;
            }
            SelfHandledAvailableListener listener = selfHandledAvailableListener;
            String string = ((NativeCampaignPayload)payload2).getCustomPayload();
            if (string == null) {
                return;
            }
            String campaignData = string;
            SelfHandledCampaignData data2 = new SelfHandledCampaignData(new CampaignData(payload2.getCampaignId(), payload2.getCampaignName(), payload2.getCampaignContext()), CoreUtils.accountMetaForInstance((SdkInstance)this.sdkInstance), new SelfHandledCampaign(campaignData, payload2.getDismissInterval()));
            GlobalResources.INSTANCE.getMainThread().post(() -> ShowTestInApp.displayTestInAppIfPossible$lambda-0(listener, data2));
            return;
        }
        ViewCreationMeta meta = UtilsKt.getViewCreationMeta(this.context);
        View view = controller.getViewHandler().buildInApp(payload2, meta);
        if (view == null) {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ ShowTestInApp this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ShowTestInApp.access$getTag$p(this.this$0) + " displayTestInAppIfPossible() : Cannot show in-app. View creation failed.";
                }
            }), (int)3, null);
            this.showErrorDialog("Something went wrong in creating the in-app view. Cannot show in-app.\n    Try again or Contact MoEngage Support. Draft-id: " + this.campaignId);
            return;
        }
        if (UtilsKt.isInAppExceedingScreen(this.context, view)) {
            this.showErrorDialog("Created in-app exceeds screen dimensions.\n Cannot show in-app, please check and edit the in-app template on MoEngage Dashboard.");
            return;
        }
        if (!UtilsKt.canShowInAppInCurrentOrientation(UtilsKt.getCurrentOrientation(this.context), payload2.getSupportedOrientations())) {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ ShowTestInApp this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ShowTestInApp.access$getTag$p(this.this$0) + " displayTestInAppIfPossible() : Cannot show in-app in the current orientation.";
                }
            }), (int)3, null);
            this.showErrorDialog("Cannot show in-app in the current orientation");
            return;
        }
        Activity activity2 = InAppModuleManager.INSTANCE.getActivity();
        if (activity2 == null) {
            return;
        }
        Activity activity3 = activity2;
        controller.getViewHandler().addInAppToViewHierarchy(activity3, view, payload2);
    }

    private final void showErrorDialog(String errorMessage) {
        Activity activity2 = InAppModuleManager.INSTANCE.getActivity();
        if (activity2 == null) {
            return;
        }
        Activity activity3 = activity2;
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)activity3);
        alertDialog.setMessage((CharSequence)errorMessage).setTitle((CharSequence)"Test in-app error").setPositiveButton((CharSequence)"OK", ShowTestInApp::showErrorDialog$lambda-1);
        activity3.runOnUiThread(() -> ShowTestInApp.showErrorDialog$lambda-2(alertDialog));
    }

    private static final void displayTestInAppIfPossible$lambda-0(SelfHandledAvailableListener $listener, SelfHandledCampaignData $data) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)((Object)$data), (String)"$data");
        $listener.onSelfHandledAvailable($data);
    }

    private static final void showErrorDialog$lambda-1(DialogInterface dialog, int n) {
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        dialog.dismiss();
    }

    private static final void showErrorDialog$lambda-2(AlertDialog.Builder $alertDialog) {
        Intrinsics.checkNotNullParameter((Object)$alertDialog, (String)"$alertDialog");
        AlertDialog dialog = $alertDialog.create();
        dialog.show();
    }

    public static final /* synthetic */ String access$getTag$p(ShowTestInApp $this) {
        return $this.tag;
    }
}

