/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.widgets.ratingbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RatingBar;
import androidx.annotation.Keep;
import com.moengage.inapp.R;
import com.moengage.inapp.internal.model.enums.RatingType;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\nH\u0002J\u0017\u0010#\u001a\u0004\u0018\u00010\n2\u0006\u0010$\u001a\u00020\nH&\u00a2\u0006\u0002\u0010%J\u0017\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010$\u001a\u00020\nH&\u00a2\u0006\u0002\u0010%J\u001a\u0010'\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010)\u001a\u00020(H\u0002J\u0010\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020,H\u0014J\u0018\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\nH\u0014J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\nH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/moengage/inapp/internal/widgets/ratingbar/BaseRatingBar;", "Landroid/widget/RatingBar;", "context", "Landroid/content/Context;", "ratingType", "Lcom/moengage/inapp/internal/model/enums/RatingType;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Lcom/moengage/inapp/internal/model/enums/RatingType;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Lcom/moengage/inapp/internal/model/enums/RatingType;Landroid/util/AttributeSet;I)V", "colorsJoined", "Landroid/graphics/Bitmap;", "defaultColorOff", "defaultColorOn", "dp", "", "interiorAngleModifier", "paintInside", "Landroid/graphics/Paint;", "paintOutline", "path", "Landroid/graphics/Path;", "polygonVertices", "rectangle", "Landroid/graphics/RectF;", "starSize", "strokeWidth", "combineBitmaps", "leftBitmap", "rightBitmap", "createStarBySize", "size", "steps", "getColorOff", "position", "(I)Ljava/lang/Integer;", "getColorOn", "getXmlAttrs", "", "init", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "updateShader", "Landroid/graphics/BitmapShader;", "colorOn", "colorOff", "inapp_release"})
@SuppressLint(value={"AppCompatCustomView"})
@Keep
public abstract class BaseRatingBar
extends RatingBar {
    private int defaultColorOn;
    private final int defaultColorOff;
    private final int polygonVertices;
    private int strokeWidth;
    @NotNull
    private final Paint paintInside;
    @NotNull
    private final Paint paintOutline;
    @NotNull
    private Path path;
    @NotNull
    private final RectF rectangle;
    private final float interiorAngleModifier;
    private final float dp;
    private float starSize;
    private Bitmap colorsJoined;
    @NotNull
    private final RatingType ratingType;

    @JvmOverloads
    public BaseRatingBar(@NotNull Context context, @NotNull RatingType ratingType, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)ratingType), (String)"ratingType");
        super(context, attrs);
        this.defaultColorOn = Color.rgb((int)97, (int)97, (int)97);
        this.polygonVertices = 5;
        this.strokeWidth = -1;
        this.paintInside = new Paint();
        this.paintOutline = new Paint();
        this.path = new Path();
        this.rectangle = new RectF();
        this.interiorAngleModifier = 2.2f;
        this.dp = this.getResources().getDisplayMetrics().density;
        this.ratingType = ratingType;
        this.getXmlAttrs(context, attrs);
        this.init();
    }

    public /* synthetic */ BaseRatingBar(Context context, RatingType ratingType, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            attributeSet = null;
        }
        this(context, ratingType, attributeSet);
    }

    public BaseRatingBar(@NotNull Context context, @NotNull RatingType ratingType, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)ratingType), (String)"ratingType");
        super(context, attrs, defStyleAttr);
        this.defaultColorOn = Color.rgb((int)97, (int)97, (int)97);
        this.polygonVertices = 5;
        this.strokeWidth = -1;
        this.paintInside = new Paint();
        this.paintOutline = new Paint();
        this.path = new Path();
        this.rectangle = new RectF();
        this.interiorAngleModifier = 2.2f;
        this.dp = this.getResources().getDisplayMetrics().density;
        this.ratingType = ratingType;
        this.getXmlAttrs(context, attrs);
        this.init();
    }

    private final void init() {
        this.paintInside.setAntiAlias(true);
        this.paintOutline.setStrokeWidth((float)this.strokeWidth);
        this.paintOutline.setStyle(Paint.Style.STROKE);
        this.paintOutline.setStrokeJoin(Paint.Join.ROUND);
        this.paintOutline.setAntiAlias(true);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        int desiredWidth = (int)((float)20 * this.dp * (float)this.getNumStars());
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        switch (widthMode) {
            case 0x40000000: {
                n2 = widthSize;
                break;
            }
            case -2147483648: {
                n2 = Math.min(desiredWidth, widthSize);
                break;
            }
            default: {
                n2 = desiredWidth;
            }
        }
        int width = n2;
        switch (heightMode) {
            case 0x40000000: {
                n = heightSize;
                break;
            }
            case -2147483648: {
                n = Math.min(heightSize, width / this.getNumStars());
                break;
            }
            default: {
                n = width / this.getNumStars();
            }
        }
        int height = n;
        this.starSize = Math.min(height, width / this.getNumStars());
        if (this.strokeWidth < 0) {
            this.strokeWidth = (int)(this.starSize / (float)15);
        }
        this.starSize -= (float)this.strokeWidth;
        this.paintOutline.setStrokeWidth((float)this.strokeWidth);
        this.setMeasuredDimension(width, height);
    }

    private final Path createStarBySize(float size, int steps) {
        if (steps == 0) {
            this.path.addOval(new RectF(0.0f, 0.0f, size, size), Path.Direction.CW);
            this.path.close();
            return this.path;
        }
        float halfSize = size / 2.0f;
        float radius = halfSize / this.interiorAngleModifier;
        float degreesPerStep = (float)Math.toRadians(360.0f / (float)steps);
        float halfDegreesPerStep = degreesPerStep / 2.0f;
        this.path.setFillType(Path.FillType.EVEN_ODD);
        float max = (float)Math.PI * 2;
        this.path.moveTo(halfSize, 0.0f);
        for (double step = 0.0; step < (double)max; step += (double)degreesPerStep) {
            this.path.lineTo((float)((double)halfSize - (double)halfSize * Math.sin(step)), (float)((double)halfSize - (double)halfSize * Math.cos(step)));
            this.path.lineTo((float)((double)halfSize - (double)radius * Math.sin(step + (double)halfDegreesPerStep)), (float)((double)halfSize - (double)radius * Math.cos(step + (double)halfDegreesPerStep)));
        }
        this.path.close();
        return this.path;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.path.rewind();
        this.path = this.createStarBySize(this.starSize, this.polygonVertices);
        int n = this.getNumStars();
        for (int i = 0; i < n; ++i) {
            int position = this.getRating() > 0.0f ? (int)this.getRating() : i + 1;
            Integer n2 = this.getColorOn(position);
            int colorOn = n2 != null ? n2 : this.defaultColorOn;
            Integer n3 = this.getColorOff(position);
            int colorOff = n3 != null ? n3 : this.defaultColorOff;
            this.paintInside.setShader((Shader)this.updateShader(colorOn, colorOff));
            this.path.computeBounds(this.rectangle, true);
            this.path.offset(((float)i + 0.5f) * (float)this.getWidth() / (float)this.getNumStars() - this.rectangle.centerX(), (float)(this.getHeight() / 2) - this.rectangle.centerY());
            this.paintOutline.setColor(colorOn);
            canvas.drawPath(this.path, this.paintInside);
            canvas.drawPath(this.path, this.paintOutline);
        }
    }

    private final BitmapShader updateShader(int colorOn, int colorOff) {
        Bitmap bitmap;
        int ratingWidth = (int)(this.getRating() * (float)this.getWidth() / (float)this.getNumStars());
        if (ratingWidth <= 0 || this.getWidth() - ratingWidth <= 0) {
            Bitmap bitmap2 = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(width, heig\u2026 Bitmap.Config.ARGB_8888)");
            this.colorsJoined = bitmap2;
            Bitmap bitmap3 = this.colorsJoined;
            if (bitmap3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"colorsJoined");
                bitmap3 = null;
            }
            bitmap3.eraseColor(ratingWidth <= 0 ? colorOff : colorOn);
        } else {
            Bitmap colorLeft = Bitmap.createBitmap((int)ratingWidth, (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            colorLeft.eraseColor(colorOn);
            Bitmap colorRight = Bitmap.createBitmap((int)(this.getWidth() - ratingWidth), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            colorRight.eraseColor(colorOff);
            Intrinsics.checkNotNullExpressionValue((Object)colorLeft, (String)"colorLeft");
            Intrinsics.checkNotNullExpressionValue((Object)colorRight, (String)"colorRight");
            this.colorsJoined = this.combineBitmaps(colorLeft, colorRight);
        }
        if ((bitmap = this.colorsJoined) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"colorsJoined");
            bitmap = null;
        }
        return new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
    }

    private final Bitmap combineBitmaps(Bitmap leftBitmap, Bitmap rightBitmap) {
        Bitmap bitmap = Bitmap.createBitmap((int)(leftBitmap.getWidth() + rightBitmap.getWidth()), (int)leftBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(\n          \u2026onfig.ARGB_8888\n        )");
        this.colorsJoined = bitmap;
        Bitmap bitmap2 = this.colorsJoined;
        if (bitmap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"colorsJoined");
            bitmap2 = null;
        }
        Canvas comboImage = new Canvas(bitmap2);
        comboImage.drawBitmap(leftBitmap, 0.0f, 0.0f, null);
        comboImage.drawBitmap(rightBitmap, (float)leftBitmap.getWidth(), 0.0f, null);
        Bitmap bitmap3 = this.colorsJoined;
        if (bitmap3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"colorsJoined");
            bitmap3 = null;
        }
        return bitmap3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getXmlAttrs(Context context, AttributeSet attrs) {
        int n;
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MoERatingBar, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026eable.MoERatingBar, 0, 0)");
        TypedArray a = typedArray;
        BaseRatingBar baseRatingBar = this;
        try {
            BaseRatingBar baseRatingBar2 = baseRatingBar;
            n = a.getInteger(R.styleable.MoERatingBar_starColor, Color.rgb((int)97, (int)97, (int)97));
        }
        finally {
            a.recycle();
        }
        baseRatingBar2.defaultColorOn = n;
    }

    @Nullable
    public abstract Integer getColorOn(int var1);

    @Nullable
    public abstract Integer getColorOff(int var1);

    @JvmOverloads
    public BaseRatingBar(@NotNull Context context, @NotNull RatingType ratingType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)ratingType), (String)"ratingType");
        this(context, ratingType, null, 4, null);
    }
}

