package com.moengage.inbox.core.internal

import android.content.Context
import com.moengage.core.internal.inbox.InboxHandler
import com.moengage.core.internal.model.SdkInstance
import com.moengage.core.internal.storage.database.DbAdapter
import com.moengage.inbox.core.internal.repository.local.DatabaseMigrationHandler

/**
 * @author Arshiya Khanum
 */
public class InboxHandlerImpl : InboxHandler {

    override fun onDatabaseMigration(
        context: Context,
        unencryptedSdkInstance: SdkInstance,
        encryptedSdkInstance: SdkInstance,
        unencryptedDbAdapter: DbAdapter,
        encryptedDbAdapter: DbAdapter
    ) {
        DatabaseMigrationHandler(
            context = context,
            unencryptedSdkInstance = unencryptedSdkInstance,
            encryptedSdkInstance = encryptedSdkInstance,
            unencryptedDbAdapter = unencryptedDbAdapter,
            encryptedDbAdapter = encryptedDbAdapter
        ).migrate()
    }
}