package com.moengage.inbox.core.internal.repository.local

import android.content.Context
import android.database.Cursor
import com.moengage.core.LogLevel
import com.moengage.core.internal.CoreInternalHelper
import com.moengage.core.internal.model.SdkInstance
import com.moengage.core.internal.model.database.QueryParams
import com.moengage.core.internal.storage.database.DbAdapter
import com.moengage.core.internal.storage.database.contract.PROJECTION_INBOX
import com.moengage.core.internal.storage.database.contract.TABLE_NAME_INBOX
import com.moengage.inbox.core.internal.MODULE_TAG

/**
 * A helper class for migrating tables from non-encrypted to encrypted storage
 * @author Arshiya Khanum
 */
internal class DatabaseMigrationHandler(
    private val context: Context,
    unencryptedSdkInstance: SdkInstance,
    private val encryptedSdkInstance: SdkInstance,
    private val unencryptedDbAdapter: DbAdapter,
    private val encryptedDbAdapter: DbAdapter
) {
    private val tag = "${MODULE_TAG}DatabaseMigrationHelper"

    private val unEncryptedMarshallingHelper = MarshallingHelper(context, unencryptedSdkInstance)
    private val encryptedMarshallingHelper = MarshallingHelper(context, encryptedSdkInstance)
    internal fun migrate() {
        var cursor: Cursor? = null
        try {
            encryptedSdkInstance.logger.log { "$tag migrate() : will migrate data" }
            cursor = unencryptedDbAdapter.query(
                TABLE_NAME_INBOX,
                QueryParams(
                    PROJECTION_INBOX,
                    null
                )
            )
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    val campaignEntity = unEncryptedMarshallingHelper.cursorToInboxEntity(cursor)
                    if (campaignEntity != null) {
                        encryptedSdkInstance.logger.log { "$tag migrate() : will insert $campaignEntity" }
                        encryptedDbAdapter.insert(
                            TABLE_NAME_INBOX,
                            CoreInternalHelper.contentValuesFromInboxData(
                                context,
                                encryptedSdkInstance,
                                campaignEntity
                            )
                        )
                    }
                } while (cursor.moveToNext())
            }
            encryptedSdkInstance.logger.log { "$tag migrate() : migration completed" }
        } catch (t: Throwable) {
            encryptedSdkInstance.logger.log(LogLevel.ERROR, t) { "$tag migrate() : " }
        } finally {
            cursor?.close()
        }
    }
}