/*
 * Copyright (c) 2014-2021 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inbox.core.model

import com.moengage.inbox.core.model.actions.Action
import org.json.JSONObject

/**
 * Data object for Inbox Messages
 *
 * @author Umang Chamaria
 * @since 1.0.00
 */
public data class InboxMessage(
    val id: Long,
    /**
     * Unique identifier for the message.
     * @since 1.0.00
     */
    val campaignId: String,
    /**
     * Text content for message.
     * @since 1.0.00
     */
    val textContent: TextContent,
    /**
     * Click action associated to the message.
     * @since 1.0.00
     */
    val action: List<Action>,
    /**
     * True is the message has been clicked, else false.
     * @since 1.0.00
     */
    var isClicked: Boolean,
    /**
     * Tag associated with the message, if nothing is defined general category is added.
     * @since 1.0.00
     */
    val tag: String,
    /**
     * Time the message was received on the device.
     *
     * Format ISO 8601
     * @since 1.0.00
     */
    val receivedTime: String,
    /**
     * Time the message would expire.
     *
     * Format ISO 8601
     * @since 1.0.00
     */
    val expiry: String,
    /**
     * Media associated with the message.
     * @since 1.0.00
     */
    val mediaContent: MediaContent? = null,
    /**
     * Complete campaign payload.
     * @since 1.0.00
     */
    val payload: JSONObject
)