/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inbox.core.internal;

import android.content.Context;
import com.moengage.core.Properties;
import com.moengage.core.analytics.MoEAnalyticsHelper;
import com.moengage.core.internal.executor.Job;
import com.moengage.core.internal.global.GlobalResources;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.utils.CoreUtils;
import com.moengage.inbox.core.internal.InboxCoreInstanceProvider;
import com.moengage.inbox.core.listener.OnMessagesAvailableListener;
import com.moengage.inbox.core.listener.UnClickedCountListener;
import com.moengage.inbox.core.model.InboxData;
import com.moengage.inbox.core.model.InboxMessage;
import com.moengage.inbox.core.model.UnClickedCountData;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0003\u001a\u00020\u0004J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0004J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/moengage/inbox/core/internal/InboxProcessor;", "", "()V", "tag", "", "fetchMessages", "Lcom/moengage/inbox/core/model/InboxData;", "context", "Landroid/content/Context;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "fetchMessagesAsync", "", "listener", "Lcom/moengage/inbox/core/listener/OnMessagesAvailableListener;", "messageTag", "getUnClickedMessageCount", "", "getUnClickedMessageCountAsync", "Lcom/moengage/inbox/core/listener/UnClickedCountListener;", "trackMessageClicked", "inboxMessage", "Lcom/moengage/inbox/core/model/InboxMessage;", "inbox-core_release"})
public final class InboxProcessor {
    @NotNull
    private final String tag;

    public InboxProcessor() {
        this.tag = "InboxCore_2.6.0_InboxProcessor";
    }

    public final void trackMessageClicked(@NotNull Context context, @NotNull SdkInstance sdkInstance, @NotNull InboxMessage inboxMessage) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)inboxMessage, (String)"inboxMessage");
        try {
            if (inboxMessage.getId() == -1L) {
                return;
            }
            InboxCoreInstanceProvider.INSTANCE.getRepositoryForInstance(context, sdkInstance).markMessageClicked(inboxMessage);
            Properties properties = new Properties();
            properties.addAttribute("gcm_campaign_id", (Object)inboxMessage.getCampaignId());
            properties.addAttribute("source", (Object)"inbox");
            MoEAnalyticsHelper.INSTANCE.trackEvent(context, "NOTIFICATION_CLICKED_MOE", properties, sdkInstance.getInstanceMeta().getInstanceId());
        }
        catch (Exception e) {
            sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(this){
                final /* synthetic */ InboxProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InboxProcessor.access$getTag$p(this.this$0) + " trackMessageClicked() : ";
                }
            });
        }
    }

    public final void fetchMessagesAsync(@NotNull Context context, @NotNull SdkInstance sdkInstance, @NotNull OnMessagesAvailableListener listener, @NotNull String messageTag) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)messageTag, (String)"messageTag");
        sdkInstance.getTaskHandler().execute(new Job("INBOX_FETCH_MESSAGES", false, () -> InboxProcessor.fetchMessagesAsync$lambda-1(this, context, sdkInstance, messageTag, listener)));
    }

    public static /* synthetic */ void fetchMessagesAsync$default(InboxProcessor inboxProcessor, Context context, SdkInstance sdkInstance, OnMessagesAvailableListener onMessagesAvailableListener, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = "";
        }
        inboxProcessor.fetchMessagesAsync(context, sdkInstance, onMessagesAvailableListener, string);
    }

    @NotNull
    public final InboxData fetchMessages(@NotNull Context context, @NotNull SdkInstance sdkInstance, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        try {
            return StringsKt.isBlank((CharSequence)tag) ? new InboxData(CoreUtils.accountMetaForInstance((SdkInstance)sdkInstance), InboxCoreInstanceProvider.INSTANCE.getRepositoryForInstance(context, sdkInstance).fetchAllMessages()) : new InboxData(CoreUtils.accountMetaForInstance((SdkInstance)sdkInstance), InboxCoreInstanceProvider.INSTANCE.getRepositoryForInstance(context, sdkInstance).fetchMessagesByTag(tag));
        }
        catch (Exception e) {
            sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(tag){
                final /* synthetic */ String $tag;
                {
                    this.$tag = $tag;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$tag + " fetchMessages() : ";
                }
            });
            return new InboxData(CoreUtils.accountMetaForInstance((SdkInstance)sdkInstance), CollectionsKt.emptyList());
        }
    }

    public static /* synthetic */ InboxData fetchMessages$default(InboxProcessor inboxProcessor, Context context, SdkInstance sdkInstance, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        return inboxProcessor.fetchMessages(context, sdkInstance, string);
    }

    public final void getUnClickedMessageCountAsync(@NotNull Context context, @NotNull SdkInstance sdkInstance, @NotNull UnClickedCountListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        try {
            long unClickedCount = this.getUnClickedMessageCount(context, sdkInstance);
            GlobalResources.INSTANCE.getMainThread().post(() -> InboxProcessor.getUnClickedMessageCountAsync$lambda-2(listener, sdkInstance, unClickedCount));
        }
        catch (Exception e) {
            sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(this){
                final /* synthetic */ InboxProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InboxProcessor.access$getTag$p(this.this$0) + " getUnClickedMessageCountAsync() : ";
                }
            });
        }
    }

    public final long getUnClickedMessageCount(@NotNull Context context, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        return InboxCoreInstanceProvider.INSTANCE.getRepositoryForInstance(context, sdkInstance).getUnClickedMessageCount();
    }

    private static final void fetchMessagesAsync$lambda-1$lambda-0(OnMessagesAvailableListener $listener, InboxData $inboxData) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)((Object)$inboxData), (String)"$inboxData");
        $listener.onMessagesAvailable($inboxData);
    }

    private static final void fetchMessagesAsync$lambda-1(InboxProcessor this$0, Context $context, SdkInstance $sdkInstance, String $messageTag, OnMessagesAvailableListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$sdkInstance, (String)"$sdkInstance");
        Intrinsics.checkNotNullParameter((Object)$messageTag, (String)"$messageTag");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        try {
            InboxData inboxData = this$0.fetchMessages($context, $sdkInstance, $messageTag);
            GlobalResources.INSTANCE.getMainThread().post(() -> InboxProcessor.fetchMessagesAsync$lambda-1$lambda-0($listener, inboxData));
        }
        catch (Exception e) {
            $sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(this$0){
                final /* synthetic */ InboxProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return InboxProcessor.access$getTag$p(this.this$0) + " fetchMessagesAsync() : ";
                }
            });
        }
    }

    private static final void getUnClickedMessageCountAsync$lambda-2(UnClickedCountListener $listener, SdkInstance $sdkInstance, long $unClickedCount) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)$sdkInstance, (String)"$sdkInstance");
        $listener.onCountAvailable(new UnClickedCountData(CoreUtils.accountMetaForInstance((SdkInstance)$sdkInstance), $unClickedCount));
    }

    public static final /* synthetic */ String access$getTag$p(InboxProcessor $this) {
        return $this.tag;
    }
}

