/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inbox.core.internal.repository.local;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import com.moengage.core.internal.CoreInternalHelper;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.model.database.DataAccessor;
import com.moengage.core.internal.model.database.QueryParams;
import com.moengage.core.internal.model.database.WhereClause;
import com.moengage.core.internal.storage.database.contract.InboxContractKt;
import com.moengage.inbox.core.internal.repository.local.LocalRepository;
import com.moengage.inbox.core.internal.repository.local.MarshallingHelper;
import com.moengage.inbox.core.model.InboxMessage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/moengage/inbox/core/internal/repository/local/LocalRepositoryImpl;", "Lcom/moengage/inbox/core/internal/repository/local/LocalRepository;", "context", "Landroid/content/Context;", "dataAccessor", "Lcom/moengage/core/internal/model/database/DataAccessor;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Landroid/content/Context;Lcom/moengage/core/internal/model/database/DataAccessor;Lcom/moengage/core/internal/model/SdkInstance;)V", "marshallingHelper", "Lcom/moengage/inbox/core/internal/repository/local/MarshallingHelper;", "tag", "", "deleteMessage", "", "message", "Lcom/moengage/inbox/core/model/InboxMessage;", "fetchAllMessages", "", "fetchMessagesByTag", "msgTag", "getUnClickedMessageCount", "", "markMessageClicked", "markMessageClickedById", "id", "storeInboxMessage", "inboxMessage", "inbox-core_release"})
public final class LocalRepositoryImpl
implements LocalRepository {
    @NotNull
    private final Context context;
    @NotNull
    private final DataAccessor dataAccessor;
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final String tag;
    @NotNull
    private final MarshallingHelper marshallingHelper;

    public LocalRepositoryImpl(@NotNull Context context, @NotNull DataAccessor dataAccessor, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dataAccessor, (String)"dataAccessor");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.context = context;
        this.dataAccessor = dataAccessor;
        this.sdkInstance = sdkInstance;
        this.tag = "InboxCore_2.6.0_LocalRepositoryImpl";
        this.marshallingHelper = new MarshallingHelper(this.context, this.sdkInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUnClickedMessageCount() {
        long count = 0L;
        Cursor cursor = null;
        try {
            String[] stringArray = new String[]{"msgclicked"};
            String[] stringArray2 = stringArray;
            stringArray = new String[]{"0"};
            cursor = this.dataAccessor.getDbAdapter().query("MESSAGES", new QueryParams(stringArray2, new WhereClause("msgclicked = ? ", stringArray), null, null, null, 0, 60, null));
            if (cursor != null) {
                count = cursor.getCount();
            }
        }
        catch (Exception e) {
            this.sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " getUnClickedMessageCount() : ";
                }
            });
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<InboxMessage> fetchAllMessages() {
        Cursor cursor = null;
        try {
            cursor = this.dataAccessor.getDbAdapter().query("MESSAGES", new QueryParams(InboxContractKt.getPROJECTION_INBOX(), null, null, null, "gtime DESC", 0, 44, null));
            if (cursor == null || !cursor.moveToFirst()) {
                List list = CollectionsKt.emptyList();
                return list;
            }
            List<InboxMessage> list = this.marshallingHelper.cursorToMessages(cursor);
            cursor.close();
            return list;
        }
        catch (Exception e) {
            this.sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " fetchAllMessages() : ";
                }
            });
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public int deleteMessage(@NotNull InboxMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        try {
            String[] stringArray = new String[]{String.valueOf(message.getId())};
            return this.dataAccessor.getDbAdapter().delete("MESSAGES", new WhereClause("_id = ? ", stringArray));
        }
        catch (Exception e) {
            this.sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " deleteMessage() : ";
                }
            });
            return -1;
        }
    }

    @Override
    public int markMessageClicked(@NotNull InboxMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.markMessageClickedById(message.getId());
    }

    @Override
    public int markMessageClickedById(long id) {
        int rowCount = -1;
        try {
            ContentValues values = new ContentValues();
            values.put("msgclicked", Integer.valueOf(1));
            String[] stringArray = new String[]{String.valueOf(id)};
            rowCount = this.dataAccessor.getDbAdapter().update("MESSAGES", values, new WhereClause("_id = ? ", stringArray));
        }
        catch (Exception e) {
            this.sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " markMessageClickedById() : ";
                }
            });
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<InboxMessage> fetchMessagesByTag(@NotNull String msgTag) {
        Intrinsics.checkNotNullParameter((Object)msgTag, (String)"msgTag");
        Cursor cursor = null;
        try {
            Object object = new String[]{msgTag};
            cursor = this.dataAccessor.getDbAdapter().query("MESSAGES", new QueryParams(InboxContractKt.getPROJECTION_INBOX(), new WhereClause("msg_tag = ? ", object), null, null, "gtime DESC", 0, 44, null));
            if (cursor == null || !cursor.moveToFirst()) {
                object = CollectionsKt.emptyList();
                return object;
            }
            object = this.marshallingHelper.cursorToMessages(cursor);
            cursor.close();
            return object;
        }
        catch (Exception e) {
            this.sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(this){
                final /* synthetic */ LocalRepositoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return LocalRepositoryImpl.access$getTag$p(this.this$0) + " fetchMessagesByTag() : ";
                }
            });
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public long storeInboxMessage(@NotNull InboxMessage inboxMessage) {
        Intrinsics.checkNotNullParameter((Object)inboxMessage, (String)"inboxMessage");
        return CoreInternalHelper.INSTANCE.storePushCampaign(this.context, this.sdkInstance, this.marshallingHelper.inboxMessageToInboxData(inboxMessage));
    }

    public static final /* synthetic */ String access$getTag$p(LocalRepositoryImpl $this) {
        return $this.tag;
    }
}

