/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inbox.core.internal.repository.local;

import android.content.Context;
import android.database.Cursor;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.model.database.entity.InboxEntity;
import com.moengage.core.internal.storage.StorageUtilsKt;
import com.moengage.core.internal.utils.ISO8601Utils;
import com.moengage.core.internal.utils.MoEUtils;
import com.moengage.core.internal.utils.TimeUtilsKt;
import com.moengage.inbox.core.model.InboxMessage;
import com.moengage.inbox.core.model.MediaContent;
import com.moengage.inbox.core.model.TextContent;
import com.moengage.inbox.core.model.actions.Action;
import com.moengage.inbox.core.model.actions.NavigationAction;
import com.moengage.inbox.core.model.enums.ActionType;
import com.moengage.inbox.core.model.enums.MediaType;
import com.moengage.inbox.core.model.enums.NavigationType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0014J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/moengage/inbox/core/internal/repository/local/MarshallingHelper;", "", "context", "Landroid/content/Context;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Landroid/content/Context;Lcom/moengage/core/internal/model/SdkInstance;)V", "tag", "", "actionFromPayload", "", "Lcom/moengage/inbox/core/model/actions/Action;", "payload", "Lorg/json/JSONObject;", "cursorToInboxEntity", "Lcom/moengage/core/internal/model/database/entity/InboxEntity;", "cursor", "Landroid/database/Cursor;", "cursorToInboxEntity$inbox_core_release", "cursorToMessage", "Lcom/moengage/inbox/core/model/InboxMessage;", "cursorToMessage$inbox_core_release", "cursorToMessages", "inboxMessageToInboxData", "inboxMessage", "mediaFromPayload", "Lcom/moengage/inbox/core/model/MediaContent;", "inbox-core_release"})
public final class MarshallingHelper {
    @NotNull
    private final Context context;
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final String tag;

    public MarshallingHelper(@NotNull Context context, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.context = context;
        this.sdkInstance = sdkInstance;
        this.tag = "InboxCore_2.6.0_MarshallingHelper";
    }

    @NotNull
    public final List<InboxMessage> cursorToMessages(@NotNull Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        ArrayList<InboxMessage> inboxMessages = new ArrayList<InboxMessage>(cursor.getCount());
        do {
            InboxMessage message;
            if ((message = this.cursorToMessage$inbox_core_release(cursor)) == null) continue;
            inboxMessages.add(message);
        } while (cursor.moveToNext());
        return inboxMessages;
    }

    @NotNull
    public final InboxEntity inboxMessageToInboxData(@NotNull InboxMessage inboxMessage) {
        Intrinsics.checkNotNullParameter((Object)inboxMessage, (String)"inboxMessage");
        long l = inboxMessage.getId();
        String string = inboxMessage.getCampaignId();
        int n = inboxMessage.isClicked() ? 1 : 0;
        String string2 = inboxMessage.getTag();
        long l2 = TimeUtilsKt.milliSecondsFromIsoString((String)inboxMessage.getReceivedTime());
        long l3 = TimeUtilsKt.milliSecondsFromIsoString((String)inboxMessage.getExpiry());
        String string3 = inboxMessage.getPayload().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"inboxMessage.payload.toString()");
        return new InboxEntity(l, string, n, string2, l2, l3, string3);
    }

    @Nullable
    public final InboxMessage cursorToMessage$inbox_core_release(@NotNull Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        try {
            String string = cursor.getString(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(COLUMN_INDEX_MSG_DETAILS)");
            JSONObject messageJson = new JSONObject(StorageUtilsKt.decryptValueIfRequired((Context)this.context, (SdkInstance)this.sdkInstance, (String)string));
            String campaignId = cursor.getString(6);
            CharSequence charSequence = campaignId;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                campaignId = messageJson.getString("gcm_campaign_id");
            }
            long l = cursor.getLong(0);
            String string2 = campaignId;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"campaignId");
            String string3 = messageJson.getString("gcm_title");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"messageJson.getString(PUSH_NOTIFICATION_TITLE)");
            String string4 = messageJson.getString("gcm_alert");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"messageJson.getString(PUSH_NOTIFICATION_MESSAGE)");
            String string5 = messageJson.optString("gcm_subtext", "");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"messageJson.optString(PU\u2026NOTIFICATION_SUMMARY, \"\")");
            TextContent textContent = new TextContent(string3, string4, string5);
            List<Action> list = this.actionFromPayload(messageJson);
            boolean bl = cursor.getInt(3) == 1;
            String string6 = cursor.getString(5);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"cursor.getString(COLUMN_INDEX_MSG_TAG)");
            String string7 = ISO8601Utils.format((Date)new Date(cursor.getLong(1)));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(Date(cursor.getLong(COLUMN_INDEX_GTIME)))");
            String string8 = ISO8601Utils.format((Date)new Date(cursor.getLong(4)));
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(Date(cursor.getLong(COLUMN_INDEX_MSG_TTL)))");
            return new InboxMessage(l, string2, textContent, list, bl, string6, string7, string8, this.mediaFromPayload(messageJson), messageJson);
        }
        catch (Exception e) {
            Logger.Companion.print(1, (Throwable)e, (Function0)new Function0<String>(this){
                final /* synthetic */ MarshallingHelper this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return MarshallingHelper.access$getTag$p(this.this$0) + " cursorToMessage() : ";
                }
            });
            return null;
        }
    }

    private final List<Action> actionFromPayload(JSONObject payload) {
        String string;
        String notificationType = payload.getString("gcm_notificationType");
        NavigationType navigationType = Intrinsics.areEqual((Object)"gcm_webNotification", (Object)notificationType) ? NavigationType.DEEP_LINK : (payload.has("gcm_webUrl") ? NavigationType.RICH_LANDING : NavigationType.SCREEN_NAME);
        switch (WhenMappings.$EnumSwitchMapping$0[navigationType.ordinal()]) {
            case 1: {
                String string2 = payload.has("moe_webUrl") ? payload.getString("moe_webUrl") : payload.getString("gcm_webUrl");
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                if (pa\u2026          }\n            }");
                break;
            }
            case 2: {
                String string3 = payload.getString("gcm_activityName");
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n                payloa\u2026IVITY_NAME)\n            }");
                break;
            }
            default: {
                String string4 = payload.getString("gcm_webUrl");
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n                payloa\u2026INK_LEGACY)\n            }");
            }
        }
        String url = string;
        Map map = MoEUtils.jsonToMap((JSONObject)payload);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"jsonToMap(payload)");
        NavigationAction navigationAction = new NavigationAction(ActionType.NAVIGATION, navigationType, url, map);
        Object[] objectArray = new Action[]{navigationAction};
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    private final MediaContent mediaFromPayload(JSONObject payload) {
        if (!payload.has("gcm_image_url")) {
            return null;
        }
        String string = payload.getString("gcm_image_url");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"payload.getString(PUSH_NOTIFICATION_IMAGE_URL)");
        return new MediaContent(MediaType.IMAGE, string);
    }

    @Nullable
    public final InboxEntity cursorToInboxEntity$inbox_core_release(@NotNull Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        try {
            String string = cursor.getString(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(COLUMN_INDEX_MSG_DETAILS)");
            JSONObject messageJson = new JSONObject(StorageUtilsKt.decryptValueIfRequired((Context)this.context, (SdkInstance)this.sdkInstance, (String)string));
            String campaignId = cursor.getString(6);
            CharSequence charSequence = campaignId;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                campaignId = messageJson.getString("gcm_campaign_id");
            }
            long l = cursor.getLong(0);
            String string2 = campaignId;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"campaignId");
            int n = cursor.getInt(3);
            String string3 = cursor.getString(5);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"cursor.getString(COLUMN_INDEX_MSG_TAG)");
            String string4 = ISO8601Utils.format((Date)new Date(cursor.getLong(1)));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(Date(cursor.getLong(COLUMN_INDEX_GTIME)))");
            long l2 = TimeUtilsKt.milliSecondsFromIsoString((String)string4);
            String string5 = ISO8601Utils.format((Date)new Date(cursor.getLong(4)));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(Date(cursor.getLong(COLUMN_INDEX_MSG_TTL)))");
            long l3 = TimeUtilsKt.milliSecondsFromIsoString((String)string5);
            String string6 = messageJson.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"messageJson.toString()");
            return new InboxEntity(l, string2, n, string3, l2, l3, string6);
        }
        catch (Exception e) {
            Logger.Companion.print(1, (Throwable)e, (Function0)new Function0<String>(this){
                final /* synthetic */ MarshallingHelper this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return MarshallingHelper.access$getTag$p(this.this$0) + " cursorToInboxEntity() : ";
                }
            });
            return null;
        }
    }

    public static final /* synthetic */ String access$getTag$p(MarshallingHelper $this) {
        return $this.tag;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NavigationType.values().length];
            nArray[NavigationType.DEEP_LINK.ordinal()] = 1;
            nArray[NavigationType.SCREEN_NAME.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

