/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.integrationverifier.internal.repository;

import android.os.Build;
import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.BaseRequest;
import com.moengage.core.internal.remoteconfig.RConfigManager;
import com.moengage.core.internal.rest.ApiResult;
import com.moengage.core.internal.utils.MoEUtils;
import com.moengage.core.model.FeatureStatus;
import com.moengage.integrationverifier.internal.model.NetworkResult;
import com.moengage.integrationverifier.internal.model.RegisterRequest;
import com.moengage.integrationverifier.internal.model.RequestType;
import com.moengage.integrationverifier.internal.model.UnregisterRequest;
import com.moengage.integrationverifier.internal.repository.LocalRepository;
import com.moengage.integrationverifier.internal.repository.RemoteRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\tH\u0096\u0001J\t\u0010\n\u001a\u00020\u0007H\u0096\u0001J\t\u0010\u000b\u001a\u00020\fH\u0096\u0001J\t\u0010\r\u001a\u00020\u000eH\u0096\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J\u0006\u0010\u0011\u001a\u00020\u0012J\u0011\u0010\u0011\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000eH\u0096\u0001J\u0011\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001cH\u0096\u0001J\u0006\u0010\u001d\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/moengage/integrationverifier/internal/repository/VerificationRepository;", "Lcom/moengage/integrationverifier/internal/repository/RemoteRepository;", "Lcom/moengage/integrationverifier/internal/repository/LocalRepository;", "remoteRepository", "localRepository", "(Lcom/moengage/integrationverifier/internal/repository/RemoteRepository;Lcom/moengage/integrationverifier/internal/repository/LocalRepository;)V", "tag", "", "getBaseRequest", "Lcom/moengage/core/internal/model/BaseRequest;", "getFcmToken", "getFeatureStatus", "Lcom/moengage/core/model/FeatureStatus;", "getVerificationRegistrationTime", "", "isRegisteredForVerification", "", "registerDevice", "Lcom/moengage/integrationverifier/internal/model/NetworkResult;", "Lcom/moengage/core/internal/rest/ApiResult;", "request", "Lcom/moengage/integrationverifier/internal/model/RegisterRequest;", "setVerificationRegistration", "", "state", "setVerificationRegistrationTime", "registrationTime", "unRegisterDevice", "Lcom/moengage/integrationverifier/internal/model/UnregisterRequest;", "unregisterDevice", "integration-verifier_release"})
public final class VerificationRepository
implements RemoteRepository,
LocalRepository {
    private final String tag;
    private final RemoteRepository remoteRepository;
    private final LocalRepository localRepository;

    @NotNull
    public final NetworkResult registerDevice() {
        try {
            if (!this.getFeatureStatus().isSdkEnabled()) {
                Logger.v((String)(this.tag + " registerDevice() : SDK disabled"));
                return new NetworkResult(RequestType.REGISTER_DEVICE, ApiResult.SOMETHING_WENT_WRONG);
            }
            if (!RConfigManager.INSTANCE.getConfig().isAppEnabled()) {
                Logger.v((String)(this.tag + " registerDevice() : Account blocked will not make api call."));
                return new NetworkResult(RequestType.REGISTER_DEVICE, ApiResult.SOMETHING_WENT_WRONG);
            }
            BaseRequest baseRequest = this.localRepository.getBaseRequest();
            GeoLocation geoLocation = new GeoLocation(0.0, 0.0);
            String string2 = Build.MANUFACTURER;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Build.MANUFACTURER");
            String string3 = this.localRepository.getFcmToken();
            String string4 = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"Build.MODEL");
            ApiResult apiResult = this.remoteRepository.registerDevice(new RegisterRequest(baseRequest, geoLocation, string2, string3, string4));
            if (apiResult == ApiResult.SUCCESS) {
                this.setVerificationRegistration(true);
                this.setVerificationRegistrationTime(MoEUtils.currentMillis());
            }
            return new NetworkResult(RequestType.REGISTER_DEVICE, apiResult);
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " registerDevice() : "), (Throwable)e);
            return new NetworkResult(RequestType.REGISTER_DEVICE, ApiResult.SOMETHING_WENT_WRONG);
        }
    }

    @NotNull
    public final NetworkResult unregisterDevice() {
        try {
            if (!this.getFeatureStatus().isSdkEnabled()) {
                Logger.v((String)(this.tag + " unregisterDevice() : SDK disabled"));
                return new NetworkResult(RequestType.REGISTER_DEVICE, ApiResult.SOMETHING_WENT_WRONG);
            }
            if (!RConfigManager.INSTANCE.getConfig().isAppEnabled()) {
                Logger.v((String)(this.tag + " unregisterDevice() : Account blocked will not make api call."));
                return new NetworkResult(RequestType.UNREGISTER_DEVICE, ApiResult.SOMETHING_WENT_WRONG);
            }
            ApiResult apiResult = this.remoteRepository.unRegisterDevice(new UnregisterRequest(this.localRepository.getBaseRequest()));
            if (apiResult == ApiResult.SUCCESS) {
                this.setVerificationRegistration(false);
                this.setVerificationRegistrationTime(0L);
            }
            return new NetworkResult(RequestType.UNREGISTER_DEVICE, apiResult);
        }
        catch (Exception e) {
            Logger.v((String)(this.tag + " unregisterDevice() : "), (Throwable)e);
            return new NetworkResult(RequestType.UNREGISTER_DEVICE, ApiResult.SOMETHING_WENT_WRONG);
        }
    }

    public VerificationRepository(@NotNull RemoteRepository remoteRepository, @NotNull LocalRepository localRepository) {
        Intrinsics.checkNotNullParameter((Object)remoteRepository, (String)"remoteRepository");
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        this.remoteRepository = remoteRepository;
        this.localRepository = localRepository;
        this.tag = "IntVerify_VerificationRepository";
    }

    @Override
    @NotNull
    public ApiResult registerDevice(@NotNull RegisterRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return this.remoteRepository.registerDevice(request);
    }

    @Override
    @NotNull
    public ApiResult unRegisterDevice(@NotNull UnregisterRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return this.remoteRepository.unRegisterDevice(request);
    }

    @Override
    @NotNull
    public BaseRequest getBaseRequest() {
        return this.localRepository.getBaseRequest();
    }

    @Override
    @NotNull
    public String getFcmToken() {
        return this.localRepository.getFcmToken();
    }

    @Override
    @NotNull
    public FeatureStatus getFeatureStatus() {
        return this.localRepository.getFeatureStatus();
    }

    @Override
    public long getVerificationRegistrationTime() {
        return this.localRepository.getVerificationRegistrationTime();
    }

    @Override
    public boolean isRegisteredForVerification() {
        return this.localRepository.isRegisteredForVerification();
    }

    @Override
    public void setVerificationRegistration(boolean state) {
        this.localRepository.setVerificationRegistration(state);
    }

    @Override
    public void setVerificationRegistrationTime(long registrationTime) {
        this.localRepository.setVerificationRegistrationTime(registrationTime);
    }
}

