/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushamp.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.moengage.core.MoECallbacks;
import com.moengage.core.internal.executor.ITask;
import com.moengage.core.internal.executor.TaskManager;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.MoEJobParameters;
import com.moengage.core.internal.remoteconfig.RemoteConfig;
import com.moengage.core.internal.utils.MoEUtils;
import com.moengage.core.internal.utils.UtilsKt;
import com.moengage.core.listeners.AppBackgroundListener;
import com.moengage.pushamp.internal.PushAmpAlarmReceiver;
import com.moengage.pushamp.internal.PushAmpSyncJob;
import com.moengage.pushamp.internal.repository.PushAmpRepository;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncRequest;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncResponse;
import com.moengage.pushamp.internal.repository.remote.PushAmpServerSyncTask;
import com.moengage.pushbase.internal.PushHelper;
import java.util.List;
import java.util.Map;

public class PushAmpController
implements AppBackgroundListener {
    private static final String TAG = "PushAmp_3.2.00_PushAmpController";
    public final PushAmpRepository repository;
    public boolean hasSynced = false;

    PushAmpController(PushAmpRepository repository) {
        this.repository = repository;
        MoECallbacks.getInstance().addAppBackgroundListener((AppBackgroundListener)this);
    }

    public void showPush(Context context, @Nullable List<Map<String, String>> payloadList) {
        Logger.v((String)"PushAmp_3.2.00_PushAmpController showPush() : Push Amp synced. Will try to show messages.");
        if (payloadList == null) {
            Logger.v((String)"PushAmp_3.2.00_PushAmpController showPush(): No push messages to be shown");
            return;
        }
        for (Map<String, String> payload : payloadList) {
            PushHelper.getInstance().handlePushPayload(context, payload);
        }
    }

    void scheduleServerSync(Context context) {
        Logger.v((String)"PushAmp_3.2.00_PushAmpController scheduleServerSync() : Will schedule server sync.");
        if (!this.repository.isModuleEnabled()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.scheduleSyncJob(context, this.repository.getMinimumSyncDelay());
        } else {
            this.scheduleSyncAlarm(context, this.repository.getMinimumSyncDelay());
        }
    }

    private void scheduleSyncAlarm(Context context, long minimumDelayDuration) {
        Logger.v((String)"PushAmp_3.2.00_PushAmpController scheduleSyncAlarm() : Scheduling sync alarm");
        Intent alarmIntent = new Intent(context, PushAmpAlarmReceiver.class);
        alarmIntent.setAction("ACTION_SYNC_MESSAGES");
        PendingIntent pendingIntent = UtilsKt.getPendingIntentBroadcast((Context)context, (int)20001, (Intent)alarmIntent);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.set(0, MoEUtils.currentMillis() + minimumDelayDuration, pendingIntent);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    @TargetApi(value=21)
    private void scheduleSyncJob(Context context, long minimumDelayDuration) {
        JobScheduler jobScheduler;
        Logger.v((String)"PushAmp_3.2.00_PushAmpController scheduleSyncJob() : scheduling sync job");
        ComponentName serviceComponent = new ComponentName(context, PushAmpSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(20002, serviceComponent);
        builder.setOverrideDeadline(MoEUtils.currentMillis() + minimumDelayDuration + 3600000L);
        builder.setMinimumLatency(minimumDelayDuration);
        builder.setRequiredNetworkType(1);
        if (MoEUtils.hasPermission((Context)context, (String)"android.permission.RECEIVE_BOOT_COMPLETED")) {
            builder.setPersisted(true);
        }
        if ((jobScheduler = (JobScheduler)context.getSystemService("jobscheduler")) != null) {
            int result = jobScheduler.schedule(builder.build());
            Logger.v((String)("PushAmp_3.2.00_PushAmpController scheduleSyncJob() : Scheduling result: " + result));
        }
    }

    private void fetchCampaignsFromServer(Context context, boolean fromAppOpen, MoEJobParameters jobParameters) {
        TaskManager.getInstance().execute((ITask)new PushAmpServerSyncTask(context, fromAppOpen, jobParameters));
    }

    @WorkerThread
    public void fetchAndShowCampaigns(Context context, PushAmpSyncRequest request) {
        PushAmpSyncResponse pushAmpSyncResponse = this.repository.fetchCampaigns(request);
        this.hasSynced = pushAmpSyncResponse.isSuccessful;
        if (pushAmpSyncResponse.isSuccessful && pushAmpSyncResponse.campaignList != null) {
            this.showPush(context, pushAmpSyncResponse.campaignList);
        }
    }

    void syncOnAppForeground(Context context) {
        Logger.v((String)"PushAmp_3.2.00_PushAmpController syncOnAppForeground() : App came to foreground. Will try to fetch push-amp messages if required.");
        if (this.hasSynced && this.repository.getLastSyncTime() + 900000L > MoEUtils.currentMillis()) {
            Logger.d((String)"PushAmp_3.2.00_PushAmpController syncOnAppForeground() : Push Amp API had synced recently, will not sync again.");
            return;
        }
        Logger.v((String)"PushAmp_3.2.00_PushAmpController syncOnAppForeground() : Fetching campaigns from Push-Amp.");
        this.fetchCampaignsFromServer(context, true, null);
    }

    void backgroundSyncAndSchedule(Context context, @Nullable MoEJobParameters jobParameters) {
        this.fetchCampaignsFromServer(context, false, jobParameters);
        this.scheduleServerSync(context);
    }

    public boolean shouldSync() {
        if (this.repository.isPushNotificationOptedOut()) {
            Logger.i((String)"PushAmp_3.2.00_PushAmpController shouldSync() : Push notifications are opted out, disabling push-amp.");
            return false;
        }
        RemoteConfig remoteConfig = this.repository.getRemoteConfig();
        if (!remoteConfig.isAppEnabled()) {
            Logger.i((String)"PushAmp_3.2.00_PushAmpController shouldSync() : App is disabled, disabling push-amp.");
            return false;
        }
        if (!remoteConfig.isPushAmpEnabled()) {
            Logger.i((String)"PushAmp_3.2.00_PushAmpController shouldSync() : Push amp is disabled.");
            return false;
        }
        return true;
    }

    public void onAppBackground(@NonNull Context context) {
        try {
            Logger.v((String)"PushAmp_3.2.00_PushAmpController onAppBackground() : ");
            this.scheduleServerSync(context);
        }
        catch (Exception e) {
            Logger.e((String)"PushAmp_3.2.00_PushAmpController onAppBackground() : ", (Throwable)e);
        }
    }

    void onLogout() {
        this.repository.clearData();
    }
}

