/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushamp.internal.repository;

import com.moengage.core.SdkConfig;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.BaseRequest;
import com.moengage.core.internal.remoteconfig.RemoteConfig;
import com.moengage.core.internal.utils.MoEUtils;
import com.moengage.core.model.FeatureStatus;
import com.moengage.pushamp.internal.repository.local.LocalRepository;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncRequest;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncResponse;
import com.moengage.pushamp.internal.repository.remote.RemoteRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\u000bH\u0096\u0001J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0011\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u0096\u0001J\t\u0010\u0017\u001a\u00020\u0016H\u0096\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u0096\u0001J\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\u001c\u001a\u00020\u001bH\u0096\u0001J\u0011\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0016H\u0096\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/moengage/pushamp/internal/repository/PushAmpRepository;", "Lcom/moengage/pushamp/internal/repository/local/LocalRepository;", "Lcom/moengage/pushamp/internal/repository/remote/RemoteRepository;", "localRepository", "remoteRepository", "config", "Lcom/moengage/core/SdkConfig;", "(Lcom/moengage/pushamp/internal/repository/local/LocalRepository;Lcom/moengage/pushamp/internal/repository/remote/RemoteRepository;Lcom/moengage/core/SdkConfig;)V", "tag", "", "clearData", "", "fetchCampaigns", "Lcom/moengage/pushamp/internal/repository/models/PushAmpSyncResponse;", "request", "Lcom/moengage/pushamp/internal/repository/models/PushAmpSyncRequest;", "fetchCampaignsFromServer", "getBaseRequest", "Lcom/moengage/core/internal/model/BaseRequest;", "getFeatureStatus", "Lcom/moengage/core/model/FeatureStatus;", "getLastSyncTime", "", "getMinimumSyncDelay", "getRemoteConfig", "Lcom/moengage/core/internal/remoteconfig/RemoteConfig;", "isModuleEnabled", "", "isPushNotificationOptedOut", "storeLastSyncTime", "lastSyncTime", "push-amp_release"})
public final class PushAmpRepository
implements LocalRepository,
RemoteRepository {
    private final String tag;
    private final LocalRepository localRepository;
    private final RemoteRepository remoteRepository;
    private final SdkConfig config;

    @NotNull
    public final PushAmpSyncResponse fetchCampaigns(@NotNull PushAmpSyncRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        try {
            if (!this.isModuleEnabled()) {
                return new PushAmpSyncResponse(false);
            }
            PushAmpSyncResponse pushAmpSyncResponse = this.fetchCampaignsFromServer(request);
            if (pushAmpSyncResponse.isSuccessful) {
                this.storeLastSyncTime(MoEUtils.currentMillis());
            }
            return pushAmpSyncResponse;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " fetchCampaigns() : "), (Throwable)e);
            return new PushAmpSyncResponse(false);
        }
    }

    public final boolean isModuleEnabled() {
        return this.getFeatureStatus().isSdkEnabled() && this.getRemoteConfig().isAppEnabled() && this.getRemoteConfig().isPushAmpEnabled() && !this.isPushNotificationOptedOut();
    }

    public PushAmpRepository(@NotNull LocalRepository localRepository, @NotNull RemoteRepository remoteRepository, @NotNull SdkConfig config) {
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        Intrinsics.checkNotNullParameter((Object)remoteRepository, (String)"remoteRepository");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.localRepository = localRepository;
        this.remoteRepository = remoteRepository;
        this.config = config;
        this.tag = "PushAmp_3.2.00_PushAmpRepository";
    }

    @Override
    public void clearData() {
        this.localRepository.clearData();
    }

    @Override
    @NotNull
    public BaseRequest getBaseRequest() {
        return this.localRepository.getBaseRequest();
    }

    @Override
    @NotNull
    public FeatureStatus getFeatureStatus() {
        return this.localRepository.getFeatureStatus();
    }

    @Override
    public long getLastSyncTime() {
        return this.localRepository.getLastSyncTime();
    }

    @Override
    public long getMinimumSyncDelay() {
        return this.localRepository.getMinimumSyncDelay();
    }

    @Override
    @NotNull
    public RemoteConfig getRemoteConfig() {
        return this.localRepository.getRemoteConfig();
    }

    @Override
    public boolean isPushNotificationOptedOut() {
        return this.localRepository.isPushNotificationOptedOut();
    }

    @Override
    public void storeLastSyncTime(long lastSyncTime) {
        this.localRepository.storeLastSyncTime(lastSyncTime);
    }

    @Override
    @NotNull
    public PushAmpSyncResponse fetchCampaignsFromServer(@NotNull PushAmpSyncRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return this.remoteRepository.fetchCampaignsFromServer(request);
    }
}

