/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushamp.internal.repository.local;

import android.content.Context;
import com.moengage.core.SdkConfig;
import com.moengage.core.internal.model.BaseRequest;
import com.moengage.core.internal.remoteconfig.RConfigManager;
import com.moengage.core.internal.remoteconfig.RemoteConfig;
import com.moengage.core.internal.storage.StorageProvider;
import com.moengage.core.internal.utils.RestUtils;
import com.moengage.core.model.FeatureStatus;
import com.moengage.pushamp.internal.repository.local.LocalRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/moengage/pushamp/internal/repository/local/LocalRepositoryImpl;", "Lcom/moengage/pushamp/internal/repository/local/LocalRepository;", "context", "Landroid/content/Context;", "config", "Lcom/moengage/core/SdkConfig;", "(Landroid/content/Context;Lcom/moengage/core/SdkConfig;)V", "clearData", "", "getBaseRequest", "Lcom/moengage/core/internal/model/BaseRequest;", "getFeatureStatus", "Lcom/moengage/core/model/FeatureStatus;", "getLastSyncTime", "", "getMinimumSyncDelay", "getRemoteConfig", "Lcom/moengage/core/internal/remoteconfig/RemoteConfig;", "isPushNotificationOptedOut", "", "storeLastSyncTime", "lastSyncTime", "push-amp_release"})
public final class LocalRepositoryImpl
implements LocalRepository {
    private final Context context;
    private final SdkConfig config;

    @Override
    public void storeLastSyncTime(long lastSyncTime) {
        StorageProvider.INSTANCE.getSharedPreference(this.context, this.config).putLong("last_message_sync", lastSyncTime);
    }

    @Override
    public long getLastSyncTime() {
        return StorageProvider.INSTANCE.getSharedPreference(this.context, this.config).getLong("last_message_sync", 0L);
    }

    @Override
    public long getMinimumSyncDelay() {
        return RConfigManager.INSTANCE.getConfig().getPushAmpSyncInterval();
    }

    @Override
    @NotNull
    public BaseRequest getBaseRequest() {
        BaseRequest baseRequest = RestUtils.getBaseRequest((Context)this.context);
        Intrinsics.checkNotNullExpressionValue((Object)baseRequest, (String)"RestUtils.getBaseRequest(context)");
        return baseRequest;
    }

    @Override
    @NotNull
    public RemoteConfig getRemoteConfig() {
        return RConfigManager.INSTANCE.getConfig();
    }

    @Override
    public boolean isPushNotificationOptedOut() {
        return StorageProvider.INSTANCE.getRepository((Context)this.context, (SdkConfig)this.config).getDevicePreferences().isPushOptedOut;
    }

    @Override
    public void clearData() {
        StorageProvider.INSTANCE.getSharedPreference(this.context, this.config).removeKey("last_message_sync");
    }

    @Override
    @NotNull
    public FeatureStatus getFeatureStatus() {
        return StorageProvider.INSTANCE.getRepository(this.context, this.config).getFeatureStatus();
    }

    public LocalRepositoryImpl(@NotNull Context context, @NotNull SdkConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
    }
}

