/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushamp.internal.repository.remote;

import android.content.Context;
import androidx.annotation.Nullable;
import com.moengage.core.internal.executor.SDKTask;
import com.moengage.core.internal.executor.TaskResult;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.MoEJobParameters;
import com.moengage.pushamp.internal.InjectionUtils;
import com.moengage.pushamp.internal.PushAmpController;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncRequest;

public class PushAmpServerSyncTask
extends SDKTask {
    private static final String TAG = "PushAmp_3.2.00_PushAmpServerSyncTask";
    private boolean fromAppOpen;
    @Nullable
    private MoEJobParameters jobParameters;

    public PushAmpServerSyncTask(Context context, boolean fromAppOpen, @Nullable MoEJobParameters parameters) {
        super(context);
        this.fromAppOpen = fromAppOpen;
        this.jobParameters = parameters;
    }

    public TaskResult execute() {
        try {
            Logger.v((String)"PushAmp_3.2.00_PushAmpServerSyncTask execute() : Executing task");
            PushAmpController controller = InjectionUtils.getInstance().getController(this.context);
            if (!controller.repository.isModuleEnabled()) {
                return this.taskResult;
            }
            PushAmpSyncRequest request = new PushAmpSyncRequest(controller.repository.getBaseRequest(), controller.repository.getLastSyncTime(), this.fromAppOpen);
            controller.fetchAndShowCampaigns(this.context, request);
            if (this.jobParameters != null) {
                this.jobParameters.jobCompleteListener.jobComplete(this.jobParameters);
            }
            Logger.v((String)"PushAmp_3.2.00_PushAmpServerSyncTask execute() : Task Complete");
        }
        catch (Exception e) {
            Logger.e((String)"PushAmp_3.2.00_PushAmpServerSyncTask execute() : Exception: ", (Throwable)e);
        }
        return this.taskResult;
    }

    public String getTaskTag() {
        return "PUSH_AMP_SERVER_SYNC_TASK";
    }

    public boolean isSynchronous() {
        return true;
    }
}

