package com.moengage.richnotification.internal

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.os.Build
import androidx.annotation.RequiresApi
import com.moengage.core.LogLevel
import com.moengage.core.internal.logger.Logger
import com.moengage.core.internal.utils.logBundle

/**
 * @author Arshiya Khanum
 */
@RequiresApi(Build.VERSION_CODES.M)
internal class MoERichPushReceiver : BroadcastReceiver() {

    private val tag = "${MODULE_TAG}MoERichPushReceiver"

    override fun onReceive(context: Context, intent: Intent) {
        try {
            Logger.print { "$tag onReceive() : Will attempt to process intent" }
            val payload = intent.extras ?: return
            logBundle(tag, payload)
            val intentAction = intent.action ?: return
            IntentActionHandler(context, intentAction, payload).handleAction()
        } catch (t: Throwable) {
            Logger.print(LogLevel.ERROR, t) { "$tag onReceive() : " }
        }
    }
}