package com.moengage.richnotification.internal

import com.moengage.core.internal.model.SdkInstance

/**
 * @author Arshiya Khanum
 */
internal object RichNotificationInstanceProvider {

    private val controllerCache = mutableMapOf<String, RichNotificationController>()

    internal fun getControllerForInstance(sdkInstance: SdkInstance): RichNotificationController {
        return controllerCache[sdkInstance.instanceMeta.instanceId]
            ?: synchronized(RichNotificationController::class.java) {
                val controller =
                    controllerCache[sdkInstance.instanceMeta.instanceId]
                        ?: RichNotificationController(sdkInstance)
                controllerCache[sdkInstance.instanceMeta.instanceId] = controller
                controller
            }
    }
}