/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.moengage.richnotification.internal

import com.moengage.core.internal.MANUFACTURER_VIVO
import com.moengage.richnotification.BuildConfig

/**
 * @author Umang Chamaria
 * Date: 25/02/20
 */

internal const val MODULE_TAG = "RichPush_" + BuildConfig.MOENGAGE_RICH_PUSH_VERSION + "_"
internal const val TEMPLATE_NAME = "displayName"

// collapsed template names
internal const val COLLAPSED_BACKGROUND_COLOR = "stylizedBasic"

// expanded template names
internal const val EXPANDED_BACKGROUND_COLOR = "stylizedBasic"
internal const val EXPANDED_IMAGE_CAROUSEL = "imageCarousel"
internal const val EXPANDED_IMAGE_TEXT_BANNER = "imageBannerText"

internal const val TEMPLATE_NAME_IMAGE_BANNER = "imageBanner"
internal const val TEMPLATE_NAME_TIMER = "timer"
internal const val TEMPLATE_NAME_TIMER_WITH_PROGRESS = "timerWithProgressbar"

internal const val COLLAPSED_CUSTOMISATION = "collapsed"
internal const val EXPANDED_CUSTOMISATION = "expanded"
internal const val TEMPLATE_TYPE = "type"
internal const val ASSET_COLOR_LIGHT_GREY = "lightGrey"
internal const val ASSET_COLOR_DARK_GREY = "darkGrey"
internal const val WIDGET_TYPE_BUTTON = "button"
internal const val WIDGET_TYPE_IMAGE = "image"
internal const val WIDGET_TYPE_TEXT = "text"
internal const val WIDGET_TYPE_TIMER = "timer"
internal const val WIDGET_TYPE_PROGRESSBAR = "progressbar"
internal const val IMAGE_INDEX = "image_index"
internal const val TOTAL_IMAGE_COUNT = "image_count"
internal const val NAVIGATION_DIRECTION = "nav_dir"
internal const val NAVIGATION_DIRECTION_NEXT = "next"
internal const val NAVIGATION_DIRECTION_PREVIOUS = "previous"
internal const val PROPERTY_DURATION_KEY = "duration"
internal const val PROPERTY_EXPIRY_KEY = "expiry"
internal const val PROPERTY_FORMAT_KEY = "format"

internal const val MAX_IMAGE_HEIGHT = 192

internal const val MAX_IMAGE_BANNER_HEIGHT_COLLAPSED_STATE = 64
internal const val MAX_IMAGE_BANNER_HEIGHT_BIG_LAYOUT_COLLAPSED_STATE = 100
internal const val MAX_IMAGE_BANNER_HEIGHT_EXPANDED_STATE = 256
internal const val MAX_IMAGE_BANNER_HEIGHT_BIG_LAYOUT_EXPANDED_STATE = 286

internal val SUPPORTED_COLLAPSED_STATES =
    setOf(
        COLLAPSED_BACKGROUND_COLOR,
        TEMPLATE_NAME_IMAGE_BANNER,
        TEMPLATE_NAME_TIMER,
        TEMPLATE_NAME_TIMER_WITH_PROGRESS
    )

internal val SUPPORTED_EXPANDED_STATES =
    setOf(
        EXPANDED_BACKGROUND_COLOR,
        EXPANDED_IMAGE_CAROUSEL,
        TEMPLATE_NAME_IMAGE_BANNER,
        EXPANDED_IMAGE_TEXT_BANNER,
        TEMPLATE_NAME_TIMER,
        TEMPLATE_NAME_TIMER_WITH_PROGRESS
    )

// timer constants
internal const val TIMER_FORMAT_HH_MM = "MM:SS"
internal const val TIMER_FORMAT_H_MM_SS = "H:MM:SS"

internal const val BIG_TEXT_MAX_LINES_WITH_ACTION_BUTTONS = 10
internal const val BIG_TEXT_MAX_LINES_WITHOUT_ACTION_BUTTONS = 12

internal const val TIMER_ALARM_ID = "timerAlarmId"

internal const val TIMER_MIN_DURATION = 15 * 60
internal const val TIMER_MAX_DURATION = 12 * 60 * 60

// if the duration left is less than 5 seconds when the notification is received, fallback to
// OnExpiry action
internal const val TIMER_MIN_DURATION_LEFT = 5 * 1000
internal const val INTENT_ACTION_TIMER_ON_EXPIRY = "action_timer_on_expiry"

// progressbar template
internal const val PROGRESS_BAR_TEMPLATE_MAX_PROGRESS_VALUE = 100
internal const val PROGRESS_BAR_TEMPLATE_CURRENT_PROGRESS_VALUE = "current_progress_value"
internal const val PROGRESS_BAR_TEMPLATE_PROGRESS_INCREMENT_VALUE = "progress_increment_value"
internal const val PROGRESS_BAR_TEMPLATE_PROGRESS_UPDATE_INTERVAL = "progress_update_interval"
internal const val PROGRESS_BAR_TEMPLATE_MAX_PROGRESS_UPDATES_COUNT = "max_progress_updates_count"
internal const val PROGRESS_BAR_TEMPLATE_CURRENT_PROGRESS_UPDATES_COUNT =
    "current_progress_updates_count"
internal const val PROGRESS_ALARM_ID = "progressAlarmId"
internal const val INTENT_ACTION_PROGRESS_UPDATE = "action_progress_update"

internal const val PROGRESS_BAR_TEMPLATE_MAX_TOTAL_DURATION = 30 * 60 // 30 minutes

internal const val DEFAULT_HEADER_STATE_FOR_BANNER_TEMPLATE = false

internal const val DECORATED_STYLE_MAX_LINES_WITH_ACTION_IMAGE = 2
internal const val DECORATED_STYLE_MAX_LINES_WITH_ACTION_WITHOUT_IMAGE = 9
internal const val DECORATED_STYLE_MAX_LINES_WITHOUT_ACTION_IMAGE = 11
internal const val DEFAULT_DISMISS_CTA_TEXT = "Dismiss"

// list of Manufacturer which has smaller custom area (<48dp) height in collapsed notification layout
internal val DECORATED_STYLE_SMALL_LAYOUT_MANUFACTURER = setOf(
    MANUFACTURER_VIVO
)