/*
 * Copyright (c) 2014-2022 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.moengage.richnotification.internal.builder

import android.content.Context
import com.moengage.core.internal.model.SdkInstance
import com.moengage.pushbase.internal.model.NotificationMetaData
import com.moengage.richnotification.internal.EXPANDED_BACKGROUND_COLOR
import com.moengage.richnotification.internal.EXPANDED_IMAGE_CAROUSEL
import com.moengage.richnotification.internal.EXPANDED_IMAGE_TEXT_BANNER
import com.moengage.richnotification.internal.MODULE_TAG
import com.moengage.richnotification.internal.TEMPLATE_NAME_IMAGE_BANNER
import com.moengage.richnotification.internal.TEMPLATE_NAME_TIMER
import com.moengage.richnotification.internal.TEMPLATE_NAME_TIMER_WITH_PROGRESS
import com.moengage.richnotification.internal.models.ProgressProperties
import com.moengage.richnotification.internal.models.Template
import com.moengage.richnotification.internal.models.TimerTemplate

/**
 * @author Umang Chamaria
 * Date: 09/03/20
 */
internal class ExpandedTemplateBuilder(
    private val context: Context,
    private val template: Template,
    private val metaData: NotificationMetaData,
    private val sdkInstance: SdkInstance,
    private val progressProperties: ProgressProperties
) {

    private val tag = "${MODULE_TAG}ExpandedTemplateBuilder"

    fun build(): Boolean {
        if (template.expandedTemplate == null) return false
        when (template.expandedTemplate.type) {
            EXPANDED_BACKGROUND_COLOR -> return StylizedBasicTemplateBuilder(
                context,
                template,
                metaData,
                sdkInstance
            ).buildExpandedStylizedBasic()
            EXPANDED_IMAGE_CAROUSEL -> return CarouselBuilder(
                context,
                template,
                metaData,
                sdkInstance
            ).buildSimpleCarousel()
            TEMPLATE_NAME_IMAGE_BANNER -> return ImageBannerBuilder(
                context,
                template,
                metaData,
                sdkInstance
            ).buildExpandedImageBanner()
            EXPANDED_IMAGE_TEXT_BANNER -> return ImageBannerBuilder(
                context,
                template,
                metaData,
                sdkInstance
            ).buildExpandedImageBannerText()
            TEMPLATE_NAME_TIMER -> return template is TimerTemplate && TimerTemplateBuilder(
                context,
                template,
                metaData,
                sdkInstance,
                progressProperties
            ).buildExpandedTimerTemplate()
            TEMPLATE_NAME_TIMER_WITH_PROGRESS -> return template is TimerTemplate && TimerTemplateBuilder(
                context,
                template,
                metaData,
                sdkInstance,
                progressProperties
            ).buildExpandedProgressTemplate()
            else -> sdkInstance.logger.log { "$tag build() : Given expanded state not supported. Mode: ${template.expandedTemplate.type}" }
        }
        return false
    }
}