package com.moengage.richnotification.internal.models

/**
 * @author Arshiya Khanum
 */
internal class ProgressProperties(
    /**
     * Timer duration end time in milliseconds
     */
    var timerEndTime: Long,

    val timerProperties: TimerProperties
) {
    /**
     * Progressbar update interval in milliseconds
     */
    var updateInterval: Long = -1

    /**
     * Progress value increment at each progress update event
     */
    var progressIncrementPercent: Int = -1
        private set

    /**
     * Current progress value
     */
    var currentProgress: Int = -1
        private set

    /**
     * Current progress value
     */
    var maxUpdatesCount: Int = -1
        private set

    /**
     * Current progress value
     */
    var currentUpdatesCount: Int = -1
        private set

    /**
     * Alarm id for Timer duration expiry. This is also required for cancelling the alarm when
     * the notification is dismissed by user.
     */
    var timerAlarmId: Int = -1

    /**
     * Alarm id for progress update at regular [updateInterval]. This is also required for
     * cancelling the alarm when the notification is dismissed by user.
     */
    var progressAlarmId: Int = -1

    /**
     * Sets the current progress update parameters required updating template UI.
     */
    fun setProgressUpdateParameters(
        progressUpdateInterVal: Long,
        progressUpdateValue: Int,
        currentProgressValue: Int,
        maxProgressUpdateCount: Int,
        currentProgressUpdateCount: Int
    ) {
        updateInterval = progressUpdateInterVal
        progressIncrementPercent = progressUpdateValue
        currentProgress = currentProgressValue
        maxUpdatesCount = maxProgressUpdateCount
        currentUpdatesCount = currentProgressUpdateCount
    }

    override fun toString(): String {
        return "ProgressProperties(" +
            "timerProperties=$timerProperties, " +
            "timerEndTime=$timerEndTime, " +
            "updateInterval=$updateInterval, " +
            "progressUpdateValue=$progressIncrementPercent, " +
            "currentProgress=$currentProgress, " +
            "maxUpdatesCount=$maxUpdatesCount, " +
            "currentUpdatesCount=$currentUpdatesCount, " +
            "timerAlarmId=$timerAlarmId, " +
            "progressAlarmId=$progressAlarmId" +
            ")"
    }
}