/*
 * Copyright (c) 2014-2022 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.moengage.richnotification.internal.models

import com.moengage.pushbase.model.action.Action
import com.moengage.richnotification.internal.DEFAULT_DISMISS_CTA_TEXT

/**
 * @author Umang Chamaria
 * Date: 10/03/20
 */
internal open class Template internal constructor(
    val templateName: String,
    val defaultText: DefaultText,
    val defaultAction: Array<Action>,
    val collapsedTemplate: CollapsedTemplate?,
    val expandedTemplate: ExpandedTemplate?,
    val assetColor: String,
    val shouldShowLargeIcon: Boolean,
    val headerStyle: HeaderStyle,
    val dismissCta: DismissCta = DismissCta(DEFAULT_DISMISS_CTA_TEXT)
) {

    internal constructor(template: Template) : this(
        templateName = template.templateName,
        defaultText = template.defaultText,
        defaultAction = template.defaultAction,
        collapsedTemplate = template.collapsedTemplate,
        expandedTemplate = template.expandedTemplate,
        assetColor = template.assetColor,
        shouldShowLargeIcon = template.shouldShowLargeIcon,
        headerStyle = template.headerStyle,
        dismissCta = template.dismissCta
    )

    override fun toString(): String {
        return "Template(templateName='$templateName', defaultText=$defaultText, defaultAction=${defaultAction.contentToString()}, collapsedTemplate=$collapsedTemplate, expandedTemplate=$expandedTemplate, assetColor='$assetColor', shouldShowLargeIcon=$shouldShowLargeIcon, headerStyle=$headerStyle, dismissCta=$dismissCta)"
    }
}