/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.richnotification.internal;

import android.os.Build;
import android.os.Bundle;
import com.moengage.core.internal.logger.Logger;
import com.moengage.pushbase.model.NotificationPayload;
import com.moengage.richnotification.internal.RichPushConstantsKt;
import com.moengage.richnotification.internal.models.Card;
import com.moengage.richnotification.internal.models.DefaultText;
import com.moengage.richnotification.internal.models.Widget;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0010J)\u0010\u000f\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J$\u0010\u0016\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J!\u0010\u0017\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u0018J!\u0010\u0019\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u001aJ\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/moengage/richnotification/internal/Evaluator;", "", "logger", "Lcom/moengage/core/internal/logger/Logger;", "(Lcom/moengage/core/internal/logger/Logger;)V", "tag", "", "getCollapsedType", "payload", "Landroid/os/Bundle;", "getExpandedType", "hasMinimumText", "", "defaultText", "Lcom/moengage/richnotification/internal/models/DefaultText;", "isTemplateSupported", "Lcom/moengage/pushbase/model/NotificationPayload;", "collapsedTemplateType", "expandedTemplateType", "buildSdkVersion", "", "isTemplateSupported$rich_notification_release", "isTemplateSupportedOnDevice", "isTimerTemplate", "isTimerTemplate$rich_notification_release", "isTimerWithProgressbarTemplate", "isTimerWithProgressbarTemplate$rich_notification_release", "isValidBannerTextTemplate", "card", "Lcom/moengage/richnotification/internal/models/Card;", "rich-notification_release"})
public final class Evaluator {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String tag;

    public Evaluator(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.tag = "RichPush_4.7.2_Evaluator";
    }

    public final boolean isTemplateSupported(@NotNull NotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String collapsedType = this.getCollapsedType(payload.getPayload());
        String expandedType = this.getExpandedType(payload.getPayload());
        return this.isTemplateSupported$rich_notification_release(collapsedType, expandedType, Build.VERSION.SDK_INT);
    }

    private final String getCollapsedType(Bundle payload) {
        try {
            String string = payload.getString("moeFeatures");
            if (string == null) {
                return null;
            }
            String payloadString = string;
            JSONObject payloadJson = new JSONObject(payloadString);
            JSONObject templateJson = payloadJson.getJSONObject("richPush");
            return !templateJson.has("collapsed") ? (String)null : templateJson.getJSONObject("collapsed").getString("type");
        }
        catch (Throwable t) {
            this.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ Evaluator this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Evaluator.access$getTag$p(this.this$0) + " getCollapsedType() : ";
                }
            });
            return null;
        }
    }

    private final String getExpandedType(Bundle payload) {
        try {
            String string = payload.getString("moeFeatures");
            if (string == null) {
                return null;
            }
            String payloadString = string;
            JSONObject payloadJson = new JSONObject(payloadString);
            JSONObject templateJson = payloadJson.getJSONObject("richPush");
            return !templateJson.has("expanded") ? (String)null : templateJson.getJSONObject("expanded").getString("type");
        }
        catch (Throwable t) {
            this.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ Evaluator this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Evaluator.access$getTag$p(this.this$0) + " getExpandedType() : ";
                }
            });
            return null;
        }
    }

    public final boolean hasMinimumText(@NotNull DefaultText defaultText) {
        Intrinsics.checkNotNullParameter((Object)defaultText, (String)"defaultText");
        return !StringsKt.isBlank((CharSequence)defaultText.getTitle()) && !StringsKt.isBlank((CharSequence)defaultText.getMessage());
    }

    public final boolean isValidBannerTextTemplate(@NotNull Card card) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        for (Widget widget : card.getWidgets()) {
            if (widget.getId() != 0 || !Intrinsics.areEqual((Object)"image", (Object)widget.getType())) continue;
            return true;
        }
        return false;
    }

    public final boolean isTimerTemplate$rich_notification_release(@Nullable String collapsedTemplateType, @Nullable String expandedTemplateType) {
        if (collapsedTemplateType == null || expandedTemplateType == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)collapsedTemplateType, (Object)"timer") || Intrinsics.areEqual((Object)expandedTemplateType, (Object)"timer") || Intrinsics.areEqual((Object)collapsedTemplateType, (Object)"timerWithProgressbar") || Intrinsics.areEqual((Object)expandedTemplateType, (Object)"timerWithProgressbar");
    }

    public final boolean isTimerWithProgressbarTemplate$rich_notification_release(@Nullable String collapsedTemplateType, @Nullable String expandedTemplateType) {
        if (collapsedTemplateType == null || expandedTemplateType == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)collapsedTemplateType, (Object)"timerWithProgressbar") || Intrinsics.areEqual((Object)expandedTemplateType, (Object)"timerWithProgressbar");
    }

    public final boolean isTemplateSupported$rich_notification_release(@Nullable String collapsedTemplateType, @Nullable String expandedTemplateType, int buildSdkVersion) {
        CharSequence charSequence = collapsedTemplateType;
        if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)expandedTemplateType) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return false;
        }
        charSequence = expandedTemplateType;
        return ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && CollectionsKt.contains((Iterable)RichPushConstantsKt.getSUPPORTED_COLLAPSED_STATES(), (Object)collapsedTemplateType) || ((charSequence = (CharSequence)collapsedTemplateType) == null || StringsKt.isBlank((CharSequence)charSequence)) && CollectionsKt.contains((Iterable)RichPushConstantsKt.getSUPPORTED_EXPANDED_STATES(), (Object)expandedTemplateType) || CollectionsKt.contains((Iterable)RichPushConstantsKt.getSUPPORTED_COLLAPSED_STATES(), (Object)collapsedTemplateType) || CollectionsKt.contains((Iterable)RichPushConstantsKt.getSUPPORTED_EXPANDED_STATES(), (Object)expandedTemplateType)) && this.isTemplateSupportedOnDevice(collapsedTemplateType, expandedTemplateType, buildSdkVersion);
    }

    private final boolean isTemplateSupportedOnDevice(String collapsedTemplateType, String expandedTemplateType, int buildSdkVersion) {
        return Intrinsics.areEqual((Object)collapsedTemplateType, (Object)"timer") || Intrinsics.areEqual((Object)expandedTemplateType, (Object)"timer") || Intrinsics.areEqual((Object)collapsedTemplateType, (Object)"timerWithProgressbar") || Intrinsics.areEqual((Object)expandedTemplateType, (Object)"timerWithProgressbar") ? buildSdkVersion >= 24 : true;
    }

    public static final /* synthetic */ String access$getTag$p(Evaluator $this) {
        return $this.tag;
    }
}

