/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.richnotification.internal;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.utils.CoreUtils;
import com.moengage.core.internal.utils.TimeUtilsKt;
import com.moengage.pushbase.internal.MapperKt;
import com.moengage.pushbase.internal.PushHelper;
import com.moengage.pushbase.internal.model.NotificationMetaData;
import com.moengage.pushbase.internal.model.TemplateTrackingMeta;
import com.moengage.richnotification.internal.Evaluator;
import com.moengage.richnotification.internal.MoERichPushReceiver;
import com.moengage.richnotification.internal.RichPushTimerUtilsKt;
import com.moengage.richnotification.internal.models.CollapsedTemplate;
import com.moengage.richnotification.internal.models.ExpandedTemplate;
import com.moengage.richnotification.internal.models.ProgressProperties;
import com.moengage.richnotification.internal.models.Template;
import com.moengage.richnotification.internal.models.TimerProperties;
import com.moengage.richnotification.internal.models.TimerTemplate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0000\u001a \u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0001\u001a \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0001\u001a0\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0001\u001a\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0000\u001a\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a(\u0010!\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0001\u001a\u0010\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a(\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0001\u001a\u0018\u0010%\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0000\u001a0\u0010&\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u001dH\u0001\u001a0\u0010(\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a0\u0010)\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u001dH\u0003\u001a0\u0010*\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"tag", "", "addProgressPropertiesIfRequired", "Lcom/moengage/richnotification/internal/models/ProgressProperties;", "progressProperties", "template", "Lcom/moengage/richnotification/internal/models/Template;", "metaData", "Lcom/moengage/pushbase/internal/model/NotificationMetaData;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "cancelAlarmIfAny", "", "context", "Landroid/content/Context;", "bundle", "Landroid/os/Bundle;", "cancelProgressAlarmIfAny", "cancelTimerAlarmIfAny", "dismissNotificationOnTimerExpiry", "payload", "templateName", "notificationId", "", "getProgressUpdateAlarmId", "getProgressUpdateIntent", "Landroid/app/PendingIntent;", "Lcom/moengage/richnotification/internal/models/TimerTemplate;", "getTimerEndTime", "", "duration", "endTime", "getTimerExpiryAlarmId", "getTimerExpiryIntent", "hasScheduleExactPermission", "", "scheduleProgressTemplateUpdateAlarm", "setProgressUpdateProperties", "setTimerExpiryAlarm", "expiryTriggerInMillis", "setUpTimerAndProgressComponents", "setUpTimerComponentsIfRequired", "setupProgressbarComponentsIfRequired", "updateNotificationBuilderForTimerTemplate", "notificationBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "rich-notification_release"})
public final class RichPushTimerUtilsKt {
    @NotNull
    private static final String tag = "RichPush_4.7.2_RichPushTimerUtils";

    @NotNull
    public static final ProgressProperties getTimerEndTime(@NotNull Template template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        return template instanceof TimerTemplate ? new ProgressProperties(RichPushTimerUtilsKt.getTimerEndTime(((TimerTemplate)template).getTimerProperties().getDuration(), ((TimerTemplate)template).getTimerProperties().getExpiry()), ((TimerTemplate)template).getTimerProperties()) : new ProgressProperties(-1L, new TimerProperties(-1L, -1L));
    }

    public static final long getTimerEndTime(long duration, long endTime) {
        if (duration < 900L || duration > 43200L) {
            return -1L;
        }
        long durationInMillis = duration * (long)1000;
        long endTimeInMillis = endTime * (long)1000;
        long availableDuration = endTimeInMillis - TimeUtilsKt.currentMillis();
        return availableDuration <= 5000L ? -1L : (availableDuration < durationInMillis ? availableDuration : durationInMillis);
    }

    @RequiresApi(value=24)
    @NotNull
    public static final PendingIntent getTimerExpiryIntent(@NotNull Context context, @NotNull NotificationMetaData metaData, @NotNull TimerTemplate template, @NotNull ProgressProperties progressProperties) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)progressProperties, (String)"progressProperties");
        Intent expiryIntent = new Intent(context, MoERichPushReceiver.class);
        Bundle $this$getTimerExpiryIntent_u24lambda_u2d0 = bundle = metaData.getPayload().getPayload();
        boolean bl = false;
        $this$getTimerExpiryIntent_u24lambda_u2d0.putInt("MOE_NOTIFICATION_ID", metaData.getNotificationId());
        $this$getTimerExpiryIntent_u24lambda_u2d0.putString("displayName", template.getTemplateName());
        Bundle $this$getTimerExpiryIntent_u24lambda_u2d1 = bundle = expiryIntent;
        boolean bl2 = false;
        $this$getTimerExpiryIntent_u24lambda_u2d1.setFlags(0x10000000);
        $this$getTimerExpiryIntent_u24lambda_u2d1.putExtra("MOE_NOTIFICATION_ID", metaData.getNotificationId());
        $this$getTimerExpiryIntent_u24lambda_u2d1.putExtra("timerAlarmId", progressProperties.getTimerAlarmId());
        $this$getTimerExpiryIntent_u24lambda_u2d1.putExtra("displayName", template.getTemplateName());
        $this$getTimerExpiryIntent_u24lambda_u2d1.putExtra("gcm_campaign_id", metaData.getPayload().getCampaignId());
        $this$getTimerExpiryIntent_u24lambda_u2d1.putExtra("moe_app_id", metaData.getPayload().getPayload().getString("moe_app_id"));
        $this$getTimerExpiryIntent_u24lambda_u2d1.setAction("action_timer_on_expiry");
        return CoreUtils.getPendingIntentBroadcast$default((Context)context, (int)progressProperties.getTimerAlarmId(), (Intent)expiryIntent, (int)0, (int)8, null);
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresApi(value=24)
    public static final void setTimerExpiryAlarm(@NotNull Context context, @NotNull Template template, @NotNull NotificationMetaData metaData, @NotNull ProgressProperties progressProperties, long expiryTriggerInMillis) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)progressProperties, (String)"progressProperties");
        TimerTemplate cfr_ignored_0 = (TimerTemplate)template;
        if (!RichPushTimerUtilsKt.hasScheduleExactPermission(context)) {
            return;
        }
        PendingIntent intent = RichPushTimerUtilsKt.getTimerExpiryIntent(context, metaData, (TimerTemplate)template, progressProperties);
        Object object = context.getSystemService("alarm");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.AlarmManager");
        AlarmManager alarmManager = (AlarmManager)object;
        alarmManager.setExactAndAllowWhileIdle(0, expiryTriggerInMillis, intent);
        Logger.Companion.print$default((Logger.Companion)Logger.Companion, (int)0, null, (Function0)((Function0)new Function0<String>(progressProperties){
            final /* synthetic */ ProgressProperties $progressProperties;
            {
                this.$progressProperties = $progressProperties;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "setTimerExpiryAlarm() : progressProperties: " + this.$progressProperties;
            }
        }), (int)3, null);
    }

    public static final void updateNotificationBuilderForTimerTemplate(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull ProgressProperties progressProperties) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)progressProperties, (String)"progressProperties");
        notificationBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.DecoratedCustomViewStyle()).setLargeIcon(null).setSubText(null).setTimeoutAfter(progressProperties.getTimerEndTime());
    }

    public static final void cancelAlarmIfAny(@NotNull Context context, @NotNull Bundle bundle, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)cancelAlarmIfAny.1.INSTANCE, (int)3, null);
        if (Build.VERSION.SDK_INT >= 24) {
            RichPushTimerUtilsKt.cancelTimerAlarmIfAny(context, bundle, sdkInstance);
            RichPushTimerUtilsKt.cancelProgressAlarmIfAny(context, bundle, sdkInstance);
        }
    }

    @RequiresApi(value=24)
    public static final void cancelTimerAlarmIfAny(@NotNull Context context, @NotNull Bundle bundle, @NotNull SdkInstance sdkInstance) {
        Intent expiryIntent;
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Object notificationId = bundle.get("MOE_NOTIFICATION_ID");
        int timerAlarmId = bundle.getInt("timerAlarmId");
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(notificationId, timerAlarmId){
            final /* synthetic */ Object $notificationId;
            final /* synthetic */ int $timerAlarmId;
            {
                this.$notificationId = $notificationId;
                this.$timerAlarmId = $timerAlarmId;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "RichPush_4.7.2_RichPushTimerUtils cancelTimerAlarmIfAny(): notificationId:" + this.$notificationId + ", timerAlarmId: " + this.$timerAlarmId;
            }
        }), (int)3, null);
        Intent $this$cancelTimerAlarmIfAny_u24lambda_u2d2 = intent = (expiryIntent = new Intent(context, MoERichPushReceiver.class));
        boolean bl = false;
        $this$cancelTimerAlarmIfAny_u24lambda_u2d2.setFlags(0x10000000);
        $this$cancelTimerAlarmIfAny_u24lambda_u2d2.putExtra("MOE_NOTIFICATION_ID", bundle.getInt("MOE_NOTIFICATION_ID"));
        $this$cancelTimerAlarmIfAny_u24lambda_u2d2.putExtra("timerAlarmId", bundle.getInt("timerAlarmId"));
        $this$cancelTimerAlarmIfAny_u24lambda_u2d2.putExtra("displayName", bundle.getString("displayName"));
        $this$cancelTimerAlarmIfAny_u24lambda_u2d2.putExtra("gcm_campaign_id", bundle.getString("gcm_campaign_id"));
        $this$cancelTimerAlarmIfAny_u24lambda_u2d2.putExtra("moe_app_id", bundle.getString("moe_app_id"));
        $this$cancelTimerAlarmIfAny_u24lambda_u2d2.setAction("action_timer_on_expiry");
        Object object = context.getSystemService("alarm");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.AlarmManager");
        AlarmManager alarmManager = (AlarmManager)object;
        alarmManager.cancel(CoreUtils.getPendingIntentBroadcast$default((Context)context, (int)timerAlarmId, (Intent)expiryIntent, (int)0, (int)8, null));
    }

    @RequiresApi(value=24)
    public static final void cancelProgressAlarmIfAny(@NotNull Context context, @NotNull Bundle bundle, @NotNull SdkInstance sdkInstance) {
        Intent expiryIntent;
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        int notificationId = bundle.getInt("MOE_NOTIFICATION_ID");
        int progressAlarmId = bundle.getInt("progressAlarmId");
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(notificationId, progressAlarmId){
            final /* synthetic */ int $notificationId;
            final /* synthetic */ int $progressAlarmId;
            {
                this.$notificationId = $notificationId;
                this.$progressAlarmId = $progressAlarmId;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "RichPush_4.7.2_RichPushTimerUtils cancelProgressAlarmIfAny(): notificationId:" + this.$notificationId + ", progressAlarmId: " + this.$progressAlarmId;
            }
        }), (int)3, null);
        Intent $this$cancelProgressAlarmIfAny_u24lambda_u2d3 = intent = (expiryIntent = new Intent(context, MoERichPushReceiver.class));
        boolean bl = false;
        $this$cancelProgressAlarmIfAny_u24lambda_u2d3.setFlags(0x10000000);
        $this$cancelProgressAlarmIfAny_u24lambda_u2d3.putExtra("MOE_NOTIFICATION_ID", bundle.getInt("MOE_NOTIFICATION_ID"));
        $this$cancelProgressAlarmIfAny_u24lambda_u2d3.putExtra("gcm_campaign_id", bundle.getString("gcm_campaign_id"));
        $this$cancelProgressAlarmIfAny_u24lambda_u2d3.putExtra("displayName", bundle.getString("displayName"));
        $this$cancelProgressAlarmIfAny_u24lambda_u2d3.putExtra("progressAlarmId", progressAlarmId);
        $this$cancelProgressAlarmIfAny_u24lambda_u2d3.putExtra("moe_app_id", bundle.getString("moe_app_id"));
        $this$cancelProgressAlarmIfAny_u24lambda_u2d3.setAction("action_progress_update");
        Object object = context.getSystemService("alarm");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.AlarmManager");
        AlarmManager alarmManager = (AlarmManager)object;
        alarmManager.cancel(CoreUtils.getPendingIntentBroadcast$default((Context)context, (int)progressAlarmId, (Intent)expiryIntent, (int)0, (int)8, null));
    }

    public static final void dismissNotificationOnTimerExpiry(@NotNull Context context, @NotNull Bundle payload, @NotNull String templateName, int notificationId, @NotNull SdkInstance sdkInstance) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        if (Build.VERSION.SDK_INT == 24) {
            Object object = context.getSystemService("notification");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
            NotificationManager manager = (NotificationManager)object;
            manager.cancel(notificationId);
        }
        Bundle $this$dismissNotificationOnTimerExpiry_u24lambda_u2d4 = bundle = payload;
        boolean bl = false;
        $this$dismissNotificationOnTimerExpiry_u24lambda_u2d4.putString("moe_template_meta", MapperKt.templateTrackingMetaToJsonString((TemplateTrackingMeta)new TemplateTrackingMeta(templateName, -1, -1)));
        $this$dismissNotificationOnTimerExpiry_u24lambda_u2d4.putInt("MOE_NOTIFICATION_ID", notificationId);
        PushHelper.Companion.getInstance().handleNotificationCancelled(context, payload, sdkInstance);
    }

    @NotNull
    public static final ProgressProperties setProgressUpdateProperties(@NotNull ProgressProperties progressProperties, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)progressProperties, (String)"progressProperties");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        long actualDuration = progressProperties.getTimerProperties().getDuration();
        long elapsedDuration = actualDuration - progressProperties.getTimerEndTime() / (long)1000;
        int progressUpdateCount = 0;
        int progressUpdateValue = 0;
        if (actualDuration >= 900L && actualDuration <= 1800L) {
            progressUpdateCount = 10;
            progressUpdateValue = 10;
        } else if (actualDuration > 1800L && actualDuration <= 43200L) {
            progressUpdateCount = 25;
            progressUpdateValue = 4;
        } else {
            Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)setProgressUpdateProperties.1.INSTANCE, (int)3, null);
            progressUpdateCount = -1;
            progressUpdateValue = -1;
        }
        if (progressUpdateCount != -1 && progressUpdateValue != -1) {
            long progressUpdateInterval = actualDuration / (long)progressUpdateCount;
            int currentProgress = (int)(elapsedDuration / progressUpdateInterval * (long)progressUpdateValue);
            progressProperties.setProgressUpdateParameters(progressUpdateInterval * (long)1000, progressUpdateValue, currentProgress, progressUpdateCount, currentProgress / progressUpdateCount);
        }
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(progressProperties){
            final /* synthetic */ ProgressProperties $progressProperties;
            {
                this.$progressProperties = $progressProperties;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "setProgressUpdateProperties() : " + this.$progressProperties;
            }
        }), (int)3, null);
        return progressProperties;
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresApi(value=24)
    public static final void scheduleProgressTemplateUpdateAlarm(@NotNull Context context, @NotNull Template template, @NotNull NotificationMetaData metaData, @NotNull ProgressProperties progressProperties) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)progressProperties, (String)"progressProperties");
        TimerTemplate cfr_ignored_0 = (TimerTemplate)template;
        if (!RichPushTimerUtilsKt.hasScheduleExactPermission(context)) {
            return;
        }
        PendingIntent intent = RichPushTimerUtilsKt.getProgressUpdateIntent(context, metaData, (TimerTemplate)template, progressProperties);
        Object object = context.getSystemService("alarm");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.AlarmManager");
        AlarmManager alarmManager = (AlarmManager)object;
        alarmManager.setExactAndAllowWhileIdle(0, TimeUtilsKt.currentMillis() + progressProperties.getUpdateInterval(), intent);
    }

    @RequiresApi(value=24)
    @NotNull
    public static final PendingIntent getProgressUpdateIntent(@NotNull Context context, @NotNull NotificationMetaData metaData, @NotNull TimerTemplate template, @NotNull ProgressProperties progressProperties) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)progressProperties, (String)"progressProperties");
        Intent intent = new Intent(context, MoERichPushReceiver.class);
        Bundle $this$getProgressUpdateIntent_u24lambda_u2d5 = bundle = metaData.getPayload().getPayload();
        boolean bl = false;
        $this$getProgressUpdateIntent_u24lambda_u2d5.putInt("MOE_NOTIFICATION_ID", metaData.getNotificationId());
        $this$getProgressUpdateIntent_u24lambda_u2d5.putString("displayName", template.getTemplateName());
        $this$getProgressUpdateIntent_u24lambda_u2d5.putInt("current_progress_value", progressProperties.getCurrentProgress() + progressProperties.getProgressIncrementPercent());
        $this$getProgressUpdateIntent_u24lambda_u2d5.putInt("progress_increment_value", progressProperties.getProgressIncrementPercent());
        $this$getProgressUpdateIntent_u24lambda_u2d5.putLong("progress_update_interval", progressProperties.getUpdateInterval());
        $this$getProgressUpdateIntent_u24lambda_u2d5.putInt("max_progress_updates_count", progressProperties.getMaxUpdatesCount());
        $this$getProgressUpdateIntent_u24lambda_u2d5.putInt("current_progress_updates_count", progressProperties.getCurrentUpdatesCount() + 1);
        Bundle $this$getProgressUpdateIntent_u24lambda_u2d6 = bundle = intent;
        boolean bl2 = false;
        $this$getProgressUpdateIntent_u24lambda_u2d6.setFlags(0x10000000);
        $this$getProgressUpdateIntent_u24lambda_u2d6.putExtra("MOE_NOTIFICATION_ID", metaData.getNotificationId());
        $this$getProgressUpdateIntent_u24lambda_u2d6.putExtra("gcm_campaign_id", metaData.getPayload().getCampaignId());
        $this$getProgressUpdateIntent_u24lambda_u2d6.putExtra("displayName", template.getTemplateName());
        $this$getProgressUpdateIntent_u24lambda_u2d6.putExtra("progressAlarmId", progressProperties.getProgressAlarmId());
        $this$getProgressUpdateIntent_u24lambda_u2d6.putExtra("moe_app_id", metaData.getPayload().getPayload().getString("moe_app_id"));
        $this$getProgressUpdateIntent_u24lambda_u2d6.setAction("action_progress_update");
        return CoreUtils.getPendingIntentBroadcast$default((Context)context, (int)progressProperties.getProgressAlarmId(), (Intent)intent, (int)0, (int)8, null);
    }

    public static final void setUpTimerAndProgressComponents(@NotNull Context context, @NotNull Template template, @NotNull NotificationMetaData metaData, @NotNull SdkInstance sdkInstance, @NotNull ProgressProperties progressProperties) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)progressProperties, (String)"progressProperties");
        if (Build.VERSION.SDK_INT < 24) {
            return;
        }
        RichPushTimerUtilsKt.updateNotificationBuilderForTimerTemplate(metaData.getNotificationBuilder(), progressProperties);
        if (progressProperties.getTimerEndTime() == -1L) {
            Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)setUpTimerAndProgressComponents.1.INSTANCE, (int)3, null);
            return;
        }
        long expiryTriggerInMillis = TimeUtilsKt.currentMillis() + progressProperties.getTimerEndTime();
        RichPushTimerUtilsKt.setUpTimerComponentsIfRequired(context, template, metaData, progressProperties, expiryTriggerInMillis);
        RichPushTimerUtilsKt.setupProgressbarComponentsIfRequired(context, template, metaData, progressProperties, sdkInstance);
        PushHelper.Companion.getInstance().storeRepostCampaignPayload(context, sdkInstance, metaData.getPayload(), expiryTriggerInMillis);
    }

    @RequiresApi(value=24)
    private static final void setUpTimerComponentsIfRequired(Context context, Template template, NotificationMetaData metaData, ProgressProperties progressProperties, long expiryTriggerInMillis) {
        Logger.Companion.print$default((Logger.Companion)Logger.Companion, (int)0, null, (Function0)((Function0)new Function0<String>(metaData, progressProperties){
            final /* synthetic */ NotificationMetaData $metaData;
            final /* synthetic */ ProgressProperties $progressProperties;
            {
                this.$metaData = $metaData;
                this.$progressProperties = $progressProperties;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "RichPush_4.7.2_RichPushTimerUtils: setUpTimerComponentsIfRequired(): notificationId: " + this.$metaData.getNotificationId() + ", alarmId: " + this.$progressProperties.getTimerAlarmId() + ", triggerInMillis: " + this.$progressProperties.getTimerEndTime();
            }
        }), (int)3, null);
        if (metaData.getPayload().getPayload().getBoolean("moe_re_notify")) {
            return;
        }
        RichPushTimerUtilsKt.setTimerExpiryAlarm(context, template, metaData, progressProperties, expiryTriggerInMillis);
    }

    private static final void setupProgressbarComponentsIfRequired(Context context, Template template, NotificationMetaData metaData, ProgressProperties progressProperties, SdkInstance sdkInstance) {
        block5: {
            block4: {
                if (Build.VERSION.SDK_INT < 24) break block4;
                CollapsedTemplate collapsedTemplate = template.getCollapsedTemplate();
                ExpandedTemplate expandedTemplate = template.getExpandedTemplate();
                if (new Evaluator(sdkInstance.logger).isTimerWithProgressbarTemplate$rich_notification_release(collapsedTemplate != null ? collapsedTemplate.getType() : null, expandedTemplate != null ? expandedTemplate.getType() : null)) break block5;
            }
            return;
        }
        if (progressProperties.getCurrentUpdatesCount() == progressProperties.getMaxUpdatesCount() - 1) {
            progressProperties.setUpdateInterval(progressProperties.getTimerEndTime());
        }
        Logger.Companion.print$default((Logger.Companion)Logger.Companion, (int)0, null, (Function0)((Function0)new Function0<String>(metaData, progressProperties){
            final /* synthetic */ NotificationMetaData $metaData;
            final /* synthetic */ ProgressProperties $progressProperties;
            {
                this.$metaData = $metaData;
                this.$progressProperties = $progressProperties;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "RichPush_4.7.2_RichPushTimerUtils setupProgressbarComponentsIfRequired(): notificationId: " + this.$metaData.getNotificationId() + ", progressProperties: " + this.$progressProperties;
            }
        }), (int)3, null);
        RichPushTimerUtilsKt.scheduleProgressTemplateUpdateAlarm(context, template, metaData, progressProperties);
    }

    @NotNull
    public static final ProgressProperties addProgressPropertiesIfRequired(@NotNull ProgressProperties progressProperties, @NotNull Template template, @NotNull NotificationMetaData metaData, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)progressProperties, (String)"progressProperties");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        if (template instanceof TimerTemplate) {
            CollapsedTemplate collapsedTemplate = template.getCollapsedTemplate();
            ExpandedTemplate expandedTemplate = template.getExpandedTemplate();
            if (new Evaluator(sdkInstance.logger).isTimerWithProgressbarTemplate$rich_notification_release(collapsedTemplate != null ? collapsedTemplate.getType() : null, expandedTemplate != null ? expandedTemplate.getType() : null) && progressProperties.getTimerEndTime() > -1L) {
                if (metaData.getPayload().getPayload().getBoolean("moe_re_notify") && !metaData.getPayload().getPayload().getString("moe_n_r_s", "").equals("moe_source_r_l_s")) {
                    progressProperties.setProgressUpdateParameters(metaData.getPayload().getPayload().getInt("progress_update_interval"), metaData.getPayload().getPayload().getInt("progress_increment_value"), metaData.getPayload().getPayload().getInt("current_progress_value"), metaData.getPayload().getPayload().getInt("max_progress_updates_count"), metaData.getPayload().getPayload().getInt("current_progress_updates_count"));
                } else {
                    RichPushTimerUtilsKt.setProgressUpdateProperties(progressProperties, sdkInstance);
                    metaData.getPayload().getPayload().remove("moe_n_r_s");
                }
            }
        }
        return progressProperties;
    }

    public static final int getProgressUpdateAlarmId(@NotNull NotificationMetaData metaData) {
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        return metaData.getPayload().getPayload().getBoolean("moe_re_notify") ? metaData.getPayload().getPayload().getInt("progressAlarmId") : CoreUtils.getUniqueNumber();
    }

    public static final int getTimerExpiryAlarmId(@NotNull NotificationMetaData metaData) {
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        return metaData.getPayload().getPayload().getBoolean("moe_re_notify") ? metaData.getPayload().getPayload().getInt("timerAlarmId") : CoreUtils.getUniqueNumber();
    }

    public static final boolean hasScheduleExactPermission(@NotNull Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 31) {
            AlarmManager alarmManager;
            AlarmManager alarmManager2 = alarmManager = (AlarmManager)ContextCompat.getSystemService((Context)context, AlarmManager.class);
            bl = alarmManager2 != null ? alarmManager2.canScheduleExactAlarms() : false;
        } else {
            bl = true;
        }
        boolean state = bl;
        Logger.Companion.print$default((Logger.Companion)Logger.Companion, (int)0, null, (Function0)((Function0)new Function0<String>(state){
            final /* synthetic */ boolean $state;
            {
                this.$state = $state;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "RichPush_4.7.2_RichPushTimerUtils hasScheduleExactPermission() : " + this.$state;
            }
        }), (int)3, null);
        return state;
    }
}

