/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.richnotification.internal;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.text.Spanned;
import android.text.format.DateFormat;
import android.util.DisplayMetrics;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.core.text.HtmlCompat;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.remoteconfig.RemoteConfig;
import com.moengage.core.internal.utils.CoreUtils;
import com.moengage.core.internal.utils.MoEUtils;
import com.moengage.pushbase.internal.MapperKt;
import com.moengage.pushbase.internal.MoEPushWorker;
import com.moengage.pushbase.internal.PushHelper;
import com.moengage.pushbase.internal.model.NotificationMetaData;
import com.moengage.pushbase.internal.model.TemplateTrackingMeta;
import com.moengage.pushbase.model.NotificationPayload;
import com.moengage.richnotification.internal.Evaluator;
import com.moengage.richnotification.internal.RichPushConstantsKt;
import com.moengage.richnotification.internal.RichPushTimerUtilsKt;
import com.moengage.richnotification.internal.RichPushUtilsKt;
import com.moengage.richnotification.internal.models.Template;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\b\u0010\b\u001a\u00020\tH\u0001\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u001a \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\b\u0010\u001b\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u001a\u0018\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010%\u001a\u00020$H\u0000\u001a \u0010&\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0013H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"tag", "", "clearNotificationsAndCancelAlarms", "", "context", "Landroid/content/Context;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "doesSdkSupportDecoratedStyleOnDevice", "", "getAppName", "getDecoratedStyleTemplateLayout", "", "smallLayout", "defaultLayout", "getHtmlText", "Landroid/text/Spanned;", "string", "getNotificationClearIntent", "Landroid/content/Intent;", "metaData", "Lcom/moengage/pushbase/internal/model/NotificationMetaData;", "template", "Lcom/moengage/richnotification/internal/models/Template;", "getTemplateLayout", "layoutSmall", "layoutBig", "getTime", "handleLogout", "isBigLayoutSupported", "remoteConfig", "Lcom/moengage/core/internal/remoteconfig/RemoteConfig;", "isPushTemplateSupported", "payload", "Lcom/moengage/pushbase/model/NotificationPayload;", "scaleLandscapeBitmap", "Landroid/graphics/Bitmap;", "imageBitmap", "setNotificationClearIntent", "finalIntent", "rich-notification_release"})
public final class RichPushUtilsKt {
    @NotNull
    private static final String tag = "RichPush_4.7.2_RichPushUtils";

    @NotNull
    public static final String getAppName(@NotNull Context context) throws PackageManager.NameNotFoundException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PackageManager packageManager = context.getPackageManager();
        ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"packageManager.getApplic\u2026nager.GET_META_DATA\n    )");
        ApplicationInfo info = applicationInfo;
        CharSequence charSequence = packageManager.getApplicationLabel(info);
        Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)charSequence;
    }

    @NotNull
    public static final String getTime() {
        String dateFormat = "hh:mm aaa";
        CharSequence charSequence = DateFormat.format((CharSequence)dateFormat, (Date)Calendar.getInstance().getTime());
        Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)charSequence;
    }

    @NotNull
    public static final Bitmap scaleLandscapeBitmap(@NotNull Context context, @NotNull Bitmap imageBitmap) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imageBitmap, (String)"imageBitmap");
        Bitmap bitmap = imageBitmap;
        if (bitmap.getWidth() > bitmap.getHeight()) {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            int height = bitmap.getHeight() * displayMetrics.widthPixels / bitmap.getWidth();
            try {
                Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)displayMetrics.widthPixels, (int)height, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createScaledBitmap(bitma\u2026idthPixels, height, true)");
                bitmap = bitmap2;
            }
            catch (Throwable t) {
                Logger.Companion.print(1, t, (Function0)scaleLandscapeBitmap.1.INSTANCE);
            }
        }
        return bitmap;
    }

    @NotNull
    public static final Spanned getHtmlText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Spanned spanned = HtmlCompat.fromHtml((String)string, (int)63);
        Intrinsics.checkNotNullExpressionValue((Object)spanned, (String)"fromHtml(string, HtmlCom\u2026t.FROM_HTML_MODE_COMPACT)");
        return spanned;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBigLayoutSupported(@NotNull RemoteConfig remoteConfig) {
        Intrinsics.checkNotNullParameter((Object)remoteConfig, (String)"remoteConfig");
        if (Build.VERSION.SDK_INT < 24) return false;
        Set set = remoteConfig.getPushConfig().getWhiteListedOems();
        String string = MoEUtils.deviceManufacturer();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"deviceManufacturer()");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        if (!set.contains(string2)) return false;
        return true;
    }

    public static final int getTemplateLayout(int layoutSmall, int layoutBig, @NotNull SdkInstance sdkInstance) {
        int n;
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        if (RichPushUtilsKt.isBigLayoutSupported(sdkInstance.getRemoteConfig())) {
            Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)getTemplateLayout.1.INSTANCE, (int)3, null);
            n = layoutBig;
        } else {
            Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)getTemplateLayout.2.INSTANCE, (int)3, null);
            n = layoutSmall;
        }
        return n;
    }

    public static final boolean isPushTemplateSupported(@NotNull NotificationPayload payload, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Evaluator evaluator = new Evaluator(sdkInstance.logger);
        boolean isTemplateSupported = payload.getAddOnFeatures().isRichPush() && evaluator.isTemplateSupported(payload);
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(isTemplateSupported){
            final /* synthetic */ boolean $isTemplateSupported;
            {
                this.$isTemplateSupported = $isTemplateSupported;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "RichPush_4.7.2_RichPushUtils isTemplateSupported() : Template Supported? " + this.$isTemplateSupported;
            }
        }), (int)3, null);
        return isTemplateSupported;
    }

    public static final void setNotificationClearIntent(@NotNull Context context, @NotNull NotificationMetaData metaData, @NotNull Intent finalIntent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)finalIntent, (String)"finalIntent");
        PendingIntent intent = CoreUtils.getPendingIntentService$default((Context)context, (int)(metaData.getNotificationId() | 0x1F5), (Intent)finalIntent, (int)0, (int)8, null);
        metaData.getNotificationBuilder().setDeleteIntent(intent);
    }

    @NotNull
    public static final Intent getNotificationClearIntent(@NotNull Context context, @NotNull NotificationMetaData metaData, @NotNull Template template) {
        Intent finalIntent;
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intent $this$getNotificationClearIntent_u24lambda_u2d0 = intent = (finalIntent = new Intent(context, MoEPushWorker.class));
        boolean bl = false;
        $this$getNotificationClearIntent_u24lambda_u2d0.putExtras(metaData.getPayload().getPayload());
        $this$getNotificationClearIntent_u24lambda_u2d0.putExtra("moe_template_meta", MapperKt.templateTrackingMetaToJsonString((TemplateTrackingMeta)new TemplateTrackingMeta(template.getTemplateName(), -1, -1)));
        $this$getNotificationClearIntent_u24lambda_u2d0.putExtra("MOE_NOTIFICATION_ID", metaData.getNotificationId());
        $this$getNotificationClearIntent_u24lambda_u2d0.setAction("ACTION_NOTIFICATION_CLEARED");
        return finalIntent;
    }

    public static final void handleLogout(@NotNull Context context, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        try {
            RichPushUtilsKt.clearNotificationsAndCancelAlarms(context, sdkInstance);
        }
        catch (Throwable t) {
            sdkInstance.logger.log(1, t, (Function0)handleLogout.1.INSTANCE);
        }
    }

    @ChecksSdkIntAtLeast(api=31)
    public static final boolean doesSdkSupportDecoratedStyleOnDevice() {
        return Build.VERSION.SDK_INT >= 31;
    }

    public static final void clearNotificationsAndCancelAlarms(@NotNull Context context, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        List activeCampaigns = PushHelper.Companion.getInstance().getCampaignPayloadsForActiveCampaigns(context, sdkInstance);
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>((List<Bundle>)activeCampaigns){
            final /* synthetic */ List<Bundle> $activeCampaigns;
            {
                this.$activeCampaigns = $activeCampaigns;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "RichPush_4.7.2_RichPushUtils clearNotificationsAndCancelAlarms() : active template campaigns: " + this.$activeCampaigns.size();
            }
        }), (int)3, null);
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        for (Bundle payload : activeCampaigns) {
            notificationManager.cancel(payload.getInt("MOE_NOTIFICATION_ID"));
            RichPushTimerUtilsKt.cancelAlarmIfAny(context, payload, sdkInstance);
        }
    }

    public static final int getDecoratedStyleTemplateLayout(int smallLayout, int defaultLayout, @NotNull SdkInstance sdkInstance) {
        int n;
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Set<String> set = RichPushConstantsKt.getDECORATED_STYLE_SMALL_LAYOUT_MANUFACTURER();
        String string = MoEUtils.deviceManufacturer();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"deviceManufacturer()");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        if (set.contains(string2)) {
            Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)getDecoratedStyleTemplateLayout.1.INSTANCE, (int)3, null);
            n = smallLayout;
        } else {
            Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)getDecoratedStyleTemplateLayout.2.INSTANCE, (int)3, null);
            n = defaultLayout;
        }
        return n;
    }
}

