/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.richnotification.internal.builder;

import android.content.Context;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.pushbase.internal.model.NotificationMetaData;
import com.moengage.richnotification.internal.builder.CarouselBuilder;
import com.moengage.richnotification.internal.builder.ImageBannerBuilder;
import com.moengage.richnotification.internal.builder.StylizedBasicTemplateBuilder;
import com.moengage.richnotification.internal.builder.TimerTemplateBuilder;
import com.moengage.richnotification.internal.models.ProgressProperties;
import com.moengage.richnotification.internal.models.Template;
import com.moengage.richnotification.internal.models.TimerTemplate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/moengage/richnotification/internal/builder/ExpandedTemplateBuilder;", "", "context", "Landroid/content/Context;", "template", "Lcom/moengage/richnotification/internal/models/Template;", "metaData", "Lcom/moengage/pushbase/internal/model/NotificationMetaData;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "progressProperties", "Lcom/moengage/richnotification/internal/models/ProgressProperties;", "(Landroid/content/Context;Lcom/moengage/richnotification/internal/models/Template;Lcom/moengage/pushbase/internal/model/NotificationMetaData;Lcom/moengage/core/internal/model/SdkInstance;Lcom/moengage/richnotification/internal/models/ProgressProperties;)V", "tag", "", "build", "", "rich-notification_release"})
public final class ExpandedTemplateBuilder {
    @NotNull
    private final Context context;
    @NotNull
    private final Template template;
    @NotNull
    private final NotificationMetaData metaData;
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final ProgressProperties progressProperties;
    @NotNull
    private final String tag;

    public ExpandedTemplateBuilder(@NotNull Context context, @NotNull Template template, @NotNull NotificationMetaData metaData, @NotNull SdkInstance sdkInstance, @NotNull ProgressProperties progressProperties) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)progressProperties, (String)"progressProperties");
        this.context = context;
        this.template = template;
        this.metaData = metaData;
        this.sdkInstance = sdkInstance;
        this.progressProperties = progressProperties;
        this.tag = "RichPush_4.7.2_ExpandedTemplateBuilder";
    }

    public final boolean build() {
        if (this.template.getExpandedTemplate() == null) {
            return false;
        }
        switch (this.template.getExpandedTemplate().getType()) {
            case "stylizedBasic": {
                return new StylizedBasicTemplateBuilder(this.context, this.template, this.metaData, this.sdkInstance).buildExpandedStylizedBasic();
            }
            case "imageCarousel": {
                return new CarouselBuilder(this.context, this.template, this.metaData, this.sdkInstance).buildSimpleCarousel();
            }
            case "imageBanner": {
                return new ImageBannerBuilder(this.context, this.template, this.metaData, this.sdkInstance).buildExpandedImageBanner();
            }
            case "imageBannerText": {
                return new ImageBannerBuilder(this.context, this.template, this.metaData, this.sdkInstance).buildExpandedImageBannerText();
            }
            case "timer": {
                return this.template instanceof TimerTemplate && new TimerTemplateBuilder(this.context, (TimerTemplate)this.template, this.metaData, this.sdkInstance, this.progressProperties).buildExpandedTimerTemplate();
            }
            case "timerWithProgressbar": {
                return this.template instanceof TimerTemplate && new TimerTemplateBuilder(this.context, (TimerTemplate)this.template, this.metaData, this.sdkInstance, this.progressProperties).buildExpandedProgressTemplate();
            }
        }
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ ExpandedTemplateBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ExpandedTemplateBuilder.access$getTag$p(this.this$0) + " build() : Given expanded state not supported. Mode: " + ExpandedTemplateBuilder.access$getTemplate$p(this.this$0).getExpandedTemplate().getType();
            }
        }), (int)3, null);
        return false;
    }

    public static final /* synthetic */ String access$getTag$p(ExpandedTemplateBuilder $this) {
        return $this.tag;
    }

    public static final /* synthetic */ Template access$getTemplate$p(ExpandedTemplateBuilder $this) {
        return $this.template;
    }
}

