/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.richnotification.internal.builder;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.utils.CoreUtils;
import com.moengage.pushbase.internal.model.NotificationMetaData;
import com.moengage.richnotification.R;
import com.moengage.richnotification.internal.Evaluator;
import com.moengage.richnotification.internal.RichPushUtilsKt;
import com.moengage.richnotification.internal.builder.TemplateHelper;
import com.moengage.richnotification.internal.models.Card;
import com.moengage.richnotification.internal.models.CollapsedBannerTemplate;
import com.moengage.richnotification.internal.models.CollapsedTemplate;
import com.moengage.richnotification.internal.models.ExpandedBannerTemplate;
import com.moengage.richnotification.internal.models.ExpandedTemplate;
import com.moengage.richnotification.internal.models.HeaderStyle;
import com.moengage.richnotification.internal.models.ImageWidget;
import com.moengage.richnotification.internal.models.Template;
import com.moengage.richnotification.internal.models.Widget;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J@\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u0012J\u0006\u0010\u001f\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020\u0012J\b\u0010!\u001a\u00020\u0010H\u0002J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0012H\u0002J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0012H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/moengage/richnotification/internal/builder/ImageBannerBuilder;", "", "context", "Landroid/content/Context;", "template", "Lcom/moengage/richnotification/internal/models/Template;", "metaData", "Lcom/moengage/pushbase/internal/model/NotificationMetaData;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Landroid/content/Context;Lcom/moengage/richnotification/internal/models/Template;Lcom/moengage/pushbase/internal/model/NotificationMetaData;Lcom/moengage/core/internal/model/SdkInstance;)V", "tag", "", "addHeader", "", "remoteViews", "Landroid/widget/RemoteViews;", "isHeaderEnabled", "", "headerStyle", "Lcom/moengage/richnotification/internal/models/HeaderStyle;", "addHeaderWithPersistentAssets", "templateHelper", "Lcom/moengage/richnotification/internal/builder/TemplateHelper;", "addImageToTextOverlayBannerTemplate", "remoteView", "widget", "Lcom/moengage/richnotification/internal/models/ImageWidget;", "card", "Lcom/moengage/richnotification/internal/models/Card;", "buildCollapsedImageBanner", "buildExpandedImageBanner", "buildExpandedImageBannerText", "getCollapsedImageBannerLayout", "getExpandedImageBannerLayout", "isPersistent", "getExpandedImageBannerTextLayout", "getMaxAllowedImageHeightForImageBanner", "", "isCollapsedState", "rich-notification_release"})
public final class ImageBannerBuilder {
    @NotNull
    private final Context context;
    @NotNull
    private final Template template;
    @NotNull
    private final NotificationMetaData metaData;
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final String tag;

    public ImageBannerBuilder(@NotNull Context context, @NotNull Template template, @NotNull NotificationMetaData metaData, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.context = context;
        this.template = template;
        this.metaData = metaData;
        this.sdkInstance = sdkInstance;
        this.tag = "RichPush_4.7.2_ImageBannerBuilder";
    }

    public final boolean buildCollapsedImageBanner() {
        try {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ ImageBannerBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ImageBannerBuilder.access$getTag$p(this.this$0) + " buildCollapsedImageBanner() : Will try to build image banner template";
                }
            }), (int)3, null);
            if (this.template.getCollapsedTemplate() == null || !(this.template.getCollapsedTemplate() instanceof CollapsedBannerTemplate)) {
                return false;
            }
            CollapsedTemplate collapsedTemplate = this.template.getCollapsedTemplate();
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, collapsedTemplate){
                final /* synthetic */ ImageBannerBuilder this$0;
                final /* synthetic */ CollapsedTemplate $collapsedTemplate;
                {
                    this.this$0 = $receiver;
                    this.$collapsedTemplate = $collapsedTemplate;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ImageBannerBuilder.access$getTag$p(this.this$0) + " buildCollapsedImageBanner() : Collapsed template: " + this.$collapsedTemplate;
                }
            }), (int)3, null);
            RemoteViews remoteViews = this.getCollapsedImageBannerLayout();
            if (((CollapsedBannerTemplate)collapsedTemplate).getCards().isEmpty()) {
                return false;
            }
            TemplateHelper templateHelper = new TemplateHelper(this.sdkInstance);
            templateHelper.addLayoutStyle(((CollapsedBannerTemplate)collapsedTemplate).getLayoutStyle(), remoteViews, R.id.collapsedRootView);
            if (RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice()) {
                this.metaData.getNotificationBuilder().setSubText((CharSequence)"");
            } else {
                this.addHeaderWithPersistentAssets(templateHelper, remoteViews, ((CollapsedBannerTemplate)collapsedTemplate).isHeaderEnabled());
            }
            Card card = ((CollapsedBannerTemplate)collapsedTemplate).getCards().get(0);
            if (card.getWidgets().isEmpty()) {
                return false;
            }
            Widget widget = card.getWidgets().get(0);
            if (!Intrinsics.areEqual((Object)"image", (Object)widget.getType())) {
                return false;
            }
            Intrinsics.checkNotNull((Object)widget, (String)"null cannot be cast to non-null type com.moengage.richnotification.internal.models.ImageWidget");
            if (!TemplateHelper.addImageWidgetToTemplate$rich_notification_release$default(templateHelper, this.context, this.metaData, this.template, remoteViews, (ImageWidget)widget, card, null, this.getMaxAllowedImageHeightForImageBanner(true), 64, null)) {
                return false;
            }
            templateHelper.addDefaultActionToNotificationClick$rich_notification_release(this.context, remoteViews, R.id.collapsedRootView, this.template, this.metaData);
            this.metaData.getNotificationBuilder().setCustomContentView(remoteViews);
            return true;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ ImageBannerBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ImageBannerBuilder.access$getTag$p(this.this$0) + " buildCollapsedImageBanner() : ";
                }
            });
            return false;
        }
    }

    private final RemoteViews getCollapsedImageBannerLayout() {
        return RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice() ? new RemoteViews(this.context.getPackageName(), RichPushUtilsKt.getDecoratedStyleTemplateLayout(R.layout.moe_rich_push_image_banner_collapsed_small_layout_decorated_style, R.layout.moe_rich_push_image_banner_collapsed_layout_decorated_style, this.sdkInstance)) : (Build.VERSION.SDK_INT >= 23 ? new RemoteViews(this.context.getPackageName(), RichPushUtilsKt.getTemplateLayout(R.layout.moe_rich_push_image_banner_collapsed, R.layout.moe_rich_push_image_banner_collapsed_layout_big, this.sdkInstance)) : new RemoteViews(this.context.getPackageName(), R.layout.moe_rich_push_image_banner_collapsed_below_m));
    }

    public final boolean buildExpandedImageBanner() {
        try {
            Card card;
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ ImageBannerBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ImageBannerBuilder.access$getTag$p(this.this$0) + " buildExpandedImageBanner() : Will try to build image banner.";
                }
            }), (int)3, null);
            if (this.template.getExpandedTemplate() == null || !(this.template.getExpandedTemplate() instanceof ExpandedBannerTemplate)) {
                return false;
            }
            ExpandedTemplate expandedTemplate = this.template.getExpandedTemplate();
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, expandedTemplate){
                final /* synthetic */ ImageBannerBuilder this$0;
                final /* synthetic */ ExpandedTemplate $expandedTemplate;
                {
                    this.this$0 = $receiver;
                    this.$expandedTemplate = $expandedTemplate;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ImageBannerBuilder.access$getTag$p(this.this$0) + " buildExpandedImageBanner() : Template: " + this.$expandedTemplate;
                }
            }), (int)3, null);
            if (((ExpandedBannerTemplate)expandedTemplate).getCards().isEmpty()) {
                return false;
            }
            RemoteViews remoteViews = this.getExpandedImageBannerLayout(this.metaData.getPayload().getAddOnFeatures().isPersistent());
            TemplateHelper templateHelper = new TemplateHelper(this.sdkInstance);
            templateHelper.addLayoutStyle(((ExpandedBannerTemplate)expandedTemplate).getLayoutStyle(), remoteViews, R.id.expandedRootView);
            if (RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice()) {
                this.metaData.getNotificationBuilder().setSubText((CharSequence)"");
                if (this.metaData.getPayload().getAddOnFeatures().isPersistent()) {
                    TemplateHelper.setDismissCtaCustomization$rich_notification_release$default(templateHelper, remoteViews, this.template.getDismissCta(), false, 4, null);
                    templateHelper.addActionToDismissCTA(remoteViews, this.context, this.metaData);
                }
            } else {
                this.addHeaderWithPersistentAssets(templateHelper, remoteViews, ((ExpandedBannerTemplate)expandedTemplate).isHeaderEnabled());
            }
            if ((card = ((ExpandedBannerTemplate)expandedTemplate).getCards().get(0)).getWidgets().isEmpty()) {
                return false;
            }
            Widget widget = card.getWidgets().get(0);
            if (!Intrinsics.areEqual((Object)"image", (Object)widget.getType())) {
                return false;
            }
            Intrinsics.checkNotNull((Object)widget, (String)"null cannot be cast to non-null type com.moengage.richnotification.internal.models.ImageWidget");
            if (!TemplateHelper.addImageWidgetToTemplate$rich_notification_release$default(templateHelper, this.context, this.metaData, this.template, remoteViews, (ImageWidget)widget, card, null, this.getMaxAllowedImageHeightForImageBanner(false), 64, null)) {
                return false;
            }
            templateHelper.addDefaultActionToNotificationClick$rich_notification_release(this.context, remoteViews, R.id.expandedRootView, this.template, this.metaData);
            this.metaData.getNotificationBuilder().setCustomBigContentView(remoteViews);
            return true;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ ImageBannerBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ImageBannerBuilder.access$getTag$p(this.this$0) + " buildExpandedImageBanner() : ";
                }
            });
            return false;
        }
    }

    private final RemoteViews getExpandedImageBannerLayout(boolean isPersistent) {
        return RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice() ? (isPersistent ? new RemoteViews(this.context.getPackageName(), R.layout.moe_rich_push_image_banner_expanded_layout_decorated_style_with_dismiss) : new RemoteViews(this.context.getPackageName(), R.layout.moe_rich_push_image_banner_expanded_layout_decorated_style)) : new RemoteViews(this.context.getPackageName(), RichPushUtilsKt.getTemplateLayout(R.layout.moe_rich_push_image_banner_expanded, R.layout.moe_rich_push_image_banner_expanded_layout_big, this.sdkInstance));
    }

    public final boolean buildExpandedImageBannerText() {
        try {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ ImageBannerBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ImageBannerBuilder.access$getTag$p(this.this$0) + " buildExpandedImageBannerText() : Will try to build image banner text.";
                }
            }), (int)3, null);
            if (this.template.getExpandedTemplate() == null || !(this.template.getExpandedTemplate() instanceof ExpandedBannerTemplate)) {
                return false;
            }
            ExpandedTemplate expandedTemplate = this.template.getExpandedTemplate();
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, expandedTemplate){
                final /* synthetic */ ImageBannerBuilder this$0;
                final /* synthetic */ ExpandedTemplate $expandedTemplate;
                {
                    this.this$0 = $receiver;
                    this.$expandedTemplate = $expandedTemplate;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ImageBannerBuilder.access$getTag$p(this.this$0) + " buildExpandedImageBannerText() : Template payload: " + this.$expandedTemplate;
                }
            }), (int)3, null);
            if (((ExpandedBannerTemplate)expandedTemplate).getCards().isEmpty()) {
                return false;
            }
            Card card = ((ExpandedBannerTemplate)expandedTemplate).getCards().get(0);
            if (!new Evaluator(this.sdkInstance.logger).isValidBannerTextTemplate(card)) {
                return false;
            }
            RemoteViews remoteViews = this.getExpandedImageBannerTextLayout(this.metaData.getPayload().getAddOnFeatures().isPersistent());
            TemplateHelper templateHelper = new TemplateHelper(this.sdkInstance);
            templateHelper.addLayoutStyle(((ExpandedBannerTemplate)expandedTemplate).getLayoutStyle(), remoteViews, R.id.expandedRootView);
            if (RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice()) {
                this.metaData.getNotificationBuilder().setSubText((CharSequence)"");
                if (this.metaData.getPayload().getAddOnFeatures().isPersistent()) {
                    TemplateHelper.setDismissCtaCustomization$rich_notification_release$default(templateHelper, remoteViews, this.template.getDismissCta(), false, 4, null);
                    templateHelper.addActionToDismissCTA(remoteViews, this.context, this.metaData);
                }
            } else {
                this.addHeaderWithPersistentAssets(templateHelper, remoteViews, ((ExpandedBannerTemplate)expandedTemplate).isHeaderEnabled());
            }
            for (Widget widget : card.getWidgets()) {
                if (widget.getId() == 0 && Intrinsics.areEqual((Object)"image", (Object)widget.getType())) {
                    Intrinsics.checkNotNull((Object)widget, (String)"null cannot be cast to non-null type com.moengage.richnotification.internal.models.ImageWidget");
                    if (this.addImageToTextOverlayBannerTemplate(this.context, this.metaData, this.template, templateHelper, remoteViews, (ImageWidget)widget, card)) continue;
                    return false;
                }
                if (widget.getId() == 1 && Intrinsics.areEqual((Object)"text", (Object)widget.getType())) {
                    if (StringsKt.isBlank((CharSequence)widget.getContent())) continue;
                    remoteViews.setTextViewText(R.id.headerText, (CharSequence)RichPushUtilsKt.getHtmlText(widget.getContent()));
                    remoteViews.setViewVisibility(R.id.headerText, 0);
                    continue;
                }
                if (widget.getId() == 2 && Intrinsics.areEqual((Object)"text", (Object)widget.getType())) {
                    if (StringsKt.isBlank((CharSequence)widget.getContent())) continue;
                    remoteViews.setTextViewText(R.id.messageText, (CharSequence)RichPushUtilsKt.getHtmlText(widget.getContent()));
                    remoteViews.setViewVisibility(R.id.messageText, 0);
                    continue;
                }
                Logger.log$default((Logger)this.sdkInstance.logger, (int)2, null, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ ImageBannerBuilder this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return ImageBannerBuilder.access$getTag$p(this.this$0) + " buildExpandedImageBannerText() : Unknown widget. Ignoring";
                    }
                }), (int)2, null);
            }
            templateHelper.addDefaultActionToNotificationClick$rich_notification_release(this.context, remoteViews, R.id.expandedRootView, this.template, this.metaData);
            this.metaData.getNotificationBuilder().setCustomBigContentView(remoteViews);
            return true;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ ImageBannerBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ImageBannerBuilder.access$getTag$p(this.this$0) + " buildExpandedImageBannerText() : ";
                }
            });
            return false;
        }
    }

    private final RemoteViews getExpandedImageBannerTextLayout(boolean isPersistent) {
        return RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice() ? (isPersistent ? new RemoteViews(this.context.getPackageName(), R.layout.moe_rich_push_image_banner_text_expanded_layout_decorated_style_with_dismiss) : new RemoteViews(this.context.getPackageName(), R.layout.moe_rich_push_image_banner_text_expanded_layout_decorated_style)) : new RemoteViews(this.context.getPackageName(), RichPushUtilsKt.getTemplateLayout(R.layout.moe_rich_push_image_banner_text_expanded, R.layout.moe_rich_push_image_banner_text_expanded_layout_big, this.sdkInstance));
    }

    private final void addHeader(RemoteViews remoteViews, boolean isHeaderEnabled, HeaderStyle headerStyle) {
        if (!isHeaderEnabled) {
            return;
        }
        remoteViews.setViewVisibility(R.id.appInfo, 0);
        remoteViews.setImageViewResource(R.id.smallIcon, this.sdkInstance.getInitConfig().getPush().getMeta().getSmallIcon());
        TemplateHelper templateHelper = new TemplateHelper(this.sdkInstance);
        templateHelper.setSmallIconColor(this.context, remoteViews);
        remoteViews.setTextViewText(R.id.time, (CharSequence)RichPushUtilsKt.getTime());
        remoteViews.setTextViewText(R.id.appName, (CharSequence)RichPushUtilsKt.getAppName(this.context));
        templateHelper.setHeaderStyle(remoteViews, headerStyle);
        remoteViews.setImageViewResource(R.id.separatorTime, Intrinsics.areEqual((Object)this.template.getAssetColor(), (Object)"darkGrey") ? R.drawable.moe_rich_push_dark_separator : R.drawable.moe_rich_push_light_separator);
    }

    private final boolean addImageToTextOverlayBannerTemplate(Context context, NotificationMetaData metaData, Template template, TemplateHelper templateHelper, RemoteViews remoteView, ImageWidget widget, Card card) {
        int n;
        Bitmap bitmap = CoreUtils.downloadImageBitmap((String)widget.getContent());
        if (bitmap == null) {
            return false;
        }
        Bitmap bitmap2 = bitmap;
        if (RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice()) {
            if (widget.getScaleType() == ImageView.ScaleType.CENTER_CROP) {
                TemplateHelper.setViewCornerToRounded$rich_notification_release$default(templateHelper, remoteView, R.id.centerCropImage, 0.0f, 0, 12, null);
                n = R.id.centerCropImage;
            } else {
                n = R.id.centerInsideImage;
            }
        } else {
            n = R.id.imageBanner;
        }
        int widgetId = n;
        remoteView.setImageViewBitmap(widgetId, bitmap2);
        remoteView.setViewVisibility(widgetId, 0);
        TemplateHelper.addActionToImageWidget$rich_notification_release$default(templateHelper, context, metaData, template, remoteView, widget, card, widgetId, 0, 128, null);
        return true;
    }

    private final void addHeaderWithPersistentAssets(TemplateHelper templateHelper, RemoteViews remoteViews, boolean isHeaderEnabled) {
        if (this.metaData.getPayload().getAddOnFeatures().isPersistent()) {
            templateHelper.addPersistenceAsset(this.template.getAssetColor(), remoteViews, R.id.closeButton);
            templateHelper.addActionToDismissCTA(remoteViews, this.context, this.metaData);
        }
        this.addHeader(remoteViews, isHeaderEnabled, this.template.getHeaderStyle());
    }

    private final int getMaxAllowedImageHeightForImageBanner(boolean isCollapsedState) {
        return isCollapsedState ? (Build.VERSION.SDK_INT >= 23 && RichPushUtilsKt.isBigLayoutSupported(this.sdkInstance.getRemoteConfig()) ? 100 : 64) : (RichPushUtilsKt.isBigLayoutSupported(this.sdkInstance.getRemoteConfig()) ? 286 : 256);
    }

    public static final /* synthetic */ String access$getTag$p(ImageBannerBuilder $this) {
        return $this.tag;
    }
}

