/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.richnotification.internal.builder;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.text.Spanned;
import android.util.DisplayMetrics;
import android.widget.ImageView;
import android.widget.RemoteViews;
import androidx.annotation.DrawableRes;
import androidx.core.app.NotificationCompat;
import androidx.core.text.HtmlCompat;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.utils.CoreUtils;
import com.moengage.pushbase.internal.CacheStrategy;
import com.moengage.pushbase.internal.ImageHelper;
import com.moengage.pushbase.internal.MapperKt;
import com.moengage.pushbase.internal.MoEPushWorker;
import com.moengage.pushbase.internal.UtilsKt;
import com.moengage.pushbase.internal.model.NotificationMetaData;
import com.moengage.pushbase.internal.model.TemplateTrackingMeta;
import com.moengage.pushbase.model.NotificationPayload;
import com.moengage.pushbase.model.action.Action;
import com.moengage.richnotification.R;
import com.moengage.richnotification.internal.Evaluator;
import com.moengage.richnotification.internal.RichPushUtilsKt;
import com.moengage.richnotification.internal.models.Card;
import com.moengage.richnotification.internal.models.ChronometerStyle;
import com.moengage.richnotification.internal.models.DefaultText;
import com.moengage.richnotification.internal.models.DismissCta;
import com.moengage.richnotification.internal.models.HeaderStyle;
import com.moengage.richnotification.internal.models.ImageWidget;
import com.moengage.richnotification.internal.models.LayoutStyle;
import com.moengage.richnotification.internal.models.Template;
import com.moengage.richnotification.internal.models.Widget;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJC\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ6\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u001e\u0010%\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014JO\u0010&\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\"2\u0006\u0010)\u001a\u00020$2\b\b\u0002\u0010*\u001a\u00020$H\u0000\u00a2\u0006\u0002\b+J>\u0010,\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$J-\u0010-\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010.\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b/J8\u00100\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010)\u001a\u00020$H\u0002J5\u00101\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010.\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b2J-\u00103\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b4JS\u00105\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u00106\u001a\u0004\u0018\u0001072\b\b\u0002\u00108\u001a\u00020$H\u0000\u00a2\u0006\u0002\b9J\u001e\u0010:\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010;\u001a\u00020<J \u0010=\u001a\u00020\u00102\b\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$J\u001e\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$J\u001d\u0010B\u001a\u00020\u001d2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010CJ\u0017\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010'\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\bFJ\u0015\u0010G\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\bHJ\u001e\u0010I\u001a\u0002072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010J\u001a\u0002072\u0006\u0010K\u001a\u00020$J4\u0010L\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020N2\b\b\u0001\u0010O\u001a\u00020$2\b\b\u0001\u0010P\u001a\u00020$H\u0002J\u001e\u0010Q\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010;\u001a\u00020<J\u001e\u0010R\u001a\u00020\u00102\u0006\u0010>\u001a\u00020?2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$J%\u0010S\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010T\u001a\u00020\b2\u0006\u0010U\u001a\u00020VH\u0000\u00a2\u0006\u0002\bWJ\u0016\u0010X\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010M\u001a\u00020NJ&\u0010Y\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010M\u001a\u00020N2\u0006\u0010Z\u001a\u00020\b2\u0006\u0010[\u001a\u00020\\J'\u0010]\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010^\u001a\u00020_2\b\b\u0002\u0010`\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\baJ-\u0010b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\bcJ\u0016\u0010d\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010[\u001a\u00020\\J(\u0010e\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010M\u001a\u00020N2\u0006\u0010Z\u001a\u00020\b2\u0006\u0010[\u001a\u00020\\H\u0002J\u0016\u0010f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J1\u0010g\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010h\u001a\u00020$2\b\b\u0002\u0010i\u001a\u00020j2\b\b\u0002\u0010k\u001a\u00020$H\u0000\u00a2\u0006\u0002\blR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lcom/moengage/richnotification/internal/builder/TemplateHelper;", "", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Lcom/moengage/core/internal/model/SdkInstance;)V", "actionButtonIdArray", "", "tag", "", "actionListToActionJson", "Lorg/json/JSONObject;", "actions", "", "Lcom/moengage/pushbase/model/action/Action;", "([Lcom/moengage/pushbase/model/action/Action;)Lorg/json/JSONObject;", "addActionButton", "", "context", "Landroid/content/Context;", "metaData", "Lcom/moengage/pushbase/internal/model/NotificationMetaData;", "template", "Lcom/moengage/richnotification/internal/models/Template;", "remoteViews", "Landroid/widget/RemoteViews;", "actionButtons", "", "Lcom/moengage/richnotification/internal/models/Widget;", "isPersistent", "", "addActionButton$rich_notification_release", "addActionToCard", "templateName", "card", "Lcom/moengage/richnotification/internal/models/Card;", "viewId", "", "addActionToDismissCTA", "addActionToImageWidget", "widget", "Lcom/moengage/richnotification/internal/models/ImageWidget;", "widgetId", "cardId", "addActionToImageWidget$rich_notification_release", "addActionToWidget", "addDecoratedStyleBaseProperties", "rootViewId", "addDecoratedStyleBaseProperties$rich_notification_release", "addDefaultAction", "addDefaultActionToNotificationClick", "addDefaultActionToNotificationClick$rich_notification_release", "addImageToExpandedTemplate", "addImageToExpandedTemplate$rich_notification_release", "addImageWidgetToTemplate", "preloadedBitmap", "Landroid/graphics/Bitmap;", "maxAllowedImageHeight", "addImageWidgetToTemplate$rich_notification_release", "addLargeIcon", "payload", "Lcom/moengage/pushbase/model/NotificationPayload;", "addLayoutStyle", "layout", "Lcom/moengage/richnotification/internal/models/LayoutStyle;", "addPersistenceAsset", "assetColor", "containsSnoozeAction", "([Lcom/moengage/pushbase/model/action/Action;)Z", "getChronometerStyle", "Lcom/moengage/richnotification/internal/models/ChronometerStyle;", "getChronometerStyle$rich_notification_release", "removeImageWidgetFromExpandedTemplate", "removeImageWidgetFromExpandedTemplate$rich_notification_release", "scaleBitmap", "bitmap", "maxHeight", "setAssets", "defaultText", "Lcom/moengage/richnotification/internal/models/DefaultText;", "crossButton", "separator", "setAssetsIfRequired", "setBackgroundColor", "setChronometer", "format", "timerExpiry", "", "setChronometer$rich_notification_release", "setContentText", "setDefaultTextAndStyle", "appName", "headerStyle", "Lcom/moengage/richnotification/internal/models/HeaderStyle;", "setDismissCtaCustomization", "dismissCtaText", "Lcom/moengage/richnotification/internal/models/DismissCta;", "shouldCustomiseDismissView", "setDismissCtaCustomization$rich_notification_release", "setHeaderAssetsAndIcon", "setHeaderAssetsAndIcon$rich_notification_release", "setHeaderStyle", "setHeaderTextAndStyle", "setSmallIconColor", "setViewCornerToRounded", "layoutId", "radius", "", "unit", "setViewCornerToRounded$rich_notification_release", "rich-notification_release"})
public final class TemplateHelper {
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final String tag;
    @NotNull
    private final int[] actionButtonIdArray;

    public TemplateHelper(@NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.sdkInstance = sdkInstance;
        this.tag = "RichPush_4.7.2_TemplateHelper";
        int[] nArray = new int[]{R.id.actionButton1, R.id.actionButton2};
        this.actionButtonIdArray = nArray;
    }

    public final void setAssetsIfRequired(@NotNull RemoteViews remoteViews, @NotNull Template template, @NotNull NotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String string = template.getAssetColor();
        if (Intrinsics.areEqual((Object)string, (Object)"darkGrey")) {
            this.setAssets(remoteViews, payload.getAddOnFeatures().isPersistent(), template.getDefaultText(), R.drawable.moe_rich_push_dark_cross, R.drawable.moe_rich_push_dark_separator);
        } else if (Intrinsics.areEqual((Object)string, (Object)"lightGrey")) {
            this.setAssets(remoteViews, payload.getAddOnFeatures().isPersistent(), template.getDefaultText(), R.drawable.moe_rich_push_light_cross, R.drawable.moe_rich_push_light_separator);
        } else {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)1, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ TemplateHelper this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return TemplateHelper.access$getTag$p(this.this$0) + " setAssetsIfRequired() : Not a valid asset color, using default.";
                }
            }), (int)2, null);
            this.setAssets(remoteViews, payload.getAddOnFeatures().isPersistent(), template.getDefaultText(), R.drawable.moe_rich_push_light_cross, R.drawable.moe_rich_push_light_separator);
        }
    }

    private final void setAssets(RemoteViews remoteViews, boolean isPersistent, DefaultText defaultText, @DrawableRes int crossButton, @DrawableRes int separator) {
        if (isPersistent) {
            remoteViews.setImageViewResource(R.id.closeButton, crossButton);
            remoteViews.setViewVisibility(R.id.closeButton, 0);
        }
        if (!StringsKt.isBlank((CharSequence)defaultText.getSummary())) {
            remoteViews.setImageViewResource(R.id.separatorSummary, separator);
            remoteViews.setViewVisibility(R.id.separatorSummary, 0);
        }
        remoteViews.setImageViewResource(R.id.separatorTime, separator);
    }

    public final void setDefaultTextAndStyle(@NotNull RemoteViews remoteViews, @NotNull DefaultText defaultText, @NotNull String appName, @NotNull HeaderStyle headerStyle) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)defaultText, (String)"defaultText");
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter((Object)headerStyle, (String)"headerStyle");
        Spanned spanned = HtmlCompat.fromHtml((String)defaultText.getTitle(), (int)63);
        Intrinsics.checkNotNullExpressionValue((Object)spanned, (String)"fromHtml(defaultText.tit\u2026t.FROM_HTML_MODE_COMPACT)");
        remoteViews.setTextViewText(R.id.title, StringsKt.trim((CharSequence)((CharSequence)spanned)));
        Spanned spanned2 = HtmlCompat.fromHtml((String)defaultText.getMessage(), (int)63);
        Intrinsics.checkNotNullExpressionValue((Object)spanned2, (String)"fromHtml(defaultText.mes\u2026t.FROM_HTML_MODE_COMPACT)");
        remoteViews.setTextViewText(R.id.message, StringsKt.trim((CharSequence)((CharSequence)spanned2)));
        if (!RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice()) {
            this.setHeaderTextAndStyle(remoteViews, defaultText, appName, headerStyle);
        }
    }

    public final void addActionToDismissCTA(@NotNull RemoteViews remoteViews, @NotNull Context context, @NotNull NotificationMetaData metaData) {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intent intent = new Intent(context, MoEPushWorker.class);
        intent.putExtras(metaData.getPayload().getPayload()).putExtra("moe_action", UtilsKt.buildDismissActionJson((int)metaData.getNotificationId()).toString()).setAction("ACTION_NOTIFICATION_CLOSE_CLICK");
        PendingIntent pendingIntent = CoreUtils.getPendingIntentService$default((Context)context, (int)metaData.getNotificationId(), (Intent)intent, (int)0, (int)8, null);
        remoteViews.setOnClickPendingIntent(R.id.closeButton, pendingIntent);
    }

    public final void addLargeIcon(@NotNull RemoteViews remoteViews, @NotNull Template template, @NotNull NotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Bitmap largeIcon = null;
        if (!template.getShouldShowLargeIcon()) {
            return;
        }
        if (!StringsKt.isBlank((CharSequence)payload.getAddOnFeatures().getLargeIconUrl())) {
            largeIcon = new ImageHelper(this.sdkInstance).getBitmapFromUrl(payload.getAddOnFeatures().getLargeIconUrl(), CacheStrategy.MEMORY);
        }
        if (largeIcon != null) {
            remoteViews.setImageViewBitmap(R.id.largeIcon, largeIcon);
        } else if (this.sdkInstance.getInitConfig().getPush().getMeta().getLargeIcon() != -1) {
            remoteViews.setImageViewResource(R.id.largeIcon, this.sdkInstance.getInitConfig().getPush().getMeta().getLargeIcon());
        }
        if (RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice()) {
            TemplateHelper.setViewCornerToRounded$rich_notification_release$default(this, remoteViews, R.id.largeIcon, 0.0f, 0, 12, null);
        }
        remoteViews.setViewVisibility(R.id.largeIcon, 0);
    }

    public final void setBackgroundColor(@NotNull LayoutStyle layout2, @NotNull RemoteViews remoteViews, int viewId) {
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        if (StringsKt.isBlank((CharSequence)layout2.getBackgroundColor())) {
            return;
        }
        remoteViews.setInt(viewId, "setBackgroundColor", Color.parseColor((String)layout2.getBackgroundColor()));
    }

    @NotNull
    public final Bitmap scaleBitmap(@NotNull Context context, @NotNull Bitmap bitmap, int maxHeight) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        try {
            Bitmap bitmap2;
            int imageHeight = bitmap.getHeight();
            int imageWidth = bitmap.getWidth();
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, maxHeight){
                final /* synthetic */ TemplateHelper this$0;
                final /* synthetic */ int $maxHeight;
                {
                    this.this$0 = $receiver;
                    this.$maxHeight = $maxHeight;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return TemplateHelper.access$getTag$p(this.this$0) + " scaleBitmap() : Max height: " + this.$maxHeight;
                }
            }), (int)3, null);
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, displayMetrics){
                final /* synthetic */ TemplateHelper this$0;
                final /* synthetic */ DisplayMetrics $displayMetrics;
                {
                    this.this$0 = $receiver;
                    this.$displayMetrics = $displayMetrics;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return TemplateHelper.access$getTag$p(this.this$0) + " scaleBitmap() : Device dimensions: width: " + this.$displayMetrics.widthPixels + " height: " + this.$displayMetrics.heightPixels;
                }
            }), (int)3, null);
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, imageWidth, imageHeight){
                final /* synthetic */ TemplateHelper this$0;
                final /* synthetic */ int $imageWidth;
                final /* synthetic */ int $imageHeight;
                {
                    this.this$0 = $receiver;
                    this.$imageWidth = $imageWidth;
                    this.$imageHeight = $imageHeight;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return TemplateHelper.access$getTag$p(this.this$0) + " scaleBitmap() : Actual Dimension - width: " + this.$imageWidth + "   height: " + this.$imageHeight;
                }
            }), (int)3, null);
            if (imageHeight >= imageWidth) {
                Ref.IntRef width = new Ref.IntRef();
                width.element = imageWidth * maxHeight / imageHeight;
                if (width.element > displayMetrics.widthPixels) {
                    width.element = displayMetrics.widthPixels;
                }
                Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, width, maxHeight){
                    final /* synthetic */ TemplateHelper this$0;
                    final /* synthetic */ Ref.IntRef $width;
                    final /* synthetic */ int $maxHeight;
                    {
                        this.this$0 = $receiver;
                        this.$width = $width;
                        this.$maxHeight = $maxHeight;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return TemplateHelper.access$getTag$p(this.this$0) + " scaleBitmap() : Scaled dimensions: width: " + this.$width.element + " height: " + this.$maxHeight;
                    }
                }), (int)3, null);
                Bitmap bitmap3 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width.element, (int)maxHeight, (boolean)true);
                bitmap2 = bitmap3;
                Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"fun scaleBitmap(context:\u2026      return bitmap\n    }");
            } else {
                int height = imageHeight * displayMetrics.widthPixels / imageWidth;
                Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, displayMetrics, height){
                    final /* synthetic */ TemplateHelper this$0;
                    final /* synthetic */ DisplayMetrics $displayMetrics;
                    final /* synthetic */ int $height;
                    {
                        this.this$0 = $receiver;
                        this.$displayMetrics = $displayMetrics;
                        this.$height = $height;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return TemplateHelper.access$getTag$p(this.this$0) + " scaleBitmap() : Scaled dimensions: width: " + this.$displayMetrics.widthPixels + " height: " + this.$height;
                    }
                }), (int)3, null);
                Bitmap bitmap4 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)displayMetrics.widthPixels, (int)height, (boolean)true);
                bitmap2 = bitmap4;
                Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"fun scaleBitmap(context:\u2026      return bitmap\n    }");
            }
            return bitmap2;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ TemplateHelper this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return TemplateHelper.access$getTag$p(this.this$0) + " scaleBitmap() : ";
                }
            });
            return bitmap;
        }
    }

    public final void addActionToCard(@NotNull Context context, @NotNull NotificationMetaData metaData, @NotNull String templateName, @NotNull RemoteViews remoteViews, @NotNull Card card, int viewId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        if (card.getActions().length == 0) {
            return;
        }
        Intent intent = UtilsKt.getRedirectIntent((Context)context, (Bundle)metaData.getPayload().getPayload(), (int)metaData.getNotificationId());
        TemplateTrackingMeta meta = new TemplateTrackingMeta(templateName, card.getId(), -1);
        intent.putExtra("moe_template_meta", MapperKt.templateTrackingMetaToJsonString((TemplateTrackingMeta)meta)).putExtra("moe_action", this.actionListToActionJson(card.getActions()).toString());
        PendingIntent pendingIntent = CoreUtils.getPendingIntentActivity$default((Context)context, (int)(metaData.getNotificationId() + (1000 + card.getId())), (Intent)intent, (int)0, (int)8, null);
        remoteViews.setOnClickPendingIntent(viewId, pendingIntent);
    }

    public final void addActionToWidget(@NotNull Context context, @NotNull NotificationMetaData metaData, @NotNull String templateName, @NotNull RemoteViews remoteViews, @NotNull Card card, @NotNull Widget widget, int viewId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        if (widget.getActions().length == 0) {
            return;
        }
        Intent intent = UtilsKt.getRedirectIntent((Context)context, (Bundle)metaData.getPayload().getPayload(), (int)metaData.getNotificationId());
        TemplateHelper templateHelper = new TemplateHelper(this.sdkInstance);
        intent.putExtra("moe_template_meta", MapperKt.templateTrackingMetaToJsonString((TemplateTrackingMeta)new TemplateTrackingMeta(templateName, card.getId(), widget.getId()))).putExtra("moe_action", templateHelper.actionListToActionJson(widget.getActions()).toString());
        PendingIntent pendingIntent = CoreUtils.getPendingIntentActivity$default((Context)context, (int)(metaData.getNotificationId() + (100 + widget.getId())), (Intent)intent, (int)0, (int)8, null);
        remoteViews.setOnClickPendingIntent(viewId, pendingIntent);
    }

    public final void addLayoutStyle(@Nullable LayoutStyle layout2, @NotNull RemoteViews remoteViews, int viewId) {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        if (layout2 == null) {
            return;
        }
        this.setBackgroundColor(layout2, remoteViews, viewId);
    }

    public final void addPersistenceAsset(@NotNull String assetColor, @NotNull RemoteViews remoteViews, int viewId) {
        Intrinsics.checkNotNullParameter((Object)assetColor, (String)"assetColor");
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        int assetDrawable = Intrinsics.areEqual((Object)"darkGrey", (Object)assetColor) ? R.drawable.moe_rich_push_dark_cross : R.drawable.moe_rich_push_light_cross;
        remoteViews.setImageViewResource(viewId, assetDrawable);
        remoteViews.setViewVisibility(viewId, 0);
    }

    public final void setSmallIconColor(@NotNull Context context, @NotNull RemoteViews remoteViews) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        if (this.sdkInstance.getInitConfig().getPush().getMeta().getNotificationColor() <= 0) {
            return;
        }
        remoteViews.setInt(R.id.smallIcon, "setColorFilter", context.getResources().getColor(this.sdkInstance.getInitConfig().getPush().getMeta().getNotificationColor()));
    }

    @NotNull
    public final JSONObject actionListToActionJson(@NotNull Action[] actions) {
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        JSONObject actionJson = new JSONObject();
        JSONArray actionsArray = new JSONArray();
        if (actions.length == 0) {
            actionJson.put("actions", (Object)actionsArray);
            return actionJson;
        }
        for (Action action : actions) {
            actionsArray.put((Object)action.getPayload());
        }
        actionJson.put("actions", (Object)actionsArray);
        return actionJson;
    }

    public final void setHeaderStyle(@NotNull RemoteViews remoteViews, @NotNull HeaderStyle headerStyle) {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)headerStyle, (String)"headerStyle");
        CharSequence charSequence = headerStyle.getAppNameColor();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            int color = Color.parseColor((String)headerStyle.getAppNameColor());
            remoteViews.setTextColor(R.id.appName, color);
            remoteViews.setTextColor(R.id.time, color);
        }
    }

    public final void setContentText(@NotNull RemoteViews remoteViews, @NotNull DefaultText defaultText) {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)defaultText, (String)"defaultText");
        Spanned spanned = HtmlCompat.fromHtml((String)defaultText.getTitle(), (int)63);
        Intrinsics.checkNotNullExpressionValue((Object)spanned, (String)"fromHtml(defaultText.tit\u2026t.FROM_HTML_MODE_COMPACT)");
        remoteViews.setTextViewText(R.id.title, StringsKt.trim((CharSequence)((CharSequence)spanned)));
        if (!StringsKt.isBlank((CharSequence)defaultText.getMessage())) {
            Spanned spanned2 = HtmlCompat.fromHtml((String)defaultText.getMessage(), (int)63);
            Intrinsics.checkNotNullExpressionValue((Object)spanned2, (String)"fromHtml(defaultText.mes\u2026t.FROM_HTML_MODE_COMPACT)");
            remoteViews.setTextViewText(R.id.message, StringsKt.trim((CharSequence)((CharSequence)spanned2)));
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void addActionButton$rich_notification_release(@NotNull Context context, @NotNull NotificationMetaData metaData, @NotNull Template template, @NotNull RemoteViews remoteViews, @NotNull List<? extends Widget> actionButtons, boolean isPersistent) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
            Intrinsics.checkNotNullParameter(actionButtons, (String)"actionButtons");
            if (((Collection)actionButtons).isEmpty() == false) {
                maxButtonWidth = CoreUtils.getDeviceDimensions((Context)context).width / actionButtons.size();
                var9_9 = Math.min(actionButtons.size(), 2);
                for (i = 0; i < var9_9; ++i) {
                    widget = actionButtons.get(i);
                    if (!Intrinsics.areEqual((Object)"button", (Object)widget.getType())) {
                        $i$a$-check-TemplateHelper$addActionButton$1 = false;
                        $i$a$-check-TemplateHelper$addActionButton$1 = "Only button widget expected.";
                        throw new IllegalStateException($i$a$-check-TemplateHelper$addActionButton$1.toString());
                    }
                    remoteViews.setViewVisibility(this.actionButtonIdArray[i], 0);
                    if (!RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice()) {
                        remoteViews.setInt(this.actionButtonIdArray[i], "setMaxWidth", maxButtonWidth);
                    }
                    remoteViews.setTextViewText(this.actionButtonIdArray[i], (CharSequence)HtmlCompat.fromHtml((String)widget.getContent(), (int)63));
                    if (widget.getStyle() != null && StringsKt.isBlank((CharSequence)widget.getStyle().getBackgroundColor()) == false) {
                        remoteViews.setInt(this.actionButtonIdArray[i], "setBackgroundColor", Color.parseColor((String)widget.getStyle().getBackgroundColor()));
                    }
                    meta = new TemplateTrackingMeta(template.getTemplateName(), -1, widget.getId());
                    redirectIntent = UtilsKt.getRedirectIntent((Context)context, (Bundle)metaData.getPayload().getPayload(), (int)metaData.getNotificationId());
                    if (this.containsSnoozeAction(widget.getActions())) {
                        redirectIntent = UtilsKt.getIntentForSnooze((Context)context, (Bundle)metaData.getPayload().getPayload(), (int)metaData.getNotificationId());
                    }
                    redirectIntent.putExtra("moe_template_meta", MapperKt.templateTrackingMetaToJsonString((TemplateTrackingMeta)meta));
                    if (widget.getActions().length == 0 == false) {
                        templateHelper = new TemplateHelper(this.sdkInstance);
                        redirectIntent.putExtra("moe_action", templateHelper.actionListToActionJson(widget.getActions()).toString());
                    }
                    pendingIntent = CoreUtils.getPendingIntentActivity$default((Context)context, (int)(metaData.getNotificationId() + (1000 + widget.getId())), (Intent)redirectIntent, (int)0, (int)8, null);
                    remoteViews.setOnClickPendingIntent(this.actionButtonIdArray[i], pendingIntent);
                }
            }
            if (!isPersistent) break block9;
            if (RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice()) ** GOTO lbl-1000
            v0 = template.getCollapsedTemplate();
            v1 = template.getExpandedTemplate();
            if (new Evaluator(this.sdkInstance.logger).isTimerTemplate$rich_notification_release(v0 != null ? v0.getType() : null, v1 != null ? v1.getType() : null)) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            shouldCustomiseDismissView = v2;
            this.setDismissCtaCustomization$rich_notification_release(remoteViews, template.getDismissCta(), shouldCustomiseDismissView);
            this.addActionToDismissCTA(remoteViews, context, metaData);
        }
    }

    private final boolean containsSnoozeAction(Action[] actions) {
        if (actions == null) {
            return false;
        }
        Iterator iterator = ArrayIteratorKt.iterator((Object[])actions);
        while (iterator.hasNext()) {
            Action action = (Action)iterator.next();
            if (!Intrinsics.areEqual((Object)action.getActionType(), (Object)"remindLater")) continue;
            return true;
        }
        return false;
    }

    public final boolean addImageToExpandedTemplate$rich_notification_release(@NotNull Context context, @NotNull NotificationMetaData metaData, @NotNull Template template, @NotNull RemoteViews remoteViews) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        if (template.getExpandedTemplate() == null) {
            return false;
        }
        Card card = template.getExpandedTemplate().getCards().get(0);
        if (card.getWidgets().isEmpty()) {
            return false;
        }
        Widget widget = card.getWidgets().get(0);
        if (!Intrinsics.areEqual((Object)"image", (Object)widget.getType())) {
            return false;
        }
        Intrinsics.checkNotNull((Object)widget, (String)"null cannot be cast to non-null type com.moengage.richnotification.internal.models.ImageWidget");
        return TemplateHelper.addImageWidgetToTemplate$rich_notification_release$default(this, context, metaData, template, remoteViews, (ImageWidget)widget, card, null, 0, 192, null);
    }

    private final void addDefaultAction(Context context, Template template, NotificationMetaData metaData, Card card, RemoteViews remoteViews, int widgetId) {
        TemplateTrackingMeta meta = new TemplateTrackingMeta(template.getTemplateName(), card.getId(), -1);
        Intent redirectIntent = UtilsKt.getRedirectIntent((Context)context, (Bundle)metaData.getPayload().getPayload(), (int)metaData.getNotificationId());
        redirectIntent.putExtra("moe_template_meta", MapperKt.templateTrackingMetaToJsonString((TemplateTrackingMeta)meta));
        PendingIntent pendingIntent = CoreUtils.getPendingIntentActivity$default((Context)context, (int)metaData.getNotificationId(), (Intent)redirectIntent, (int)0, (int)8, null);
        remoteViews.setOnClickPendingIntent(widgetId, pendingIntent);
    }

    public final boolean setChronometer$rich_notification_release(@NotNull RemoteViews remoteViews, @NotNull String format, long timerExpiry) {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        if (timerExpiry == -1L) {
            return false;
        }
        remoteViews.setChronometer(R.id.moEChronometer, timerExpiry, format, true);
        remoteViews.setViewVisibility(R.id.chronometerLayout, 0);
        remoteViews.setViewVisibility(R.id.moEChronometer, 0);
        return true;
    }

    @Nullable
    public final ChronometerStyle getChronometerStyle$rich_notification_release(@NotNull Widget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        if (!(widget.getStyle() instanceof ChronometerStyle)) {
            return null;
        }
        return (ChronometerStyle)widget.getStyle();
    }

    public final boolean addImageWidgetToTemplate$rich_notification_release(@NotNull Context context, @NotNull NotificationMetaData metaData, @NotNull Template template, @NotNull RemoteViews remoteViews, @NotNull ImageWidget widget, @NotNull Card card, @Nullable Bitmap preloadedBitmap, int maxAllowedImageHeight) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        if (template.getExpandedTemplate() == null) {
            return false;
        }
        Bitmap bitmap = preloadedBitmap;
        if (bitmap == null && (bitmap = CoreUtils.downloadImageBitmap((String)widget.getContent())) == null) {
            return false;
        }
        Bitmap bitmap2 = bitmap;
        int widgetId = 0;
        if (RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice()) {
            int n;
            if (widget.getScaleType() == ImageView.ScaleType.CENTER_CROP) {
                remoteViews.setViewVisibility(R.id.centerInsideImage, 8);
                TemplateHelper.setViewCornerToRounded$rich_notification_release$default(this, remoteViews, R.id.centerCropImage, 0.0f, 0, 12, null);
                n = R.id.centerCropImage;
            } else {
                remoteViews.setViewVisibility(R.id.centerCropImage, 8);
                n = R.id.centerInsideImage;
            }
            widgetId = n;
        } else {
            int n;
            int maxImageHeight = !((Collection)template.getExpandedTemplate().getActionButtonList()).isEmpty() ? UtilsKt.transformToPx((Context)context, (int)(maxAllowedImageHeight - 40)) : UtilsKt.transformToPx((Context)context, (int)maxAllowedImageHeight);
            boolean isTablet = CoreUtils.isTablet((Context)context);
            if (!isTablet) {
                bitmap2 = this.scaleBitmap(context, bitmap2, maxImageHeight);
            }
            if (isTablet) {
                remoteViews.setViewVisibility(R.id.horizontalFitCenterImage, 8);
                remoteViews.setViewVisibility(R.id.verticalImage, 8);
                n = R.id.horizontalCenterCropImage;
            } else if (bitmap2.getHeight() >= bitmap2.getWidth()) {
                remoteViews.setViewVisibility(R.id.horizontalCenterCropImage, 8);
                remoteViews.setViewVisibility(R.id.horizontalFitCenterImage, 8);
                n = R.id.verticalImage;
            } else if (bitmap2.getHeight() >= maxImageHeight) {
                remoteViews.setViewVisibility(R.id.horizontalFitCenterImage, 8);
                remoteViews.setViewVisibility(R.id.verticalImage, 8);
                n = R.id.horizontalCenterCropImage;
            } else {
                remoteViews.setViewVisibility(R.id.horizontalCenterCropImage, 8);
                remoteViews.setViewVisibility(R.id.verticalImage, 8);
                n = R.id.horizontalFitCenterImage;
            }
            widgetId = n;
        }
        remoteViews.setImageViewBitmap(widgetId, bitmap2);
        remoteViews.setViewVisibility(widgetId, 0);
        TemplateHelper.addActionToImageWidget$rich_notification_release$default(this, context, metaData, template, remoteViews, widget, card, widgetId, 0, 128, null);
        return true;
    }

    public static /* synthetic */ boolean addImageWidgetToTemplate$rich_notification_release$default(TemplateHelper templateHelper, Context context, NotificationMetaData notificationMetaData, Template template, RemoteViews remoteViews, ImageWidget imageWidget, Card card, Bitmap bitmap, int n, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            bitmap = null;
        }
        if ((n2 & 0x80) != 0) {
            n = 192;
        }
        return templateHelper.addImageWidgetToTemplate$rich_notification_release(context, notificationMetaData, template, remoteViews, imageWidget, card, bitmap, n);
    }

    public final void removeImageWidgetFromExpandedTemplate$rich_notification_release(@NotNull RemoteViews remoteViews) {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        if (RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice()) {
            remoteViews.setViewVisibility(R.id.centerInsideImage, 8);
            remoteViews.setViewVisibility(R.id.centerCropImage, 8);
        } else {
            remoteViews.setViewVisibility(R.id.horizontalFitCenterImage, 8);
            remoteViews.setViewVisibility(R.id.verticalImage, 8);
            remoteViews.setViewVisibility(R.id.horizontalCenterCropImage, 8);
        }
    }

    private final void setHeaderTextAndStyle(RemoteViews remoteViews, DefaultText defaultText, String appName, HeaderStyle headerStyle) {
        if (!StringsKt.isBlank((CharSequence)defaultText.getSummary())) {
            remoteViews.setViewVisibility(R.id.summaryText, 0);
            remoteViews.setTextViewText(R.id.summaryText, (CharSequence)HtmlCompat.fromHtml((String)defaultText.getSummary(), (int)63));
        }
        remoteViews.setTextViewText(R.id.time, (CharSequence)RichPushUtilsKt.getTime());
        if (StringsKt.isBlank((CharSequence)appName)) {
            throw new IllegalStateException("App name cannot be empty");
        }
        remoteViews.setTextViewText(R.id.appName, (CharSequence)appName);
        this.setHeaderStyle(remoteViews, headerStyle);
    }

    public final void setViewCornerToRounded$rich_notification_release(@NotNull RemoteViews remoteViews, int layoutId, float radius, int unit) {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        if (Build.VERSION.SDK_INT >= 31) {
            remoteViews.setViewOutlinePreferredRadius(layoutId, radius, unit);
        }
    }

    public static /* synthetic */ void setViewCornerToRounded$rich_notification_release$default(TemplateHelper templateHelper, RemoteViews remoteViews, int n, float f, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            f = 4.0f;
        }
        if ((n3 & 8) != 0) {
            n2 = 1;
        }
        templateHelper.setViewCornerToRounded$rich_notification_release(remoteViews, n, f, n2);
    }

    public final void setDismissCtaCustomization$rich_notification_release(@NotNull RemoteViews remoteViews, @NotNull DismissCta dismissCtaText, boolean shouldCustomiseDismissView) {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)dismissCtaText, (String)"dismissCtaText");
        if (shouldCustomiseDismissView) {
            remoteViews.setTextViewText(R.id.closeButton, (CharSequence)HtmlCompat.fromHtml((String)dismissCtaText.getText(), (int)63));
        }
        remoteViews.setViewVisibility(R.id.closeButton, 0);
    }

    public static /* synthetic */ void setDismissCtaCustomization$rich_notification_release$default(TemplateHelper templateHelper, RemoteViews remoteViews, DismissCta dismissCta, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice();
        }
        templateHelper.setDismissCtaCustomization$rich_notification_release(remoteViews, dismissCta, bl);
    }

    public final void setHeaderAssetsAndIcon$rich_notification_release(@NotNull Context context, @NotNull RemoteViews remoteViews, @NotNull Template template, @NotNull NotificationMetaData metaData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        this.setAssetsIfRequired(remoteViews, template, metaData.getPayload());
        if (this.sdkInstance.getInitConfig().getPush().getMeta().getSmallIcon() != -1) {
            remoteViews.setImageViewResource(R.id.smallIcon, this.sdkInstance.getInitConfig().getPush().getMeta().getSmallIcon());
            this.setSmallIconColor(context, remoteViews);
        }
    }

    public final void addDecoratedStyleBaseProperties$rich_notification_release(@NotNull RemoteViews remoteViews, int rootViewId, @NotNull Template template, @NotNull NotificationMetaData metaData) {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        TemplateHelper.setViewCornerToRounded$rich_notification_release$default(this, remoteViews, rootViewId, 0.0f, 0, 12, null);
        NotificationCompat.Builder builder = metaData.getNotificationBuilder();
        Spanned spanned = HtmlCompat.fromHtml((String)template.getDefaultText().getSummary(), (int)63);
        Intrinsics.checkNotNullExpressionValue((Object)spanned, (String)"fromHtml(template.defaul\u2026t.FROM_HTML_MODE_COMPACT)");
        builder.setSubText(StringsKt.trim((CharSequence)((CharSequence)spanned)));
    }

    public final void addDefaultActionToNotificationClick$rich_notification_release(@NotNull Context context, @NotNull RemoteViews remoteViews, int rootViewId, @NotNull Template template, @NotNull NotificationMetaData metaData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        TemplateTrackingMeta meta = new TemplateTrackingMeta(template.getTemplateName(), -1, -1);
        Intent redirectIntent = UtilsKt.getRedirectIntent((Context)context, (Bundle)metaData.getPayload().getPayload(), (int)metaData.getNotificationId());
        redirectIntent.putExtra("moe_template_meta", MapperKt.templateTrackingMetaToJsonString((TemplateTrackingMeta)meta));
        PendingIntent intent = CoreUtils.getPendingIntentActivity$default((Context)context, (int)metaData.getNotificationId(), (Intent)redirectIntent, (int)0, (int)8, null);
        remoteViews.setOnClickPendingIntent(rootViewId, intent);
        metaData.getNotificationBuilder().setContentIntent(intent);
    }

    public final void addActionToImageWidget$rich_notification_release(@NotNull Context context, @NotNull NotificationMetaData metaData, @NotNull Template template, @NotNull RemoteViews remoteViews, @NotNull ImageWidget widget, @NotNull Card card, int widgetId, int cardId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        if (widget.getActions().length == 0 && card.getActions().length == 0) {
            this.addDefaultAction(context, template, metaData, card, remoteViews, widgetId);
        } else {
            this.addActionToWidget(context, metaData, template.getTemplateName(), remoteViews, card, widget, widgetId);
            this.addActionToCard(context, metaData, template.getTemplateName(), remoteViews, card, cardId);
        }
    }

    public static /* synthetic */ void addActionToImageWidget$rich_notification_release$default(TemplateHelper templateHelper, Context context, NotificationMetaData notificationMetaData, Template template, RemoteViews remoteViews, ImageWidget imageWidget, Card card, int n, int n2, int n3, Object object) {
        if ((n3 & 0x80) != 0) {
            n2 = R.id.card;
        }
        templateHelper.addActionToImageWidget$rich_notification_release(context, notificationMetaData, template, remoteViews, imageWidget, card, n, n2);
    }

    public static final /* synthetic */ String access$getTag$p(TemplateHelper $this) {
        return $this.tag;
    }
}

