/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.richnotification.internal.builder;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.widget.RemoteViews;
import androidx.annotation.RequiresApi;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.pushbase.internal.model.NotificationMetaData;
import com.moengage.richnotification.R;
import com.moengage.richnotification.internal.Evaluator;
import com.moengage.richnotification.internal.RichPushTimerUtilsKt;
import com.moengage.richnotification.internal.RichPushUtilsKt;
import com.moengage.richnotification.internal.builder.TemplateHelper;
import com.moengage.richnotification.internal.builder.TimerTemplateBuilderKt;
import com.moengage.richnotification.internal.models.Card;
import com.moengage.richnotification.internal.models.ChronometerStyle;
import com.moengage.richnotification.internal.models.ChronometerWidget;
import com.moengage.richnotification.internal.models.ImageWidget;
import com.moengage.richnotification.internal.models.ProgressProperties;
import com.moengage.richnotification.internal.models.ProgressbarWidget;
import com.moengage.richnotification.internal.models.Template;
import com.moengage.richnotification.internal.models.TimerTemplate;
import com.moengage.richnotification.internal.models.Widget;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\r\u0010\u0011\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b\u0013J\b\u0010\u0014\u001a\u00020\u0012H\u0007J\b\u0010\u0015\u001a\u00020\u0012H\u0007J\b\u0010\u0016\u001a\u00020\u0012H\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0003J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0012H\u0002J\b\u0010\"\u001a\u00020\u001aH\u0002J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u001aH\u0002J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0012H\u0002J\u0015\u0010&\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b'J\u0018\u0010(\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010)\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/moengage/richnotification/internal/builder/TimerTemplateBuilder;", "", "context", "Landroid/content/Context;", "template", "Lcom/moengage/richnotification/internal/models/TimerTemplate;", "metaData", "Lcom/moengage/pushbase/internal/model/NotificationMetaData;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "progressProperties", "Lcom/moengage/richnotification/internal/models/ProgressProperties;", "(Landroid/content/Context;Lcom/moengage/richnotification/internal/models/TimerTemplate;Lcom/moengage/pushbase/internal/model/NotificationMetaData;Lcom/moengage/core/internal/model/SdkInstance;Lcom/moengage/richnotification/internal/models/ProgressProperties;)V", "tag", "", "templateHelper", "Lcom/moengage/richnotification/internal/builder/TemplateHelper;", "buildCollapsedProgressTemplate", "", "buildCollapsedProgressTemplate$rich_notification_release", "buildCollapsedTimerTemplate", "buildExpandedProgressTemplate", "buildExpandedTimerTemplate", "checkAndAddChronometer", "", "remoteViews", "Landroid/widget/RemoteViews;", "chronometerWidget", "Lcom/moengage/richnotification/internal/models/ChronometerWidget;", "checkAndAddProgressbar", "getDecoratedStyleExpandedProgressbarLayoutId", "", "hasButtons", "hasExactAlarmPermission", "getProgressbarCollapsedRemoteViews", "getProgressbarExpandedRemoteViews", "getTimerCollapsedRemoteViews", "getTimerExpandedRemoteViews", "setChronometerCountdown", "setChronometerCountdown$rich_notification_release", "setChronometerStyle", "setMessageMaxLines", "hasActionButtons", "hasImage", "rich-notification_release"})
public final class TimerTemplateBuilder {
    @NotNull
    private final Context context;
    @NotNull
    private final TimerTemplate template;
    @NotNull
    private final NotificationMetaData metaData;
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final ProgressProperties progressProperties;
    @NotNull
    private final String tag;
    @NotNull
    private final TemplateHelper templateHelper;

    public TimerTemplateBuilder(@NotNull Context context, @NotNull TimerTemplate template, @NotNull NotificationMetaData metaData, @NotNull SdkInstance sdkInstance, @NotNull ProgressProperties progressProperties) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)progressProperties, (String)"progressProperties");
        this.context = context;
        this.template = template;
        this.metaData = metaData;
        this.sdkInstance = sdkInstance;
        this.progressProperties = progressProperties;
        this.tag = "RichPush_4.7.2_TimerTemplateBuilder";
        this.templateHelper = new TemplateHelper(this.sdkInstance);
    }

    @TargetApi(value=24)
    public final boolean buildCollapsedTimerTemplate() {
        if (this.template.getCollapsedTemplate() == null) {
            return false;
        }
        if (!new Evaluator(this.sdkInstance.logger).hasMinimumText(this.template.getDefaultText())) {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)2, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ TimerTemplateBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return TimerTemplateBuilder.access$getTag$p(this.this$0) + " buildCollapsedTimerTemplate() : Does not have minimum text.";
                }
            }), (int)2, null);
            return false;
        }
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TimerTemplateBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return TimerTemplateBuilder.access$getTag$p(this.this$0) + " buildCollapsedTimerTemplate() : Template: " + TimerTemplateBuilder.access$getTemplate$p(this.this$0).getCollapsedTemplate();
            }
        }), (int)3, null);
        if (this.template.getCollapsedTemplate().getCards().isEmpty()) {
            return false;
        }
        RemoteViews remoteViews = this.getTimerCollapsedRemoteViews();
        this.templateHelper.setContentText(remoteViews, this.template.getDefaultText());
        if (!((Collection)this.template.getCollapsedTemplate().getCards()).isEmpty()) {
            Card card = this.template.getCollapsedTemplate().getCards().get(0);
            for (Widget widget : card.getWidgets()) {
                if (widget.getId() != 1 || !(widget instanceof ChronometerWidget)) continue;
                this.checkAndAddChronometer(remoteViews, (ChronometerWidget)widget);
            }
        }
        this.templateHelper.addDefaultActionToNotificationClick$rich_notification_release(this.context, remoteViews, R.id.collapsedRootView, this.template, this.metaData);
        this.metaData.getNotificationBuilder().setCustomContentView(remoteViews);
        return true;
    }

    private final RemoteViews getTimerCollapsedRemoteViews() {
        return new RemoteViews(this.context.getPackageName(), RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice() ? RichPushUtilsKt.getDecoratedStyleTemplateLayout(R.layout.moe_rich_push_timer_collapsed_small_layout_decorated_style, R.layout.moe_rich_push_timer_collapsed_layout_decorated_style, this.sdkInstance) : R.layout.moe_rich_push_timer_collapsed_layout);
    }

    @TargetApi(value=24)
    public final boolean buildExpandedTimerTemplate() {
        if (this.template.getExpandedTemplate() == null) {
            return false;
        }
        if (!new Evaluator(this.sdkInstance.logger).hasMinimumText(this.template.getDefaultText())) {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)2, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ TimerTemplateBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return TimerTemplateBuilder.access$getTag$p(this.this$0) + " buildExpandedTimerTemplate() : Does not have minimum text.";
                }
            }), (int)2, null);
            return false;
        }
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TimerTemplateBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return TimerTemplateBuilder.access$getTag$p(this.this$0) + " buildExpandedTimerTemplate() : Template: " + TimerTemplateBuilder.access$getTemplate$p(this.this$0).getExpandedTemplate();
            }
        }), (int)3, null);
        if (this.template.getExpandedTemplate().getCards().isEmpty()) {
            return false;
        }
        boolean hasActionButtons = !((Collection)this.template.getExpandedTemplate().getActionButtonList()).isEmpty() || this.metaData.getPayload().getAddOnFeatures().isPersistent();
        RemoteViews remoteViews = this.getTimerExpandedRemoteViews(hasActionButtons);
        if (this.template.getExpandedTemplate().getCards().isEmpty() && this.template.getExpandedTemplate().getActionButtonList().isEmpty()) {
            return false;
        }
        this.templateHelper.setContentText(remoteViews, this.template.getDefaultText());
        if (hasActionButtons) {
            this.templateHelper.addActionButton$rich_notification_release(this.context, this.metaData, this.template, remoteViews, this.template.getExpandedTemplate().getActionButtonList(), this.metaData.getPayload().getAddOnFeatures().isPersistent());
        }
        boolean hasImage = false;
        if (!((Collection)this.template.getExpandedTemplate().getCards()).isEmpty()) {
            Card card = this.template.getExpandedTemplate().getCards().get(0);
            for (Widget widget : card.getWidgets()) {
                if (widget.getId() == 0 && Intrinsics.areEqual((Object)widget.getType(), (Object)"image")) {
                    Template template = this.template;
                    Intrinsics.checkNotNull((Object)widget, (String)"null cannot be cast to non-null type com.moengage.richnotification.internal.models.ImageWidget");
                    hasImage = TemplateHelper.addImageWidgetToTemplate$rich_notification_release$default(this.templateHelper, this.context, this.metaData, template, remoteViews, (ImageWidget)widget, card, null, 0, 192, null);
                    continue;
                }
                if (widget.getId() != 1 || !(widget instanceof ChronometerWidget)) continue;
                this.checkAndAddChronometer(remoteViews, (ChronometerWidget)widget);
            }
        }
        this.setMessageMaxLines(remoteViews, hasActionButtons, hasImage);
        this.templateHelper.addDefaultActionToNotificationClick$rich_notification_release(this.context, remoteViews, R.id.expandedRootView, this.template, this.metaData);
        this.metaData.getNotificationBuilder().setCustomBigContentView(remoteViews);
        return true;
    }

    private final RemoteViews getTimerExpandedRemoteViews(boolean hasButtons) {
        return new RemoteViews(this.context.getPackageName(), RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice() ? (hasButtons ? R.layout.moe_rich_push_timer_expanded_decorated_style_with_action_buttons : R.layout.moe_rich_push_timer_expanded_decorated_style_without_action_buttons) : (hasButtons ? R.layout.moe_rich_push_timer_expanded_with_action_buttons : R.layout.moe_rich_push_timer_expanded_without_action_buttons));
    }

    private final void setMessageMaxLines(RemoteViews remoteViews, boolean hasActionButtons, boolean hasImage) {
        if (RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice()) {
            remoteViews.setInt(R.id.message, "setMaxLines", hasImage ? 2 : (hasActionButtons ? 9 : 11));
        } else {
            if (hasImage) {
                remoteViews.setBoolean(R.id.message, "setSingleLine", true);
                remoteViews.setInt(R.id.message, "setMaxLines", 1);
                return;
            }
            remoteViews.setBoolean(R.id.message, "setSingleLine", false);
            remoteViews.setInt(R.id.message, "setMaxLines", hasActionButtons ? 10 : 12);
        }
    }

    @RequiresApi(value=24)
    public final void setChronometerCountdown$rich_notification_release(@NotNull RemoteViews remoteViews) {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        remoteViews.setChronometerCountDown(R.id.moEChronometer, true);
    }

    @RequiresApi(value=24)
    private final void checkAndAddChronometer(RemoteViews remoteViews, ChronometerWidget chronometerWidget) {
        block0: {
            this.setChronometerCountdown$rich_notification_release(remoteViews);
            this.setChronometerStyle(chronometerWidget, remoteViews);
            String string = (String)TimerTemplateBuilderKt.access$getTIMER_FORMAT_TO_STRING_MAPPING$p().get(chronometerWidget.getProperties().getFormat());
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, it){
                final /* synthetic */ TimerTemplateBuilder this$0;
                final /* synthetic */ String $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return TimerTemplateBuilder.access$getTag$p(this.this$0) + " checkAndAddChronometer(): format: " + this.$it;
                }
            }), (int)3, null);
            this.templateHelper.setChronometer$rich_notification_release(remoteViews, it, SystemClock.elapsedRealtime() + RichPushTimerUtilsKt.getTimerEndTime(this.progressProperties.getTimerProperties().getDuration(), this.progressProperties.getTimerProperties().getExpiry()));
        }
    }

    private final void setChronometerStyle(ChronometerWidget chronometerWidget, RemoteViews remoteViews) {
        ChronometerStyle chronometerStyle = this.templateHelper.getChronometerStyle$rich_notification_release(chronometerWidget);
        if (chronometerStyle == null) {
            return;
        }
        ChronometerStyle chronometerStyle2 = chronometerStyle;
        CharSequence charSequence = chronometerStyle2.getTextColor();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            remoteViews.setTextColor(R.id.moEChronometer, Color.parseColor((String)chronometerStyle2.getTextColor()));
        }
    }

    @TargetApi(value=24)
    public final boolean buildCollapsedProgressTemplate$rich_notification_release() {
        if (this.template.getCollapsedTemplate() == null) {
            return false;
        }
        if (StringsKt.isBlank((CharSequence)this.template.getDefaultText().getTitle())) {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)2, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ TimerTemplateBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return TimerTemplateBuilder.access$getTag$p(this.this$0) + " buildCollapsedProgressTemplate() : Does not have minimum text.";
                }
            }), (int)2, null);
            return false;
        }
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TimerTemplateBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return TimerTemplateBuilder.access$getTag$p(this.this$0) + " buildCollapsedProgressTemplate() : Template: " + TimerTemplateBuilder.access$getTemplate$p(this.this$0).getCollapsedTemplate();
            }
        }), (int)3, null);
        if (this.template.getCollapsedTemplate().getCards().isEmpty()) {
            return false;
        }
        RemoteViews remoteViews = this.getProgressbarCollapsedRemoteViews();
        this.templateHelper.setContentText(remoteViews, this.template.getDefaultText());
        if (!((Collection)this.template.getCollapsedTemplate().getCards()).isEmpty()) {
            Card card = this.template.getCollapsedTemplate().getCards().get(0);
            for (Widget widget : card.getWidgets()) {
                if (widget.getId() == 1 && widget instanceof ChronometerWidget) {
                    this.checkAndAddChronometer(remoteViews, (ChronometerWidget)widget);
                    continue;
                }
                if (widget.getId() != 2 || !(widget instanceof ProgressbarWidget)) continue;
                this.checkAndAddProgressbar(remoteViews);
            }
        }
        this.templateHelper.addDefaultActionToNotificationClick$rich_notification_release(this.context, remoteViews, R.id.collapsedRootView, this.template, this.metaData);
        this.metaData.getNotificationBuilder().setCustomContentView(remoteViews);
        return true;
    }

    private final RemoteViews getProgressbarCollapsedRemoteViews() {
        return new RemoteViews(this.context.getPackageName(), RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice() ? (RichPushTimerUtilsKt.hasScheduleExactPermission(this.context) ? RichPushUtilsKt.getDecoratedStyleTemplateLayout(R.layout.moe_rich_push_progressbar_collapsed_small_layout_decroated_style, R.layout.moe_rich_push_progressbar_collapsed_layout_decroated_style, this.sdkInstance) : RichPushUtilsKt.getDecoratedStyleTemplateLayout(R.layout.moe_rich_push_timer_with_title_collapsed_small_layout_decroated_style, R.layout.moe_rich_push_timer_with_title_collapsed_layout_decroated_style, this.sdkInstance)) : R.layout.moe_rich_push_progressbar_collapsed_layout);
    }

    @TargetApi(value=24)
    public final boolean buildExpandedProgressTemplate() {
        if (this.template.getExpandedTemplate() == null) {
            return false;
        }
        if (StringsKt.isBlank((CharSequence)this.template.getDefaultText().getTitle())) {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)2, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ TimerTemplateBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return TimerTemplateBuilder.access$getTag$p(this.this$0) + " buildExpandedProgressTemplate() : Does not have minimum text.";
                }
            }), (int)2, null);
            return false;
        }
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TimerTemplateBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return TimerTemplateBuilder.access$getTag$p(this.this$0) + " buildExpandedProgressTemplate() : Template: " + TimerTemplateBuilder.access$getTemplate$p(this.this$0).getExpandedTemplate();
            }
        }), (int)3, null);
        if (this.template.getExpandedTemplate().getCards().isEmpty()) {
            return false;
        }
        boolean hasActionButtons = !((Collection)this.template.getExpandedTemplate().getActionButtonList()).isEmpty() || this.metaData.getPayload().getAddOnFeatures().isPersistent();
        RemoteViews remoteViews = this.getProgressbarExpandedRemoteViews(hasActionButtons);
        if (this.template.getExpandedTemplate().getCards().isEmpty() && this.template.getExpandedTemplate().getActionButtonList().isEmpty()) {
            return false;
        }
        this.templateHelper.setContentText(remoteViews, this.template.getDefaultText());
        if (hasActionButtons) {
            this.templateHelper.addActionButton$rich_notification_release(this.context, this.metaData, this.template, remoteViews, this.template.getExpandedTemplate().getActionButtonList(), this.metaData.getPayload().getAddOnFeatures().isPersistent());
        }
        boolean hasImage = false;
        if (!((Collection)this.template.getExpandedTemplate().getCards()).isEmpty()) {
            Card card = this.template.getExpandedTemplate().getCards().get(0);
            for (Widget widget : card.getWidgets()) {
                if (widget.getId() == 0 && Intrinsics.areEqual((Object)widget.getType(), (Object)"image")) {
                    Template template = this.template;
                    Intrinsics.checkNotNull((Object)widget, (String)"null cannot be cast to non-null type com.moengage.richnotification.internal.models.ImageWidget");
                    hasImage = TemplateHelper.addImageWidgetToTemplate$rich_notification_release$default(this.templateHelper, this.context, this.metaData, template, remoteViews, (ImageWidget)widget, card, null, 0, 192, null);
                    continue;
                }
                if (widget.getId() == 1 && widget instanceof ChronometerWidget) {
                    this.checkAndAddChronometer(remoteViews, (ChronometerWidget)widget);
                    continue;
                }
                if (widget.getId() != 2 || !(widget instanceof ProgressbarWidget)) continue;
                this.checkAndAddProgressbar(remoteViews);
            }
        }
        this.setMessageMaxLines(remoteViews, hasActionButtons, hasImage);
        this.templateHelper.addDefaultActionToNotificationClick$rich_notification_release(this.context, remoteViews, R.id.expandedRootView, this.template, this.metaData);
        this.metaData.getNotificationBuilder().setCustomBigContentView(remoteViews);
        return true;
    }

    private final RemoteViews getProgressbarExpandedRemoteViews(boolean hasButtons) {
        return new RemoteViews(this.context.getPackageName(), RichPushUtilsKt.doesSdkSupportDecoratedStyleOnDevice() ? this.getDecoratedStyleExpandedProgressbarLayoutId(hasButtons, RichPushTimerUtilsKt.hasScheduleExactPermission(this.context)) : (hasButtons ? R.layout.moe_rich_push_progressbar_expanded_with_action_buttons : R.layout.moe_rich_push_progressbar_expanded_without_action_buttons));
    }

    private final void checkAndAddProgressbar(RemoteViews remoteViews) {
        if (!RichPushTimerUtilsKt.hasScheduleExactPermission(this.context)) {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)4, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ TimerTemplateBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return TimerTemplateBuilder.access$getTag$p(this.this$0) + " buildExpandedProgressTemplate() : Does not have permission to schedule exact alarm.";
                }
            }), (int)2, null);
            return;
        }
        if (this.progressProperties.getCurrentProgress() <= -1) {
            remoteViews.setViewVisibility(R.id.moEProgressbar, 8);
            return;
        }
        remoteViews.setViewVisibility(R.id.chronometerLayout, 0);
        remoteViews.setViewVisibility(R.id.moEProgressbar, 0);
        remoteViews.setProgressBar(R.id.moEProgressbar, 100, this.progressProperties.getCurrentProgress(), false);
    }

    private final int getDecoratedStyleExpandedProgressbarLayoutId(boolean hasButtons, boolean hasExactAlarmPermission) {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, hasButtons, hasExactAlarmPermission){
            final /* synthetic */ TimerTemplateBuilder this$0;
            final /* synthetic */ boolean $hasButtons;
            final /* synthetic */ boolean $hasExactAlarmPermission;
            {
                this.this$0 = $receiver;
                this.$hasButtons = $hasButtons;
                this.$hasExactAlarmPermission = $hasExactAlarmPermission;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return TimerTemplateBuilder.access$getTag$p(this.this$0) + " getDecoratedStyleExpandedProgressbarLayoutId() : hasButton: " + this.$hasButtons + ", hasExactAlarmPermission: " + this.$hasExactAlarmPermission;
            }
        }), (int)3, null);
        return hasButtons ? (hasExactAlarmPermission ? R.layout.moe_rich_push_progressbar_expanded_with_action_buttons_decorated_style : R.layout.moe_rich_push_timer_with_title_expanded_with_action_buttons_decorated_style) : (hasExactAlarmPermission ? R.layout.moe_rich_push_progressbar_expanded_without_action_buttons_decorated_style : R.layout.moe_rich_push_timer_with_title_expanded_without_action_buttons_decorated_style);
    }

    public static final /* synthetic */ String access$getTag$p(TimerTemplateBuilder $this) {
        return $this.tag;
    }

    public static final /* synthetic */ TimerTemplate access$getTemplate$p(TimerTemplateBuilder $this) {
        return $this.template;
    }
}

