/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.richnotification.internal.repository;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.storage.FileManager;
import com.moengage.core.internal.utils.CoreUtils;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/moengage/richnotification/internal/repository/ImageManager;", "", "context", "Landroid/content/Context;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Landroid/content/Context;Lcom/moengage/core/internal/model/SdkInstance;)V", "fileManager", "Lcom/moengage/core/internal/storage/FileManager;", "tag", "", "getImageFromUrl", "Landroid/graphics/Bitmap;", "campaignId", "imageUrl", "isImageExist", "", "saveImage", "directoryName", "image", "rich-notification_release"})
public final class ImageManager {
    @NotNull
    private final Context context;
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final String tag;
    @NotNull
    private final FileManager fileManager;

    public ImageManager(@NotNull Context context, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.context = context;
        this.sdkInstance = sdkInstance;
        this.tag = "RichPush_4.7.2_ImageManager";
        this.fileManager = new FileManager(this.context, this.sdkInstance);
    }

    @Nullable
    public final Bitmap getImageFromUrl(@NotNull String campaignId, @NotNull String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        try {
            String fileName = CoreUtils.getSha256ForString((String)imageUrl);
            return !this.fileManager.fileExistsInDirectory(campaignId, fileName) ? (Bitmap)null : BitmapFactory.decodeFile((String)this.fileManager.getPathForFile(campaignId, fileName));
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ ImageManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ImageManager.access$getTag$p(this.this$0) + " getImageFromUrl() : ";
                }
            });
            return null;
        }
    }

    public final boolean saveImage(@NotNull String directoryName, @NotNull String imageUrl, @NotNull Bitmap image) {
        Intrinsics.checkNotNullParameter((Object)directoryName, (String)"directoryName");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        try {
            String fileName = CoreUtils.getSha256ForString((String)imageUrl);
            this.fileManager.saveImageFile(directoryName, fileName, image);
            return this.fileManager.fileExistsInDirectory(directoryName, fileName);
        }
        catch (NoSuchAlgorithmException e) {
            this.sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(this){
                final /* synthetic */ ImageManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ImageManager.access$getTag$p(this.this$0) + " saveImage() : ";
                }
            });
            return false;
        }
    }

    public final boolean isImageExist(@NotNull String campaignId, @NotNull String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        try {
            return this.fileManager.fileExistsInDirectory(campaignId, CoreUtils.getSha256ForString((String)imageUrl));
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ ImageManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ImageManager.access$getTag$p(this.this$0) + " isImageExist() : ";
                }
            });
            return false;
        }
    }

    public static final /* synthetic */ String access$getTag$p(ImageManager $this) {
        return $this.tag;
    }
}

