/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.richnotification.internal.repository;

import android.os.Build;
import android.widget.ImageView;
import androidx.annotation.VisibleForTesting;
import com.moengage.core.internal.logger.Logger;
import com.moengage.pushbase.internal.repository.ActionParser;
import com.moengage.pushbase.model.action.Action;
import com.moengage.richnotification.internal.models.Card;
import com.moengage.richnotification.internal.models.ChronometerProperties;
import com.moengage.richnotification.internal.models.ChronometerStyle;
import com.moengage.richnotification.internal.models.ChronometerWidget;
import com.moengage.richnotification.internal.models.CollapsedBannerTemplate;
import com.moengage.richnotification.internal.models.CollapsedTemplate;
import com.moengage.richnotification.internal.models.DefaultText;
import com.moengage.richnotification.internal.models.DismissCta;
import com.moengage.richnotification.internal.models.ExpandedBannerTemplate;
import com.moengage.richnotification.internal.models.ExpandedTemplate;
import com.moengage.richnotification.internal.models.HeaderStyle;
import com.moengage.richnotification.internal.models.ImageWidget;
import com.moengage.richnotification.internal.models.LayoutStyle;
import com.moengage.richnotification.internal.models.ProgressbarProperties;
import com.moengage.richnotification.internal.models.ProgressbarWidget;
import com.moengage.richnotification.internal.models.Style;
import com.moengage.richnotification.internal.models.Template;
import com.moengage.richnotification.internal.models.TimerProperties;
import com.moengage.richnotification.internal.models.TimerTemplate;
import com.moengage.richnotification.internal.models.Widget;
import com.moengage.richnotification.internal.models.WidgetProperties;
import com.moengage.richnotification.internal.repository.PayloadParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0018H\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0007J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0016\u0010&\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010(\u001a\u00020)2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0016\u0010*\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010,\u001a\u00020-2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0018\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0018H\u0002J\u0010\u00105\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u00106\u001a\u0004\u0018\u0001072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010=\u001a\u00020>2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020\u0007H\u0002J\u0012\u0010B\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010\u00132\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0012\u0010D\u001a\u0004\u0018\u00010-2\u0006\u0010E\u001a\u00020\u0018H\u0007J\u0018\u0010F\u001a\u00020G2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0018H\u0007J\u0018\u0010H\u001a\u00020I2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0018\u0010J\u001a\u00020K2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010L\u001a\u0002072\u0006\u0010M\u001a\u00020-H\u0007J\u0018\u0010N\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u001e\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010P\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006Q"}, d2={"Lcom/moengage/richnotification/internal/repository/PayloadParser;", "", "()V", "actionButtonListFromJson", "", "Lcom/moengage/richnotification/internal/models/Widget;", "expandedState", "Lorg/json/JSONObject;", "richPushJson", "actionListFromJson", "", "Lcom/moengage/pushbase/model/action/Action;", "actionArray", "Lorg/json/JSONArray;", "(Lorg/json/JSONArray;)[Lcom/moengage/pushbase/model/action/Action;", "baseCollapsedTemplateFromJson", "Lcom/moengage/richnotification/internal/models/CollapsedTemplate;", "collapsedJson", "baseExpandedTemplateFromJson", "Lcom/moengage/richnotification/internal/models/ExpandedTemplate;", "expandedJson", "baseWidgetFromJson", "widgetJson", "widgetType", "", "cardFromJson", "Lcom/moengage/richnotification/internal/models/Card;", "cardJson", "cardListFromJson", "", "chronometerPropertiesFromJson", "Lcom/moengage/richnotification/internal/models/ChronometerProperties;", "propertiesPath", "chronometerStyleFromJson", "Lcom/moengage/richnotification/internal/models/ChronometerStyle;", "styleJson", "chronometerWidgetFromJson", "Lcom/moengage/richnotification/internal/models/ChronometerWidget;", "collapsedBannerTemplateFromJson", "Lcom/moengage/richnotification/internal/models/CollapsedBannerTemplate;", "defaultTextFromJson", "Lcom/moengage/richnotification/internal/models/DefaultText;", "expandedBannerTemplateFromJson", "Lcom/moengage/richnotification/internal/models/ExpandedBannerTemplate;", "getBaseTemplate", "Lcom/moengage/richnotification/internal/models/Template;", "getDismissCtaFromJson", "Lcom/moengage/richnotification/internal/models/DismissCta;", "getImageWidgetScaleType", "Landroid/widget/ImageView$ScaleType;", "getJsonFromReferencePath", "responseJson", "contentPath", "getTemplateType", "getTimerPropertiesFromWidgetList", "Lcom/moengage/richnotification/internal/models/TimerProperties;", "widgetList", "getTimerTemplate", "Lcom/moengage/richnotification/internal/models/TimerTemplate;", "headerStyleFromJson", "Lcom/moengage/richnotification/internal/models/HeaderStyle;", "imageWidgetFromJson", "Lcom/moengage/richnotification/internal/models/ImageWidget;", "layoutStyleFromJson", "Lcom/moengage/richnotification/internal/models/LayoutStyle;", "collapsedState", "parseCollapsedTemplate", "parseExpandedTemplate", "parseTemplate", "payloadString", "progressbarPropertiesFromJson", "Lcom/moengage/richnotification/internal/models/ProgressbarProperties;", "progressbarWidgetFromJson", "Lcom/moengage/richnotification/internal/models/ProgressbarWidget;", "styleFromJson", "Lcom/moengage/richnotification/internal/models/Style;", "timerPropertiesFromBaseTemplate", "baseTemplate", "widgetFromJson", "widgetListFromJson", "widgetsArray", "rich-notification_release"})
public final class PayloadParser {
    @androidx.annotation.Nullable
    @Nullable
    public final Template parseTemplate(@NotNull String payloadString) {
        Intrinsics.checkNotNullParameter((Object)payloadString, (String)"payloadString");
        try {
            JSONObject payloadJson = new JSONObject(payloadString);
            if (payloadJson.length() == 0 || !payloadJson.has("richPush")) {
                return null;
            }
            JSONObject jSONObject = payloadJson.getJSONObject("richPush");
            if (jSONObject == null) {
                return null;
            }
            JSONObject richPushJson = jSONObject;
            String templateType = this.getTemplateType(richPushJson);
            return Intrinsics.areEqual((Object)templateType, (Object)"timer") ? (Template)this.getTimerTemplate(richPushJson) : this.getBaseTemplate(richPushJson);
        }
        catch (Throwable t) {
            Logger.Companion.print(1, t, (Function0)parseTemplate.1.INSTANCE);
            return null;
        }
    }

    private final DefaultText defaultTextFromJson(JSONObject richPushJson) throws JSONException {
        String string = richPushJson.optString("title", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"richPushJson.optString(NOTIFICATION_TITLE, \"\")");
        String string2 = richPushJson.optString("body", "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"richPushJson.optString(NOTIFICATION_MESSAGE, \"\")");
        String string3 = richPushJson.optString("summary", "");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"richPushJson.optString(NOTIFICATION_SUMMARY, \"\")");
        return new DefaultText(string, string2, string3);
    }

    private final CollapsedTemplate parseCollapsedTemplate(JSONObject richPushJson) throws JSONException {
        CollapsedTemplate collapsedTemplate;
        if (!richPushJson.has("collapsed")) {
            return null;
        }
        JSONObject collapsedJson = richPushJson.getJSONObject("collapsed");
        String string = collapsedJson.getString("type");
        if (string == null) {
            return null;
        }
        String templateType = string;
        String string2 = templateType;
        if (Intrinsics.areEqual((Object)string2, (Object)"imageBannerText") ? true : Intrinsics.areEqual((Object)string2, (Object)"imageBanner")) {
            Intrinsics.checkNotNullExpressionValue((Object)collapsedJson, (String)"collapsedJson");
            collapsedTemplate = this.collapsedBannerTemplateFromJson(collapsedJson, richPushJson);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)collapsedJson, (String)"collapsedJson");
            collapsedTemplate = this.baseCollapsedTemplateFromJson(collapsedJson, richPushJson);
        }
        return collapsedTemplate;
    }

    private final ExpandedTemplate parseExpandedTemplate(JSONObject richPushJson) throws JSONException {
        ExpandedTemplate expandedTemplate;
        if (!richPushJson.has("expanded")) {
            return null;
        }
        JSONObject expandedState = richPushJson.getJSONObject("expanded");
        String string = expandedState.getString("type");
        if (string == null) {
            return null;
        }
        String templateType = string;
        String string2 = templateType;
        if (Intrinsics.areEqual((Object)string2, (Object)"imageBannerText") ? true : Intrinsics.areEqual((Object)string2, (Object)"imageBanner")) {
            Intrinsics.checkNotNullExpressionValue((Object)expandedState, (String)"expandedState");
            expandedTemplate = this.expandedBannerTemplateFromJson(expandedState, richPushJson);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)expandedState, (String)"expandedState");
            expandedTemplate = this.baseExpandedTemplateFromJson(expandedState, richPushJson);
        }
        return expandedTemplate;
    }

    private final List<Widget> actionButtonListFromJson(JSONObject expandedState, JSONObject richPushJson) throws JSONException {
        if (!expandedState.has("actionButton")) {
            return CollectionsKt.emptyList();
        }
        JSONArray actionButtons = expandedState.getJSONArray("actionButton");
        return actionButtons == null || actionButtons.length() == 0 ? CollectionsKt.emptyList() : this.widgetListFromJson(actionButtons, richPushJson);
    }

    private final List<Card> cardListFromJson(JSONObject expandedState, JSONObject richPushJson) throws JSONException {
        if (!expandedState.has("cards")) {
            return CollectionsKt.toMutableList((Collection)CollectionsKt.emptyList());
        }
        JSONArray cardArray = expandedState.getJSONArray("cards");
        List cards = new ArrayList(cardArray.length());
        int n = cardArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject cardJson = cardArray.getJSONObject(i);
            Intrinsics.checkNotNullExpressionValue((Object)cardJson, (String)"cardJson");
            cards.add(this.cardFromJson(cardJson, richPushJson));
        }
        return cards;
    }

    private final Card cardFromJson(JSONObject cardJson, JSONObject richPushJson) throws JSONException {
        Action[] actionArray;
        int n = cardJson.getInt("id");
        JSONArray jSONArray = cardJson.getJSONArray("widgets");
        Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"cardJson.getJSONArray(WIDGETS)");
        List<Widget> list = this.widgetListFromJson(jSONArray, richPushJson);
        String string = cardJson.getString("type");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cardJson.getString(TYPE)");
        if (cardJson.has("actions")) {
            JSONArray jSONArray2 = cardJson.getJSONArray("actions");
            Intrinsics.checkNotNullExpressionValue((Object)jSONArray2, (String)"cardJson.getJSONArray(ACTIONS)");
            actionArray = this.actionListFromJson(jSONArray2);
        } else {
            boolean $i$f$emptyArray = false;
            actionArray = (Action[])((Object[])new Action[0]);
        }
        return new Card(n, list, string, actionArray);
    }

    private final List<Widget> widgetListFromJson(JSONArray widgetsArray, JSONObject richPushJson) throws JSONException {
        List widgetList = new ArrayList(widgetsArray.length());
        int n = widgetsArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject widgetJson = widgetsArray.getJSONObject(i);
            Intrinsics.checkNotNullExpressionValue((Object)widgetJson, (String)"widgetJson");
            Widget widget = this.widgetFromJson(widgetJson, richPushJson);
            if (widget == null) continue;
            widgetList.add(widget);
        }
        return widgetList;
    }

    private final Widget baseWidgetFromJson(JSONObject widgetJson, String widgetType) throws JSONException {
        Action[] actionArray;
        Style style;
        int n = widgetJson.getInt("id");
        String string = Intrinsics.areEqual((Object)widgetType, (Object)"timer") || Intrinsics.areEqual((Object)widgetType, (Object)"progressbar") ? "" : widgetJson.getString("content");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (widgetType == WIDGET\u2026          )\n            }");
        if (widgetJson.has("style")) {
            JSONObject jSONObject = widgetJson.getJSONObject("style");
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"widgetJson.getJSONObject(STYLE)");
            style = this.styleFromJson(jSONObject, widgetType);
        } else {
            style = null;
        }
        if (widgetJson.has("actions")) {
            JSONArray jSONArray = widgetJson.getJSONArray("actions");
            Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"widgetJson.getJSONArray(ACTIONS)");
            actionArray = this.actionListFromJson(jSONArray);
        } else {
            boolean $i$f$emptyArray = false;
            actionArray = (Action[])((Object[])new Action[0]);
        }
        return new Widget(widgetType, n, string, style, actionArray);
    }

    private final Style styleFromJson(JSONObject styleJson, String widgetType) throws JSONException {
        Style style;
        if (Intrinsics.areEqual((Object)widgetType, (Object)"timer")) {
            style = this.chronometerStyleFromJson(styleJson);
        } else {
            String string = styleJson.getString("bgColor");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"styleJson.getString(BACKGROUND_COLOR)");
            style = new Style(string);
        }
        return style;
    }

    private final Action[] actionListFromJson(JSONArray actionArray) throws JSONException {
        List actionList = new ArrayList(actionArray.length());
        ActionParser actionParser = new ActionParser();
        int n = actionArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = actionArray.getJSONObject(i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"actionArray.getJSONObject(i)");
            Action action = actionParser.actionFromJson(jSONObject);
            if (action == null) continue;
            actionList.add(action);
        }
        Collection $this$toTypedArray$iv = actionList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Action[] actionArray2 = thisCollection$iv.toArray(new Action[0]);
        Intrinsics.checkNotNull((Object)actionArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return actionArray2;
    }

    private final LayoutStyle layoutStyleFromJson(JSONObject collapsedState) throws JSONException {
        LayoutStyle layoutStyle;
        if (!collapsedState.has("style")) {
            return null;
        }
        if (!collapsedState.getJSONObject("style").has("bgColor")) {
            layoutStyle = null;
        } else {
            String string = collapsedState.getJSONObject("style").getString("bgColor");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collapsedState.getJSONOb\u2026tString(BACKGROUND_COLOR)");
            layoutStyle = new LayoutStyle(string);
        }
        return layoutStyle;
    }

    private final HeaderStyle headerStyleFromJson(JSONObject richPushJson) throws JSONException {
        if (!richPushJson.has("appNameColor")) {
            return new HeaderStyle(null);
        }
        return new HeaderStyle(richPushJson.getString("appNameColor"));
    }

    private final ExpandedTemplate baseExpandedTemplateFromJson(JSONObject expandedJson, JSONObject richPushJson) {
        boolean autostart = Build.VERSION.SDK_INT > 29 ? false : expandedJson.optBoolean("autoStart", false);
        String string = expandedJson.getString("type");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expandedJson.getString(TYPE)");
        return new ExpandedTemplate(string, this.layoutStyleFromJson(expandedJson), this.actionButtonListFromJson(expandedJson, richPushJson), this.cardListFromJson(expandedJson, richPushJson), autostart);
    }

    @NotNull
    public final ExpandedBannerTemplate expandedBannerTemplateFromJson(@NotNull JSONObject expandedJson, @NotNull JSONObject richPushJson) {
        Intrinsics.checkNotNullParameter((Object)expandedJson, (String)"expandedJson");
        Intrinsics.checkNotNullParameter((Object)richPushJson, (String)"richPushJson");
        return new ExpandedBannerTemplate(this.baseExpandedTemplateFromJson(expandedJson, richPushJson), expandedJson.optBoolean("showHeader", false));
    }

    private final CollapsedTemplate baseCollapsedTemplateFromJson(JSONObject collapsedJson, JSONObject richPushJson) {
        String string = collapsedJson.getString("type");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collapsedJson.getString(TYPE)");
        return new CollapsedTemplate(string, this.layoutStyleFromJson(collapsedJson), this.cardListFromJson(collapsedJson, richPushJson));
    }

    @NotNull
    public final CollapsedBannerTemplate collapsedBannerTemplateFromJson(@NotNull JSONObject collapsedJson, @NotNull JSONObject richPushJson) {
        Intrinsics.checkNotNullParameter((Object)collapsedJson, (String)"collapsedJson");
        Intrinsics.checkNotNullParameter((Object)richPushJson, (String)"richPushJson");
        return new CollapsedBannerTemplate(this.baseCollapsedTemplateFromJson(collapsedJson, richPushJson), collapsedJson.optBoolean("showHeader", false));
    }

    private final JSONObject getJsonFromReferencePath(JSONObject responseJson, String contentPath) throws JSONException {
        String[] stringArray = new String[]{"/"};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)contentPath, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] pathPieces = stringArray2;
        JSONObject propertiesPayload = responseJson;
        int n = pathPieces.length;
        for (int i = 1; i < n; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)propertiesPayload.getJSONObject(pathPieces[i]), (String)"propertiesPayload.getJSONObject(pathPieces[i])");
        }
        return propertiesPayload;
    }

    private final Template getBaseTemplate(JSONObject richPushJson) throws JSONException {
        String string = richPushJson.getString("displayName");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"richPushJson.getString(TEMPLATE_NAME)");
        DefaultText defaultText = this.defaultTextFromJson(richPushJson);
        JSONArray jSONArray = richPushJson.getJSONArray("defaultActions");
        Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"richPushJson.getJSONArray(DEFAULT_ACTION)");
        Action[] actionArray = this.actionListFromJson(jSONArray);
        CollapsedTemplate collapsedTemplate = this.parseCollapsedTemplate(richPushJson);
        ExpandedTemplate expandedTemplate = this.parseExpandedTemplate(richPushJson);
        String string2 = richPushJson.getJSONObject("android").optString("indicatorColor", "lightGrey");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"richPushJson.getJSONObje\u2026, ASSET_COLOR_LIGHT_GREY)");
        return new Template(string, defaultText, actionArray, collapsedTemplate, expandedTemplate, string2, richPushJson.getJSONObject("android").getBoolean("showLargeIcon"), this.headerStyleFromJson(richPushJson), this.getDismissCtaFromJson(richPushJson));
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final ChronometerProperties chronometerPropertiesFromJson(@NotNull JSONObject richPushJson, @NotNull String propertiesPath) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)richPushJson, (String)"richPushJson");
        Intrinsics.checkNotNullParameter((Object)propertiesPath, (String)"propertiesPath");
        JSONObject properties = this.getJsonFromReferencePath(richPushJson, propertiesPath);
        long l = properties.getLong("duration");
        long l2 = properties.getLong("expiry");
        String string = properties.getString("format");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"properties.getString(PROPERTY_FORMAT_KEY)");
        return new ChronometerProperties(l, l2, string, new WidgetProperties(properties));
    }

    private final String getTemplateType(JSONObject richPushJson) throws JSONException {
        if (!richPushJson.has("collapsed")) {
            return "";
        }
        JSONObject collapsedJson = richPushJson.getJSONObject("collapsed");
        String string = collapsedJson.getString("type");
        if (string == null) {
            return "";
        }
        String templateType = string;
        return Intrinsics.areEqual((Object)templateType, (Object)"timer") || Intrinsics.areEqual((Object)templateType, (Object)"timerWithProgressbar") ? "timer" : "";
    }

    private final TimerTemplate getTimerTemplate(JSONObject richPushJson) throws JSONException {
        Template baseTemplate = this.getBaseTemplate(richPushJson);
        return new TimerTemplate(baseTemplate, this.timerPropertiesFromBaseTemplate(baseTemplate));
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final ChronometerStyle chronometerStyleFromJson(@NotNull JSONObject styleJson) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)styleJson, (String)"styleJson");
        return new ChronometerStyle(styleJson.getString("color"));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Widget widgetFromJson(JSONObject widgetJson, JSONObject richPushJson) throws JSONException {
        Widget widget;
        String widgetType = widgetJson.getString("type");
        if (widgetType != null) {
            int n = -1;
            switch (widgetType.hashCode()) {
                case 110364485: {
                    if (!widgetType.equals("timer")) break;
                    n = 1;
                    break;
                }
                case 100313435: {
                    if (!widgetType.equals("image")) break;
                    n = 2;
                    break;
                }
                case 1131540166: {
                    if (!widgetType.equals("progressbar")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    widget = this.chronometerWidgetFromJson(widgetJson, richPushJson);
                    return widget;
                }
                case 3: {
                    widget = this.progressbarWidgetFromJson(widgetJson, richPushJson);
                    return widget;
                }
                case 2: {
                    widget = this.imageWidgetFromJson(widgetJson, widgetType);
                    return widget;
                }
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)widgetType, (String)"widgetType");
        widget = this.baseWidgetFromJson(widgetJson, widgetType);
        return widget;
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final ChronometerWidget chronometerWidgetFromJson(@NotNull JSONObject widgetJson, @NotNull JSONObject richPushJson) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)widgetJson, (String)"widgetJson");
        Intrinsics.checkNotNullParameter((Object)richPushJson, (String)"richPushJson");
        Widget widget = this.baseWidgetFromJson(widgetJson, "timer");
        String string = widgetJson.getString("prop");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"widgetJson.getString(WIDGET_PROPERTIES)");
        return new ChronometerWidget(widget, this.chronometerPropertiesFromJson(richPushJson, string));
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final TimerProperties timerPropertiesFromBaseTemplate(@NotNull Template baseTemplate) throws JSONException {
        TimerProperties timerProperties;
        Intrinsics.checkNotNullParameter((Object)baseTemplate, (String)"baseTemplate");
        TimerProperties timerProperties2 = null;
        if (baseTemplate.getCollapsedTemplate() != null && !((Collection)baseTemplate.getCollapsedTemplate().getCards()).isEmpty()) {
            timerProperties2 = this.getTimerPropertiesFromWidgetList(baseTemplate.getCollapsedTemplate().getCards().get(0).getWidgets());
        }
        if (timerProperties2 == null && baseTemplate.getExpandedTemplate() != null && !((Collection)baseTemplate.getExpandedTemplate().getCards()).isEmpty()) {
            timerProperties2 = this.getTimerPropertiesFromWidgetList(baseTemplate.getExpandedTemplate().getCards().get(0).getWidgets());
        }
        if ((timerProperties = timerProperties2) == null) {
            timerProperties = new TimerProperties(-1L, -1L);
        }
        return timerProperties;
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final ProgressbarWidget progressbarWidgetFromJson(@NotNull JSONObject widgetJson, @NotNull JSONObject richPushJson) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)widgetJson, (String)"widgetJson");
        Intrinsics.checkNotNullParameter((Object)richPushJson, (String)"richPushJson");
        Widget widget = this.baseWidgetFromJson(widgetJson, "progressbar");
        String string = widgetJson.getString("prop");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"widgetJson.getString(WIDGET_PROPERTIES)");
        return new ProgressbarWidget(widget, this.progressbarPropertiesFromJson(richPushJson, string));
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final ProgressbarProperties progressbarPropertiesFromJson(@NotNull JSONObject richPushJson, @NotNull String propertiesPath) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)richPushJson, (String)"richPushJson");
        Intrinsics.checkNotNullParameter((Object)propertiesPath, (String)"propertiesPath");
        JSONObject properties = this.getJsonFromReferencePath(richPushJson, propertiesPath);
        return new ProgressbarProperties(properties.getLong("duration"), properties.getLong("expiry"), new WidgetProperties(properties));
    }

    private final TimerProperties getTimerPropertiesFromWidgetList(List<? extends Widget> widgetList) {
        for (Widget widget : widgetList) {
            if (widget instanceof ChronometerWidget) {
                return new TimerProperties(((ChronometerWidget)widget).getProperties().getDuration(), ((ChronometerWidget)widget).getProperties().getExpiry());
            }
            if (!(widget instanceof ProgressbarWidget)) continue;
            return new TimerProperties(((ProgressbarWidget)widget).getProperties().getDuration(), ((ProgressbarWidget)widget).getProperties().getExpiry());
        }
        return null;
    }

    private final DismissCta getDismissCtaFromJson(JSONObject richPushJson) {
        String string = richPushJson.optString("dismissCta", "Dismiss");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"richPushJson.optString(D\u2026DEFAULT_DISMISS_CTA_TEXT)");
        return new DismissCta(string);
    }

    private final ImageWidget imageWidgetFromJson(JSONObject widgetJson, String widgetType) {
        return new ImageWidget(this.baseWidgetFromJson(widgetJson, widgetType), this.getImageWidgetScaleType(widgetJson));
    }

    private final ImageView.ScaleType getImageWidgetScaleType(JSONObject widgetJson) {
        String string = widgetJson.optString("scaleType", "");
        return Intrinsics.areEqual((Object)string, (Object)"cc") ? ImageView.ScaleType.CENTER_CROP : (Intrinsics.areEqual((Object)string, (Object)"ci") ? ImageView.ScaleType.CENTER_INSIDE : ImageView.ScaleType.CENTER_CROP);
    }
}

