/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.api.exceptions;

import com.moesif.api.APIHelper;
import com.moesif.api.http.client.HttpContext;
import com.moesif.api.http.response.HttpStringResponse;
import java.io.IOException;

public class APIException
extends Exception {
    private static final long serialVersionUID = 6424174253911720338L;
    private int responseCode;
    private HttpContext httpContext;

    public int getResponseCode() {
        return this.httpContext != null ? this.httpContext.getResponse().getStatusCode() : -1;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public APIException(String reason) {
        super(reason);
    }

    public APIException(String reason, HttpContext context) {
        super(reason);
        this.httpContext = context;
        if (this.getClass().equals(APIException.class) || context == null || context.getResponse() == null || context.getResponse().getRawBody() == null) {
            return;
        }
        try {
            String response_body = ((HttpStringResponse)context.getResponse()).getBody();
            APIHelper.populate(response_body, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

