/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.api.http.client;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.HttpRequestWithBody;
import com.moesif.api.APIHelper;
import com.moesif.api.exceptions.APIException;
import com.moesif.api.http.client.APICallBack;
import com.moesif.api.http.client.HttpClient;
import com.moesif.api.http.client.HttpContext;
import com.moesif.api.http.request.HttpBodyRequest;
import com.moesif.api.http.request.HttpMethod;
import com.moesif.api.http.request.HttpRequest;
import com.moesif.api.http.response.HttpStringResponse;
import java.util.Map;

public class UnirestClient
implements HttpClient {
    private static Object synRoot = new Object();
    private static HttpClient sharedInstance = null;
    private static String version = APIHelper.getVersion();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient getSharedInstance() {
        Object object = synRoot;
        synchronized (object) {
            if (sharedInstance == null) {
                sharedInstance = new UnirestClient();
            }
            return sharedInstance;
        }
    }

    @Override
    public void executeAsStringAsync(HttpRequest request, APICallBack<com.moesif.api.http.response.HttpResponse> callBack) {
        com.mashape.unirest.request.HttpRequest uniRequest = UnirestClient.convertRequest(request);
        try {
            HttpResponse response = uniRequest.asString();
            UnirestClient.publishResponse(response, request, callBack, null);
        }
        catch (UnirestException ex) {
            UnirestClient.publishResponse(null, request, callBack, ex);
        }
    }

    @Override
    public void executeAsBinaryAsync(HttpRequest request, APICallBack<com.moesif.api.http.response.HttpResponse> callBack) {
        com.mashape.unirest.request.HttpRequest uniRequest = UnirestClient.convertRequest(request);
        try {
            HttpResponse response = uniRequest.asBinary();
            UnirestClient.publishResponse(response, request, callBack, null);
        }
        catch (UnirestException ex) {
            UnirestClient.publishResponse(null, request, callBack, ex);
        }
    }

    @Override
    public com.moesif.api.http.response.HttpResponse executeAsBinary(HttpRequest request) throws APIException {
        com.mashape.unirest.request.HttpRequest uniRequest = UnirestClient.convertRequest(request);
        try {
            HttpResponse response = uniRequest.asBinary();
            return UnirestClient.convertResponse(response);
        }
        catch (UnirestException ex) {
            throw new APIException(ex.getMessage());
        }
    }

    @Override
    public com.moesif.api.http.response.HttpResponse executeAsString(HttpRequest request) throws APIException {
        com.mashape.unirest.request.HttpRequest uniRequest = UnirestClient.convertRequest(request);
        try {
            HttpResponse response = uniRequest.asString();
            return UnirestClient.convertResponse(response);
        }
        catch (UnirestException ex) {
            throw new APIException(ex.getMessage());
        }
    }

    protected static void publishResponse(HttpResponse<?> response, HttpRequest request, APICallBack<com.moesif.api.http.response.HttpResponse> completionBlock, UnirestException uniException) {
        com.moesif.api.http.response.HttpResponse httpResponse = response == null ? null : UnirestClient.convertResponse(response);
        HttpContext context = new HttpContext(request, httpResponse);
        if (uniException == null && httpResponse != null) {
            completionBlock.onSuccess(context, httpResponse);
        } else {
            Throwable innerException = uniException.getCause();
            completionBlock.onFailure(context, new APIException(innerException.getMessage()));
        }
    }

    public static com.moesif.api.http.response.HttpResponse convertResponse(HttpResponse<?> response) {
        com.moesif.api.http.response.HttpResponse httpResponse = null;
        if (null == response) {
            return null;
        }
        httpResponse = response.getBody() instanceof String ? new HttpStringResponse(response.getStatus(), (Map<String, String>)response.getHeaders().getFlatHeaders(), response.getRawBody(), (String)response.getBody()) : new com.moesif.api.http.response.HttpResponse(response.getStatus(), response.getHeaders().getFlatHeaders(), response.getRawBody(), response.getBaseRequest());
        return httpResponse;
    }

    protected static com.mashape.unirest.request.HttpRequest convertRequest(HttpRequest request) {
        com.mashape.unirest.http.HttpMethod uniMethod = UnirestClient.convertHttpMetod(request.getHttpMethod());
        String url = request.getQueryUrl();
        HttpRequestWithBody uniRequest = new HttpRequestWithBody(uniMethod, url);
        if (request instanceof HttpBodyRequest) {
            uniRequest.body(((HttpBodyRequest)request).getBody());
        } else {
            uniRequest.fields(request.getParameters());
        }
        uniRequest.headers(request.getHeaders());
        uniRequest.header("User-Agent", "moesifapi-java/" + version);
        if (request instanceof HttpBodyRequest) {
            uniRequest.header("content-type", "application/json; charset=UTF-8");
        }
        if (null != request.getUsername() && !request.getUsername().isEmpty()) {
            uniRequest.basicAuth(request.getUsername(), request.getPassword());
        }
        return uniRequest;
    }

    protected static com.mashape.unirest.http.HttpMethod convertHttpMetod(HttpMethod method) {
        switch (method) {
            case POST: {
                return com.mashape.unirest.http.HttpMethod.POST;
            }
            case PATCH: {
                return com.mashape.unirest.http.HttpMethod.PATCH;
            }
            case PUT: {
                return com.mashape.unirest.http.HttpMethod.PUT;
            }
            case DELETE: {
                return com.mashape.unirest.http.HttpMethod.DELETE;
            }
        }
        return com.mashape.unirest.http.HttpMethod.GET;
    }

    @Override
    public HttpRequest get(String _queryUrl, Map<String, String> _headers, Map<String, Object> _parameters, String _username, String _password) {
        return new HttpRequest(HttpMethod.GET, _queryUrl, _headers, _parameters, _username, _password);
    }

    @Override
    public HttpRequest get(String _queryUrl, Map<String, String> _headers, Map<String, Object> _parameters) {
        return new HttpRequest(HttpMethod.GET, _queryUrl, _headers, _parameters);
    }

    @Override
    public HttpRequest post(String _queryUrl, Map<String, String> _headers, Map<String, Object> _parameters) {
        return new HttpRequest(HttpMethod.POST, _queryUrl, _headers, _parameters);
    }

    @Override
    public HttpRequest post(String _queryUrl, Map<String, String> _headers, Map<String, Object> _parameters, String _username, String _password) {
        return new HttpRequest(HttpMethod.POST, _queryUrl, _headers, _parameters, _username, _password);
    }

    @Override
    public HttpBodyRequest postBody(String _queryUrl, Map<String, String> _headers, String _body) {
        return new HttpBodyRequest(HttpMethod.POST, _queryUrl, _headers, _body);
    }

    @Override
    public HttpBodyRequest postBody(String _queryUrl, Map<String, String> _headers, String _body, String _username, String _password) {
        return new HttpBodyRequest(HttpMethod.POST, _queryUrl, _headers, _body, _username, _password);
    }

    @Override
    public HttpRequest put(String _queryUrl, Map<String, String> _headers, Map<String, Object> _parameters) {
        return new HttpRequest(HttpMethod.PUT, _queryUrl, _headers, _parameters);
    }

    @Override
    public HttpRequest put(String _queryUrl, Map<String, String> _headers, Map<String, Object> _parameters, String _username, String _password) {
        return new HttpRequest(HttpMethod.PUT, _queryUrl, _headers, _parameters, _username, _password);
    }

    @Override
    public HttpBodyRequest putBody(String _queryUrl, Map<String, String> _headers, String _body) {
        return new HttpBodyRequest(HttpMethod.PUT, _queryUrl, _headers, _body);
    }

    @Override
    public HttpBodyRequest putBody(String _queryUrl, Map<String, String> _headers, String _body, String _username, String _password) {
        return new HttpBodyRequest(HttpMethod.PUT, _queryUrl, _headers, _body, _username, _password);
    }

    @Override
    public HttpRequest patch(String _queryUrl, Map<String, String> _headers, Map<String, Object> _parameters) {
        return new HttpRequest(HttpMethod.PATCH, _queryUrl, _headers, _parameters);
    }

    @Override
    public HttpRequest patch(String _queryUrl, Map<String, String> _headers, Map<String, Object> _parameters, String _username, String _password) {
        return new HttpRequest(HttpMethod.PATCH, _queryUrl, _headers, _parameters, _username, _password);
    }

    @Override
    public HttpBodyRequest patchBody(String _queryUrl, Map<String, String> _headers, String _body) {
        return new HttpBodyRequest(HttpMethod.PATCH, _queryUrl, _headers, _body);
    }

    @Override
    public HttpBodyRequest patchBody(String _queryUrl, Map<String, String> _headers, String _body, String _username, String _password) {
        return new HttpBodyRequest(HttpMethod.PATCH, _queryUrl, _headers, _body, _username, _password);
    }

    @Override
    public HttpRequest delete(String _queryUrl, Map<String, String> _headers, Map<String, Object> _parameters) {
        return new HttpRequest(HttpMethod.DELETE, _queryUrl, _headers, _parameters);
    }

    @Override
    public HttpRequest delete(String _queryUrl, Map<String, String> _headers, Map<String, Object> _parameters, String _username, String _password) {
        return new HttpRequest(HttpMethod.DELETE, _queryUrl, _headers, _parameters, _username, _password);
    }

    @Override
    public HttpBodyRequest deleteBody(String _queryUrl, Map<String, String> _headers, String _body) {
        return new HttpBodyRequest(HttpMethod.DELETE, _queryUrl, _headers, _body);
    }

    @Override
    public HttpBodyRequest deleteBody(String _queryUrl, Map<String, String> _headers, String _body, String _username, String _password) {
        return new HttpBodyRequest(HttpMethod.DELETE, _queryUrl, _headers, _body, _username, _password);
    }
}

