/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.api.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moesif.api.APIHelper;
import com.moesif.api.Configuration;
import com.moesif.api.IAPIController;
import com.moesif.api.controllers.BaseController;
import com.moesif.api.controllers.syncwrapper.APICallBackCatcher;
import com.moesif.api.exceptions.APIException;
import com.moesif.api.http.client.APICallBack;
import com.moesif.api.http.client.HttpContext;
import com.moesif.api.http.request.HttpBodyRequest;
import com.moesif.api.http.request.HttpRequest;
import com.moesif.api.http.response.HttpResponse;
import com.moesif.api.models.AppConfigBuilder;
import com.moesif.api.models.AppConfigModel;
import com.moesif.api.models.CompanyModel;
import com.moesif.api.models.EventBuilder;
import com.moesif.api.models.EventModel;
import com.moesif.api.models.EventRequestModel;
import com.moesif.api.models.EventResponseModel;
import com.moesif.api.models.GovernanceRulesModel;
import com.moesif.api.models.UserModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class APIController
extends BaseController
implements IAPIController {
    private static Object syncObject = new Object();
    private static APIController instance = null;
    private static final Logger logger = Logger.getLogger(APIController.class.toString());
    private static final String APP_CONFIG_ETAG_HEADER = "x-moesif-config-etag";
    private static final int APP_CONFIG_DEBOUNCE = 300000;
    private long lastAppConfigFetch;
    private boolean shouldSyncAppConfig = false;
    private AppConfigModel appConfigModel;
    private String appConfigEtag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static APIController getInstance() {
        Object object = syncObject;
        synchronized (object) {
            if (null == instance) {
                instance = new APIController();
            }
        }
        return instance;
    }

    @Override
    public Map<String, String> createEvent(EventModel body) throws Throwable {
        QueryInfo qInfo = this.getQueryInfo("/v1/events");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnBeforeRequest(_request);
        }
        return this.executeRequest(_request);
    }

    @Override
    public void createEventAsync(EventModel body, APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/events");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public Map<String, String> createEventsBatch(List<EventModel> body) throws Throwable {
        QueryInfo qInfo = this.getQueryInfo("/v1/events/batch");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        return this.executeRequest(_request);
    }

    @Override
    public void createEventsBatchAsync(List<EventModel> body, APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/events/batch");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public void updateUser(UserModel body) throws Throwable {
        APICallBackCatcher<HttpResponse> callback = new APICallBackCatcher<HttpResponse>();
        this.updateUserAsync(body, callback);
        if (!callback.isSuccess()) {
            throw callback.getError();
        }
        callback.getResult();
    }

    @Override
    public void updateUserAsync(UserModel body, APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/users");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public void updateUsersBatch(List<UserModel> body) throws Throwable {
        APICallBackCatcher<HttpResponse> callback = new APICallBackCatcher<HttpResponse>();
        this.updateUsersBatchAsync(body, callback);
        if (!callback.isSuccess()) {
            throw callback.getError();
        }
        callback.getResult();
    }

    @Override
    public void updateUsersBatchAsync(List<UserModel> body, APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/users/batch");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public void updateCompany(CompanyModel body) throws Throwable {
        APICallBackCatcher<HttpResponse> callback = new APICallBackCatcher<HttpResponse>();
        this.updateCompanyAsync(body, callback);
        if (!callback.isSuccess()) {
            throw callback.getError();
        }
        callback.getResult();
    }

    @Override
    public void updateCompanyAsync(CompanyModel body, APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/companies");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public void updateCompaniesBatch(List<CompanyModel> body) throws Throwable {
        APICallBackCatcher<HttpResponse> callback = new APICallBackCatcher<HttpResponse>();
        this.updateCompaniesBatchAsync(body, callback);
        if (!callback.isSuccess()) {
            throw callback.getError();
        }
        callback.getResult();
    }

    @Override
    public void updateCompaniesBatchAsync(List<CompanyModel> body, APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/companies/batch");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public HttpResponse getAppConfig() throws Throwable {
        QueryInfo qInfo = this.getQueryInfo("/v1/config");
        HttpRequest _request = APIController.getClientInstance().get(qInfo._queryUrl, qInfo._headers, null);
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnBeforeRequest(_request);
        }
        HttpResponse _response = APIController.getClientInstance().executeAsString(_request);
        HttpContext _context = new HttpContext(_request, _response);
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnAfterResponse(_context);
        }
        this.validateResponse(_response, _context);
        return _response;
    }

    @Override
    public void getAppConfigAsync(APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/config");
        HttpRequest _request = APIController.getClientInstance().get(qInfo._queryUrl, qInfo._headers, null);
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public HttpResponse getGovernanceRules() throws Throwable {
        QueryInfo qInfo = this.getQueryInfo("/v1/rules");
        HttpRequest _request = APIController.getClientInstance().get(qInfo._queryUrl, qInfo._headers, null);
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnBeforeRequest(_request);
        }
        HttpResponse _response = APIController.getClientInstance().executeAsString(_request);
        HttpContext _context = new HttpContext(_request, _response);
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnAfterResponse(_context);
        }
        this.validateResponse(_response, _context);
        return _response;
    }

    @Override
    public void getGovernanceRulesAsync(APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/rules");
        HttpRequest _request = APIController.getClientInstance().get(qInfo._queryUrl, qInfo._headers, null);
        this.executeRequestAsync(_request, callBack);
    }

    private QueryInfo getQueryInfo(String url) {
        if (Configuration.ApplicationId == null || Configuration.ApplicationId.equals("")) {
            throw new IllegalArgumentException("A Moesif Application Id is required. Please obtain it through your settings at www.moesif.com");
        }
        if (Configuration.BaseUri == null || Configuration.BaseUri.equals("")) {
            throw new IllegalArgumentException("The API BaseUri is required.");
        }
        String _baseUri = Configuration.BaseUri;
        StringBuilder _queryBuilder = new StringBuilder(_baseUri);
        _queryBuilder.append(url);
        String _queryUrl = APIHelper.cleanUrl(_queryBuilder);
        HashMap<String, String> _headers = new HashMap<String, String>(){
            {
                this.put("X-Moesif-Application-Id", Configuration.ApplicationId);
            }
        };
        return new QueryInfo(_queryUrl, (Map<String, String>)_headers);
    }

    private Map<String, String> executeRequest(HttpRequest _request) throws Throwable {
        HttpResponse _response = APIController.getClientInstance().executeAsString(_request);
        Map<String, String> headers = _response.getHeaders();
        HttpContext _context = new HttpContext(_request, _response);
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnAfterResponse(_context);
        }
        this.validateResponse(_response, _context);
        this.checkAppConfigEtag(headers.get(APP_CONFIG_ETAG_HEADER));
        return headers;
    }

    private void executeRequestAsync(final HttpRequest _request, final APICallBack<HttpResponse> callBack) {
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnBeforeRequest(_request);
        }
        Runnable _responseTask = new Runnable(){

            @Override
            public void run() {
                BaseController.getClientInstance().executeAsStringAsync(_request, APIController.this.createHttpResponseCallback(callBack));
            }
        };
        APIHelper.getScheduler().execute(_responseTask);
    }

    private AppConfigModel getCachedAppConfig() {
        if (this.appConfigModel == null) {
            this.trySyncAppConfig();
            return this.getDefaultAppConfig();
        }
        return this.appConfigModel;
    }

    public void setAppConfig(AppConfigModel config) {
        if (config != null) {
            this.appConfigModel = config;
        }
    }

    public void setShouldSyncAppConfig(boolean shouldSync) {
        this.shouldSyncAppConfig = shouldSync;
    }

    private void checkAppConfigEtag(String newAppConfigEtag) {
        if (newAppConfigEtag != null && !newAppConfigEtag.equals(this.appConfigEtag)) {
            this.trySyncAppConfig();
        }
    }

    private boolean trySyncAppConfig() {
        boolean willFetch;
        long now = new Date().getTime();
        boolean bl = willFetch = this.shouldSyncAppConfig && this.lastAppConfigFetch + 300000L < now;
        if (willFetch) {
            this.lastAppConfigFetch = now;
            this.syncAppConfig();
        }
        return willFetch;
    }

    public static List<GovernanceRulesModel> parseGovernanceRulesModel(InputStream jsonTxt) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (List)mapper.readValue(jsonTxt, (TypeReference)new TypeReference<List<GovernanceRulesModel>>(){});
    }

    public static AppConfigModel parseAppConfigModel(InputStream jsonTxt) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (AppConfigModel)mapper.readValue(jsonTxt, AppConfigModel.class);
    }

    private void syncAppConfig() {
        if (this.shouldSyncAppConfig) {
            APICallBack<HttpResponse> callback = new APICallBack<HttpResponse>(){

                @Override
                public void onSuccess(HttpContext context, HttpResponse response) {
                    try {
                        InputStream respBodyIs = response.getRawBody();
                        APIController.this.appConfigModel = APIController.parseAppConfigModel(respBodyIs);
                        respBodyIs.close();
                    }
                    catch (Exception e) {
                        logger.warning("Invalid AppConfig JSON: " + e.getMessage());
                    }
                    logger.info("App Config Model returned is " + APIController.this.appConfigModel);
                    APIController.this.appConfigEtag = response.getHeaders().get(APIController.APP_CONFIG_ETAG_HEADER);
                }

                @Override
                public void onFailure(HttpContext context, Throwable error) {
                }
            };
            try {
                this.getAppConfigAsync(callback);
            }
            catch (Exception e) {
                logger.warning("Error performing async operation");
            }
        }
    }

    public AppConfigModel getDefaultAppConfig() {
        return new AppConfigBuilder().sampleRate(100).build();
    }

    public int calculateWeight(int sampleRate) {
        return (int)(sampleRate == 0 ? 1.0 : Math.floor(100.0 / (double)sampleRate));
    }

    public EventModel buildEventModel(EventRequestModel eventRequestModel, EventResponseModel eventResponseModel, String userId, String companyId, String sessionToken, String apiVersion, Object metadata, String direction) {
        EventBuilder eb = new EventBuilder();
        eb.request(eventRequestModel);
        eb.response(eventResponseModel);
        if (userId != null) {
            eb.userId(userId);
        }
        if (companyId != null) {
            eb.companyId(companyId);
        }
        if (sessionToken != null) {
            eb.sessionToken(sessionToken);
        }
        if (apiVersion != null) {
            eb.tags(apiVersion);
        }
        if (metadata != null) {
            eb.metadata(metadata);
        }
        eb.direction(direction);
        return eb.build();
    }

    public boolean shouldSendSampledEvent() {
        double randomPercentage;
        int sampleRate = this.getCachedAppConfig().getSampleRate();
        return (double)sampleRate >= (randomPercentage = Math.random() * 100.0);
    }

    public boolean shouldSendSampledEvent(EventModel eventModel) {
        double randomPercentage;
        int sampleRate = this.getSampleRateToUse(eventModel);
        return (double)sampleRate >= (randomPercentage = Math.random() * 100.0);
    }

    public int getSampleRateToUse(EventModel eventModel) {
        AppConfigModel appConfigModel = this.getCachedAppConfig();
        int sampleRate = appConfigModel.getSampleRate();
        if (eventModel.getUserId() != null && appConfigModel.getUserSampleRate().containsKey(eventModel.getUserId())) {
            sampleRate = appConfigModel.getUserSampleRate().get(eventModel.getUserId());
        } else if (eventModel.getCompanyId() != null && appConfigModel.getCompanySampleRate().containsKey(eventModel.getCompanyId())) {
            sampleRate = appConfigModel.getCompanySampleRate().get(eventModel.getCompanyId());
        }
        return sampleRate;
    }

    private APICallBack<HttpResponse> createHttpResponseCallback(final APICallBack<HttpResponse> callBack) {
        return new APICallBack<HttpResponse>(){

            @Override
            public void onSuccess(HttpContext _context, HttpResponse _response) {
                try {
                    if (APIController.this.getHttpCallBack() != null) {
                        APIController.this.getHttpCallBack().OnAfterResponse(_context);
                    }
                    APIController.this.validateResponse(_response, _context);
                    APIController.this.checkAppConfigEtag(_response.getHeaders().get(APIController.APP_CONFIG_ETAG_HEADER));
                    callBack.onSuccess(_context, _response);
                }
                catch (APIException error) {
                    callBack.onFailure(_context, error);
                }
                catch (Exception exception) {
                    callBack.onFailure(_context, exception);
                }
            }

            @Override
            public void onFailure(HttpContext _context, Throwable _error) {
                if (APIController.this.getHttpCallBack() != null) {
                    APIController.this.getHttpCallBack().OnAfterResponse(_context);
                }
                callBack.onFailure(_context, _error);
            }
        };
    }

    private static class QueryInfo {
        String _queryUrl;
        Map<String, String> _headers;

        public QueryInfo(String url, Map<String, String> headers) {
            this._queryUrl = url;
            this._headers = headers;
        }
    }
}

