/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.api.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.moesif.api.models.GovernanceRuleRegexConditionModel;
import com.moesif.api.models.GovernanceRuleRegexRuleModel;
import com.moesif.api.models.GovernanceRulesResponseModel;
import com.moesif.api.models.GovernanceRulesVariableModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GovernanceRulesModel
implements Serializable {
    private String Id;
    private String createdAt;
    private String orgId;
    private String appId;
    private String name;
    private boolean block;
    private String type;
    private List<GovernanceRulesVariableModel> variables;
    private List<GovernanceRuleRegexRuleModel> regexConfig;
    private GovernanceRulesResponseModel response;

    @JsonGetter(value="_id")
    public String getId() {
        return this.Id;
    }

    @JsonSetter(value="_id")
    public void setId(String value) {
        this.Id = value;
    }

    @JsonGetter(value="created_at")
    public String getcreatedAt() {
        return this.createdAt;
    }

    @JsonSetter(value="created_at")
    public void setcreatedAt(String value) {
        this.createdAt = value;
    }

    @JsonGetter(value="org_id")
    public String getOrgId() {
        return this.orgId;
    }

    @JsonSetter(value="org_id")
    public void setOrgId(String value) {
        this.orgId = value;
    }

    @JsonGetter(value="app_id")
    public String getAppId() {
        return this.appId;
    }

    @JsonSetter(value="app_id")
    public void setAppId(String value) {
        this.appId = value;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public void setName(String value) {
        this.name = value;
    }

    @JsonGetter(value="block")
    public boolean getBlock() {
        return this.block;
    }

    @JsonSetter(value="block")
    public void setBlock(boolean value) {
        this.block = value;
    }

    @JsonGetter(value="type")
    public String getType() {
        return this.type;
    }

    @JsonSetter(value="type")
    public void setType(String value) {
        this.type = value;
    }

    @JsonGetter(value="variables")
    public List<GovernanceRulesVariableModel> getVariables() {
        return this.variables;
    }

    @JsonSetter(value="variables")
    public void setVariables(List<GovernanceRulesVariableModel> value) {
        this.variables = value;
    }

    @JsonGetter(value="regex_config")
    public List<GovernanceRuleRegexRuleModel> getRegexConfig() {
        return this.regexConfig;
    }

    @JsonSetter(value="regex_config")
    public void setRegexConfig(List<GovernanceRuleRegexRuleModel> value) {
        this.regexConfig = value;
    }

    @JsonGetter(value="response")
    public GovernanceRulesResponseModel getResponse() {
        return this.response;
    }

    @JsonSetter(value="response")
    public void setResponse(GovernanceRulesResponseModel value) {
        this.response = value;
    }

    public String toString() {
        List<GovernanceRuleRegexRuleModel> regexConfigs;
        StringBuilder sb = new StringBuilder();
        sb.append("***** GovernanceRulesModel Details *****\n");
        sb.append("Id=" + this.getId() + "\n");
        sb.append("CreatedAt=" + this.getcreatedAt() + "\n");
        sb.append("OrgId=" + this.getOrgId() + "\n");
        sb.append("AppId=" + this.getAppId() + "\n");
        sb.append("Name=" + this.getName() + "\n");
        sb.append("Block=" + this.getBlock() + "\n");
        sb.append("Type=" + this.getType() + "\n");
        List<GovernanceRulesVariableModel> variableList = this.getVariables();
        if (variableList != null) {
            sb.append("Variables=" + this.convertVariables(variableList) + "\n");
        }
        if ((regexConfigs = this.getRegexConfig()) != null) {
            sb.append("RegexConfigs=" + this.convertRegexConfigs(regexConfigs) + "\n");
        }
        sb.append("Response=" + this.convertResponse(this.getResponse()) + "\n");
        sb.append("*****************************");
        return sb.toString();
    }

    private String convertResponse(GovernanceRulesResponseModel response) {
        StringBuilder sb = new StringBuilder();
        sb.append("Status=" + response.getStatus() + "\n");
        sb.append("Headers=" + this.convertWithStream(response.getHeaders()) + "\n");
        sb.append("Body=" + response.getBody() + "\n");
        return sb.toString();
    }

    private List<String> convertVariables(List<GovernanceRulesVariableModel> variableList) {
        ArrayList<String> vlist = new ArrayList<String>();
        for (GovernanceRulesVariableModel variables : variableList) {
            StringBuilder sb = new StringBuilder();
            sb.append("Name=" + variables.getName() + "\n");
            sb.append("Path=" + variables.getPath() + "\n");
            vlist.add(sb.toString());
        }
        return vlist;
    }

    private List<String> convertRegexConfigs(List<GovernanceRuleRegexRuleModel> regexConfigList) {
        ArrayList<String> rlist = new ArrayList<String>();
        for (GovernanceRuleRegexRuleModel regexConfigs : regexConfigList) {
            StringBuilder sb = new StringBuilder();
            sb.append("Conditions=" + this.convertRegexCondition(regexConfigs.getConditions()) + "\n");
            sb.append("SampleRate=" + regexConfigs.getSampleRate() + "\n");
            rlist.add(sb.toString());
        }
        return rlist;
    }

    private List<String> convertRegexCondition(List<GovernanceRuleRegexConditionModel> regexConditionList) {
        ArrayList<String> rclist = new ArrayList<String>();
        for (GovernanceRuleRegexConditionModel regexConditions : regexConditionList) {
            StringBuilder sb = new StringBuilder();
            sb.append("Path=" + regexConditions.getPath() + "\n");
            sb.append("Value=" + regexConditions.getValue() + "\n");
            rclist.add(sb.toString());
        }
        return rclist;
    }

    private String convertWithStream(Map<String, String> map) {
        String mapAsString = map.keySet().stream().map(key -> key + "=" + (String)map.get(key)).collect(Collectors.joining(", ", "{", "}"));
        return mapAsString;
    }
}

