/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.external.facebook.stetho.inspector.network;

import com.moesif.external.facebook.stetho.inspector.network.CountingOutputStream;
import com.moesif.external.facebook.stetho.inspector.network.GunzippingOutputStream;
import com.moesif.external.facebook.stetho.inspector.network.ResponseHandler;
import com.moesif.external.facebook.stetho.inspector.network.ResponseHandlingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.InflaterOutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompressionHelper {
    private static final Logger logger = LoggerFactory.getLogger(DecompressionHelper.class);
    static final String GZIP_ENCODING = "gzip";
    static final String DEFLATE_ENCODING = "deflate";

    public static InputStream teeInputWithDecompression(String requestId, InputStream availableInputStream, OutputStream decompressedOutput, @Nullable String contentEncoding, ResponseHandler responseHandler) throws IOException {
        OutputStream output = decompressedOutput;
        CountingOutputStream decompressedCounter = null;
        if (contentEncoding != null) {
            boolean gzipEncoding = GZIP_ENCODING.equals(contentEncoding);
            boolean deflateEncoding = DEFLATE_ENCODING.equals(contentEncoding);
            if (gzipEncoding || deflateEncoding) {
                decompressedCounter = new CountingOutputStream(decompressedOutput);
                if (gzipEncoding) {
                    output = GunzippingOutputStream.create(decompressedCounter);
                } else if (deflateEncoding) {
                    output = new InflaterOutputStream(decompressedCounter);
                }
            } else {
                logger.warn("Unsupported Content-Encoding in response for request #" + requestId + ": " + contentEncoding);
            }
        }
        return new ResponseHandlingInputStream(availableInputStream, requestId, output, decompressedCounter, responseHandler);
    }
}

