/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.external.facebook.stetho.inspector.network;

import com.moesif.helpers.ExceptionUtils;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

class GunzippingOutputStream
extends FilterOutputStream {
    private final Future<Void> mCopyFuture;
    private static final ExecutorService sExecutor = Executors.newCachedThreadPool();

    public static GunzippingOutputStream create(OutputStream finalOut) throws IOException {
        PipedInputStream pipeIn = new PipedInputStream();
        PipedOutputStream pipeOut = new PipedOutputStream(pipeIn);
        Future<Void> copyFuture = sExecutor.submit(new GunzippingCallable(pipeIn, finalOut));
        return new GunzippingOutputStream(pipeOut, copyFuture);
    }

    private GunzippingOutputStream(OutputStream out, Future<Void> copyFuture) throws IOException {
        super(out);
        this.mCopyFuture = copyFuture;
    }

    @Override
    public void close() throws IOException {
        boolean success = false;
        try {
            super.close();
            success = true;
        }
        finally {
            block8: {
                try {
                    GunzippingOutputStream.getAndRethrow(this.mCopyFuture);
                }
                catch (IOException e) {
                    if (!success) break block8;
                    throw e;
                }
            }
        }
    }

    private static <T> T getAndRethrow(Future<T> future) throws IOException {
        while (true) {
            try {
                return future.get();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                ExceptionUtils.propagateIfInstanceOf(cause, IOException.class);
                org.apache.commons.lang3.exception.ExceptionUtils.wrapAndThrow((Throwable)cause);
                continue;
            }
            break;
        }
    }

    private static class GunzippingCallable
    implements Callable<Void> {
        private final InputStream mIn;
        private final OutputStream mOut;

        public GunzippingCallable(InputStream in, OutputStream out) {
            this.mIn = in;
            this.mOut = out;
        }

        @Override
        public Void call() throws IOException {
            GZIPInputStream in = new GZIPInputStream(this.mIn);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)this.mOut);
            }
            finally {
                in.close();
                this.mOut.close();
            }
            return null;
        }
    }
}

