/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.external.facebook.stetho.inspector.network;

import com.moesif.external.facebook.stetho.inspector.network.DecompressionHelper;
import com.moesif.external.facebook.stetho.inspector.network.NetworkEventReporterMoesif;
import com.moesif.external.facebook.stetho.inspector.network.ResourceTypeHelper;
import com.moesif.external.facebook.stetho.inspector.network.ResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkEventReporterMoesifImpl
implements NetworkEventReporterMoesif {
    private static final Logger logger = LoggerFactory.getLogger(NetworkEventReporterMoesifImpl.class);
    private final AtomicInteger mNextRequestId = new AtomicInteger(0);
    private @Nullable ResourceTypeHelper mResourceTypeHelper;
    private static NetworkEventReporterMoesif sInstance;

    private NetworkEventReporterMoesifImpl() {
    }

    public static synchronized NetworkEventReporterMoesif get() {
        if (sInstance == null) {
            sInstance = new NetworkEventReporterMoesifImpl();
        }
        return sInstance;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void requestWillBeSent(NetworkEventReporterMoesif.InspectorRequest request) {
    }

    @Override
    public void responseHeadersReceived(NetworkEventReporterMoesif.InspectorResponse response) {
    }

    @Override
    public InputStream interpretResponseStream(String requestId, @Nullable String contentType, @Nullable String contentEncoding, @Nullable InputStream availableInputStream, ResponseHandler responseHandler, OutputStream decompressedOutput) {
        if (availableInputStream == null) {
            responseHandler.onEOF();
            return null;
        }
        try {
            return DecompressionHelper.teeInputWithDecompression(requestId, availableInputStream, decompressedOutput, contentEncoding, responseHandler);
        }
        catch (IOException e) {
            logger.warn("Error writing response body data for request #" + requestId);
            return availableInputStream;
        }
    }

    @Override
    public void httpExchangeFailed(String requestId, String errorText) {
        this.loadingFailed(requestId, errorText);
    }

    @Override
    public void responseReadFinished(String requestId) {
        this.loadingFinished(requestId);
    }

    private void loadingFinished(String requestId) {
        logger.info("Loading Finished");
    }

    @Override
    public void responseReadFailed(String requestId, String errorText) {
        this.loadingFailed(requestId, errorText);
    }

    private void loadingFailed(String requestId, String errorText) {
        logger.warn("Loading Failed: " + errorText);
    }

    @Override
    public void dataSent(String requestId, int dataLength, int encodedDataLength) {
        this.dataReceived(requestId, dataLength, encodedDataLength);
    }

    @Override
    public void dataReceived(String requestId, int dataLength, int encodedDataLength) {
        logger.info("Data received");
    }

    @Override
    public String nextRequestId() {
        return String.valueOf(this.mNextRequestId.getAndIncrement());
    }

    private @Nullable String getContentType(NetworkEventReporterMoesif.InspectorHeaders headers) {
        return headers.firstHeaderValue("Content-Type");
    }

    @Override
    public void webSocketCreated(String requestId, String url) {
        logger.info("Websocket created");
    }

    @Override
    public void webSocketClosed(String requestId) {
        logger.info("Websocket closed");
    }

    @Override
    public void webSocketWillSendHandshakeRequest(NetworkEventReporterMoesif.InspectorWebSocketRequest request) {
        logger.info("webSocketWillSendHandshakeRequest");
    }

    @Override
    public void webSocketHandshakeResponseReceived(NetworkEventReporterMoesif.InspectorWebSocketResponse response) {
        logger.info("webSocketHandshakeResponseReceived");
    }

    @Override
    public void webSocketFrameSent(NetworkEventReporterMoesif.InspectorWebSocketFrame frame) {
        logger.info("webSocketFrameSent");
    }

    @Override
    public void webSocketFrameReceived(NetworkEventReporterMoesif.InspectorWebSocketFrame frame) {
        logger.info("webSocketFrameReceived");
    }

    @Override
    public void webSocketFrameError(String requestId, String errorMessage) {
        logger.info("webSocketFrameError");
    }

    private @NonNull ResourceTypeHelper getResourceTypeHelper() {
        if (this.mResourceTypeHelper == null) {
            this.mResourceTypeHelper = new ResourceTypeHelper();
        }
        return this.mResourceTypeHelper;
    }
}

